/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.configservice.SystemAttributes;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.ScriptingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ConfigHelper {
    private static TraceComponent tc = Tr.register(ConfigHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private AbstractShell _shell = null;
    private String _domain = null;

    public ConfigHelper(AbstractShell shell, String domain) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigHelper");
        }
        this._shell = shell;
        this._domain = domain;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigHelper");
        }
    }

    public Hashtable parseObjectIdString(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseObjectIdString: " + name);
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (name != null) {
            int start;
            int end;
            if (name.startsWith("\"") && name.endsWith("\"")) {
                name = name.substring(1, name.length() - 1);
            }
            String displayName = null;
            String configId = null;
            if (!name.endsWith(")")) {
                this._shell.setAndThrowScriptingException("WASX7077E", "incomplete config id", new Object[]{name});
            }
            if ((end = name.lastIndexOf("(")) < 0) {
                this._shell.setAndThrowScriptingException("WASX7078E", "missing config id", new Object[]{name});
            }
            if ((start = name.indexOf("(")) != end) {
                if (name.indexOf("cells/") > 0) {
                    end = name.lastIndexOf("(cells/");
                } else if (name.indexOf("templates/") > 0) {
                    end = name.lastIndexOf("(templates/");
                }
            }
            configId = name.substring(end + 1, name.length() - 1);
            if (end > 0) {
                displayName = name.substring(0, end);
            }
            table.put("_Websphere_Config_Data_Id", configId);
            if (displayName != null) {
                table.put("_Websphere_Config_Data_Display_Name", displayName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseObjectIdString:");
        }
        return table;
    }

    public ObjectName stringToObjectName(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToObjectName: " + name);
        }
        ObjectName ret = null;
        Hashtable table = this.parseObjectIdString(name);
        if (table.size() > 0) {
            try {
                ret = new ObjectName(this._domain, table);
            }
            catch (MalformedObjectNameException ex) {
                this._shell.setAndThrowScriptingException("MALFORMED_OBJECT_NAME", "Malformed object name", new Object[]{table.toString()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToObjectName:");
        }
        return ret;
    }

    public String getListingName(ObjectName on) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getListingName");
        }
        String ret = null;
        if (on != null) {
            String displayName = on.getKeyProperty("_Websphere_Config_Data_Display_Name");
            String configId = on.getKeyProperty("_Websphere_Config_Data_Id");
            ret = displayName != null ? displayName + "(" + configId + ")" : "(" + configId + ")";
            if (ret.indexOf(" ") >= 0) {
                ret = "\"" + ret + "\"";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getListingName");
        }
        return ret;
    }

    protected String nameToResolveString(String name) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nameToResolveString", new Object[]{name});
        }
        StringBuffer ret = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(name, "/:", true);
        Object end = null;
        boolean error = false;
        boolean invalidName = false;
        boolean noObject = false;
        try {
            boolean lookForSlash = true;
            while (tok.hasMoreTokens()) {
                String start;
                if (lookForSlash && !(start = tok.nextToken()).equals("/")) {
                    this._shell.setAndThrowScriptingException("INVALID_OBJECT_NAME", "Invalid object name: " + name, new Object[]{name});
                }
                if (!tok.hasMoreTokens()) continue;
                String n = tok.nextToken();
                String junk = tok.nextToken();
                String next = tok.nextToken();
                if (next.equals("/")) {
                    lookForSlash = false;
                    next = "";
                } else {
                    lookForSlash = true;
                }
                if (ret.length() > 0) {
                    ret.append(":");
                }
                ret.append(n);
                ret.append("=");
                ret.append(next);
            }
        }
        catch (NoSuchElementException nsee) {
            invalidName = true;
            error = true;
        }
        if (error) {
            this._shell.setAndThrowScriptingException("INVALID_OBJECT_NAME", "Invalid object name: " + name, new Object[]{name});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nameToResolveString", new Object[]{ret.toString()});
        }
        return ret.toString();
    }

    protected AttributeList stripSystemAttrs(AttributeList rawList) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stripSystemAttrs");
        }
        AttributeList ret = new AttributeList();
        for (int i = 0; i < rawList.size(); ++i) {
            Attribute next = (Attribute)rawList.get(i);
            if (!SystemAttributes.isSystemAttribute(next.getName())) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Adding: " + next.getName());
                }
                ret.add(next);
                continue;
            }
            if (!tc.isEntryEnabled()) continue;
            Tr.debug(tc, "Not adding; system attribute: " + next.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stripSystemAttrs");
        }
        return ret;
    }

    public String cleanString(String s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanString");
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanString");
        }
        return s;
    }

    public AttributeList merge(AttributeList oldList, AttributeList newList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "merge");
        }
        AttributeList mergedList = new AttributeList();
        for (int i = 0; i < newList.size(); ++i) {
            ArrayList newVersion;
            Attribute a;
            String name;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute number: " + i);
            }
            if (SystemAttributes.isSystemAttribute(name = (a = (Attribute)newList.get(i)).getName())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "sys attr " + name);
                }
                mergedList.add(a);
                continue;
            }
            Object oldVersion = this.findAttribute(oldList, name);
            if (oldVersion == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "old value for " + name + " null");
                }
                mergedList.add(a);
                continue;
            }
            if (oldVersion instanceof AttributeList) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "old value  for " + name + " AttributeList");
                }
                newVersion = (AttributeList)a.getValue();
                AttributeList merged = this.innerMerge((AttributeList)oldVersion, (AttributeList)newVersion);
                mergedList.add(new Attribute(name, merged));
                continue;
            }
            if (oldVersion instanceof ArrayList) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "old value  for " + name + " ArrayList");
                }
                if ((newVersion = (ArrayList)a.getValue()).size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deleting list because new list has size zero.");
                    }
                    oldVersion = newVersion;
                } else {
                    for (int j = 0; j < newVersion.size(); ++j) {
                        ((ArrayList)oldVersion).add(newVersion.get(j));
                    }
                }
                mergedList.add(new Attribute(name, oldVersion));
                continue;
            }
            if (oldVersion instanceof ObjectName) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "old value  for " + name + " ObjectName");
                }
                mergedList.add(a);
                continue;
            }
            if (oldVersion.getClass().isArray()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "old value  for " + name + " Array");
                }
                mergedList.add(a);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "old value  for " + name + " type " + oldVersion.getClass().getName());
            }
            mergedList.add(a);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "merge");
        }
        return mergedList;
    }

    public AttributeList innerMerge(AttributeList oldList, AttributeList newList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "innerMerge");
        }
        AttributeList mergedList = new AttributeList();
        for (int i = 0; i < oldList.size(); ++i) {
            ArrayList oldVersion;
            Attribute a;
            String name;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute number: " + i);
            }
            if (SystemAttributes.isSystemAttribute(name = (a = (Attribute)oldList.get(i)).getName())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "sys attr " + name);
                }
                mergedList.add(a);
                continue;
            }
            Object newVersion = this.findAttribute(newList, name);
            if (newVersion == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "new value null");
                continue;
            }
            if (newVersion instanceof AttributeList) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new value AttributeList");
                }
                oldVersion = (AttributeList)a.getValue();
                AttributeList merged = this.innerMerge((AttributeList)oldVersion, (AttributeList)newVersion);
                mergedList.add(new Attribute(name, merged));
                continue;
            }
            if (newVersion instanceof ArrayList) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new value ArrayList");
                }
                oldVersion = (ArrayList)a.getValue();
                ArrayList new1 = (ArrayList)newVersion;
                if (new1.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deleting list because new list has size zero.");
                    }
                    oldVersion = new1;
                } else {
                    for (int j = 0; j < new1.size(); ++j) {
                        oldVersion.add(new1.get(j));
                    }
                }
                mergedList.add(new Attribute(name, oldVersion));
                continue;
            }
            if (newVersion instanceof ObjectName) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new value ObjectName");
                }
                mergedList.add(new Attribute(name, newVersion));
                continue;
            }
            if (newVersion.getClass().isArray()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new value Array");
                }
                mergedList.add(new Attribute(name, newVersion));
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "new value type " + newVersion.getClass().getName());
            }
            mergedList.add(new Attribute(name, newVersion));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "innerMerge");
        }
        return mergedList;
    }

    Object findAttribute(AttributeList l, String n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findAttribute", new Object[]{n});
        }
        Object ret = null;
        if (l != null) {
            for (int i = 0; i < l.size(); ++i) {
                Attribute a = (Attribute)l.get(i);
                String name = a.getName();
                if (!name.equals(n)) continue;
                ret = a.getValue();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findAttribute");
        }
        return ret;
    }

    public Object getAttributeValue(AttributeList attrList, String name) {
        Object result = null;
        for (Attribute attr : attrList) {
            if (!attr.getName().equals(name)) continue;
            result = attr.getValue();
            break;
        }
        return result;
    }

    public Attribute getAttribute(AttributeList attrList, String name) {
        Attribute result = null;
        for (Attribute attr : attrList) {
            if (!attr.getName().equals(name)) continue;
            result = attr;
            break;
        }
        return result;
    }

    public void OKToCreate(String type, ObjectName on, String processType, ObjectName connectedServer) throws ScriptingException {
        if (connectedServer != null) {
            String displayName = on.getKeyProperty("_Websphere_Config_Data_Display_Name");
            String serverNode = ObjectNameHelper.getNodeName(connectedServer);
            if (type.equals("Server") && "DeploymentManager".equals(processType) && displayName != null && displayName.equals(serverNode)) {
                this._shell.setAndThrowScriptingException("WASX7307E", "Cannot create object of type " + type + " on a Network Deployment Manager node.", new Object[]{type});
            }
        }
    }
}

