/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class AttrInfo {
    private String name;
    private String type;
    private boolean object;
    private boolean reference;
    private Hashtable enuminfo;
    private Object defaultval;
    private boolean collection;
    private Hashtable contained;
    private ArrayList subtypes;
    private boolean required;
    private String start;
    private String removed;
    private String deprecated;

    public AttrInfo(String name, String type, boolean object, boolean reference, Object defaultval, Hashtable enuminfo, boolean collection, boolean st) {
        this(name, type, object, reference, defaultval, enuminfo, collection, st, false);
    }

    public AttrInfo(String name, String type, boolean object, boolean reference, Object defaultval, Hashtable enuminfo, boolean collection, boolean st, boolean required) {
        this(name, type, object, reference, defaultval, enuminfo, collection, st, required, null, null, null);
    }

    public AttrInfo(String name, String type, boolean object, boolean reference, Object defaultval, Hashtable enuminfo, boolean collection, boolean st, boolean required, String start, String removed, String deprecated) {
        this.name = name;
        this.type = type;
        this.object = object;
        this.reference = reference;
        this.defaultval = defaultval;
        this.enuminfo = enuminfo;
        this.collection = collection;
        this.required = required;
        this.contained = this.object ? new Hashtable() : null;
        if (st) {
            this.subtypes = new ArrayList();
        }
        this.start = start;
        this.removed = removed;
        this.deprecated = deprecated;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDecoratedType() {
        StringBuffer buf = new StringBuffer(this.type);
        if (this.subtypes != null & !this.reference) {
            buf.append("(");
            for (int i = 0; i < this.subtypes.size(); ++i) {
                buf.append(this.subtypes.get(i));
                if (i >= this.subtypes.size() - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (this.reference) {
            buf.append("@");
        }
        if (this.collection) {
            buf.append("*");
        }
        if (this.enuminfo != null) {
            buf.append("(");
            Enumeration e = this.enuminfo.keys();
            while (e.hasMoreElements()) {
                String nm = (String)e.nextElement();
                buf.append(nm);
                if (!e.hasMoreElements()) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public boolean isObject() {
        return this.object;
    }

    public boolean isReference() {
        return this.reference;
    }

    public Object defaultValue() {
        return this.defaultval;
    }

    public Hashtable enumInfo() {
        return this.enuminfo;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public boolean hasSubtypes() {
        return this.subtypes != null;
    }

    public void addContained(String s, AttrInfo c) {
        this.contained.put(s, c);
    }

    public void addSubtypes(List l) {
        this.subtypes.addAll(l);
    }

    public Hashtable getContained() {
        return this.contained;
    }

    public ArrayList getSubtypes() {
        return this.subtypes;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getStart() {
        return this.start;
    }

    public String getRemoved() {
        return this.removed;
    }

    public String getDeprecated() {
        return this.deprecated;
    }
}

