/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.workloadcontroller;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.workloadcontroller.IWorkloadRegulator;
import com.ibm.ws.runtime.workloadcontroller.WorkloadRegulator;
import com.ibm.ws.runtime.workloadcontroller.WorkloadResource;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WorkloadController {
    public static final int DEFAULT_QUIESCE_TIMEOUT = 180;
    public static final String QUIESCE_TIMEOUT_PROP_NAME = "com.ibm.ejs.sm.server.quiesceTimeout";
    public static final int DEFAULT_QUIESCE_INACTIVE_REQUEST_TIME = 5000;
    public static final String QUIESCE_INACTIVE_REQUEST_TIME_PROP_NAME = "com.ibm.ejs.sm.server.quiesceInactiveRequestTime";
    private Hashtable _regulators = new Hashtable();
    private Vector _resources = new Vector();
    private boolean _fQuiesce = false;
    private boolean _fStarting = false;
    private boolean _fStarted = true;
    private boolean _fQuiesceComplete = false;
    private static WorkloadController _theInstance = null;
    private static TraceComponent tc = Tr.register(WorkloadController.class);

    private WorkloadController() {
    }

    public static WorkloadController getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (_theInstance == null) {
            WorkloadController.create();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance");
        }
        return _theInstance;
    }

    public static synchronized void registerResource(WorkloadResource wlr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerResource: " + wlr.getName());
        }
        WorkloadController instance = WorkloadController.getInstance();
        instance._resources.add(wlr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerResource");
        }
    }

    public static synchronized void registerRegulator(IWorkloadRegulator wlr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerRegulator: " + wlr.getName());
        }
        WorkloadController instance = WorkloadController.getInstance();
        instance._regulators.put(wlr.getName(), wlr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerRegulator");
        }
    }

    public static synchronized void registerRegulator(WorkloadRegulator wlr) {
        WorkloadController.registerRegulator((IWorkloadRegulator)wlr);
    }

    public static IWorkloadRegulator getRegulator(String sName) {
        return (IWorkloadRegulator)WorkloadController.getInstance()._regulators.get(sName);
    }

    public static boolean quiesce(int timeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "quiesce: timeout=" + timeout);
        }
        boolean fRet = false;
        if (timeout == 0) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "quiesce: quiesce timeout value = 0 - do not quiesce, just shutdown");
            }
            fRet = WorkloadController.quiesceCompleteWorkloads(-1);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "quiesce: quiesceCompleteWorkloads= " + fRet);
            }
            return fRet;
        }
        fRet = WorkloadController.quiesceWorkloads(-1, timeout);
        if (tc.isEntryEnabled()) {
            Tr.event(tc, "quiesce: workload quiesced=" + fRet);
        }
        fRet = WorkloadController.quiesceCompleteWorkloads(-1);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesce: quiesceCompleteWorkloads= " + fRet);
        }
        return fRet;
    }

    public static boolean inQuiesceMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inQuiesceMode");
        }
        WorkloadController instance = WorkloadController.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "inQuiesceMode: " + instance._fQuiesce);
        }
        return instance._fQuiesce;
    }

    protected static boolean quiesceWorkloads(int typeMask, int timeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "quiesceWorkloads: typeMask=" + typeMask + " timeout=" + timeout);
        }
        long timeoutMs = timeout * 1000;
        long startTime = System.currentTimeMillis();
        WorkloadController instance = WorkloadController.getInstance();
        instance._fQuiesce = true;
        instance._fStarting = false;
        instance._fStarted = false;
        instance._fQuiesceComplete = false;
        boolean fQuiesced = false;
        while (System.currentTimeMillis() < startTime + timeoutMs && !fQuiesced) {
            fQuiesced = true;
            Enumeration regulators = instance._regulators.keys();
            while (regulators.hasMoreElements()) {
                String sKey = (String)regulators.nextElement();
                IWorkloadRegulator regulator = (IWorkloadRegulator)instance._regulators.get(sKey);
                if (regulator == null) continue;
                if ((typeMask & regulator.getType()) == regulator.getType()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "quiesceWorkloads: will attempt to quiesce " + regulator.getName());
                    }
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "quiesceWorkloads: regulator " + regulator.getName() + " quiesce state is " + regulator.quiesce());
                    }
                    fQuiesced = regulator.quiesce() && fQuiesced;
                    continue;
                }
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "quiesceWorkloads: will NOT attempt to quiesce " + regulator.getName());
            }
            WorkloadController.shortSleep(fQuiesced);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesceWorkloads: fQuiesced=" + fQuiesced + " stop time=" + System.currentTimeMillis());
        }
        return fQuiesced;
    }

    public static boolean quiesceResources(int timeout) {
        WorkloadResource r;
        int rnum;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "quiesceResources: timeout=" + timeout);
        }
        long timeoutMs = timeout * 1000;
        long startTime = System.currentTimeMillis();
        WorkloadController instance = WorkloadController.getInstance();
        instance._fQuiesce = true;
        boolean fQuiesced = false;
        while (System.currentTimeMillis() < startTime + timeoutMs && !fQuiesced) {
            fQuiesced = true;
            for (rnum = 0; rnum < instance._resources.size(); ++rnum) {
                r = (WorkloadResource)instance._resources.get(rnum);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "quiesceResources: Checking for quiesced state of " + r.toString());
                }
                fQuiesced = r.isQuiesced() && fQuiesced;
            }
            WorkloadController.shortSleep(fQuiesced);
        }
        for (rnum = 0; rnum < instance._resources.size(); ++rnum) {
            r = (WorkloadResource)instance._resources.get(rnum);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "quiesceResources: Forcing quiesced state of " + r.toString());
            }
            if (r.isQuiesced()) continue;
            r.quiesce();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesceResources: fQuiesce=" + fQuiesced);
        }
        return fQuiesced;
    }

    protected static boolean quiesceCompleteWorkloads(int typeMask) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "quiesceCompleteWorkloads: typeMask= " + typeMask);
        }
        WorkloadController instance = WorkloadController.getInstance();
        instance._fStarting = false;
        instance._fStarted = false;
        instance._fQuiesce = false;
        instance._fQuiesceComplete = true;
        boolean fQuiesceComplete = true;
        Enumeration regulators = instance._regulators.keys();
        while (regulators.hasMoreElements()) {
            String sKey = (String)regulators.nextElement();
            IWorkloadRegulator regulator = (IWorkloadRegulator)instance._regulators.get(sKey);
            if (regulator == null) continue;
            if ((typeMask & regulator.getType()) == regulator.getType()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "quiesceCompleteWorkloads: will notify regulator " + regulator.getName());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "quiesceCompleteWorkloads: regulator " + regulator.getName() + " voted " + regulator.quiesceComplete() + " to allow quiesce to complete");
                }
                fQuiesceComplete = regulator.quiesceComplete() && fQuiesceComplete;
                continue;
            }
            if (!tc.isEventEnabled()) continue;
            Tr.event(tc, "quiesceCompleteWorkloads: will NOT notify regulator " + regulator.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesceCompleteWorkloads: fQuiesceComplete= " + fQuiesceComplete);
        }
        return fQuiesceComplete;
    }

    public static boolean inQuiesceCompleteMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inQuiesceCompleteMode ");
        }
        WorkloadController instance = WorkloadController.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "inQuiesceCompleteMode: " + instance._fQuiesceComplete);
        }
        return instance._fQuiesceComplete;
    }

    public static boolean starting() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "starting");
        }
        boolean fRet = false;
        fRet = WorkloadController.startingWorkloads(-1);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "starting " + fRet);
        }
        return fRet;
    }

    protected static boolean startingWorkloads(int typeMask) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startingWorkloads: typeMask= " + typeMask);
        }
        WorkloadController instance = WorkloadController.getInstance();
        instance._fStarting = true;
        instance._fStarted = false;
        instance._fQuiesce = false;
        instance._fQuiesceComplete = false;
        boolean fStarting = true;
        Enumeration regulators = instance._regulators.keys();
        while (regulators.hasMoreElements()) {
            String sKey = (String)regulators.nextElement();
            IWorkloadRegulator regulator = (IWorkloadRegulator)instance._regulators.get(sKey);
            if (regulator == null) continue;
            if ((typeMask & regulator.getType()) == regulator.getType()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "startingWorkloads: will notify regulator " + regulator.getName());
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "startingWorkloads: regulator " + regulator.getName() + " quiesce starting state is " + regulator.starting());
                }
                fStarting = regulator.starting() && fStarting;
                continue;
            }
            if (!tc.isEventEnabled()) continue;
            Tr.event(tc, "startingWorkloads: will NOT notify regulator " + regulator.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startingWorkloads: fStarting= " + fStarting);
        }
        return fStarting;
    }

    public static boolean inStartingMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inStartingMode ");
        }
        WorkloadController instance = WorkloadController.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "inStartingMode: " + instance._fStarting);
        }
        return instance._fStarting;
    }

    public static boolean started() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "started");
        }
        boolean fRet = false;
        fRet = WorkloadController.startedWorkloads(-1);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "started " + fRet);
        }
        return fRet;
    }

    protected static boolean startedWorkloads(int typeMask) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startedWorkloads: typeMask=" + typeMask);
        }
        WorkloadController instance = WorkloadController.getInstance();
        instance._fStarting = false;
        instance._fStarted = false;
        instance._fQuiesce = false;
        instance._fQuiesceComplete = false;
        boolean fStarted = true;
        Enumeration regulators = instance._regulators.keys();
        while (regulators.hasMoreElements()) {
            String sKey = (String)regulators.nextElement();
            IWorkloadRegulator regulator = (IWorkloadRegulator)instance._regulators.get(sKey);
            if (regulator == null) continue;
            if ((typeMask & regulator.getType()) == regulator.getType()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "startedWorkloads: will notify regulator " + regulator.getName());
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "startedWorkloads: regulator " + regulator.getName() + " quiesce started state is " + regulator.started());
                }
                fStarted = regulator.started() && fStarted;
                continue;
            }
            if (!tc.isEventEnabled()) continue;
            Tr.event(tc, "startedWorkloads: will NOT notify regulator " + regulator.getName());
        }
        instance._fStarted = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startedWorkloads: fStarted=" + fStarted);
        }
        return fStarted;
    }

    public static boolean inStartedMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inStartedMode");
        }
        WorkloadController instance = WorkloadController.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "inStartedMode: " + instance._fStarted);
        }
        return instance._fStarted;
    }

    protected static synchronized void create() {
        _theInstance = new WorkloadController();
    }

    protected static void shortSleep(boolean fQuiesced) {
        if (!fQuiesced) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                FFDCFilter.processException(ie, "com.ibm.ws.runtime.workloadcontroller.WorkloadController.shortSleep", "714");
            }
        }
    }
}

