/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.workloadcontroller;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.oa.EJSRootObjectAdapter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.workloadcontroller.WorkloadCollaborator;
import com.ibm.ws.runtime.workloadcontroller.WorkloadController;
import com.ibm.ws.runtime.workloadcontroller.WorkloadRegulator;
import java.util.Vector;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class OrbWorkloadRegulator
extends WorkloadRegulator {
    public static final int SYSTEM = 1;
    public static final int EXISTING = 2;
    public static final int NONE = 3;
    public static final int NEW = 4;
    public static final int UNDEFINED = 0;
    public static final int ACTIVITY_SESSION = 1;
    public static final int JBROKER_SUPPORT = 2;
    public static final int EJB_CONTAINER = 3;
    public static final int WLM_SERVER_QUIESCE = 1229066304;
    private static OrbWorkloadRegulator _reg = null;
    private ORB orb = null;
    private int _requests = 0;
    private int _replies = 0;
    private boolean _fAdvanced = true;
    private boolean _fQuiesceRequested = false;
    private boolean _fQuiesceComplete = false;
    private boolean _fStartingMode = false;
    private boolean _fStartedMode = true;
    private Vector _collaborators = null;
    private boolean[] _votes = null;
    private final Object lock = new Object();
    private long _lastRequestTime = 0L;
    private int _inactiveRequestTime = 5000;
    private static TraceComponent tc = Tr.register(OrbWorkloadRegulator.class);

    private OrbWorkloadRegulator(String sName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "OrbWorkloadRequlator", sName);
        }
        this._requests = 0;
        this._replies = 0;
        this._fQuiesceRequested = WorkloadController.inQuiesceMode();
        this._fQuiesceComplete = WorkloadController.inQuiesceCompleteMode();
        this._fStartingMode = WorkloadController.inStartingMode();
        this._fStartedMode = WorkloadController.inStartedMode();
        this._collaborators = new Vector();
        this._sName = sName;
        this._type = 1;
        WorkloadController.registerRegulator(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "OrbWorkloadRegulator", sName);
        }
    }

    protected static synchronized void create() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create");
        }
        if (_reg == null) {
            OrbWorkloadRegulator reg;
            block7: {
                reg = new OrbWorkloadRegulator("ORB");
                String waitTimeString = System.getProperty("com.ibm.ejs.sm.server.quiesceInactiveRequestTime");
                if (waitTimeString != null) {
                    try {
                        reg._inactiveRequestTime = Integer.parseInt(waitTimeString) * 1000;
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "create: setting quiesceInactiveRequestTime=" + reg._inactiveRequestTime);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        FFDCFilter.processException(nfe, "com.ibm.ws.runtime.workloadcontroller.OrbWorkloadRegulator.create", "195");
                        if (!tc.isEventEnabled()) break block7;
                        Tr.event(tc, "create: format exception: use default quiesceInactiveRequestTime=" + reg._inactiveRequestTime);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "create");
            }
            _reg = reg;
        }
    }

    public static boolean isVoteNeeded(int voterID) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isVoteNeeded", new Integer(voterID));
        }
        boolean fRet = false;
        if (_reg == null) {
            OrbWorkloadRegulator.create();
        }
        if (OrbWorkloadRegulator._reg._fQuiesceRequested) {
            fRet = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isVoteNeeded", new Boolean(fRet));
        }
        return fRet;
    }

    protected static void vote(int voterID, int contextReceived) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "vote: voterID=" + voterID + " contextReceived=" + contextReceived);
        }
        if (_reg == null) {
            OrbWorkloadRegulator.create();
        }
        SystemException exception = null;
        if (OrbWorkloadRegulator._reg._fQuiesceRequested && contextReceived != 1 && contextReceived != 2) {
            exception = _reg.getException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "vote", exception);
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected static void handleRequest(ServerRequestInfo serverRequestInfo) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequest:  ServerRequestInfo = " + serverRequestInfo);
        }
        if (_reg == null) {
            OrbWorkloadRegulator.create();
        }
        if (serverRequestInfo.response_expected()) {
            _reg.incrOutstanding();
        }
        if (OrbWorkloadRegulator._reg._fQuiesceRequested) {
            OrbWorkloadRegulator.handleRequestForQuiesceRequestedMode(serverRequestInfo);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleRequest: _fQuiesceRequested=true");
            }
            return;
        }
        if (OrbWorkloadRegulator._reg._fQuiesceComplete) {
            OrbWorkloadRegulator.handleRequestForQuiesceCompleteMode();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleRequest: _fQuiesceComplete=true");
            }
            return;
        }
        if (OrbWorkloadRegulator._reg._fStartingMode) {
            OrbWorkloadRegulator.handleRequestForStartingMode();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleRequest: _fStartingMode=true");
            }
            return;
        }
        if (OrbWorkloadRegulator._reg._fStartedMode) {
            OrbWorkloadRegulator.handleRequestForStartedMode();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleRequest: _fStartedMode=true");
            }
            return;
        }
        OrbWorkloadRegulator.handleRequestForStartedMode();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest: ");
        }
    }

    protected static void handleRequestForQuiesceRequestedMode(ServerRequestInfo serverRequestInfo) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequestForQuiesceRequestedMode");
        }
        boolean votes = false;
        OrbWorkloadRegulator._reg._lastRequestTime = System.currentTimeMillis();
        for (int i = 0; i < OrbWorkloadRegulator._reg._collaborators.size(); ++i) {
            WorkloadCollaborator collaborator = (WorkloadCollaborator)OrbWorkloadRegulator._reg._collaborators.elementAt(i);
            if (collaborator == null) continue;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "handleRequestForQuiesceRequestedMode: asking collaborator to vote ", new Object[]{collaborator});
            }
            votes = votes || collaborator.voteOnRequest(serverRequestInfo);
        }
        if (!votes) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "handleRequestForQuiesceRequestedMode: throw exception.");
            }
            SystemException se = _reg.getException();
            throw se;
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "handleRequestForQuiesceRequestedMode: someone voted to accept the request.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequestForQuiesceRequestedMode:  requests= " + OrbWorkloadRegulator._reg._requests + " replies= " + OrbWorkloadRegulator._reg._replies);
        }
    }

    protected static void handleRequestForQuiesceCompleteMode() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequestForQuiesceCompleteMode");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequestForQuiesceCompleteMode: throw exception.");
        }
        SystemException se = _reg.getException();
        throw se;
    }

    protected static void handleRequestForStartingMode() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequestForStartingMode");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequestForStartingMode");
        }
    }

    protected static void handleRequestForStartedMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequestForStartedMode");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequestForStartedMode:  requests= " + OrbWorkloadRegulator._reg._requests + " replies= " + OrbWorkloadRegulator._reg._replies);
        }
    }

    protected static void handleReply(ServerRequestInfo serverRequestInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleReply");
        }
        if (_reg == null) {
            OrbWorkloadRegulator.create();
        }
        if (serverRequestInfo.response_expected()) {
            _reg.decrOutstanding();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleReply: quiesceRequested=" + OrbWorkloadRegulator._reg._fQuiesceRequested + " requests=" + OrbWorkloadRegulator._reg._requests + " replies=" + OrbWorkloadRegulator._reg._replies);
        }
    }

    protected static void handleUserException(ServerRequestInfo serverRequestInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleUserException");
        }
        if (_reg == null) {
            OrbWorkloadRegulator.create();
        }
        if (serverRequestInfo.response_expected()) {
            _reg.decrOutstanding();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleUserException: quiesceRequested=" + OrbWorkloadRegulator._reg._fQuiesceRequested + " requests=" + OrbWorkloadRegulator._reg._requests + " replies=" + OrbWorkloadRegulator._reg._replies);
        }
    }

    public boolean quiesce() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "quiesce: type= " + this.getName());
        }
        boolean fRet = false;
        this._fQuiesceRequested = true;
        this._fQuiesceComplete = false;
        this._fStartingMode = false;
        this._fStartedMode = false;
        if (this._lastRequestTime == 0L) {
            this._lastRequestTime = System.currentTimeMillis();
        }
        long lastRequestDelta = System.currentTimeMillis() - this._lastRequestTime;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "quiesce: milliseconds since last request=" + lastRequestDelta);
        }
        fRet = !this.requestsOutstanding() && lastRequestDelta >= (long)this._inactiveRequestTime;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesce: type= " + this.getName() + ": fRet=" + fRet + " requests= " + this._requests + " replies= " + this._replies);
        }
        return fRet;
    }

    public boolean starting() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "starting: type= " + this.getName());
        }
        boolean fRet = true;
        this._fQuiesceRequested = false;
        this._fQuiesceComplete = false;
        this._fStartingMode = true;
        this._fStartedMode = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "starting: type= " + this.getName());
        }
        return fRet;
    }

    public boolean started() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "started: type= " + this.getName());
        }
        boolean fRet = true;
        this._fQuiesceRequested = false;
        this._fQuiesceComplete = false;
        this._fStartingMode = false;
        this._fStartedMode = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "started: type= " + this.getName());
        }
        return fRet;
    }

    public boolean quiesceComplete() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "quiesceComplete: type= " + this.getName());
        }
        try {
            EJSRootObjectAdapter OA = null;
            if (this.orb != null) {
                OA = (EJSRootObjectAdapter)this.orb.getObjectResolver();
            }
            if (OA != null) {
                OA.quiesce(this.getException());
            }
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        boolean fRet = true;
        this._fQuiesceComplete = true;
        this._fQuiesceRequested = false;
        this._fStartingMode = false;
        this._fStartedMode = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "quiesceComplete: type= " + this.getName());
        }
        return fRet;
    }

    public SystemException getException() {
        return new COMM_FAILURE(1229066304, CompletionStatus.COMPLETED_NO);
    }

    private boolean requestsOutstanding() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestsOutstanding", this.getName());
        }
        boolean fRet = false;
        if (this._requests - this._replies > 0) {
            fRet = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestsOutstanding: " + this.getName() + ": " + fRet);
        }
        return fRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrOutstanding() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "incrOutstanding", this.getName());
        }
        Object object = this.lock;
        synchronized (object) {
            this._requests = this._requests == Integer.MAX_VALUE ? 1 : ++this._requests;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "incrOutstanding: " + this.getName() + ":  req=" + this._requests + " rep=" + this._replies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrOutstanding() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decrOutstanding", this.getName());
        }
        Object object = this.lock;
        synchronized (object) {
            this._replies = this._replies == Integer.MAX_VALUE ? 1 : ++this._replies;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decrOutstanding: " + this.getName() + ": req=" + this._requests + " rep=" + this._replies);
        }
    }

    public static synchronized void registerCollaborator(WorkloadCollaborator wlc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerCollaborator: ", new Object[]{wlc});
        }
        if (_reg == null) {
            OrbWorkloadRegulator.create();
        }
        OrbWorkloadRegulator._reg._collaborators.addElement(wlc);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerCollaborator");
        }
    }

    public static OrbWorkloadRegulator getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (_reg == null) {
            OrbWorkloadRegulator.create();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance");
        }
        return _reg;
    }

    public void setORB(ORB orb) {
        this.orb = orb;
    }

    private OrbWorkloadRegulator() {
    }
}

