/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.runtime.service.impl.BundleContextMap;
import com.ibm.ws.runtime.util.StreamHandlerUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;

class URLStreamHandlerAdapter
implements URLStreamHandlerService {
    private URLStreamHandler urlStreamHandlerInstance = null;
    private String urlStreamHandlerClass = null;
    private String urlStreamHandlerClassPath = null;
    private String protocol = null;
    private ServiceRegistration registration = null;
    private static Method _equals;
    private static Method _getDefaultPort;
    private static Method _getHostAddress;
    private static Method _hashCode;
    private static Method _hostsEqual;
    private static Method _openConnection;
    private static Method _parseURL;
    private static Method _sameFile;
    private static Method _toExternalForm;
    private static Field _handlerField;
    private static TraceComponent tc;

    public URLStreamHandlerAdapter(String protocol, String urlStreamHandlerClass, String classPath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{protocol, urlStreamHandlerClass, classPath});
        }
        this.protocol = protocol;
        this.urlStreamHandlerClass = urlStreamHandlerClass;
        this.urlStreamHandlerClassPath = classPath;
        this.registerInOSGi();
    }

    void destroy() {
        this.deregisterFromOSGi();
    }

    public URLConnection openConnection(URL url) throws IOException {
        try {
            return (URLConnection)_openConnection.invoke(this.getInstance(), url);
        }
        catch (Exception e) {
            this.log(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseURL(URLStreamHandlerSetter setter, URL url, String arg2, int arg3, int arg4) {
        URLStreamHandler currentHandler = null;
        try {
            currentHandler = (URLStreamHandler)_handlerField.get(url);
            _handlerField.set(url, this.getInstance());
            _parseURL.invoke(this.getInstance(), url, arg2, new Integer(arg3), new Integer(arg4));
        }
        catch (Exception e) {
            this.log(e);
        }
        finally {
            if (currentHandler != null) {
                try {
                    _handlerField.set(url, currentHandler);
                }
                catch (Exception e) {
                    this.log(e);
                }
            }
        }
    }

    public String toExternalForm(URL url) {
        try {
            return (String)_toExternalForm.invoke(this.getInstance(), url);
        }
        catch (Exception e) {
            this.log(e);
            return null;
        }
    }

    public boolean equals(URL url1, URL url2) {
        try {
            Boolean result = (Boolean)_equals.invoke(this.getInstance(), url1, url2);
            return result;
        }
        catch (Exception e) {
            this.log(e);
            return false;
        }
    }

    public int getDefaultPort() {
        try {
            Integer result = (Integer)_getDefaultPort.invoke(this.getInstance(), null);
            return result;
        }
        catch (Exception e) {
            this.log(e);
            return 0;
        }
    }

    public InetAddress getHostAddress(URL url) {
        try {
            return (InetAddress)_getHostAddress.invoke(this.getInstance(), url);
        }
        catch (Exception e) {
            this.log(e);
            return null;
        }
    }

    public int hashCode(URL url) {
        try {
            Integer result = (Integer)_hashCode.invoke(this.getInstance(), url);
            return result;
        }
        catch (Exception e) {
            this.log(e);
            return url.hashCode();
        }
    }

    public boolean hostsEqual(URL url1, URL url2) {
        try {
            Boolean result = (Boolean)_hostsEqual.invoke(this.getInstance(), url1, url2);
            return result;
        }
        catch (Exception e) {
            this.log(e);
            return false;
        }
    }

    public boolean sameFile(URL url1, URL url2) {
        try {
            Boolean result = (Boolean)_sameFile.invoke(this.getInstance(), url1, url2);
            return result;
        }
        catch (Exception e) {
            this.log(e);
            return false;
        }
    }

    private void deregisterFromOSGi() {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    private void registerInOSGi() {
        BundleContext bundleContext = BundleContextMap.instance().get(this.getClass().getClassLoader());
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("url.handler.protocol", new String[]{this.protocol});
        this.registration = bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)this, properties);
    }

    private Object getInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException, MalformedURLException {
        if (this.urlStreamHandlerInstance == null) {
            this.urlStreamHandlerInstance = (URLStreamHandler)Class.forName(this.urlStreamHandlerClass, true, StreamHandlerUtils.getResourceClassLoader(this.urlStreamHandlerClassPath, null)).newInstance();
        }
        return this.urlStreamHandlerInstance;
    }

    private void log(Exception e) {
        Manager.Ffdc.log(e, this, null, "346");
    }

    static {
        tc = Tr.register(URLStreamHandlerAdapter.class, "Runtime", "com.ibm.ws.runtime.runtime");
        try {
            _equals = URLStreamHandler.class.getDeclaredMethod("equals", URL.class, URL.class);
            _equals.setAccessible(true);
            _getDefaultPort = URLStreamHandler.class.getDeclaredMethod("getDefaultPort", null);
            _getDefaultPort.setAccessible(true);
            _getHostAddress = URLStreamHandler.class.getDeclaredMethod("getHostAddress", URL.class);
            _getHostAddress.setAccessible(true);
            _hashCode = URLStreamHandler.class.getDeclaredMethod("hashCode", URL.class);
            _hashCode.setAccessible(true);
            _hostsEqual = URLStreamHandler.class.getDeclaredMethod("hostsEqual", URL.class, URL.class);
            _hostsEqual.setAccessible(true);
            _openConnection = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class);
            _openConnection.setAccessible(true);
            _parseURL = URLStreamHandler.class.getDeclaredMethod("parseURL", URL.class, String.class, Integer.TYPE, Integer.TYPE);
            _parseURL.setAccessible(true);
            _sameFile = URLStreamHandler.class.getDeclaredMethod("sameFile", URL.class, URL.class);
            _sameFile.setAccessible(true);
            _toExternalForm = URLStreamHandler.class.getDeclaredMethod("toExternalForm", URL.class);
            _toExternalForm.setAccessible(true);
            _handlerField = URL.class.getDeclaredField("handler");
            _handlerField.setAccessible(true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

