/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.WsRuntimeException;
import com.ibm.ws.runtime.config.ResourceLocator;
import com.ibm.ws.runtime.service.ConfigRoot;
import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceLocatorImpl
implements ResourceLocator {
    private static final TraceComponent tc = Tr.register(ResourceLocatorImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    protected String resourceName;

    public ResourceLocatorImpl(String resourceName) {
        this.resourceName = resourceName;
    }

    public Resource getResource(ConfigRoot configRoot, int context) {
        try {
            return configRoot.getResource(context, this.resourceName);
        }
        catch (FileNotFoundException fnfe) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, configRoot.getAbsolutePath(context, this.resourceName) + " not found\n", fnfe);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, configRoot.getAbsolutePath(context, this.resourceName) + " was not loaded\n", e);
            }
            throw new WsRuntimeException(e);
        }
        return null;
    }

    public boolean isResourceUpdated(long lastAccessTime, ConfigRoot configRoot, int context) {
        String path = configRoot.getAbsolutePath(context, this.resourceName);
        File file = new File(path);
        return file.lastModified() > lastAccessTime;
    }
}

