/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.WsRuntimeException;
import com.ibm.ws.runtime.service.ConfigRoot;
import java.io.File;
import org.eclipse.emf.common.util.URI;

public class RelativeURIContextResolver {
    static TraceComponent tc = Tr.register(RelativeURIContextResolver.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private int owningResourceType;
    private ConfigRoot thisResourcesConfigRoot;
    private int maximumAllowableContextPops = 0;
    private int numberOfContextPopsPerformed = 0;
    private String uriOfResourceBeingProcessed = null;
    private boolean heirachicalSearchAllowed = true;

    public void setOwningResourceType(int type, ConfigRoot configRoot, String resourceBeingProcessed) {
        this.owningResourceType = type;
        this.thisResourcesConfigRoot = configRoot;
        this.numberOfContextPopsPerformed = 0;
        this.uriOfResourceBeingProcessed = resourceBeingProcessed;
        switch (type) {
            case 2: {
                this.maximumAllowableContextPops = 0;
                break;
            }
            case 0: {
                this.maximumAllowableContextPops = 0;
                break;
            }
            case 3: {
                this.maximumAllowableContextPops = 1;
                break;
            }
            case 4: {
                this.maximumAllowableContextPops = 2;
                break;
            }
            case 1: {
                this.maximumAllowableContextPops = 0;
                break;
            }
        }
    }

    public URI resolveRelativeURI(URI uri) {
        URI newRootURI = null;
        String configRootPrefix = this.thisResourcesConfigRoot.getConfigRootPath();
        StringBuffer baseURI = null;
        int uriTrailingSeparatorCount = 0;
        if (uri.hasTrailingPathSeparator()) {
            uriTrailingSeparatorCount = 1;
        }
        switch (this.owningResourceType) {
            case 1: {
                if (uri.segmentCount() == uriTrailingSeparatorCount + 1) {
                    baseURI = this.thisResourcesConfigRoot.getURIBaseForType(this.owningResourceType);
                    newRootURI = URI.createFileURI(configRootPrefix + baseURI.toString() + File.separator);
                    this.heirachicalSearchAllowed = false;
                    break;
                }
                this.invalidURISegmentCount(uri);
                break;
            }
            case 2: {
                if (uri.segmentCount() == uriTrailingSeparatorCount + 1) {
                    baseURI = this.thisResourcesConfigRoot.getURIBaseForType(this.owningResourceType);
                    newRootURI = URI.createFileURI(configRootPrefix + baseURI.toString() + File.separator);
                    this.heirachicalSearchAllowed = false;
                    break;
                }
                this.invalidURISegmentCount(uri);
                break;
            }
            case 0: {
                if (uri.segmentCount() == uriTrailingSeparatorCount + 1) {
                    baseURI = this.thisResourcesConfigRoot.getURIBaseForType(this.owningResourceType);
                    newRootURI = URI.createFileURI(configRootPrefix + baseURI.toString() + File.separator);
                    this.heirachicalSearchAllowed = false;
                    break;
                }
                this.invalidURISegmentCount(uri);
                break;
            }
            case 3: {
                if (uri.segmentCount() == uriTrailingSeparatorCount + 1) {
                    baseURI = this.thisResourcesConfigRoot.getURIBaseForType(this.owningResourceType);
                    newRootURI = URI.createFileURI(configRootPrefix + baseURI.toString() + File.separator);
                    break;
                }
                if (uri.segmentCount() == uriTrailingSeparatorCount + 3) {
                    baseURI = this.thisResourcesConfigRoot.getURIBaseForType(0);
                    newRootURI = URI.createFileURI(configRootPrefix + baseURI.toString() + File.separator);
                    this.heirachicalSearchAllowed = false;
                    break;
                }
                this.invalidURISegmentCount(uri);
                break;
            }
            case 4: {
                if (uri.segmentCount() == uriTrailingSeparatorCount + 1) {
                    baseURI = this.thisResourcesConfigRoot.getURIBaseForType(this.owningResourceType);
                    newRootURI = URI.createFileURI(configRootPrefix + baseURI.toString() + File.separator);
                    break;
                }
                this.heirachicalSearchAllowed = false;
                if (uri.segmentCount() == uriTrailingSeparatorCount + 3) {
                    baseURI = this.thisResourcesConfigRoot.getURIBaseForType(3);
                    newRootURI = URI.createFileURI(configRootPrefix + baseURI.toString() + File.separator);
                    break;
                }
                if (uri.segmentCount() == uriTrailingSeparatorCount + 5) {
                    baseURI = this.thisResourcesConfigRoot.getURIBaseForType(0);
                    newRootURI = URI.createFileURI(configRootPrefix + baseURI.toString() + File.separator);
                    break;
                }
                this.invalidURISegmentCount(uri);
                break;
            }
            default: {
                this.invalidResourceType(this.owningResourceType);
            }
        }
        URI newURI = null;
        if (this.heirachicalSearchAllowed) {
            if (this.numberOfContextPopsPerformed > 0) {
                if (newRootURI.hasTrailingPathSeparator()) {
                    newRootURI = newRootURI.trimSegments(this.numberOfContextPopsPerformed * 2 + 1);
                    newRootURI = URI.createFileURI(newRootURI.path() + File.separator);
                } else {
                    newRootURI = newRootURI.trimSegments(this.numberOfContextPopsPerformed * 2);
                }
            }
            newURI = uri;
        } else {
            int segmentCount = uri.segmentCount();
            String fileName = null;
            fileName = uri.segment(segmentCount - (uriTrailingSeparatorCount + 1));
            newURI = uri.trimSegments(segmentCount);
            newURI = newURI.appendSegment(fileName);
            if (uriTrailingSeparatorCount > 0) {
                newRootURI = URI.createFileURI(newRootURI.path() + File.separator);
            }
        }
        URI result = newURI.resolve(newRootURI);
        return result;
    }

    private void invalidURISegmentCount(URI uri) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSVR0230E", new Object[]{uri.toString()});
        }
        throw new WsRuntimeException();
    }

    private void invalidResourceType(int resourceType) {
        Tr.error(tc, "WSVR0231E", new Object[]{new Integer(resourceType)});
        throw new WsRuntimeException();
    }

    public boolean popSearchContext() {
        if (this.heirachicalSearchAllowed) {
            if (this.numberOfContextPopsPerformed < this.maximumAllowableContextPops) {
                ++this.numberOfContextPopsPerformed;
                return true;
            }
            return false;
        }
        return false;
    }

    public String getURIOfResourceBeingProcessed() {
        return this.uriOfResourceBeingProcessed;
    }
}

