/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.WsRuntimeException;
import com.ibm.ws.runtime.config.DocumentLocator;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

public class DocumentLocatorImpl
implements DocumentLocator {
    private static final TraceComponent tc = Tr.register(DocumentLocatorImpl.class, "RCS", "com.ibm.ws.runtime.runtime");
    private String name;

    public DocumentLocatorImpl(String name) {
        this.name = name;
    }

    public List getDocumentObjects(ConfigService configService, ConfigScope scope, boolean readCache) {
        try {
            return configService.getDocumentObjects(scope, this.name, readCache);
        }
        catch (FileNotFoundException ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, scope.getAbsolutePath(this.name) + " not found", ex);
            }
            return null;
        }
        catch (IOException ex) {
            throw new WsRuntimeException(ex);
        }
        catch (ConfigurationError ex) {
            throw new WsRuntimeException(ex);
        }
    }

    public boolean isUpdated(long lastAccessTime, ConfigService configService, ConfigScope scope) {
        String path = scope.getAbsolutePath(this.name);
        File file = new File(path);
        return file.lastModified() > lastAccessTime;
    }
}

