/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.binder;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.IndirectJndiLookup;
import com.ibm.ws.runtime.component.binder.GenericJMSDestinationIndirectLookup;
import com.ibm.ws.runtime.component.binder.ResourceBindingException;
import com.ibm.ws.runtime.component.collaborator.JMSResourceMBean;
import com.ibm.ws.runtime.resource.ResourceBinderImpl;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.Enumeration;
import java.util.Properties;

public class JMSDestinationBinder
extends ResourceBinderImpl {
    private static TraceComponent tc = Tr.register(JMSDestinationBinder.class, "ResourceBinders", "com.ibm.ejs.jms.messaging");

    public boolean isUsedFor(ConfigObject resource) {
        return resource.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.xmi", "GenericJMSDestination");
    }

    public String getNamePrefix() {
        return "jms";
    }

    public Object getBindingObject(ConfigObject f) throws ResourceBindingException {
        ConfigObject provider = f.getParent();
        String genericJMSDestinationName = f.getString("name", "__null__");
        String externalInitialContextFactory = provider.getString("externalInitialContextFactory", "__null__");
        String externalProviderURL = provider.getString("externalProviderURL", "__null__");
        String externalJNDIName = null;
        String className = "javax.jms.Destination";
        if (f.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.xmi", "GenericJMSDestination")) {
            ConfigObject destination = f;
            externalJNDIName = destination.getString("externalJNDIName", "__null__");
            className = destination.getString("type", "QUEUE").equals("TOPIC") ? "javax.jms.Topic" : (destination.getString("type", "QUEUE").equals("QUEUE") ? "javax.jms.Queue" : "javax.jms.Destination");
        } else if (f.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.xmi", "GenericJMSConnectionFactory")) {
            ConfigObject connFact = f;
            externalJNDIName = connFact.getString("externalJNDIName", "__null__");
        } else {
            throw new ResourceBindingException(f, "unknown JMS resource type: " + f.getClass().getName());
        }
        this.checkRequiredProperty(externalJNDIName, "Invalid Configuration! The JMS Resource: " + genericJMSDestinationName + " has a null externalJNDIName property.");
        this.checkRequiredProperty(externalInitialContextFactory, "Invalid Configuration! The JMS Resource: " + genericJMSDestinationName + " has a null externalInitialContextFactory property.");
        this.checkRequiredProperty(externalProviderURL, "Invalid Configuration! The JMS Resource: " + genericJMSDestinationName + " has a null externalProviderURL property.");
        if (externalJNDIName.equals("") || externalInitialContextFactory.equals("") || externalProviderURL.equals("")) {
            String error = "Invalid Configuration! The JMS Resource: " + genericJMSDestinationName + " has an empty string property.";
            throw new ResourceBindingException(error);
        }
        Properties customProperties = new Properties();
        this.addPropertySet(customProperties, provider.getObject("propertySet"), true);
        Properties destinationCustomProperties = new Properties();
        this.addPropertySet(destinationCustomProperties, f.getObject("propertySet"), true);
        boolean cacheDestination = false;
        Enumeration<?> e = destinationCustomProperties.propertyNames();
        while (e.hasMoreElements()) {
            try {
                String prop = (String)e.nextElement();
                if (!prop.equals("com.ibm.ejs.messaging.GenericDestinationCache")) continue;
                cacheDestination = Boolean.valueOf(destinationCustomProperties.getProperty(prop));
            }
            catch (Exception exc) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Problem getting destination custom properties: " + e);
            }
        }
        IndirectJndiLookup lookup = new IndirectJndiLookup(externalJNDIName, externalInitialContextFactory, externalProviderURL, false, className, customProperties);
        IndirectJndiLookup ref = null;
        if (cacheDestination) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caching Destination");
            }
            ref = new GenericJMSDestinationIndirectLookup(externalJNDIName, externalInitialContextFactory, externalProviderURL, false, className, customProperties);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not Caching Destination");
            }
            ref = lookup;
        }
        return ref;
    }

    public void activateProviderMBean(ConfigObject rp, String serverName) {
        new JMSResourceMBean(rp, serverName);
    }
}

