/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.component.ChannelFrameworkServiceImpl;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import javax.naming.Context;
import javax.naming.InitialContext;

public class CFSBinder
extends WsComponentImpl {
    private static final TraceComponent tc = Tr.register(CFSBinder.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    protected boolean _started = false;
    protected String _configID;
    protected boolean _frameworkEnabled = true;
    protected ChannelFrameworkService cfs = null;

    public void initialize(Object configuration) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        ConfigObject root;
        block3: {
            ConfigService configService = null;
            root = null;
            try {
                configService = WsServiceRegistry.getService(this, ConfigService.class);
                root = ChannelFrameworkServiceImpl.getConfig(configService);
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Caught Exception while obtaining registry service: " + e);
            }
        }
        String string = this._configID = root != null ? this.getConfigId(root) : this.getClass().getName();
        if (root != null && root.isSet("enable") && !root.getBoolean("enable", false)) {
            this._frameworkEnabled = false;
            Tr.audit(tc, "framework.disabled");
            throw new ConfigurationWarning("framework.disabled");
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        block11: {
            if (this._started) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "ChannelFrameworkService MBean registration skipped because we are ALREADY started");
                }
                return;
            }
            this.bindJNDIService();
            if (this._frameworkEnabled) {
                try {
                    if (this.cfs != null) {
                        this.registerMBean("TransportChannelService", new DefaultRuntimeCollaborator(this.cfs), "TransportChannelService", this._configID, null);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "ChannelFrameworkService MBean successfully registered");
                        }
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "ChannelFrameworkService not registering MBean due to null ref");
                    }
                    break block11;
                }
                catch (Exception exp) {
                    FFDCFilter.processException((Throwable)exp, this.getClass().getName() + ".start", "123", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "ChannelFrameworkService MBean registration failed; " + exp);
                    }
                    break block11;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ChannelFrameworkService MBean registration skipped since it is DISABLED");
            }
        }
        this._started = true;
    }

    public void stop() {
        if (this._frameworkEnabled) {
            this.deregisterMBean(this._configID);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ChannelFrameworkService MBean successfully deregistered");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ChannelFrameworkService MBean deregistration skipped");
        }
        this._started = false;
    }

    public void destroy() {
    }

    protected void bindJNDIService() {
        block6: {
            try {
                this.cfs = WsServiceRegistry.getService(this, ChannelFrameworkService.class);
                if (this.cfs != null) {
                    JndiHelper.recursiveBind((Context)new InitialContext(), "services:websphere/ChannelFrameworkService", (Object)this.cfs);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "ChannelFrameworkService successfully bound into the services context.");
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "ChannelFrameworkService could not be found.");
                }
            }
            catch (Throwable exp) {
                FFDCFilter.processException(exp, this.getClass().getName() + ".bindJNDIService", "126", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "ChannelFrameworkService could not be bound into the services context; " + exp);
            }
        }
    }
}

