/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.WSThreadPoolRepository;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPool;

public final class WSThreadPool
implements ThreadPool {
    private static final TraceComponent tc = Tr.register(WSThreadPool.class, "Runtime", "com.ibm.ws.runtime");
    private com.ibm.ws.util.ThreadPool _threadPool;
    private WSThreadPoolRepository _repository;

    protected WSThreadPool(com.ibm.ws.util.ThreadPool threadPool, WSThreadPoolRepository repository2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSThreadPool", threadPool);
        }
        this._threadPool = threadPool;
        this._repository = repository2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSThreadPool");
        }
    }

    public void setThreadWaiting(boolean isWaiting) {
        this._threadPool.setThreadWaiting(isWaiting);
    }

    protected WSThreadPool(String name, int minSize, int maxSize, long keepAliveTime, WSThreadPoolRepository repository2) {
        this._threadPool = new com.ibm.ws.util.ThreadPool(name, minSize, maxSize);
        this._threadPool.setKeepAliveTime(keepAliveTime);
        this._repository = repository2;
    }

    protected WSThreadPool(String name, int minSize, int maxSize, long keepAliveTime, int backingStorageSize, WSThreadPoolRepository repository2) {
        this(name, minSize, maxSize, keepAliveTime, repository2);
        this._threadPool.setRequestBufferSize(backingStorageSize);
    }

    public int execute(Runnable command) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", command);
        }
        try {
            this._threadPool.execute(command, this.mapExecutionMode(0));
        }
        catch (InterruptedException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.WSThreadPool.execute", "97", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", new Integer(1));
            }
            return 1;
        }
        catch (IllegalStateException ise) {
            FFDCFilter.processException((Throwable)ise, "com.ibm.ws.runtime.WSThreadPool.execute", "103", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", new Integer(1));
            }
            return 1;
        }
        catch (ThreadPool.ThreadPoolQueueIsFullException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.WSThreadPool.execute", "109", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", new Integer(2));
            }
            return 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", new Integer(0));
        }
        return 0;
    }

    public int execute(Runnable command, int mode) throws UnsupportedOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", new Object[]{command, new Integer(mode)});
        }
        try {
            this._threadPool.execute(command, this.mapExecutionMode(mode));
        }
        catch (InterruptedException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.WSThreadPool.execute", "155", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", new Integer(1));
            }
            return 1;
        }
        catch (IllegalStateException ise) {
            FFDCFilter.processException((Throwable)ise, "com.ibm.ws.runtime.WSThreadPool.execute", "161", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", new Integer(1));
            }
            return 1;
        }
        catch (ThreadPool.ThreadPoolQueueIsFullException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.runtime.WSThreadPool.execute", "167", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute", new Integer(2));
            }
            return 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute", new Integer(0));
        }
        return 0;
    }

    public void setMinimumPoolSize(int minimumPoolSize) throws UnsupportedOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMinimumPoolSize", new Integer(minimumPoolSize));
        }
        this._threadPool.setMinimumPoolSize(minimumPoolSize);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMinimumPoolSize");
        }
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMaximumPoolSize", new Integer(maximumPoolSize));
        }
        this._threadPool.setMaximumPoolSize(maximumPoolSize);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMaximumPoolSize");
        }
    }

    public int getMinimumPoolSize() {
        return this._threadPool.getMinimumPoolSize();
    }

    public int getMaximumPoolSize() {
        return this._threadPool.getMaximumPoolSize();
    }

    public long getKeepAliveTime() {
        return this._threadPool.getKeepAliveTime();
    }

    public void setKeepAliveTime(long keepAliveTime) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeepAliveTime", new Long(keepAliveTime));
        }
        this._threadPool.setKeepAliveTime(keepAliveTime);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKeepAliveTime");
        }
    }

    public void shutdown() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        this._threadPool.shutdownAfterProcessingCurrentlyQueuedTasks();
        this._repository.removeThreadPool(this._threadPool.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    public com.ibm.ws.util.ThreadPool getBackingThreadPool() {
        return this._threadPool;
    }

    private int mapExecutionMode(int executionMode) throws UnsupportedOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapExecutionMode", new Integer(executionMode));
        }
        int mappedMode = 0;
        switch (executionMode) {
            case 0: {
                mappedMode = 1;
                break;
            }
            case 1: {
                mappedMode = 0;
                break;
            }
            case 2: {
                mappedMode = 2;
                break;
            }
            case 3: {
                mappedMode = 3;
                break;
            }
            default: {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "mapExecutionMode");
                }
                throw new UnsupportedOperationException("Unsupported execution mode : " + executionMode);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapExecutionMode", new Integer(mappedMode));
        }
        return mappedMode;
    }
}

