/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.StatsConfigHelper;
import com.ibm.ws.pmi.wire.WpdCollection;
import com.ibm.ws.pmi.wire.WpdData;
import com.ibm.wsspi.pmi.stat.SPIStats;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public class StatsImpl
implements SPIStats,
WpdCollection,
PmiConstants,
Serializable {
    private static final long serialVersionUID = -5812710047173154854L;
    protected String statsType;
    protected String name;
    protected int type;
    protected int instrumentationLevel = -1;
    protected ArrayList dataMembers;
    protected ArrayList subCollections;
    protected long time = PmiUtil.currentTime();
    private transient boolean bTextInfoInited = false;
    private static transient boolean bTextInfoEnabled = true;
    private static transient boolean bTextInfoTranslationEnabled = true;
    private static transient Locale _locale = null;

    public StatsImpl(String name, int type) {
        this(name, type, -1, null, null);
    }

    public StatsImpl(String name, int type, int level) {
        this(name, type, level, null, null);
    }

    public StatsImpl(String name, int type, int level, ArrayList dataMembers, ArrayList subCollections) {
        if (name == null) {
            name = "Undefined";
        }
        this.name = name;
        this.type = type == 11 || type == 12 || type == 13 ? type : 17;
        this.instrumentationLevel = level;
        this.dataMembers = dataMembers;
        this.subCollections = subCollections;
    }

    public StatsImpl(String statsType, String name, int type, int level, ArrayList dataMembers, ArrayList subCollections) {
        this(name, type, level, dataMembers, subCollections);
        this.statsType = statsType;
    }

    public String getName() {
        return this.name;
    }

    public int numStatistics() {
        if (this.dataMembers == null) {
            return 0;
        }
        return this.dataMembers.size();
    }

    public String getStatsType() {
        return this.statsType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatsType(String modName) {
        this.statsType = modName;
    }

    public int getType() {
        return this.type;
    }

    public long getTime() {
        return this.time;
    }

    public synchronized void setTime(long t) {
        this.time = t;
    }

    public int getLevel() {
        return this.instrumentationLevel;
    }

    public void setLevel(int level) {
        this.instrumentationLevel = level;
    }

    public static void setEnableTextInfo(boolean flag) {
        bTextInfoEnabled = flag;
    }

    public static boolean getEnableTextInfo() {
        return bTextInfoEnabled;
    }

    public static void setEnableNLS(boolean flag, Locale locale) {
        _locale = locale;
        bTextInfoTranslationEnabled = flag;
    }

    public static boolean getEnableNLS() {
        return bTextInfoTranslationEnabled;
    }

    public static Locale getNLSLocale() {
        return _locale;
    }

    public void setStatistics(ArrayList dataMembers) {
        this.dataMembers = dataMembers;
    }

    public void setSubStats(ArrayList subCollections) {
        this.subCollections = subCollections;
    }

    public WSStatistic getStatistic(int dataId) {
        ArrayList members = this.copyStatistics();
        if (members == null || members.size() <= 0) {
            return null;
        }
        if (!this.bTextInfoInited) {
            this.bindTextForWSCall();
        }
        int sz = members.size();
        for (int i = 0; i < sz; ++i) {
            StatisticImpl data = (StatisticImpl)members.get(i);
            if (data == null || data.getId() != dataId) continue;
            return data;
        }
        return null;
    }

    public WSStatistic getStatistic(String name) {
        ArrayList members = this.copyStatistics();
        if (members == null) {
            return null;
        }
        if (!this.bTextInfoInited) {
            this.bindTextForWSCall();
        }
        int sz = members.size();
        for (int i = 0; i < sz; ++i) {
            StatisticImpl statistic = (StatisticImpl)members.get(i);
            if (statistic == null || !statistic.getName().equals(name)) continue;
            return statistic;
        }
        return null;
    }

    public WSStatistic[] getStatistics() {
        ArrayList members = this.copyStatistics();
        if (members == null || members.size() == 0) {
            return new StatisticImpl[0];
        }
        if (!this.bTextInfoInited) {
            this.bindTextForWSCall();
        }
        WSStatistic[] ret = new StatisticImpl[members.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (StatisticImpl)members.get(i);
        }
        return ret;
    }

    public WSStatistic[] listStatistics() {
        return this.getStatistics();
    }

    public String[] listStatisticNames() {
        return this.getStatisticNames();
    }

    public String[] getStatisticNames() {
        ArrayList members = this.copyStatistics();
        if (members == null) {
            return new String[0];
        }
        if (!this.bTextInfoInited) {
            this.bindTextForWSCall();
        }
        String[] ret = new String[members.size()];
        for (int i = 0; i < ret.length; ++i) {
            if (members.get(i) == null) continue;
            ret[i] = ((StatisticImpl)members.get(i)).getName();
        }
        return ret;
    }

    public StatisticImpl getJ2EEStatistic(String name) {
        ArrayList members = this.copyStatistics();
        if (members == null) {
            return null;
        }
        if (!this.bTextInfoInited) {
            this.bindTextForJ2EECall();
        }
        int sz = members.size();
        for (int i = 0; i < sz; ++i) {
            StatisticImpl statistic = (StatisticImpl)members.get(i);
            if (statistic == null || !statistic.getName().equals(name)) continue;
            return statistic;
        }
        return null;
    }

    public StatisticImpl[] getJ2EEStatistics() {
        ArrayList members = this.copyStatistics();
        if (members == null || members.size() == 0) {
            return new StatisticImpl[0];
        }
        if (!this.bTextInfoInited) {
            this.bindTextForJ2EECall();
        }
        StatisticImpl[] ret = new StatisticImpl[members.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (StatisticImpl)members.get(i);
        }
        return ret;
    }

    public String[] getJ2EEStatisticNames() {
        ArrayList members = this.copyStatistics();
        if (members == null) {
            return new String[0];
        }
        if (!this.bTextInfoInited) {
            this.bindTextForJ2EECall();
        }
        String[] ret = new String[members.size()];
        for (int i = 0; i < ret.length; ++i) {
            if (members.get(i) == null) continue;
            ret[i] = ((StatisticImpl)members.get(i)).getName();
        }
        return ret;
    }

    public WSStats getStats(String name) {
        ArrayList collections = this.copyStats();
        if (collections == null) {
            return null;
        }
        StatsImpl stat = null;
        for (int i = 0; i < collections.size(); ++i) {
            stat = (StatsImpl)collections.get(i);
            if (!stat.getName().equals(name)) continue;
            return stat;
        }
        return null;
    }

    public WSStats[] getSubStats() {
        ArrayList collections = this.copyStats();
        if (collections == null || collections.size() == 0) {
            return new StatsImpl[0];
        }
        WSStats[] ret = new StatsImpl[collections.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (StatsImpl)collections.get(i);
        }
        return ret;
    }

    public WSStats[] listSubStats() {
        return this.getSubStats();
    }

    public synchronized boolean add(StatisticImpl newMember) {
        if (this.dataMembers == null) {
            this.dataMembers = new ArrayList();
        }
        if (newMember == null) {
            return false;
        }
        this.dataMembers.add(newMember);
        return true;
    }

    public synchronized boolean add(StatsImpl newMember) {
        if (this.subCollections == null) {
            this.subCollections = new ArrayList();
        }
        if (newMember == null) {
            return false;
        }
        this.subCollections.add(newMember);
        return true;
    }

    public synchronized boolean remove(int dataId) {
        if (this.dataMembers == null || this.dataMembers.size() <= 0) {
            return false;
        }
        for (int i = this.dataMembers.size() - 1; i >= 0; --i) {
            if (((StatisticImpl)this.dataMembers.get(i)).getId() != dataId) continue;
            this.dataMembers.remove(i);
            return true;
        }
        return false;
    }

    public synchronized boolean remove(String name) {
        if (this.subCollections == null || this.subCollections.size() <= 0) {
            return false;
        }
        for (int i = this.subCollections.size() - 1; i >= 0; --i) {
            StatsImpl collection = (StatsImpl)this.subCollections.get(i);
            if (!collection.getName().equals(name)) continue;
            this.subCollections.remove(i);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        ArrayList collections;
        if (!this.bTextInfoInited) {
            this.bindTextForWSCall();
        }
        String myIndent = indent;
        String typeString = null;
        switch (this.type) {
            case 10: {
                typeString = "PMIROOT";
                break;
            }
            case 11: {
                typeString = "NODE";
                break;
            }
            case 12: {
                typeString = "SERVER";
                break;
            }
            case 13: {
                typeString = "MODULE";
                break;
            }
            case 15: {
                typeString = "SUBMODULE";
                break;
            }
            case 14: {
                typeString = "INSTANCE";
                break;
            }
            case 16: {
                typeString = "SUBINSTANCE";
                break;
            }
            case 17: {
                typeString = "COLLECTION";
                break;
            }
            default: {
                typeString = "WRONG_TYPE";
            }
        }
        StringBuffer res = new StringBuffer();
        res.append("\n");
        res.append(indent);
        res.append("Stats name=").append(this.name);
        res.append(", type=").append(this.getStatsType());
        res.append("\n{");
        ArrayList members = this.copyStatistics();
        if (members != null) {
            for (int i = 0; i < members.size(); ++i) {
                StatisticImpl data = (StatisticImpl)members.get(i);
                if (data == null) continue;
                res.append("\n").append(myIndent);
                res.append(data.toString());
                res.append("\n");
            }
        }
        if ((collections = this.copyStats()) != null) {
            for (int i = 0; i < collections.size(); ++i) {
                StatsImpl col = (StatsImpl)collections.get(i);
                if (col == null) continue;
                res.append(col.toString(myIndent));
            }
        }
        res.append("}");
        return res.toString();
    }

    public void setConfig(PmiModuleConfig config) {
        if (config == null) {
            return;
        }
        this.bTextInfoInited = true;
        ArrayList members = this.copyStatistics();
        if (members != null) {
            for (int i = 0; i < members.size(); ++i) {
                StatisticImpl data = (StatisticImpl)members.get(i);
                if (data == null) continue;
                data.setDataInfo(config);
            }
        }
    }

    public boolean add(WpdData newMember) {
        return false;
    }

    public boolean add(WpdCollection newMember) {
        if (newMember instanceof StatsImpl) {
            return this.add((StatsImpl)newMember);
        }
        return false;
    }

    public String toXML() {
        ArrayList collections;
        String typeString = null;
        switch (this.type) {
            case 11: {
                typeString = "NODE";
                break;
            }
            case 12: {
                typeString = "SERVER";
                break;
            }
            case 13: {
                typeString = "MODULE";
                break;
            }
            case 17: {
                typeString = "COLLECTION";
                break;
            }
            default: {
                typeString = "WRONG_TYPE";
            }
        }
        StringBuffer res = new StringBuffer();
        res.append("<Stats name=\"");
        res.append(this.name);
        res.append("\" statType=\"");
        res.append(this.getStatsType());
        res.append("\" il=\"");
        res.append(this.instrumentationLevel);
        res.append("\" type=\"");
        res.append(typeString);
        res.append("\">\n");
        ArrayList members = this.copyStatistics();
        if (members != null) {
            for (int i = 0; i < members.size(); ++i) {
                StatisticImpl data = (StatisticImpl)members.get(i);
                if (data == null) continue;
                res.append(data.toXML());
                res.append("\n");
            }
        }
        if ((collections = this.copyStats()) != null) {
            for (int i = 0; i < collections.size(); ++i) {
                StatsImpl col = (StatsImpl)collections.get(i);
                if (col == null) continue;
                res.append(col.toXML());
            }
        }
        res.append("</Stats>");
        res.append("\n");
        return res.toString();
    }

    public void setDataMembers(ArrayList dataMembers) {
        this.setStatistics(dataMembers);
    }

    public void setSubcollections(ArrayList subCollections) {
        this.setSubStats(subCollections);
    }

    public ArrayList dataMembers() {
        return this.dataMembers;
    }

    public synchronized ArrayList copyStatistics() {
        if (this.dataMembers != null) {
            return new ArrayList(this.dataMembers);
        }
        return null;
    }

    public ArrayList subCollections() {
        return this.subCollections;
    }

    public synchronized ArrayList copyStats() {
        if (this.subCollections != null) {
            return new ArrayList(this.subCollections);
        }
        return null;
    }

    public WpdData getData(int dataId) {
        System.err.println("Warning: this method is defunc'ed - call getStatistic(dataId) instead");
        return null;
    }

    public WpdCollection getSubcollection(String name) {
        System.err.println("Warning: this method is defunc'ed - call getStats(name) instead");
        return null;
    }

    public synchronized void update(WSStats newStats, boolean keepOld, boolean recursiveUpdate) {
        if (newStats == null) {
            return;
        }
        StatsImpl newStats1 = (StatsImpl)newStats;
        if (!this.name.equals(newStats1.getName()) || this.type != newStats1.getType()) {
            return;
        }
        this.myupdate(newStats1, keepOld, recursiveUpdate);
    }

    private synchronized void myupdate(WSStats newStats, boolean keepOld, boolean recursiveUpdate) {
        if (newStats == null) {
            return;
        }
        StatsImpl newStats1 = (StatsImpl)newStats;
        this.instrumentationLevel = newStats1.getLevel();
        this.updateMembers(newStats, keepOld);
        if (recursiveUpdate) {
            this.updateSubcollection(newStats, keepOld, recursiveUpdate);
        }
    }

    private synchronized void updateMembers(WSStats grp, boolean keepOld) {
        if (!keepOld) {
            this.dataMembers = null;
        }
        if (grp == null) {
            return;
        }
        if (this.dataMembers == null || this.dataMembers.size() == 0) {
            this.dataMembers = ((StatsImpl)grp).dataMembers;
        } else {
            WSStatistic[] otherdata = grp.getStatistics();
            if (otherdata == null || otherdata.length == 0) {
                return;
            }
            for (int i = 0; i < otherdata.length; ++i) {
                boolean found = false;
                StatisticImpl myData = null;
                for (int n = 0; n < this.dataMembers.size(); ++n) {
                    myData = (StatisticImpl)this.dataMembers.get(n);
                    if (otherdata[i].getId() != myData.getId()) continue;
                    found = true;
                    myData.update(otherdata[i]);
                    break;
                }
                if (found) continue;
                this.dataMembers.add(otherdata[i]);
            }
        }
    }

    private synchronized void updateSubcollection(WSStats otherStats, boolean keepOld, boolean recursiveUpdate) {
        if (!keepOld) {
            this.subCollections = null;
        }
        if (otherStats == null) {
            return;
        }
        if (this.subCollections == null || this.subCollections.size() == 0) {
            this.subCollections = ((StatsImpl)otherStats).subCollections;
        } else {
            WSStats[] newSubStats = otherStats.getSubStats();
            if (newSubStats == null || newSubStats.length == 0) {
                return;
            }
            StatsImpl thisStats = null;
            for (int i = 0; i < newSubStats.length; ++i) {
                boolean found = false;
                int cmp = 0;
                int index = -1;
                for (int j = 0; j < this.subCollections.size(); ++j) {
                    thisStats = (StatsImpl)this.subCollections.get(j);
                    cmp = newSubStats[i].getName().compareTo(thisStats.getName());
                    if (cmp == 0) {
                        found = true;
                        thisStats.update(newSubStats[i], keepOld, recursiveUpdate);
                        break;
                    }
                    if (cmp >= 0) continue;
                    index = i;
                    break;
                }
                if (!found && index > 0) {
                    this.subCollections.add(index, newSubStats[i]);
                    continue;
                }
                if (found || index != -1) continue;
                this.subCollections.add(newSubStats[i]);
            }
        }
    }

    public void resetOnClient(boolean recursive) {
        int i;
        if (this.dataMembers != null) {
            StatisticImpl data = null;
            for (i = 0; i < this.dataMembers.size(); ++i) {
                data = (StatisticImpl)this.dataMembers.get(i);
                data.resetOnClient(null);
            }
        }
        if (!recursive) {
            return;
        }
        if (this.subCollections != null) {
            StatsImpl col = null;
            for (i = 0; i < this.subCollections.size(); ++i) {
                col = (StatsImpl)this.subCollections.get(i);
                col.resetOnClient(recursive);
            }
        }
    }

    private void bindTextForJ2EECall() {
        PmiModuleConfig cfg = StatsConfigHelper.getTranslatedStatsConfig(this.getStatsType(), Locale.ENGLISH);
        if (cfg != null) {
            this.setConfig(cfg);
        }
    }

    private void bindTextForWSCall() {
        if (!bTextInfoEnabled) {
            return;
        }
        PmiModuleConfig cfg = null;
        cfg = bTextInfoTranslationEnabled ? StatsConfigHelper.getTranslatedStatsConfig(this.getStatsType(), _locale) : StatsConfigHelper.getStatsConfig(this.getStatsType());
        if (cfg != null) {
            this.setConfig(cfg);
        }
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
    }
}

