/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdLongExternalValue;
import com.ibm.websphere.pmi.server.SpdStatExternalValue;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.pmi.server.data.SpdLongExternal;
import com.ibm.ws.pmi.server.data.SpdStatExternal;
import com.ibm.ws.pmi.server.system.SystemData;
import com.ibm.ws.pmi.stat.AverageStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.wsspi.pmi.stat.SPIStatistic;

public class SystemModule
extends PmiAbstractModule {
    private static final long serialVersionUID = -4785156674247042753L;
    public static String moduleID = "systemModule";
    private static final int defaultLevel = 0;
    private SpdLongExternal freeMemory;
    private SpdLongExternal cpuUtilization;
    private SpdStatExternal avgCpuUtilization;
    public static final int CPU_UTILIZATION = 1;
    public static final int AVG_CPU_UTILIZATION = 2;
    public static final int FREE_MEMORY = 3;
    private SystemData systemData;
    private SystemPerfData avgCPUPerfData;
    private static PlatformHelper platHelp = AdminHelper.getPlatformHelper();
    private static final TraceComponent tc = Tr.register(SystemModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");

    public SystemModule(String nodeName) {
        boolean successCreate;
        block5: {
            super(moduleID, nodeName);
            this.freeMemory = null;
            this.cpuUtilization = null;
            this.avgCpuUtilization = null;
            this.systemData = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "new SystemModule");
            }
            this.type = 13;
            successCreate = true;
            try {
                this.systemData = new SystemData();
            }
            catch (UnsatisfiedLinkError ule) {
                successCreate = false;
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "SystemModule constructor failed");
            }
        }
        if (successCreate) {
            this.avgCPUPerfData = new SystemPerfData(2, this.systemData);
            super.registerModule(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "new SystemModule");
        }
    }

    protected SpdData createOneData(PmiDataInfo info) {
        int dataId = info.getId();
        if (dataId == 3) {
            this.freeMemory = new SpdLongExternal(dataId, new SystemPerfData(3, this.systemData));
            return this.freeMemory;
        }
        if (dataId == 1) {
            this.cpuUtilization = new SpdLongExternal(dataId, new SystemPerfData(1, this.systemData));
            return this.cpuUtilization;
        }
        if (dataId == 2) {
            this.avgCpuUtilization = new SpdStatExternal(dataId, this.avgCPUPerfData);
            return this.avgCpuUtilization;
        }
        if (tc.isDebugEnabled()) {
            Tr.warning(tc, "PMI0008W", " ID = " + dataId);
        }
        return null;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    private class SystemPerfData
    implements SpdLongExternalValue,
    SpdStatExternalValue {
        int type = 0;
        private SystemData systemData;
        private SPIStatistic statistic;

        public SystemPerfData(int type, SystemData sysData) {
            this.type = type;
            this.systemData = sysData;
            this.statistic = type == 1 || type == 3 ? new CountStatisticImpl(type) : new AverageStatisticImpl(type);
        }

        public SPIStatistic getLongValue() {
            return this.statistic;
        }

        public SPIStatistic getStatValue() {
            return this.statistic;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateStatistic() {
            if (!platHelp.isZOS() || !platHelp.isServantJvm()) {
                long thisValue = 0L;
                if (this.type == 1) {
                    thisValue = this.systemData.getCpuUtilization();
                    ((CountStatisticImpl)this.statistic).setCount(thisValue);
                } else if (this.type == 2) {
                    SPIStatistic sPIStatistic = this.statistic;
                    synchronized (sPIStatistic) {
                        AverageStatisticImpl tstat = (AverageStatisticImpl)this.statistic;
                        long curTime = System.currentTimeMillis();
                        long count = (curTime - this.statistic.getLastSampleTime()) / 1000L;
                        if (count > 0L) {
                            thisValue = this.systemData.getCpuUtilization();
                            long min = tstat.getMin();
                            long max = tstat.getMax();
                            if (min < 0L) {
                                min = thisValue;
                            } else if (thisValue < min) {
                                min = thisValue;
                            }
                            if (thisValue > max) {
                                max = thisValue;
                            }
                            tstat.set(tstat.getCount() + count, min, max, tstat.getTotal() + thisValue * count, 0.0, tstat.getStartTime(), curTime);
                        }
                    }
                } else if (this.type == 3) {
                    thisValue = this.systemData.getFreeMemory();
                    ((CountStatisticImpl)this.statistic).setCount(thisValue);
                } else if (tc.isDebugEnabled()) {
                    Tr.warning(tc, "PMI0008W", "dataId=" + this.type);
                }
            }
        }
    }
}

