/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.ServletSessionsPerf;
import com.ibm.websphere.pmi.SessionMemoryInfo;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.server.SpdStatExternalValue;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.data.SpdStatExternal;
import com.ibm.ws.pmi.server.modules.RuntimeModule;
import com.ibm.ws.pmi.stat.AverageStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import com.ibm.wsspi.pmi.stat.SPIStatistic;

public class ServletSessionsModule
extends PmiAbstractModule
implements ServletSessionsPerf {
    private static final long serialVersionUID = 2268750772220281170L;
    protected static TraceComponent tc = Tr.register(ServletSessionsModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static final String moduleID = "servletSessionsModule";
    public static final int defaultLevel = 0;
    private CountStatisticImpl createdSessions = null;
    private CountStatisticImpl invalidatedSessions = null;
    private CountStatisticImpl finalizedSessions = null;
    private TimeStatisticImpl sessionLifeTime = null;
    private TimeStatisticImpl sessionInvalidateTime = null;
    private RangeStatisticImpl activeSessions = null;
    private RangeStatisticImpl liveSessions = null;
    private boolean notPrinted = true;
    private CountStatisticImpl sessCreateErrors = null;
    private CountStatisticImpl cacheDiscards = null;
    private CountStatisticImpl affinityBreaks = null;
    private TimeStatisticImpl extReadTime = null;
    private AverageStatisticImpl extReadSize = null;
    private TimeStatisticImpl extWriteTime = null;
    private AverageStatisticImpl extWriteSize = null;
    private TimeStatisticImpl timeSinceLastActivated = null;
    private CountStatisticImpl invalidateViaTimeout = null;
    private CountStatisticImpl activateNonExistSession = null;
    private AverageStatisticImpl serializableObjSize = null;
    private AverageStatisticImpl myObjSize = null;
    public static final int CREATED_SESSIONS = 1;
    public static final int INVALIDATED_SESSIONS = 2;
    public static final int FINALIZED_SESSIONS = 3;
    public static final int SESSION_LIFE_TIME = 4;
    public static final int SESSION_INVALIDATE_TIME = 5;
    public static final int ACTIVE_SESSIONS = 6;
    public static final int LIVE_SESSIONS = 7;
    public static final int SESSION_CREATE_ERRORS = 8;
    public static final int CACHE_DISCARDS = 9;
    public static final int EXTERNAL_READ_TIME = 10;
    public static final int EXTERNAL_READ_SIZE = 11;
    public static final int EXTERNAL_WRITE_TIME = 12;
    public static final int EXTERNAL_WRITE_SIZE = 13;
    public static final int AFFINITY_BREAKS = 14;
    public static final int TIME_SINCE_LAST_ACTIVATED = 15;
    public static final int INVALIDATE_VIA_TIMEOUT = 16;
    public static final int INVALIDATE_NONEXIST_SESSION = 17;
    public static final int SERIALIZABLE_SESSOBJ_SIZE = 18;

    public ServletSessionsModule(String webappName, PmiCallback callback) {
        super(moduleID, webappName, callback);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new ServletSessionsModule, webapp=" + webappName);
        }
        this.registerModule(this);
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    protected boolean longCreated(SpdLong data) {
        switch (data.getId()) {
            case 1: {
                this.createdSessions = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 2: {
                this.invalidatedSessions = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 3: {
                this.finalizedSessions = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 8: {
                this.sessCreateErrors = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 9: {
                this.cacheDiscards = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 14: {
                this.affinityBreaks = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 16: {
                this.invalidateViaTimeout = (CountStatisticImpl)data.getStatistic();
                return true;
            }
            case 17: {
                this.activateNonExistSession = (CountStatisticImpl)data.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean statCreated(SpdStat data) {
        switch (data.getId()) {
            case 4: {
                this.sessionLifeTime = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
            case 5: {
                this.sessionInvalidateTime = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
            case 10: {
                this.extReadTime = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
            case 11: {
                this.extReadSize = (AverageStatisticImpl)data.getStatistic();
                return true;
            }
            case 12: {
                this.extWriteTime = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
            case 13: {
                this.extWriteSize = (AverageStatisticImpl)data.getStatistic();
                return true;
            }
            case 15: {
                this.timeSinceLastActivated = (TimeStatisticImpl)data.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected boolean loadCreated(SpdLoad data) {
        switch (data.getId()) {
            case 6: {
                this.activeSessions = (RangeStatisticImpl)data.getStatistic();
                return true;
            }
            case 7: {
                this.liveSessions = (RangeStatisticImpl)data.getStatistic();
                return true;
            }
        }
        return false;
    }

    protected SpdData createOneData(PmiDataInfo info) {
        int dataId = info.getId();
        if (dataId == 18) {
            this.myObjSize = new TimeStatisticImpl(dataId);
            return new SpdStatExternal(dataId, new SessionObjSize());
        }
        return super.createOneData(info);
    }

    public final void sessionCreated() {
        if (this.createdSessions != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sessionCreated");
            }
            this.createdSessions.increment();
        }
    }

    public final void sessionActivated() {
        if (this.activeSessions != null) {
            this.activeSessions.increment();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sessionActivated");
            }
        }
    }

    public final void sessionActivated(long timeAfterLastActivation) {
        if (this.activeSessions != null) {
            this.activeSessions.increment();
        }
        if (this.timeSinceLastActivated != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sessionActivated, timeAfterLastActivation=" + timeAfterLastActivation);
            }
            if (timeAfterLastActivation >= 0L) {
                this.timeSinceLastActivated.add(timeAfterLastActivation);
            }
        }
    }

    public final void sessionInactivated() {
        if (this.activeSessions != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sessionInactivated");
            }
            this.activeSessions.decrement();
        }
    }

    public final void sessionInvalidated(long creationTime) {
        if (this.invalidatedSessions != null) {
            this.invalidatedSessions.increment();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sessionInvalidated, creationTime=" + creationTime);
            }
        }
        if (this.sessionLifeTime != null && creationTime >= RuntimeModule.jvmStartTime) {
            this.sessionLifeTime.add(System.currentTimeMillis() - creationTime);
        }
    }

    public void sessionFinalized(long invalidationTime) {
        if (this.finalizedSessions == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sessionFinalized, invalidationTime=" + invalidationTime);
        }
        if (this.notPrinted) {
            System.err.println("WARNING: sessionFinalized is called");
            this.notPrinted = false;
        }
    }

    public final void sessionAdded() {
        if (this.liveSessions != null) {
            this.liveSessions.increment();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sessionAdded");
            }
        }
    }

    public final void sessionRemoved() {
        if (this.liveSessions != null) {
            this.liveSessions.decrement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sessionRemoved");
            }
        }
    }

    public final void noRoomForNewSession() {
        if (this.sessCreateErrors != null) {
            this.sessCreateErrors.increment();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "noRoomForNewSession");
            }
        }
    }

    public final void discardCache() {
        if (this.cacheDiscards != null) {
            this.cacheDiscards.increment();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "discardCache");
            }
        }
    }

    public final void readExternal(long timeTaken, long readSize) {
        if (this.extReadTime != null && timeTaken >= 0L) {
            this.extReadTime.add(timeTaken * 1L);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "readExternal, time=" + timeTaken + ", size=" + readSize);
            }
        }
        if (this.extReadSize != null && readSize >= 0L) {
            this.extReadSize.add(readSize);
        }
    }

    public final void writeExternal(long timeTaken, long writeSize) {
        if (this.extWriteTime != null && timeTaken >= 0L) {
            this.extWriteTime.add(timeTaken * 1L);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeExternal, time=" + timeTaken + ", size=" + writeSize);
            }
        }
        if (this.extWriteSize != null && writeSize >= 0L) {
            this.extWriteSize.add(writeSize);
        }
    }

    public final void affinityBreak() {
        if (this.affinityBreaks != null) {
            this.affinityBreaks.increment();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "affinityBreak");
            }
        }
    }

    public final void invalidatedViaTimeout() {
        if (this.invalidateViaTimeout != null) {
            this.invalidateViaTimeout.increment();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invalidatedViaTimeout");
            }
        }
    }

    public final void attempToActiveNonExistSession() {
        if (this.activateNonExistSession != null) {
            this.activateNonExistSession.increment();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attempToActiveNonExistSession");
            }
        }
    }

    public void unregister() {
        PmiRegistry.unregisterModule(this);
    }

    protected void initializeMe(int newLevel) {
        if (this.currentLevel >= 7 || newLevel < 7) {
            return;
        }
        long numSessions = 0L;
        if (this.activeSessions != null) {
            numSessions = this.activeSessions.getCurrent();
        }
        if (numSessions < 0L) {
            this.activeSessions.setLastValue(0L);
        }
        numSessions = 0L;
        if (this.liveSessions != null) {
            numSessions = this.liveSessions.getCurrent();
        }
        if (numSessions < 0L) {
            this.liveSessions.setLastValue(0L);
        }
    }

    private final class SessionObjSize
    implements SpdStatExternalValue {
        private SessionObjSize() {
        }

        public SPIStatistic getStatValue() {
            return ServletSessionsModule.this.myObjSize;
        }

        public void updateStatistic() {
            if (ServletSessionsModule.this.callback == null) {
                ServletSessionsModule.this.myObjSize.set(0L, 0L, 0L, 0L, 0.0, ServletSessionsModule.this.myObjSize.getStartTime(), System.currentTimeMillis());
            } else {
                SessionMemoryInfo info = (SessionMemoryInfo)ServletSessionsModule.this.callback.getRuntimeInfo();
                long total = info.getTotal() * 1L;
                ServletSessionsModule.this.myObjSize.set(info.getCount(), info.getMin(), info.getMax(), total, total * total, ServletSessionsModule.this.myObjSize.getStartTime(), System.currentTimeMillis());
            }
        }
    }
}

