/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.data;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.ws.pmi.stat.StatisticImpl;

public abstract class SpdDataImpl
implements SpdData,
PmiConstants {
    protected final int dataId;
    protected boolean enabled = true;
    protected boolean sync = false;

    public SpdDataImpl(PmiModuleConfig moduleConfig, String name) {
        this.dataId = moduleConfig != null ? moduleConfig.getDataId(name) : -1;
    }

    public SpdDataImpl(int id) {
        this.dataId = id;
    }

    public int getId() {
        return this.dataId;
    }

    public void enable(int level) {
        this.sync = level >= 7;
        if (!this.enabled) {
            this.enabled = true;
            this.reset();
        }
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int compareTo(SpdData other) {
        if (this.dataId < other.getId()) {
            return -1;
        }
        if (this.dataId > other.getId()) {
            return 1;
        }
        return 0;
    }

    public void reset() {
        this.reset(true);
    }

    public void setDataInfo(PmiModuleConfig moduleConfig) {
        StatisticImpl stat = this.getStatistic();
        if (stat != null) {
            stat.setDataInfo(moduleConfig);
        }
    }

    public abstract void reset(boolean var1);

    public abstract StatisticImpl getStatistic();

    public boolean isExternal() {
        return false;
    }

    public void updateExternal() {
    }

    public boolean isAggregate() {
        return false;
    }
}

