/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiJmxMapper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.xml.ParserFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PmiJmxMapParser
extends DefaultHandler
implements PmiConstants {
    private static final TraceComponent tc = Tr.register(PmiJmxMapParser.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static final String MAPPER = "Mapper";
    private static final String MBEAN_TYPE = "mbeanType";
    private static final String PERF_MODULE = "perfModule";
    private static final String PERF_SUBMODULE = "perfSubmodule";
    private static final String MODULE_ONLY = "moduleOnly";
    private PmiJmxMapper jmxMapper = null;
    private String mbeanType = null;
    private String perfModule = null;
    private String perfInstance = null;
    private String perfSubmodule = null;
    private boolean isModuleOnlyMapping = false;
    private String currentChars = null;
    private Locator locator = null;
    private InputStream istream;
    private XMLReader parser;

    public PmiJmxMapParser(PmiJmxMapper mapper) {
        this.jmxMapper = mapper;
    }

    private void reInit() {
        this.mbeanType = null;
        this.perfModule = null;
        this.perfInstance = null;
        this.perfSubmodule = null;
        this.isModuleOnlyMapping = false;
        this.currentChars = null;
        this.locator = null;
    }

    public void parse(String fileName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse", fileName);
        }
        final String _fileName = fileName;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PmiJmxMapParser.this.istream = this.getClass().getResourceAsStream(_fileName);
                try {
                    PmiJmxMapParser.this.parser = ParserFactory.createXMLReader();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        this._parse(this.istream, fileName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parse");
        }
    }

    public void parseExtensions() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    PmiJmxMapParser.this.getExtensionInfo();
                    HashSet<URL> resourceSet = new HashSet<URL>();
                    Enumeration<URL> e = Thread.currentThread().getContextClassLoader().getResources("pmiJmxMapperExtension.xml");
                    while (e.hasMoreElements()) {
                        resourceSet.add(e.nextElement());
                    }
                    for (URL aUrl : resourceSet) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Loading pmiJmxMapperExtension: " + aUrl.getFile());
                        }
                        PmiJmxMapParser.this.istream = aUrl.openStream();
                        PmiJmxMapParser.this.parser = ParserFactory.createXMLReader();
                        PmiJmxMapParser.this._parse(PmiJmxMapParser.this.istream, aUrl.getFile());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return null;
            }
        });
    }

    private void getExtensionInfo() {
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (registry == null) {
            Tr.error(tc, "Unable to get eclipse extension registry");
            return;
        }
        String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".pmiJmxMapperExtension";
        IExtensionPoint extensionPoint = registry.getExtensionPoint(epid);
        if (extensionPoint == null) {
            Tr.error(tc, "Unable to get extension point - " + epid);
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing extension point " + epid);
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        block0: for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] mapperElements;
            IExtension extension2 = extensions[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing extension " + extension2.getUniqueIdentifier());
            }
            if ((mapperElements = extension2.getConfigurationElements()).length != 1) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Invalid number of main elements - " + mapperElements.length);
                continue;
            }
            IConfigurationElement mapperElement = mapperElements[0];
            if (!mapperElement.getName().equals(MAPPER)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Invalid name of main element - expecting <Mapper> but got <" + mapperElement.getName() + ">");
                continue;
            }
            IConfigurationElement[] mapperChildren = mapperElement.getChildren();
            String mbeanType = null;
            String perfModule = null;
            String perfSubModule = null;
            String moduleOnly = "false";
            for (int j = 0; j < mapperChildren.length; ++j) {
                IConfigurationElement mapperChild = mapperChildren[j];
                String childName = mapperChild.getName();
                if (childName.equals(MBEAN_TYPE)) {
                    mbeanType = mapperChild.getValue();
                    continue;
                }
                if (childName.equals(PERF_MODULE)) {
                    perfModule = mapperChild.getValue();
                    continue;
                }
                if (childName.equals("perfSubModule")) {
                    perfSubModule = mapperChild.getValue();
                    continue;
                }
                if (childName.equals(MODULE_ONLY)) {
                    moduleOnly = mapperChild.getValue();
                    continue;
                }
                if (!tc.isDebugEnabled()) continue block0;
                Tr.debug(tc, "Invalid element name under Mapper - " + childName);
                continue block0;
            }
            if (mbeanType == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Required element <mbeanType> missing under <Mapper>");
                continue;
            }
            if (perfModule == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Required element <perfModule> missing under <Mapper>");
                continue;
            }
            if (!moduleOnly.equals("true") && !moduleOnly.equals("false")) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Invalid value for <moduleOnly> - expecting 'true' or 'false' but got '" + moduleOnly + "'");
                continue;
            }
            this.jmxMapper.setMapping(perfModule, this.perfInstance, this.perfSubmodule, mbeanType);
            if (!moduleOnly.equals("true")) continue;
            this.jmxMapper.setModuleOnlyMapping(perfModule, mbeanType);
        }
    }

    private void _parse(InputStream istream, String fileName) {
        this.reInit();
        if (istream == null) {
            Tr.error(tc, "PMI0010W", fileName);
            return;
        }
        try {
            this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
            boolean validateDescriptors = Boolean.getBoolean("com.ibm.websphere.pmi.validateDescriptors");
            this.parser.setFeature("http://xml.org/sax/features/validation", validateDescriptors);
            this.parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", validateDescriptors);
            this.parser.setEntityResolver(this);
            this.parser.setContentHandler(this);
            this.parser.setErrorHandler(this);
            InputSource source = new InputSource(istream);
            source.setSystemId(fileName);
            this.parser.parse(source);
            istream.close();
            this.parser = null;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.pmi.server.PmiJmxParser._parse", "97", this);
            return;
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void error(SAXParseException exception) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "error", exception);
        }
        throw new SAXException(exception);
    }

    public void startDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startDocument");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startDocument");
        }
    }

    public void endDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "endDocument");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "endDocument");
        }
    }

    public void startElement(String uri, String localpart, String rawname, Attributes attributes) throws SAXException {
        if (rawname.equals(MAPPER)) {
            this.isModuleOnlyMapping = false;
            this.perfSubmodule = null;
            this.perfModule = null;
            this.mbeanType = null;
        } else if (rawname.equals(MBEAN_TYPE) || rawname.equals(PERF_MODULE) || rawname.equals(PERF_SUBMODULE) || rawname.equals(MODULE_ONLY)) {
            // empty if block
        }
        this.currentChars = null;
    }

    public void endElement(String uri, String localpart, String rawname) throws SAXException {
        if (rawname.equals(MAPPER)) {
            this.jmxMapper.setMapping(this.perfModule, this.perfInstance, this.perfSubmodule, this.mbeanType);
            if (this.isModuleOnlyMapping) {
                this.jmxMapper.setModuleOnlyMapping(this.perfModule, this.mbeanType);
            }
        } else if (rawname.equals(MBEAN_TYPE)) {
            this.mbeanType = this.currentChars;
        } else if (rawname.equals(PERF_MODULE)) {
            this.perfModule = this.currentChars;
        } else if (rawname.equals(PERF_SUBMODULE)) {
            this.perfSubmodule = this.currentChars;
        } else if (rawname.equals(MODULE_ONLY) && this.currentChars.equals("true")) {
            this.isModuleOnlyMapping = true;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tmpStr = new String(ch, start, length);
        this.currentChars = this.currentChars == null ? tmpStr : this.currentChars + tmpStr;
    }
}

