/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.CachePerf;
import com.ibm.websphere.pmi.ConnPoolPerf;
import com.ibm.websphere.pmi.J2CPerf;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.ServletSessionsPerf;
import com.ibm.websphere.pmi.ThreadPoolPerf;
import com.ibm.websphere.pmi.WLMPerf;
import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.server.PmiModuleGenericImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.modules.CachePerfModule;
import com.ibm.ws.pmi.server.modules.ConnPoolModule;
import com.ibm.ws.pmi.server.modules.J2CModule;
import com.ibm.ws.pmi.server.modules.ResourcePmiModule;
import com.ibm.ws.pmi.server.modules.RuntimeModule;
import com.ibm.ws.pmi.server.modules.ServletSessionsModule;
import com.ibm.ws.pmi.server.modules.SystemModule;
import com.ibm.ws.pmi.server.modules.ThreadPoolModule;
import com.ibm.ws.pmi.server.modules.WLMModule;
import com.ibm.ws.pmi.server.modules.WSGWModule;
import com.ibm.ws.pmi.server.modules.WebServicesModule;
import com.ibm.ws390.sm.smf.SmfServletSessionsModule;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.ObjectName;

public class PmiFactory
implements PmiConstants {
    private static HashMap webAppMap = new HashMap();
    private static HashMap webServicesMap = new HashMap();
    private static final TraceComponent tc = Tr.register(PmiFactory.class, null, "com.ibm.ws.pmi.properties.PMIMessages");

    public static PmiModule createPmiModule(String moduleName) {
        return PmiFactory.createPmiModule(moduleName, (ArrayList)null);
    }

    public static PmiModule createPmiModule(String moduleName, String instanceName) {
        if (instanceName == null) {
            return PmiFactory.createPmiModule(moduleName, (ArrayList)null);
        }
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(instanceName);
        return PmiFactory.createPmiModule(moduleName, params);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static PmiModule createPmiModule(String moduleName, ArrayList params) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        if (moduleName == null) {
            Tr.warning(tc, "PMI0013W", "createPmiModule");
            return null;
        }
        Object perfModule = null;
        String instanceName = null;
        if (params != null && params.size() > 0 && params.get(0) instanceof String) {
            instanceName = (String)params.get(0);
        }
        if (moduleName.equals("threadPoolModule")) {
            if (instanceName != null && params.size() == 3) {
                int min = (Integer)params.get(1);
                int max = (Integer)params.get(2);
                perfModule = PmiFactory.createThreadPoolPerf(instanceName, min, max, null);
                return (PmiModule)perfModule;
            }
            Tr.warning(tc, "PMI0012W", "createPmiModule.threadPool");
            return (PmiModule)perfModule;
        }
        if (moduleName.equals("connectionPoolModule")) {
            if (instanceName == null) {
                Tr.warning(tc, "PMI0012W", "createPmiModule.connectionPool");
                return (PmiModule)perfModule;
            }
            perfModule = PmiFactory.createConnPoolPerf(instanceName, null, null, null);
            return (PmiModule)perfModule;
        }
        if (moduleName.equals("j2cModule")) {
            if (instanceName == null) {
                Tr.warning(tc, "PMI0012W", "createPmiModule.j2c");
                return (PmiModule)perfModule;
            }
            perfModule = PmiFactory.createJ2CPerf(instanceName, null, null, null);
            return (PmiModule)perfModule;
        }
        if (moduleName.equals("jvmRuntimeModule")) {
            perfModule = PmiFactory.createJvmPerf(-1, -1);
            return (PmiModule)perfModule;
        }
        if (moduleName.equals("servletSessionsModule")) {
            perfModule = PmiFactory.createServletSessionsPerf();
            return (PmiModule)perfModule;
        }
        if (moduleName.equals("transactionModule")) {
            if (params != null && params.size() == 1) {
                perfModule = PmiFactory.createTransactionPerf(params.get(0), null);
                return (PmiModule)perfModule;
            }
            Tr.warning(tc, "PMI0012W", "createPmiModule.JTA");
            return null;
        }
        if (moduleName.equals("webServicesModule")) {
            if (params == null || params.size() != 2) {
                Tr.warning(tc, "PMI0012W", "createPmiModule.webservices");
                return null;
            }
            if (params.get(0) instanceof String && params.get(1) instanceof String) {
                perfModule = PmiFactory.createWebServicesPerf((String)params.get(0), (String)params.get(1));
                return (PmiModule)perfModule;
            }
            Tr.warning(tc, "PMI0013W", "createPmiModule.webservices");
            return null;
        }
        if (moduleName.equals("wlmModule")) {
            if (params != null && params.size() == 1) {
                perfModule = PmiFactory.createWLMPerf((String)params.get(0));
                return (PmiModule)perfModule;
            }
            Tr.warning(tc, "PMI0012W", "createPmiModule.WLM");
            return null;
        }
        if (!moduleName.equals("wsgwModule")) {
            perfModule = new PmiModuleGenericImpl(moduleName, instanceName);
            return (PmiModule)perfModule;
        }
        if (params != null && params.size() == 1) {
            perfModule = PmiFactory.createWSGWPerf((String)params.get(0));
            return (PmiModule)perfModule;
        }
        Tr.warning(tc, "PMI0012W", "createPmiModule.webservices");
        return null;
    }

    public static ThreadPoolPerf createThreadPoolPerf(String poolName, int minPoolSize, int maxPoolSize) {
        return PmiFactory.createThreadPoolPerf(poolName, minPoolSize, maxPoolSize, null);
    }

    public static ThreadPoolPerf createThreadPoolPerf(String poolName, int minPoolSize, int maxPoolSize, PmiCallback callback) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        return new ThreadPoolModule(poolName, minPoolSize, maxPoolSize, callback);
    }

    public static ConnPoolPerf createConnPoolPerf(String dataSourceName, ObjectName providerName, ObjectName factoryName) {
        return PmiFactory.createConnPoolPerf(dataSourceName, null, providerName, factoryName);
    }

    public static ConnPoolPerf createConnPoolPerf(String dataSourceName, PmiCallback callback, ObjectName providerName, ObjectName factoryName) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        return new ConnPoolModule(dataSourceName, providerName, factoryName);
    }

    public static SystemModule createSystemPerf(String nodeName) {
        return PmiFactory.createSystemPerf(nodeName, null);
    }

    public static SystemModule createSystemPerf(String nodeName, PmiCallback callback) {
        if (!PmiRegistry.isDisabled()) {
            return new SystemModule(nodeName);
        }
        return null;
    }

    public static void initJ2CPerf(ObjectName providerName) {
        if (PmiRegistry.isDisabled()) {
            return;
        }
        String pName = providerName.getKeyProperty("name");
        String mbeanType = "J2CResourceAdapter";
        if (providerName != null) {
            mbeanType = providerName.getKeyProperty("type");
        }
        if (mbeanType.equals("JDBCProvider")) {
            new ResourcePmiModule("connectionPoolModule", pName, providerName);
        } else {
            new ResourcePmiModule("j2cModule", pName, providerName);
        }
    }

    public static J2CPerf createJ2CPerf(String eisName, ObjectName providerName, ObjectName factoryName, ObjectName mcf) {
        return PmiFactory.createJ2CPerf(eisName, null, providerName, factoryName, mcf, false);
    }

    public static J2CPerf createJ2CPerf(String eisName, ObjectName providerName, ObjectName factoryName) {
        return PmiFactory.createJ2CPerf(eisName, null, providerName, factoryName, null, false);
    }

    public static J2CPerf createJ2CPerf(String eisName, ObjectName providerName, ObjectName factoryName, boolean nonPool) {
        return PmiFactory.createJ2CPerf(eisName, null, providerName, factoryName, null, nonPool);
    }

    public static J2CPerf createJ2CPerf(String eisName, PmiCallback callback, ObjectName providerName, ObjectName factoryName, ObjectName mcf, boolean nonPool) {
        PmiModule mod;
        ModuleItem mi;
        int ix;
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createJ2CPerf: providerName=" + providerName + ", eisName=" + eisName);
        }
        String mbeanType = "J2CResourceAdapter";
        if (providerName != null) {
            mbeanType = providerName.getKeyProperty("type");
        }
        if (mbeanType.equals("JDBCProvider")) {
            return new J2CModule("connectionPoolModule", eisName, providerName, factoryName, mcf, nonPool);
        }
        if (eisName != null && (ix = eisName.indexOf("$JMSManagedConnection@")) > 0 && (mi = PmiRegistry.findModuleItem(new String[]{"j2cModule", "jmsConnections", eisName = eisName.substring(0, ix)})) != null && (mod = mi.getInstance()) != null && mod instanceof J2CPerf) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createJ2CPerf: returning previously created PMI module for: " + eisName);
            }
            return (J2CPerf)((Object)mod);
        }
        return new J2CModule("j2cModule", eisName, providerName, factoryName, mcf, nonPool);
    }

    public static RuntimeModule createJvmPerf(int initialHeap, int maxHeap) {
        if (!PmiRegistry.isDisabled()) {
            return new RuntimeModule(initialHeap, maxHeap);
        }
        return null;
    }

    public static ServletSessionsPerf createServletSessionsPerf() {
        return PmiFactory.createServletSessionsPerf("unknownWebApp", null);
    }

    public static ServletSessionsPerf createServletSessionsPerf(String webappName) {
        return PmiFactory.createServletSessionsPerf(webappName, null);
    }

    public static ServletSessionsPerf createServletSessionsPerf(String webappName, PmiCallback callback) {
        if (PmiRegistry.Z) {
            return new SmfServletSessionsModule(webappName, callback);
        }
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        return new ServletSessionsModule(webappName, callback);
    }

    public static PmiModule createTransactionPerf(Object txManager) {
        return PmiFactory.createTransactionPerf(txManager, null);
    }

    public static PmiModule createTransactionPerf(Object txManager, PmiCallback callback) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        String className = "com.ibm.ws.pmi.server.modules.TransactionModule";
        PmiModule tranModule = null;
        try {
            Class<?> classFor = Class.forName(className);
            tranModule = (PmiModule)classFor.newInstance();
            Object[] params = new Object[]{txManager};
            tranModule.init(params);
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.pmi.server.PmiFactory.createTransactionPerf", "275");
            Tr.warning(tc, "PMI0014W", ex.toString());
        }
        return tranModule;
    }

    public static WLMPerf createWLMPerf(String moduleName) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        return new WLMModule(moduleName);
    }

    public static WSGWModule createWSGWPerf(String appName) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        return new WSGWModule(appName);
    }

    public static CachePerf createCachePerf() {
        return PmiFactory.createCachePerf("Dynamic Cache");
    }

    public static CachePerf createCachePerf(String cacheName) {
        return PmiFactory.createCachePerf("cache.servlet", "Dynamic Cache");
    }

    public static CachePerf createCachePerf(String cacheType, String cacheName) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        return new CachePerfModule(cacheType, cacheName, null);
    }

    public static WebServicesPerf createWebServicesPerf(String appName, String modName) {
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        String instanceName = WebServicesModule.buildInstanceName(appName, modName);
        WebServicesPerf module = (WebServicesPerf)webServicesMap.get(instanceName);
        if (module == null) {
            module = new WebServicesModule(instanceName);
            webServicesMap.put(instanceName, module);
        }
        return module;
    }

    public static void removePmiModule(Object removeObj) {
        String[] path;
        if (removeObj == null) {
            return;
        }
        Object obj = null;
        if (removeObj instanceof SmfServletSessionsModule && (obj = ((SmfServletSessionsModule)removeObj).getPmiModule()) == null) {
            return;
        }
        if (obj == null) {
            obj = removeObj;
        }
        if (!(obj instanceof PmiModule)) {
            Tr.warning(tc, "PMI9999E", "removePmiModule(): parameter should be PmiModule type");
            return;
        }
        PmiModule instance = (PmiModule)obj;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removePmiModule: " + instance.getModuleID() + ", " + instance.getName());
        }
        if ((path = instance.getPath()).length == 2 && path[0].equals("webServicesModule")) {
            webServicesMap.remove(path[1]);
        }
        instance.unregister();
    }
}

