/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.StatLevelSpec;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.management.MBeanStateConsumer;
import com.ibm.ws.pmi.component.PMIImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PMIServiceState;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.server.PmiCollaborator;
import com.ibm.ws.pmi.server.PmiConfigManager;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.server.StatsHelper;
import com.ibm.ws.pmi.stat.StatsImpl;
import java.io.Serializable;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.management.ObjectName;

public class PmiCollaboratorImpl
implements PmiCollaborator,
PmiConstants,
MBeanStateConsumer {
    private static final TraceComponent tc = Tr.register(PmiCollaboratorImpl.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static PmiCollaboratorImpl _instance = null;

    private PmiCollaboratorImpl() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "init: PmiCollaboratorImpl");
        }
    }

    public static PmiCollaborator getSingletonInstance() {
        if (_instance == null) {
            _instance = new PmiCollaboratorImpl();
        }
        return _instance;
    }

    public MBeanStatDescriptor[] listStatMembers(ObjectName mName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listStatMembers(ObjectName)");
        }
        MBeanStatDescriptor[] members = PmiRegistry.listStatMembers(mName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listStatMembers(ObjectName)");
        }
        return members;
    }

    public MBeanStatDescriptor[] listStatMembers(MBeanStatDescriptor msd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listStatMembers(MBeanStatDescriptor");
        }
        MBeanStatDescriptor[] members = PmiRegistry.listStatMembers(msd);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listStatMembers(MBeanStatDescriptor)");
        }
        return members;
    }

    public StatDescriptor[] listStatMembers(StatDescriptor sd, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listStatMembers(StatDescriptor, Boolean)");
        }
        StatDescriptor[] members = PmiRegistry.listStatMembers(sd, recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listStatMembers(StatDescriptor, Boolean)");
        }
        return members;
    }

    public void savePMIConfiguration() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "savePMIConfiguration");
        }
        PmiConfigManager.saveSpec();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "savePMIConfiguration");
        }
    }

    public void setStatisticSet(String statSet) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStatisticSet(statSet): " + statSet);
        }
        PmiRegistry.setInstrumentationLevel(statSet);
        PMIImpl.setStatisticSet(statSet);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStatisticSet(statSet)");
        }
    }

    public String getStatisticSet() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatisticSet");
        }
        String ret = PMIImpl.getStatisticSet();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatisticSet: " + ret);
        }
        return ret;
    }

    public void setSynchronizedUpdate(Boolean enabled) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSynchronizedUpdate(): " + enabled);
        }
        PmiRegistry.setSynchronizedUpdate(enabled);
        PMIImpl.setSynchronizedUpdate(enabled);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSynchronizedUpdate())");
        }
    }

    public Boolean getSynchronizedUpdate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSynchronizedUpdate");
        }
        boolean ret = PMIImpl.getSynchronizedUpdate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSynchronizedUpdate: " + ret);
        }
        return new Boolean(ret);
    }

    public String getCustomSetString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomSetString");
        }
        String ret = PmiRegistry.getInstrumentationLevelString60();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomSetString");
        }
        return ret;
    }

    public void setCustomSetString(String setting, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCustomSetString (String, Boolean): " + setting);
        }
        this.setInstrumentationLevel(this._createSLSFromString(setting), recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCustomSetString");
        }
    }

    private StatLevelSpec[] _createSLSFromString(String spec) {
        StringTokenizer psr1 = new StringTokenizer(spec, ":");
        int s = psr1.countTokens();
        StatLevelSpec[] sls = new StatLevelSpec[s];
        int k = 0;
        while (psr1.hasMoreTokens()) {
            sls[k++] = this._createSLS(psr1.nextToken());
        }
        return sls;
    }

    private StatLevelSpec _createSLS(String spec) {
        String enable;
        String[] sd;
        StringTokenizer psr1 = new StringTokenizer(spec, "=");
        try {
            sd = PmiConfigManager.parsePath(psr1.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        try {
            enable = psr1.nextToken();
        }
        catch (Exception e) {
            enable = null;
        }
        return new StatLevelSpec(sd, PmiConfigManager.parseSpecStr(enable));
    }

    public WSStats getStatsObject(ObjectName mName, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsObject(ObjectName, Boolean)");
        }
        StatsImpl stat = PmiRegistry.getStats(new MBeanStatDescriptor(mName), (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsObject(ObjectName, Boolean)");
        }
        return stat;
    }

    public WSStats getStatsObject(MBeanStatDescriptor msd, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsObject(MBeanStatDescriptor, Boolean)");
        }
        StatsImpl stat = PmiRegistry.getStats(msd, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsObject(MBeanStatDescriptor, Boolean)");
        }
        return stat;
    }

    public WSStats[] getStatsArray(ObjectName[] mNames, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsArray (ObjectName[], Boolean)");
        }
        if (mNames == null || mNames.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ObjectName is null or empty");
            }
            return null;
        }
        WSStats[] stats = PmiRegistry.getStats(mNames, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsArray (ObjectName[], Boolean)");
        }
        return stats;
    }

    public WSStats[] getStatsArray(StatDescriptor[] sd, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsArray (StatDescriptor[], Boolean)");
        }
        if (sd == null || sd.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StatDescriptor is null or empty");
            }
            return null;
        }
        WSStats[] stats = PmiRegistry.getStats(sd, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsArray (StatDescriptor[], Boolean)");
        }
        return stats;
    }

    public WSStats[] getStatsArray(MBeanStatDescriptor[] msds, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsArray (MBeanStatDescriptor[], Boolean)");
        }
        if (msds == null || msds.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MBeanStatDescriptor is null or empty");
            }
            return null;
        }
        WSStats[] stats = PmiRegistry.getStats(msds, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsArray (MBeanStatDescriptor[], Boolean)");
        }
        return stats;
    }

    public void setInstrumentationLevel(MBeanLevelSpec mls, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInstrumentationLevel (MBeanLevelSpec, Boolean)");
        }
        PmiRegistry.setMBeanLevel(mls, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInstrumentationLevel (MBeanLevelSpec, Boolean)");
        }
    }

    public void setInstrumentationLevel(MBeanLevelSpec[] mlss, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInstrumentationLevel (MBeanLevelSpec[], Boolean)");
        }
        if (mlss == null || mlss.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MBeanLevelSpec is null or empty");
            }
            return;
        }
        PmiRegistry.setMBeanLevel(mlss, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInstrumentationLevel (MBeanLevelSpec[], Boolean)");
        }
    }

    public void setInstrumentationLevel(StatLevelSpec[] mlss, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInstrumentationLevel (StatLevelSpec[], Boolean)");
        }
        if (mlss == null || mlss.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "StatLevelSpec is null or empty");
            }
            return;
        }
        PmiRegistry.setInstrumentationLevel(mlss, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInstrumentationLevel (StatLevelSpec[], Boolean)");
        }
    }

    public MBeanLevelSpec[] getInstrumentationLevel(ObjectName mName, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstrumentationLevel (ObjectName, Boolean");
        }
        if (mName == null) {
            return null;
        }
        MBeanLevelSpec[] specs = PmiRegistry.getMBeanLevelSpecs(mName, null, recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstrumentationLevel (ObjectName, Boolean");
        }
        return specs;
    }

    public StatLevelSpec[] getInstrumentationLevel(StatDescriptor sd, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstrumentationLevel (StatDescriptor, Boolean)");
        }
        if (sd == null) {
            return null;
        }
        StatLevelSpec[] specs = PmiRegistry.getInstrumentationLevel(sd, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstrumentationLevel (StatDescriptor, Boolean)");
        }
        return specs;
    }

    public MBeanLevelSpec[] getInstrumentationLevel(MBeanStatDescriptor msd, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstrumentationLevel (MBeanStatDescriptor, Boolean)");
        }
        if (msd == null || msd.getObjectName() == null) {
            return null;
        }
        MBeanLevelSpec[] specs = PmiRegistry.getMBeanLevelSpecs(msd.getObjectName(), msd.getStatDescriptor(), recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstrumentationLevel (MBeanStatDescriptor, Boolean)");
        }
        return specs;
    }

    public PmiModuleConfig[] getConfigs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigs");
        }
        PmiModuleConfig[] configs = PmiRegistry.getConfigs();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigs");
        }
        return configs;
    }

    public PmiModuleConfig[] getConfigs(Locale l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigs (Locale)");
        }
        PmiModuleConfig[] configs = PmiRegistry.getConfigs(l);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigs (Locale)");
        }
        return configs;
    }

    public PmiModuleConfig getConfig(String statsType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigs (statsType)");
        }
        PmiModuleConfig configs = PmiRegistry.getConfig(statsType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigs (statsType)");
        }
        return configs;
    }

    public PmiModuleConfig getConfig(ObjectName mName) {
        ModuleItem mi;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigs (ObjectName)");
        }
        if (mName == null) {
            return null;
        }
        String moduleName = PmiRegistry.jmxMapper.getPmiModuleName(mName);
        if (moduleName == null && (mi = PmiRegistry.findModuleItem(mName)) != null) {
            moduleName = mi.getInstance().getModuleID();
        }
        PmiModuleConfig config = PmiRegistry.getConfig(moduleName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigs (ObjectName)");
        }
        return config;
    }

    public String getInstrumentationLevelString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstrumentationLevelString");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstrumentationLevelString");
        }
        return PmiRegistry.getInstrumentationLevelString();
    }

    public void setInstrumentationLevel(String levelStr, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInstrumentationLevel (String, Boolean): " + levelStr);
        }
        PerfLevelDescriptor[] plds = PmiUtil.getPerfLevelSpecsFromString(levelStr);
        PmiRegistry.setInstrumentationLevel(plds, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInstrumentationLevel (String, Boolean)");
        }
    }

    public String getStatsString(ObjectName on, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsString (ObjectName, Boolean)");
        }
        StatsImpl stats = (StatsImpl)this.getStatsObject(on, recursive);
        String returnVal = null;
        if (stats != null) {
            DataDescriptor dd = PmiRegistry.mBeanToDataDescriptor(new MBeanStatDescriptor(on, null));
            returnVal = StatsHelper.statsToTclAttrString(stats, dd, PmiRegistry.nodeName, PmiRegistry.serverName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsString (ObjectName, Boolean)");
        }
        return returnVal;
    }

    public String getStatsString(ObjectName on, String submoduleName, Boolean recursive) {
        StatDescriptor sd = new StatDescriptor(new String[]{submoduleName});
        MBeanStatDescriptor msd = new MBeanStatDescriptor(on, sd);
        StatsImpl stats = (StatsImpl)this.getStatsObject(msd, recursive);
        if (stats == null) {
            return null;
        }
        DataDescriptor dd = PmiRegistry.mBeanToDataDescriptor(new MBeanStatDescriptor(on, sd));
        return StatsHelper.statsToTclAttrString(stats, dd, PmiRegistry.nodeName, PmiRegistry.serverName);
    }

    public String listStatMemberNames(ObjectName on) {
        MBeanStatDescriptor[] msds;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "listStatMemberNames (ObjectName): " + on.toString());
        }
        if ((msds = this.listStatMembers(on)) == null || msds.length == 0) {
            return "";
        }
        String retStr = "";
        boolean first = true;
        for (int i = 0; i < msds.length; ++i) {
            if (msds[i] == null || msds[i].getStatDescriptor() == null) continue;
            if (first) {
                first = false;
                retStr = msds[i].getStatDescriptor().getName();
                continue;
            }
            retStr = retStr + " " + msds[i].getStatDescriptor().getName();
        }
        return retStr;
    }

    public WSStats getStatsObject(DataDescriptor dd, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsObject(DataDescriptor, Boolean)");
        }
        StatsImpl stat = PmiRegistry.getStats(dd, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsObject(DataDescriptor)");
        }
        return stat;
    }

    public WSStats[] getStatsArray(DataDescriptor[] dd, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatsArray(DataDescriptor[], Boolean)");
        }
        if (dd == null || dd.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatsArray - null ObjectName");
            }
            return null;
        }
        WSStats[] stats = PmiRegistry.getStats(dd, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatsArray(DataDescriptor)" + stats.length);
        }
        return stats;
    }

    public DataDescriptor[] listStatMembers(DataDescriptor dd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listStatMembers(DataDescriptor)");
        }
        DataDescriptor[] members = PmiRegistry.listMembers(dd);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listStatMembers(DataDescriptor)");
        }
        return members;
    }

    public void setInstrumentationLevel(PerfLevelDescriptor pld, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInstrumentationLevel(PerfLevelDescriptor, Boolean)");
        }
        PmiRegistry.setInstrumentationLevel(pld, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInstrumentationLevel(PerfLevelDescriptor)");
        }
    }

    public void setInstrumentationLevel(PerfLevelDescriptor[] pld, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInstrumentationLevel(PerfLevelDescriptor[], Boolean)");
        }
        PmiRegistry.setInstrumentationLevel(pld, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInstrumentationLevel(PerfLevelDescriptor)");
        }
    }

    public PerfLevelDescriptor[] getInstrumentationLevel(DataDescriptor dd, Boolean recursive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstrumentationLevel(DataDescriptor, Boolean)");
        }
        if (dd == null) {
            return null;
        }
        PerfLevelDescriptor[] specs = PmiRegistry.getInstrumentationLevel(dd, (boolean)recursive);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstrumentationLevel(DataDescriptor)");
        }
        return specs;
    }

    public void setMBeanState(Serializable stateObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMBeanState - updating PMI service with PMIServiceState");
        }
        if (stateObject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PMI state object is null");
            }
        } else if (stateObject instanceof PMIServiceState) {
            PMIServiceState state = (PMIServiceState)((Object)stateObject);
            PMIImpl.updateRuntimeWithStateObject(state);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invalid PMI state object type: " + stateObject.getClass().getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMBeanState");
        }
    }
}

