/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.server.PmiModuleAggregate;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.StatLevelSpec;
import com.ibm.ws.pmi.component.PMIImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.StatsImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.management.ObjectName;

public class ModuleItem
implements Serializable,
PmiConstants {
    private static final long serialVersionUID = 4893797935750745475L;
    PmiModule instance = null;
    Map children = null;
    ModuleItem parent = null;
    int level = -1;
    private static final TraceComponent tc = Tr.register(ModuleItem.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private StatsImpl myStats;
    private StatsImpl myStatsWithChildren;

    public ModuleItem() {
        this(null);
    }

    public ModuleItem(PmiModule instance) {
        this.instance = instance;
    }

    public PmiModule getInstance() {
        return this.instance;
    }

    public ModuleItem find(String name) {
        if (this.children == null) {
            return null;
        }
        return (ModuleItem)this.children.get(name);
    }

    public ModuleItem find(String[] path, int index) {
        if (path == null) {
            return null;
        }
        if (path.length == 0) {
            return this;
        }
        ModuleItem item = this.find(path[index]);
        if (item == null) {
            return null;
        }
        if (index == path.length - 1) {
            return item;
        }
        return item.find(path, index + 1);
    }

    public synchronized ModuleItem add(String[] path, int index) {
        if (path == null) {
            return null;
        }
        if (path.length == 0) {
            return this;
        }
        ModuleItem item = this.find(path[index]);
        if (item == null) {
            String[] myPath = new String[index + 1];
            System.arraycopy(path, 0, myPath, 0, myPath.length);
            if (myPath.length == 1) {
                ModuleAggregate aggregate = new ModuleAggregate(myPath[0]);
                item = this.find(path[index]);
            } else if (myPath.length == 3) {
                new ModuleAggregate(myPath[0], myPath[1], myPath[2]);
                item = this.find(path[index]);
            } else {
                Tr.warning(tc, "PMI9999E", "Parent module not found.");
            }
            this.add(item);
        }
        if (index == path.length - 1) {
            return item;
        }
        return item.add(path, index + 1);
    }

    public synchronized boolean add(ModuleItem item) {
        String itemName;
        if (item == null) {
            return false;
        }
        if (this.children == null) {
            this.children = new TreeMap();
        }
        if (this.find(itemName = item.getInstance().getName()) == null) {
            item.setParent(this);
            this.children.put(itemName, item);
            if (this.myStatsWithChildren != null) {
                this.addToStatsTree(item);
            }
            return true;
        }
        return false;
    }

    public ModuleItem[] children() {
        if (this.children == null) {
            return null;
        }
        ModuleItem[] members = new ModuleItem[this.children.size()];
        this.children.values().toArray(members);
        return members;
    }

    public ModuleItem getParent() {
        return this.parent;
    }

    public void setParent(ModuleItem parent) {
        this.parent = parent;
        this.updateParent();
    }

    private void updateParent() {
        if (this.parent == null) {
            return;
        }
        if (this.instance instanceof PmiModuleAggregate) {
            return;
        }
        PmiModule myInstance = null;
        for (ModuleItem myParent = this.parent; myParent != null; myParent = myParent.getParent()) {
            myInstance = myParent.getInstance();
            if (myInstance == null || !(myInstance instanceof PmiModuleAggregate)) continue;
            ((PmiModuleAggregate)((Object)myInstance)).add(this.getInstance());
            if (myInstance.isCustomModule()) {
                if (myParent.myStatsWithChildren != null) {
                    myParent.myStatsWithChildren.setStatsType(myInstance.getWCCMStatsType());
                }
                if (myParent.myStats != null) {
                    myParent.myStats.setStatsType(myInstance.getWCCMStatsType());
                }
            }
            ((PmiAbstractModule)myInstance).updateDataList();
            ((PmiAbstractModule)myInstance).updateEnabledByLevel();
            if (!((PmiAbstractModule)this.getInstance()).isStandaloneTree()) continue;
        }
    }

    private void updateChildrenInfo(Map myChild) {
        if (myChild != null) {
            for (ModuleItem childMI : myChild.values()) {
                if (!(childMI.getInstance() instanceof PmiModuleAggregate)) {
                    ((PmiModuleAggregate)((Object)this.instance)).add(childMI.getInstance());
                    ((PmiAbstractModule)this.instance).updateDataList();
                }
                this.updateChildrenInfo(childMI.children);
            }
        }
    }

    public synchronized void remove(ModuleItem item) {
        if (item == null || this.children == null) {
            return;
        }
        PmiModule removeInstance = item.getInstance();
        if (!(removeInstance instanceof PmiModuleAggregate)) {
            PmiModule parModule = null;
            for (ModuleItem myParent = this; myParent != null; myParent = myParent.getParent()) {
                parModule = myParent.getInstance();
                if (parModule == null || !(parModule instanceof PmiModuleAggregate)) continue;
                ((PmiModuleAggregate)((Object)parModule)).remove(removeInstance);
            }
        }
        item._cleanChildren();
        this.children.remove(item.getInstance().getName());
        if (this.myStatsWithChildren != null) {
            this.updateStatsTree();
        }
        item.getInstance().cleanup();
        item = null;
    }

    public DataDescriptor[] listMembers(DataDescriptor dd, boolean jmxBased) {
        int i;
        SpdData[] dataList = null;
        int dataLength = 0;
        if (!jmxBased && (dataList = this.instance.listData()) != null) {
            dataLength = dataList.length;
        }
        String[] nameList = null;
        int itemLength = 0;
        ModuleItem[] items = this.children();
        if (items != null) {
            itemLength = items.length;
            nameList = new String[itemLength];
            for (int i2 = 0; i2 < itemLength; ++i2) {
                String[] path = items[i2].getInstance().getPath();
                nameList[i2] = path[path.length - 1];
            }
        }
        if (itemLength == 0 && dataLength == 0) {
            return null;
        }
        DataDescriptor[] res = new DataDescriptor[itemLength + dataLength];
        for (i = 0; i < itemLength; ++i) {
            res[i] = new DataDescriptor(dd, nameList[i]);
        }
        for (i = 0; i < dataLength; ++i) {
            res[i + itemLength] = new DataDescriptor(dd, dataList[i].getId());
        }
        return res;
    }

    public ArrayList getStatLevelSpec(boolean recursive) {
        ModuleItem[] mi;
        ArrayList<StatLevelSpec> list = new ArrayList<StatLevelSpec>(1);
        if (this.instance != null) {
            list.add(new StatLevelSpec(this.instance.getPath(), this.instance.getEnabled()));
        }
        if (recursive && (mi = this.children()) != null) {
            for (int i = 0; i < mi.length; ++i) {
                ArrayList cList = mi[i].getStatLevelSpec(recursive);
                for (int k = 0; k < cList.size(); ++k) {
                    list.add((StatLevelSpec)cList.get(k));
                }
            }
        }
        return list;
    }

    public ArrayList listChildStatDescriptors(boolean recursive) {
        ArrayList<StatDescriptor> list = new ArrayList<StatDescriptor>(1);
        ModuleItem[] mi = this.children();
        if (mi != null) {
            for (int i = 0; i < mi.length; ++i) {
                list.add(mi[i].getInstance().get60_StatDescriptor());
                if (!recursive) continue;
                ArrayList cList = mi[i].listChildStatDescriptors(recursive);
                for (int k = 0; k < cList.size(); ++k) {
                    list.add((StatDescriptor)cList.get(k));
                }
            }
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList getPerfLevelDescriptors(boolean jmxBased) {
        ArrayList<Serializable> res = new ArrayList<Serializable>();
        if (this.instance == null) {
            if (jmxBased) {
                ObjectName serverMBean = PmiRegistry.getServerMBean();
                res.add(new MBeanLevelSpec(serverMBean, null, this.level));
            } else {
                res.add(new PerfLevelDescriptor(new String[]{"pmi"}, this.level));
            }
        } else {
            PmiModule instance = this.getInstance();
            if (jmxBased) {
                if (instance.getMBeanName() == null) return res;
                int level = instance.getInstrumentationLevel();
                MBeanLevelSpec spec = new MBeanLevelSpec(instance.getMBeanName(), instance.getMSD_StatDescriptor(), level);
                if (level == -2) {
                    spec.setEnabled(instance.getEnabled());
                }
                res.add(spec);
            } else {
                String[] path = instance.getPath();
                PerfLevelDescriptor pld = new PerfLevelDescriptor(path, instance.getInstrumentationLevel(), instance.getModuleID());
                res.add(pld);
            }
        }
        ModuleItem[] items = this.children();
        if (items == null) {
            return res;
        }
        for (int i = 0; i < items.length; ++i) {
            ArrayList childrenLevels = items[i].getPerfLevelDescriptors(jmxBased);
            if (childrenLevels == null || childrenLevels.size() == 0) continue;
            for (int j = 0; j < childrenLevels.size(); ++j) {
                res.add((Serializable)childrenLevels.get(j));
            }
        }
        return res;
    }

    public ArrayList getTreePerfLevelDescriptors(int parentLevel) {
        ArrayList<PerfLevelDescriptor> res = new ArrayList<PerfLevelDescriptor>();
        int thisLevel = this.level;
        if (this.instance == null) {
            res.add(new PerfLevelDescriptor(new String[]{"pmi"}, thisLevel));
        } else {
            PmiModule instance = this.getInstance();
            thisLevel = instance.getInstrumentationLevel();
            if (thisLevel != -1 && thisLevel != parentLevel) {
                res.add(new PerfLevelDescriptor(instance.getPath(), thisLevel, instance.getModuleID()));
            }
        }
        ModuleItem[] items = this.children();
        if (items == null) {
            return res;
        }
        for (int i = 0; i < items.length; ++i) {
            ArrayList childrenLevels = items[i].getTreePerfLevelDescriptors(thisLevel);
            for (int j = 0; j < childrenLevels.size(); ++j) {
                res.add((PerfLevelDescriptor)childrenLevels.get(j));
            }
        }
        return res;
    }

    private void updateStatisticsForStatsTree(long time2) {
        ModuleItem[] items;
        if (this.instance != null) {
            this.instance.updateStatistics();
        }
        if (this.myStatsWithChildren != null) {
            this.myStatsWithChildren.setTime(time2);
        }
        if ((items = this.children()) != null) {
            for (int i = 0; i < items.length; ++i) {
                items[i].updateStatisticsForStatsTree(time2);
            }
        }
    }

    private void addToStatsTree(ModuleItem mi) {
        ArrayList<StatsImpl> colMembers = this.myStatsWithChildren.subCollections();
        if (colMembers == null) {
            colMembers = new ArrayList<StatsImpl>(1);
            this.myStatsWithChildren.setSubcollections(colMembers);
        }
        colMembers.add(mi.getStats(true));
    }

    private void updateStatsTree() {
        if (this.myStatsWithChildren == null) {
            return;
        }
        ArrayList colMembers = this.myStatsWithChildren.subCollections();
        if (colMembers == null) {
            return;
        }
        colMembers.clear();
        ModuleItem[] items = this.children();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                colMembers.add(items[i].getStats(true));
            }
        }
    }

    public StatsImpl getStats(boolean recursive) {
        if (recursive) {
            if (this.myStatsWithChildren == null) {
                ArrayList dataMembers = null;
                if (this.instance != null) {
                    dataMembers = this.instance.listStatistics();
                }
                ArrayList<StatsImpl> colMembers = null;
                ModuleItem[] items = this.children();
                if (items != null) {
                    colMembers = new ArrayList<StatsImpl>(items.length);
                    for (int i = 0; i < items.length; ++i) {
                        colMembers.add(items[i].getStats(recursive));
                    }
                }
                this.myStatsWithChildren = this.instance != null ? this.instance.getStats(dataMembers, colMembers) : new StatsImpl("server", 12, this.level, null, colMembers);
            } else {
                this.updateStatisticsForStatsTree(System.currentTimeMillis());
            }
            return this.myStatsWithChildren;
        }
        if (this.myStats == null) {
            this.myStats = this.instance != null ? this.instance.getStats(this.instance.listStatistics(), null) : new StatsImpl("server", 12, this.level, null, null);
        } else {
            if (this.instance != null) {
                this.instance.updateStatistics();
            }
            this.myStats.setTime(System.currentTimeMillis());
        }
        return this.myStats;
    }

    public StatsImpl getJSR77Stats() {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getJSR77Stats(this);
    }

    public StatsImpl getStats(int[] dataIds, boolean recursive) {
        int i;
        if (dataIds == null) {
            return this.getStats(recursive);
        }
        if (this.instance == null) {
            return null;
        }
        SpdData[] dataList = this.instance.listData(dataIds);
        ModuleItem[] items = this.children();
        ArrayList<StatisticImpl> dataMembers = null;
        ArrayList<StatsImpl> colMembers = null;
        if (dataList != null) {
            dataMembers = new ArrayList<StatisticImpl>(dataList.length);
            for (i = 0; i < dataList.length; ++i) {
                dataMembers.add(dataList[i].getStatistic());
            }
        }
        if (recursive && items != null) {
            colMembers = new ArrayList<StatsImpl>(items.length);
            for (i = 0; i < items.length; ++i) {
                colMembers.add(items[i].getStats(dataIds, recursive));
            }
        }
        return this.instance.getStats(dataMembers, colMembers);
    }

    public void setInstanceLevel(int[] enabled, int[] enabledSync, int newLevel, boolean recursive) {
        if (newLevel != -2) {
            if (newLevel != -1) {
                this.setInstanceLevel_V5(newLevel, recursive);
            }
        } else if (enabled != null) {
            this.setInstanceLevel_FG(enabled, enabledSync, recursive);
        }
        PMIImpl.setStatisticSet("custom");
    }

    private void setInstanceLevel_FG(int[] enabled, int[] enabledSync, boolean recursive) {
        if (this.instance != null) {
            boolean action = this.instance.setFineGrainedInstrumentation(enabled, enabledSync);
            this.updateParent();
        }
        if (recursive) {
            ModuleItem[] items = this.children();
            if (items == null) {
                return;
            }
            for (int i = 0; i < items.length; ++i) {
                items[i].setInstanceLevel_FG(enabled, enabledSync, recursive);
            }
        }
    }

    private void setInstanceLevel_V5(int newLevel, boolean recursive) {
        if (this.instance != null) {
            int oldLevel = this.instance.getInstrumentationLevel();
            this.instance.setInstrumentationLevel(newLevel);
            if (oldLevel < newLevel) {
                this.updateParent();
            }
        } else {
            this.level = newLevel;
        }
        if (recursive) {
            ModuleItem[] items = this.children();
            if (items == null) {
                return;
            }
            for (int i = 0; i < items.length; ++i) {
                items[i].setInstanceLevel_V5(newLevel, recursive);
            }
        }
    }

    public void setInstanceLevel_Set(String set, boolean recursive) {
        if (this.instance != null) {
            this.instance.setInstrumentationBySet(set);
            this.updateParent();
        }
        if (recursive) {
            ModuleItem[] items = this.children();
            if (items == null) {
                return;
            }
            for (int i = 0; i < items.length; ++i) {
                items[i].setInstanceLevel_Set(set, recursive);
            }
        }
    }

    public void turnOnOffData(int dataId, boolean on, boolean recursive) {
        ModuleItem[] items;
        if (this.instance != null) {
            if (on) {
                this.instance.enableData(dataId);
            } else {
                this.instance.disableData(dataId);
            }
        }
        if (recursive && (items = this.children()) != null) {
            for (int i = 0; i < items.length; ++i) {
                items[i].turnOnOffData(dataId, on, recursive);
            }
        }
    }

    public ObjectName getParentMBean() {
        if (this.parent.getInstance() == null) {
            return PmiRegistry.getServerMBean();
        }
        ObjectName on = this.parent.getInstance().getMBeanName();
        if (on == null) {
            return this.parent.getParentMBean();
        }
        return on;
    }

    public boolean isStatisticsProvider() {
        return this.instance.isJ2EEStatisticProvider();
    }

    private void _cleanChildren() {
        if (this.children != null) {
            for (ModuleItem remMI : this.children.values()) {
                remMI.getInstance().cleanup();
                remMI._cleanChildren();
                Object var2_2 = null;
            }
            this.children.clear();
        }
    }
}

