/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.dynamicproxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.ws.pmi.dynamicproxy.PerfMBeanAggregationHandler;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PmiCollaborator;
import com.ibm.ws.pmi.server.PmiCollaboratorFactory;
import com.ibm.ws.pmi.stat.AverageStatisticImpl;
import com.ibm.ws.pmi.stat.BoundaryStatisticImpl;
import com.ibm.ws.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.DoubleStatisticImpl;
import com.ibm.ws.pmi.stat.JCAConnectionPoolStatsImpl;
import com.ibm.ws.pmi.stat.JCAConnectionStatsImpl;
import com.ibm.ws.pmi.stat.JCAStatsImpl;
import com.ibm.ws.pmi.stat.JDBCConnectionPoolStatsImpl;
import com.ibm.ws.pmi.stat.JDBCConnectionStatsImpl;
import com.ibm.ws.pmi.stat.JDBCStatsImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import java.util.ArrayList;

public class StatsUtil {
    private static TraceComponent tc = Tr.register(StatsUtil.class, "PMI", null);
    private static final String[] systemModule = new String[]{"systemModule"};
    private static final String[] runtimeModule = new String[]{"jvmRuntimeModule"};

    public static StatsImpl combine(StatsImpl aStats, StatsImpl bStats) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "combine", new Object[]{StatsUtil.getStatsName(aStats), StatsUtil.getStatsName(bStats)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "combine - StatsImpl params", new Object[]{aStats, bStats});
        }
        StatisticImpl[] aStatistic = (StatisticImpl[])aStats.listStatistics();
        StatisticImpl[] bStatistic = (StatisticImpl[])bStats.listStatistics();
        int i = 0;
        int j = 0;
        if (aStatistic != null && bStatistic != null) {
            block0: for (i = 0; i < aStatistic.length; ++i) {
                int aID = aStatistic[i].getId();
                for (j = 0; j < bStatistic.length; ++j) {
                    if (aID != bStatistic[j].getId()) continue;
                    aStatistic[i].combine(bStatistic[j]);
                    continue block0;
                }
            }
        }
        StatsImpl[] aSubStats = (StatsImpl[])aStats.listSubStats();
        StatsImpl[] bSubStats = (StatsImpl[])bStats.listSubStats();
        if (aSubStats != null && bSubStats != null) {
            block2: for (i = 0; i < aSubStats.length; ++i) {
                String aName = aSubStats[i].getName();
                for (j = 0; j < bSubStats.length; ++j) {
                    if (aName.compareTo(bSubStats[j].getName()) != 0) continue;
                    StatsUtil.combine(aSubStats[i], bSubStats[j]);
                    continue block2;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "combine - return val", aStats);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "combine", StatsUtil.getStatsName(aStats));
        }
        return aStats;
    }

    public static StatsImpl combineAll(StatsImpl aStats, StatsImpl bStats) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "combineAll", new Object[]{StatsUtil.getStatsName(aStats), StatsUtil.getStatsName(bStats)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "combineAll - StatsImpl params", new Object[]{aStats, bStats});
        }
        StatsImpl largerSubStatCount = aStats;
        StatsImpl smallerSubStatCount = bStats;
        if (((StatsImpl[])bStats.listSubStats()).length > ((StatsImpl[])aStats.listSubStats()).length) {
            largerSubStatCount = bStats;
            smallerSubStatCount = aStats;
        }
        StatisticImpl[] lStatistic = (StatisticImpl[])largerSubStatCount.listStatistics();
        StatisticImpl[] sStatistic = (StatisticImpl[])smallerSubStatCount.listStatistics();
        int i = 0;
        int j = 0;
        if (lStatistic != null && sStatistic != null) {
            byte[] combinedStatsInventory = new byte[sStatistic.length];
            block0: for (i = 0; i < lStatistic.length; ++i) {
                for (j = 0; j < sStatistic.length; ++j) {
                    if (lStatistic[i].getId() != sStatistic[j].getId()) continue;
                    lStatistic[i].combine(sStatistic[j]);
                    combinedStatsInventory[j] = 1;
                    continue block0;
                }
            }
            for (i = 0; i < combinedStatsInventory.length; ++i) {
                if (combinedStatsInventory[i] != 0) continue;
                largerSubStatCount.add(sStatistic[i]);
            }
        }
        StatsImpl[] lSubStats = (StatsImpl[])largerSubStatCount.listSubStats();
        StatsImpl[] sSubStats = (StatsImpl[])smallerSubStatCount.listSubStats();
        if (lSubStats != null && sSubStats != null) {
            byte[] combinedSubStatsInventory = new byte[sSubStats.length];
            block3: for (i = 0; i < lSubStats.length; ++i) {
                String aName = lSubStats[i].getName();
                for (j = 0; j < sSubStats.length; ++j) {
                    if (aName.compareTo(sSubStats[j].getName()) != 0) continue;
                    StatsImpl tmpStatsImpl = null;
                    tmpStatsImpl = StatsUtil.combineAll(lSubStats[i], sSubStats[j]);
                    largerSubStatCount.remove(tmpStatsImpl.getName());
                    largerSubStatCount.add(tmpStatsImpl);
                    combinedSubStatsInventory[j] = 1;
                    continue block3;
                }
            }
            for (i = 0; i < combinedSubStatsInventory.length; ++i) {
                if (combinedSubStatsInventory[i] != 0) continue;
                largerSubStatCount.add(sSubStats[i]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "combineAll - return val", largerSubStatCount);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "combineAll", StatsUtil.getStatsName(largerSubStatCount));
        }
        return largerSubStatCount;
    }

    public static StatsImpl aggregate(StatsImpl newStats, StatsImpl oldStats) {
        StatsImpl[] newSubStats;
        StatisticImpl[] newStatistics;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "aggregate", new Object[]{StatsUtil.getStatsName(newStats), StatsUtil.getStatsName(oldStats)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "aggregate - StatsImpl params", new Object[]{newStats, oldStats});
        }
        if ((newStatistics = (StatisticImpl[])newStats.listStatistics()) != null) {
            for (int s = 0; s < newStatistics.length; ++s) {
                StatisticImpl oldStatistic = (StatisticImpl)oldStats.getStatistic(newStatistics[s].getId());
                if (newStatistics[s] instanceof RangeStatisticImpl) {
                    ((RangeStatisticImpl)newStatistics[s]).set(0L);
                }
                if (oldStatistic == null) continue;
                newStatistics[s].combine(oldStatistic);
            }
        }
        if ((newSubStats = (StatsImpl[])newStats.listSubStats()) != null) {
            for (int s = 0; s < newSubStats.length; ++s) {
                StatsImpl oldSubStats = (StatsImpl)oldStats.getStats(newSubStats[s].getName());
                if (oldSubStats == null) continue;
                StatsUtil.aggregate(newSubStats[s], oldSubStats);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "aggregate - return val", newStats);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "aggregate", StatsUtil.getStatsName(newStats));
        }
        return newStats;
    }

    public static StatsImpl copyStats(StatsImpl stats) {
        StatisticImpl[] statistics;
        StatDescriptor[] sd;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyStats", StatsUtil.getStatsName(stats));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copyStats - StatsImpl param", stats);
        }
        if (stats == null) {
            return null;
        }
        ArrayList<StatsImpl> newSubStats = null;
        ArrayList newStatistics = null;
        StatsImpl[] subStats = (StatsImpl[])stats.listSubStats();
        if (subStats != null && subStats.length > 0) {
            newSubStats = new ArrayList<StatsImpl>();
            for (int i = 0; i < subStats.length; ++i) {
                newSubStats.add(StatsUtil.copyStats(subStats[i]));
            }
        }
        if (StatsUtil.getStatsName(stats).equals("systemModule")) {
            if (!PerfMBeanAggregationHandler.obtainedSystemStats()) {
                PmiCollaborator pmi2 = PmiCollaboratorFactory.getPmiCollaborator();
                sd = new StatDescriptor[]{new StatDescriptor(systemModule)};
                StatsImpl[] controlRegionSystemStats = (StatsImpl[])pmi2.getStatsArray(sd, new Boolean(false));
                stats = controlRegionSystemStats[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got SystemStats from ControlRegion \n" + stats);
                }
                PerfMBeanAggregationHandler.setObtainedSystemStats(true);
            }
        } else if (StatsUtil.getStatsName(stats).equals("jvmRuntimeModule") && !PerfMBeanAggregationHandler.obtainedJVMStats()) {
            PmiCollaborator pmi3 = PmiCollaboratorFactory.getPmiCollaborator();
            sd = new StatDescriptor[]{new StatDescriptor(runtimeModule)};
            StatsImpl[] controlRegionJvmStats = (StatsImpl[])pmi3.getStatsArray(sd, new Boolean(false));
            stats = controlRegionJvmStats[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got JVMStats from ControlRegion \n" + stats);
            }
            PerfMBeanAggregationHandler.setObtainedJVMStats(true);
        }
        if ((statistics = (StatisticImpl[])stats.listStatistics()) != null && statistics.length > 0) {
            newStatistics = StatsUtil.copyStatistics(statistics);
        }
        StatsImpl newStats = new StatsImpl(stats.getStatsType(), stats.getName(), stats.getType(), stats.getLevel(), newStatistics, newSubStats);
        if (stats instanceof JCAStatsImpl) {
            newStats = new JCAStatsImpl(stats.getStatsType(), stats.getName(), stats.getType(), stats.getLevel(), newStatistics, newSubStats);
        } else if (stats instanceof JCAConnectionStatsImpl) {
            newStats = new JCAConnectionStatsImpl(stats.getStatsType(), stats.getName(), stats.getType(), stats.getLevel(), newStatistics, newSubStats);
            ((JCAConnectionStatsImpl)newStats).setConnectionFactory(((JCAConnectionStatsImpl)stats).getConnectionFactoryObjectName());
            ((JCAConnectionStatsImpl)newStats).setManagedConnectionFactory(((JCAConnectionStatsImpl)stats).getManagedConnectionFactoryObjectName());
        } else if (stats instanceof JCAConnectionPoolStatsImpl) {
            newStats = new JCAConnectionPoolStatsImpl(stats.getStatsType(), stats.getName(), stats.getType(), stats.getLevel(), newStatistics, newSubStats);
        } else if (stats instanceof JDBCStatsImpl) {
            newStats = new JDBCStatsImpl(stats.getStatsType(), stats.getName(), stats.getType(), stats.getLevel(), newStatistics, newSubStats);
        } else if (stats instanceof JDBCConnectionStatsImpl) {
            newStats = new JDBCConnectionStatsImpl(stats.getStatsType(), stats.getName(), stats.getType(), stats.getLevel(), newStatistics, newSubStats);
        } else if (stats instanceof JDBCConnectionPoolStatsImpl) {
            newStats = new JDBCConnectionPoolStatsImpl(stats.getStatsType(), stats.getName(), stats.getType(), stats.getLevel(), newStatistics, newSubStats);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "copyStats - return val", newStats);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyStats", StatsUtil.getStatsName(newStats));
        }
        return newStats;
    }

    private static ArrayList copyStatistics(StatisticImpl[] sArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyStatistics");
        }
        ArrayList<StatisticImpl> sCopy = null;
        if (sArray != null) {
            sCopy = new ArrayList<StatisticImpl>(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                sCopy.add(StatsUtil.copyStatistic(sArray[i]));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyStatistics");
        }
        return sCopy;
    }

    private static StatisticImpl copyStatistic(StatisticImpl s) {
        StatisticImpl sCopy = null;
        if (s instanceof BoundedRangeStatisticImpl) {
            BoundedRangeStatisticImpl brStic = (BoundedRangeStatisticImpl)s;
            BoundedRangeStatisticImpl brsi = new BoundedRangeStatisticImpl(s.getId());
            brsi.set(brStic.getLowerBound(), brStic.getUpperBound(), brStic.getLowWaterMark(), brStic.getHighWaterMark(), brStic.getCurrent(), brStic.getIntegral(), brStic.getStartTime(), brStic.getLastSampleTime());
            brsi.setDataInfo(s.getDataInfo());
            sCopy = brsi;
        } else if (s instanceof RangeStatisticImpl) {
            RangeStatisticImpl rStic = (RangeStatisticImpl)s;
            RangeStatisticImpl rsi = new RangeStatisticImpl(s.getId());
            rsi.set(rStic.getLowWaterMark(), rStic.getHighWaterMark(), rStic.getCurrent(), rStic.getIntegral(), rStic.getStartTime(), rStic.getLastSampleTime());
            rsi.setDataInfo(s.getDataInfo());
            sCopy = rsi;
        } else if (s instanceof BoundaryStatisticImpl) {
            BoundaryStatisticImpl bStic = (BoundaryStatisticImpl)s;
            BoundaryStatisticImpl bsi = new BoundaryStatisticImpl(s.getId());
            bsi.set(bStic.getLowerBound(), bStic.getUpperBound(), bStic.getStartTime(), bStic.getLastSampleTime());
            bsi.setDataInfo(s.getDataInfo());
            sCopy = bsi;
        } else if (s instanceof CountStatisticImpl) {
            CountStatisticImpl cStic = (CountStatisticImpl)s;
            CountStatisticImpl csi = new CountStatisticImpl(s.getId());
            csi.set(cStic.getCount(), cStic.getStartTime(), cStic.getLastSampleTime());
            csi.setDataInfo(s.getDataInfo());
            sCopy = csi;
        } else if (s instanceof TimeStatisticImpl) {
            TimeStatisticImpl tStic = (TimeStatisticImpl)s;
            TimeStatisticImpl tsi = new TimeStatisticImpl(s.getId());
            tsi.set(tStic.getCount(), tStic.getMinTime(), tStic.getMaxTime(), tStic.getTotalTime(), tStic.getSumOfSquares(), tStic.getStartTime(), tStic.getLastSampleTime());
            tsi.setDataInfo(s.getDataInfo());
            sCopy = tsi;
        } else if (s instanceof AverageStatisticImpl) {
            AverageStatisticImpl tStic = (AverageStatisticImpl)s;
            AverageStatisticImpl tsi = new AverageStatisticImpl(s.getId());
            tsi.set(tStic.getCount(), tStic.getMin(), tStic.getMax(), tStic.getTotal(), tStic.getSumOfSquares(), tStic.getStartTime(), tStic.getLastSampleTime());
            tsi.setDataInfo(s.getDataInfo());
            sCopy = tsi;
        } else if (s instanceof DoubleStatisticImpl) {
            DoubleStatisticImpl dStic = (DoubleStatisticImpl)s;
            DoubleStatisticImpl dsi = new DoubleStatisticImpl(s.getId());
            dsi.set(dStic.getDouble(), dStic.getStartTime(), dStic.getLastSampleTime());
            dsi.setDataInfo(s.getDataInfo());
            sCopy = dsi;
        }
        return sCopy;
    }

    public static StatsImpl findStats(StatsImpl seedStats, DataDescriptor dd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findStats", new Object[]{StatsUtil.getStatsName(seedStats), dd});
        }
        if (seedStats == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findStats - null seedStats passed in", null);
            }
            return null;
        }
        if (dd == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findStats - Server StatsImpl (null DataDescriptor)", StatsUtil.getStatsName(seedStats));
            }
            return seedStats;
        }
        String[] path = dd.getPath();
        if (path == null || path.length == 0 || path.length == 1 && path[0].equals("pmi")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findStats - Server StatsImpl (null Path)", StatsUtil.getStatsName(seedStats));
            }
            return seedStats;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "findStats - path", path[0]);
        }
        StatsImpl stats = seedStats;
        Object nextStats = null;
        for (int i = 0; i < path.length; ++i) {
            String childName = path[i];
            if ((stats = (StatsImpl)stats.getStats(childName)) != null) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findStats - stats not found", null);
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "findStats - return val", stats);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findStats", StatsUtil.getStatsName(stats));
        }
        return stats;
    }

    public static final String getStatsName(StatsImpl s) {
        if (s == null) {
            return "null";
        }
        return s.getName();
    }
}

