/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.dynamicproxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.pmi.dynamicproxy.PerfPrivateLocal;
import com.ibm.ws.pmi.dynamicproxy.StatsUtil;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.stat.StatsImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public class PmiStateObject {
    private static HashMap activeServerStats = new HashMap();
    private static HashMap idleServerStats = new HashMap();
    private static StatsImpl terminatedServerStats = null;
    private static TraceComponent tc = Tr.register(PmiStateObject.class, "PMI", null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize(String stoken) {
        StatsImpl serverStats;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", stoken);
        }
        StatsImpl statsImpl = serverStats = PerfPrivateLocal.get().getServerStats();
        synchronized (statsImpl) {
            activeServerStats.put(stoken, serverStats);
            Stack<StatsImpl> nodeStack = new Stack<StatsImpl>();
            nodeStack.push(serverStats);
            while (!nodeStack.empty()) {
                StatsImpl s = (StatsImpl)nodeStack.pop();
                s.setDataMembers(new ArrayList(0));
                StatsImpl[] children = (StatsImpl[])s.getSubStats();
                if (children == null) continue;
                for (int c = 0; c < children.length; ++c) {
                    nodeStack.push(children[c]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private static boolean isInitialized(String stoken) {
        return activeServerStats.containsKey(stoken);
    }

    public static void setActiveServerStats(String stoken, DataDescriptor dd, StatsImpl s) {
        String childName;
        StatsImpl idleStats;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStats", new Object[]{stoken, dd, PmiStateObject.getStatsName(s)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setStats - StatsImpl param", s);
        }
        if ((idleStats = (StatsImpl)idleServerStats.get(stoken)) != null) {
            if (idleStats.getTime() >= s.getTime()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setStats - idle StatsImpl is newer, not storing");
                }
                return;
            }
            idleServerStats.remove(stoken);
        }
        if (dd == null) {
            activeServerStats.put(stoken, s);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setStats - Server StatsImpl (null DataDescriptor)");
            }
            return;
        }
        String[] path = dd.getPath();
        if (path == null || path.length == 0 || path.length == 1 && path[0].equals("pmi")) {
            activeServerStats.put(stoken, s);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setStats - Server StatsImpl (null Path)");
            }
            return;
        }
        if (!PmiStateObject.isInitialized(stoken)) {
            PmiStateObject.initialize(stoken);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setStats - path", path[0]);
        }
        StatsImpl stats = (StatsImpl)activeServerStats.get(stoken);
        StatsImpl nextStats = null;
        for (int i = 0; i < path.length - 1; ++i) {
            childName = path[i];
            nextStats = (StatsImpl)stats.getStats(childName);
            if (nextStats == null) {
                nextStats = new StatsImpl(childName, 0, 0, null, new ArrayList());
                stats.add(nextStats);
            }
            stats = nextStats;
        }
        ArrayList<StatsImpl> subStats = stats.subCollections();
        if (subStats == null) {
            subStats = new ArrayList<StatsImpl>();
            subStats.add(s);
            stats.setSubcollections(subStats);
        } else {
            childName = s.getName();
            boolean found = false;
            for (int i = 0; i < subStats.size() && !found; ++i) {
                if (!((StatsImpl)subStats.get(i)).getName().equals(childName)) continue;
                subStats.set(i, s);
                found = true;
            }
            if (!found) {
                subStats.add(s);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStats");
        }
    }

    public static StatsImpl getActiveServerStats(DataDescriptor dd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveServerStats", dd);
        }
        StatsImpl s = PmiStateObject.combineFromHashMap(activeServerStats, dd);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getActiveServerStats - return value", s);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveServerStats", PmiStateObject.getStatsName(s));
        }
        return s;
    }

    public static StatsImpl getActiveServerStats(String stoken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveServerStats", stoken);
        }
        if (!PmiStateObject.isInitialized(stoken)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getActiveServerStats - non existent server", null);
            }
            return null;
        }
        StatsImpl stats = (StatsImpl)activeServerStats.get(stoken);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getActiveServerStats - return value", stats);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveServerStats", PmiStateObject.getStatsName(stats));
        }
        return stats;
    }

    public static void addIdleServerStats(String stoken, StatsImpl s) {
        StatsImpl activeStats;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addIdleServerStats", new Object[]{stoken, PmiStateObject.getStatsName(s)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getIdleServerStats - StatsImpl param", s);
        }
        if ((activeStats = (StatsImpl)activeServerStats.get(stoken)) != null) {
            if (activeStats.getTime() > s.getTime()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addIdleServerStats - active StatsImpl is newer, not storing");
                }
                return;
            }
            activeServerStats.remove(stoken);
        }
        idleServerStats.put(stoken, s);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addIdleServerStats");
        }
    }

    public static StatsImpl getIdleServerStats(DataDescriptor dd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIdleServerStats(dd)", dd);
        }
        StatsImpl s = PmiStateObject.combineFromHashMap(idleServerStats, dd);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getIdleServerStats(dd) - return value", s);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdleServerStats(dd)", PmiStateObject.getStatsName(s));
        }
        return s;
    }

    public static StatsImpl getIdleServerStats(String stoken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIdleServerStats(stoken)", stoken);
        }
        StatsImpl stats = (StatsImpl)activeServerStats.get(stoken);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getIdleServerStats(stoken) - return value", stats);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdleServerStats(stoken)", PmiStateObject.getStatsName(stats));
        }
        return stats;
    }

    public static void addTerminatedServerStats(String stoken, StatsImpl s) {
        WSStats[] subStats;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTerminatedStats", PmiStateObject.getStatsName(s));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addTerminatedStats - StatsImpl param", s);
        }
        if ((subStats = s.listSubStats()) != null) {
            for (int i = 0; i < subStats.length; ++i) {
                PmiStateObject.updateStatistics(subStats[i]);
            }
        }
        if (terminatedServerStats == null) {
            terminatedServerStats = s;
        } else {
            StatsUtil.aggregate(terminatedServerStats, s);
        }
        activeServerStats.remove(stoken);
        idleServerStats.remove(stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTerminatedStats");
        }
    }

    private static void updateStatistics(WSStats stats) {
        StatsImpl statsImpl;
        WSStatistic[] statistics;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateStatistics", stats);
        }
        if ((statistics = (statsImpl = (StatsImpl)stats).getStatistics()) != null) {
            ArrayList<WSStatistic> newList = new ArrayList<WSStatistic>();
            boolean listUpdated = false;
            for (int i = 0; i < statistics.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "statistics[" + i + "]", statistics[i]);
                }
                if (statistics[i].getDataInfo().isZosAggregatable()) {
                    newList.add(statistics[i]);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "statistics[" + i + "] added to new list");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "statistics[" + i + "] not added to new list");
                }
                listUpdated = true;
            }
            if (listUpdated) {
                statsImpl.setStatistics(newList);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stats updated", stats);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateStatistics");
        }
    }

    public static StatsImpl getTerminatedServerStats(DataDescriptor dd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTerminatedStats", dd);
        }
        StatsImpl stats = null;
        if (terminatedServerStats != null) {
            stats = StatsUtil.findStats(terminatedServerStats, dd);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTerminatedStats - return value", stats);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTerminatedStats", PmiStateObject.getStatsName(stats));
        }
        return stats;
    }

    private static synchronized StatsImpl combineFromHashMap(HashMap hash, DataDescriptor dd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "combineFromHashMap", dd);
        }
        StatsImpl s = null;
        StatsImpl tmpStats = null;
        String stoken2 = null;
        for (String stoken2 : hash.keySet()) {
            tmpStats = StatsUtil.findStats((StatsImpl)hash.get(stoken2), dd);
            if (tmpStats == null) continue;
            if (s == null) {
                s = StatsUtil.copyStats(tmpStats);
                continue;
            }
            s = StatsUtil.combineAll(s, tmpStats);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "combineFromHashMap", s);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "combineFromHashMap", PmiStateObject.getStatsName(s));
        }
        return s;
    }

    private static String getStatsName(StatsImpl s) {
        if (s == null) {
            return "null";
        }
        return s.getName();
    }
}

