/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.dynamicproxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.dynamicproxy.AggregationHandler;
import com.ibm.websphere.management.dynamicproxy.ServantMBeanResult;
import com.ibm.websphere.management.dynamicproxy.StateObject;
import com.ibm.ws.pmi.dynamicproxy.PerfMBeanAggregationHandler;
import com.ibm.ws.pmi.dynamicproxy.PerfPrivateLocal;
import com.ibm.ws.pmi.dynamicproxy.ZMBeanStats;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.stat.StatsImpl;
import javax.management.ObjectName;

public class MBeanStatsAggregationHandler
implements AggregationHandler {
    private static TraceComponent tc = Tr.register(MBeanStatsAggregationHandler.class, "PMI", null);

    public Object aggregateResults(String methodName, Object[] params, String[] signatures, ServantMBeanResult[] servantMBeanResults, StateObject stateObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "aggregateResults", methodName);
        }
        if (methodName.equals("getStats")) {
            ServantMBeanResult rslt;
            int i;
            if (!PerfPrivateLocal.exists()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "aggregateResults (PMI is NOT enabled)", null);
                }
                return null;
            }
            StatsImpl result = null;
            StatsImpl[] stats = null;
            String[] stokens = null;
            ObjectName invokeTarget = null;
            DataDescriptor dd = null;
            if (servantMBeanResults != null && servantMBeanResults.length > 0) {
                stats = new StatsImpl[servantMBeanResults.length];
                stokens = new String[servantMBeanResults.length];
                boolean haveResult = false;
                for (i = 0; i < servantMBeanResults.length; ++i) {
                    rslt = servantMBeanResults[i];
                    if (rslt != null) {
                        ZMBeanStats zs = (ZMBeanStats)rslt.getResult();
                        if (zs != null) {
                            stats[i] = (StatsImpl)zs.getZWSImpl();
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ZMBeanStats is null");
                        }
                        stokens[i] = rslt.getStoken();
                        if (haveResult) continue;
                        invokeTarget = rslt.getObjectName();
                        dd = PerfPrivateLocal.get().getDataDescriptor(invokeTarget);
                        haveResult = true;
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "ServantMBeanResults is null");
                }
            }
            if (dd != null) {
                result = PerfMBeanAggregationHandler.aggregate(dd, stokens, stats);
            }
            ZMBeanStats zResult = null;
            for (i = 0; servantMBeanResults != null && i < servantMBeanResults.length; ++i) {
                rslt = servantMBeanResults[i];
                if (rslt == null || (zResult = (ZMBeanStats)rslt.getResult()) == null) continue;
                zResult.setZWSImpl(result);
                break;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "aggregateResults", zResult);
            }
            return zResult;
        }
        return methodName + " is NOT handled by " + this.getClass().getName();
    }
}

