/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.xml.product.product;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.pmi.component.PMI;
import com.ibm.ws.pmi.server.PMIServiceState;
import com.ibm.ws.pmi.server.PerfPrivate;
import com.ibm.ws.pmi.server.PmiCollaborator;
import com.ibm.ws.pmi.server.PmiCollaboratorFactory;
import com.ibm.ws.pmi.server.PmiConfigManager;
import com.ibm.ws.pmi.server.PmiFactory;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.modules.RuntimeModule;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class PMIImpl
extends ComponentImpl
implements PMI {
    public static final String PMI_CONFIGFILE = "pmi-config.xml";
    private static PMIServiceState serviceState = new PMIServiceState();
    private boolean enabled = false;
    private static boolean bIsCustomSet = false;
    private static boolean bSpecChanged = false;
    private static TraceComponent tc = Tr.register(PMIImpl.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static ConfigService cfgService;

    public void initialize(Object config) {
        String sStatisticSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", config);
        }
        this.addService(PMI.class);
        ConfigObject pmiCfg = (ConfigObject)config;
        this.enabled = pmiCfg.getBoolean("enable", false);
        if (this.isXD()) {
            this.enabled = true;
        }
        if (!this.enabled) {
            return;
        }
        String processType = AdminServiceFactory.getAdminService().getProcessType();
        if (processType.equals("DeploymentManager")) {
            Tr.warning(tc, "PMI0032W");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
            return;
        }
        Tr.audit(tc, "PMI0001A");
        PmiRegistry.init();
        String levelSpec50 = pmiCfg.getString("initialSpecLevel", null);
        if (levelSpec50 != null && levelSpec50.length() > 0 && tc.isDebugEnabled()) {
            Tr.warning(tc, "PMI0031W");
        }
        if ((sStatisticSet = pmiCfg.getString("statisticSet", null)) == null || sStatisticSet.length() == 0) {
            sStatisticSet = "custom";
        }
        serviceState.setSynchronizedUpdate(pmiCfg.getBoolean("synchronizedUpdate", false));
        serviceState.setStatisticSet(sStatisticSet);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "statisticSet=" + sStatisticSet + "; syncUpdate=" + serviceState.getSynchronizedUpdate());
        }
        try {
            cfgService = WsServiceRegistry.getService(this, ConfigService.class);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.pmi.component.PMIImpl.initialize", "52", this);
            Tr.warning(tc, "PMI9999E", ex);
        }
        if (sStatisticSet.equals("custom")) {
            bIsCustomSet = true;
            PMIImpl.initSpecFromPmiConfigDocument();
        }
        PmiRegistry.restorePmiLevel();
        try {
            PmiCollaborator pmiCollaborator = PmiCollaboratorFactory.getPmiCollaborator(processType);
            DefaultRuntimeCollaborator rtCollaborator = new DefaultRuntimeCollaborator(pmiCollaborator);
            MBeanFactory factory = AdminServiceFactory.getMBeanFactory();
            factory.activateMBean("Perf", rtCollaborator, "PerfMBean", null);
            if (PmiRegistry.Z) {
                if (AdminHelper.getPlatformHelper().isServantJvm() || AdminHelper.getPlatformHelper().isCRAJvm() || processType.equals("NodeAgent")) {
                    PerfPrivate.init();
                }
            } else {
                PerfPrivate.init();
            }
            if (processType.equals("NodeAgent") || processType.equals("UnManagedProcess")) {
                DefaultRuntimeCollaborator sysCollab = new DefaultRuntimeCollaborator(this, "SystemMetrics");
                factory.activateMBean("SystemMetrics", sysCollab, "SystemMetrics", null);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.pmi.component.PMIImpl.initialize", "52", this);
            Tr.warning(tc, "PMI9999E", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public static boolean initSpecFromPmiConfigDocument() {
        ConfigObject conObj;
        try {
            conObj = PMIImpl.returnCfgObject(cfgService, 4, PMI_CONFIGFILE);
        }
        catch (Exception e) {
            conObj = null;
            Tr.warning(tc, "PMI0026W", e);
        }
        if (conObj != null) {
            PmiConfigManager.initRCSSpec(conObj);
            return true;
        }
        return false;
    }

    public void start() {
        if (!this.enabled) {
            return;
        }
        int[] heapsz = this.readJVMConfig();
        if (heapsz[2] == 1) {
            RuntimeModule.setJVMPIEnabled(true);
        }
        if (heapsz[2] == 2) {
            RuntimeModule.setJVMTIEnabled(true);
        }
        RuntimeModule rtMod = PmiFactory.createJvmPerf(heapsz[0], heapsz[1]);
        try {
            String processType = AdminServiceFactory.getAdminService().getProcessType();
            if (processType.equals("NodeAgent") || processType.equals("UnManagedProcess")) {
                PmiFactory.createSystemPerf("sys module");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.pmi.component.PMIImpl.start", "75", this);
            Tr.warning(tc, "PMI9999E", e);
        }
    }

    public void stop() {
    }

    public void destroy() {
    }

    private int[] readJVMConfig() {
        PlatformHelper platHelp = AdminHelper.getPlatformHelper();
        String zOSRegion = "Servant";
        if (platHelp.isControlJvm()) {
            zOSRegion = "Control";
        } else if (platHelp.isServantJvm()) {
            zOSRegion = "Servant";
        } else if (platHelp.isServantJvm()) {
            zOSRegion = "Adjunct";
        }
        int[] jvmConfig = new int[]{0, 0, 0};
        ConfigObject javaVirtualMachine = null;
        ConfigObject jpDef = null;
        ConfigObject s = null;
        try {
            Object o;
            ConfigService cfgService = WsServiceRegistry.getService(this, ConfigService.class);
            s = PMIImpl.returnCfgObject(cfgService, 4, "server.xml");
            ListIterator list = s.getObjectList("processDefinitions").listIterator();
            if (list != null) {
                String processType;
                while (list.hasNext() && ((o = list.next()) == null || (processType = (jpDef = (ConfigObject)o).getString("processType", null)) != null && !processType.equalsIgnoreCase(zOSRegion))) {
                }
            }
            if (jpDef == null && (o = s.getObject("processDefinition")) != null) {
                jpDef = o;
            }
            if (jpDef != null) {
                javaVirtualMachine = (ConfigObject)jpDef.getObjectList("jvmEntries").get(0);
            }
        }
        catch (Exception exx) {
            Tr.warning(tc, "PMI9999E", exx);
        }
        if (javaVirtualMachine != null) {
            jvmConfig[0] = javaVirtualMachine.getInt("initialHeapSize", 0);
            if (jvmConfig[0] == 0) {
                jvmConfig[0] = 50;
            }
            jvmConfig[0] = 1024 * jvmConfig[0];
            jvmConfig[1] = javaVirtualMachine.getInt("maximumHeapSize", 0);
            if (jvmConfig[1] == 0) {
                jvmConfig[1] = 256;
            }
            jvmConfig[1] = 1024 * jvmConfig[1];
            String genArg = javaVirtualMachine.getString("genericJvmArguments", null);
            if (genArg != null && genArg.length() > 0) {
                if (genArg.indexOf("pmiJvmpiProfiler") > -1 || genArg.indexOf("QWASJVMPI") > -1) {
                    jvmConfig[2] = 1;
                }
                if (genArg.indexOf("pmiJvmtiProfiler") > -1 || genArg.indexOf("QWASJVMTI") > -1) {
                    jvmConfig[2] = 2;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JVM config {ms, mx, jvmpi}: " + jvmConfig[0] + ", " + jvmConfig[1] + ", " + jvmConfig[2]);
            }
        } else {
            Tr.warning(tc, "PMI9999E", "Error getting JavaVirtualMachine configuration");
        }
        return jvmConfig;
    }

    public static void setSynchronizedUpdate(boolean flag) {
        if (serviceState.getSynchronizedUpdate() == flag) {
            return;
        }
        bSpecChanged = true;
        serviceState.setSynchronizedUpdate(flag);
    }

    public static boolean getSynchronizedUpdate() {
        return serviceState.getSynchronizedUpdate();
    }

    public static void setStatisticSet(String s) {
        if (serviceState.getStatisticSet().equals(s)) {
            return;
        }
        bSpecChanged = true;
        serviceState.setStatisticSet(s);
        if (s.equals("custom")) {
            bIsCustomSet = true;
        }
    }

    public static String getStatisticSet() {
        return serviceState.getStatisticSet();
    }

    public static boolean isCustomSet() {
        return bIsCustomSet;
    }

    public static boolean isSpecUpdated() {
        return bSpecChanged;
    }

    public static PMIServiceState getStateObject() {
        return serviceState;
    }

    public static void updateRuntimeWithStateObject(PMIServiceState state) {
        serviceState.setStatisticSet(state.getStatisticSet());
        serviceState.setSynchronizedUpdate(state.getSynchronizedUpdate());
        PmiConfigManager.updateSpec(state.getInstrumentationSpec());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private boolean isXD() {
        boolean retval = false;
        try {
            WASProduct product2 = new WASProduct();
            Iterator products = product2.getProducts();
            while (products.hasNext()) {
                product nextProduct = (product)products.next();
                String nextProductId = nextProduct.getId();
                if (nextProductId == null || nextProductId.indexOf("XD") == -1) continue;
                if (nextProductId.equalsIgnoreCase("XDMS")) {
                    retval = false;
                    continue;
                }
                retval = true;
            }
            if (!retval) {
                try {
                    Class<?> asyncPmi = Thread.currentThread().getContextClassLoader().loadClass("com.ibm.ws.xd.pmi.async.server.Publisher");
                    retval = true;
                }
                catch (ClassNotFoundException e) {
                }
                catch (NoClassDefFoundError e) {}
            }
        }
        catch (Exception e) {
            Tr.warning(tc, "PMI9999E", "Error getting WAS Version");
        }
        return retval;
    }

    private static ConfigObject returnCfgObject(ConfigService cs, int scope, String file) {
        ConfigObject conObj = null;
        try {
            List list = cs.getDocumentObjects(cs.getScope(scope), file);
            conObj = (ConfigObject)list.get(0);
        }
        catch (Exception e) {
            Tr.error(tc, "Could Not Return ConfigObject");
            e.printStackTrace();
            return null;
        }
        return conObj;
    }
}

