/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.transport;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ffdc.Manager;
import com.ibm.ws.orbimpl.MessageUtility;
import com.ibm.ws.orbimpl.transport.JNIReaderPoolBase;
import com.ibm.ws.orbimpl.transport.JNIReaderThread;
import java.util.Hashtable;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;

public class JNIReaderPoolImpl
extends JNIReaderPoolBase {
    private int numReaders;
    private int nextReader = 0;
    private JNIReaderThread[] readers;
    private Hashtable readerMap = new Hashtable();
    private ORB theORB = null;
    private static final int DEFAULT_NUMBER_OR_READERS = 4;
    private static final String NUMBER_OF_READERS_PROPERTY_NAME = "com.ibm.CORBA.numJNIReaders";
    private static final String LOCAL_HOST_PROPERTY_NAME = "com.ibm.CORBA.LocalHost";
    private static final String USE_MULTIHOME_PROPERTY_NAME = "com.ibm.ws.orb.transport.useSingleNIC";

    public void init(ORB theORB) {
        String numReadersString;
        boolean useSingleNIC;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(256L, (Object)this, "ijavaorb", (Object)"Constructor)");
        }
        this.theORB = theORB;
        int queueDepth = theORB.getSocketQueueDepth();
        String localHost = theORB.getProperty("LOCAL_HOST_PROPERTY_NAME");
        String BindAddr = theORB.getProperty("USE_MULTIHOME_PROPERTY");
        boolean bl = useSingleNIC = localHost != null && BindAddr != null && BindAddr.equalsIgnoreCase("false");
        if (useSingleNIC && ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, (Object)this, "constructor - init(...)", "Bind To A Specific NIC Card Flag Is Set To = " + useSingleNIC);
        }
        if ((numReadersString = theORB.getProperty(NUMBER_OF_READERS_PROPERTY_NAME)) == null) {
            this.numReaders = 4;
        } else {
            try {
                this.numReaders = Integer.parseInt(numReadersString);
            }
            catch (NumberFormatException ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ws.orbimpl.transport.JNIReaderPoolImpl.init", "881", this);
                Object[] fillins = new String[]{NUMBER_OF_READERS_PROPERTY_NAME, numReadersString, String.valueOf(4)};
                ORBRas.orbMsgLogger.msg(2L, (Object)this, "constructor", MessageUtility.getMessage("JNIReaderManager.invalidNumberOfReaders"), (String)null, fillins);
                this.numReaders = 4;
            }
            if (this.numReaders <= 0) {
                Object[] fillins = new String[]{NUMBER_OF_READERS_PROPERTY_NAME, numReadersString, String.valueOf(4)};
                ORBRas.orbMsgLogger.msg(2L, (Object)this, "constructor", MessageUtility.getMessage("JNIReaderManager.invalidNumberOfReaders"), (String)null, fillins);
                this.numReaders = 4;
            }
        }
        this.readers = new JNIReaderThread[this.numReaders];
        for (int i = 0; i < this.numReaders; ++i) {
            this.readers[i] = new JNIReaderThread(queueDepth, localHost, useSingleNIC);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(256L, (Object)this, "ijavaorb", (Object)"Constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addConnection(ORBConnection c) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(256L, (Object)this, "ijavaorb", (Object)"addConnection)");
        }
        int index = 0;
        JNIReaderPoolImpl jNIReaderPoolImpl = this;
        synchronized (jNIReaderPoolImpl) {
            boolean aNonFullReaderWasFound = false;
            for (int numberOfReadersTried = 0; numberOfReadersTried < this.readers.length; ++numberOfReadersTried) {
                ++this.nextReader;
                if (this.nextReader >= this.numReaders) {
                    this.nextReader = 0;
                }
                if (this.readers[index].getAvailableQueueSpace() == 0) continue;
                aNonFullReaderWasFound = true;
                break;
            }
            if (!aNonFullReaderWasFound) {
                String message = MessageUtility.getMessage("JNIReaderManager.noNonFullNativeReaders");
                ORBRas.orbMsgLogger.msg(4L, (Object)this, "addConnection()", MessageUtility.getMessage("JNIReaderManager.noNonFullNativeReaders"), (String)null, (Object[])null);
                throw new COMM_FAILURE(message, 1229127170, CompletionStatus.COMPLETED_NO);
            }
        }
        this.readers[index].addConnection(c);
        this.readerMap.put(c, this.readers[index]);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(256L, (Object)this, "ijavaorb", (Object)"addConnection");
        }
        return this.readers[index];
    }

    public void removeConnection(ORBConnection c, Object readerHandle) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(256L, (Object)this, "ijavaorb", (Object)"removeConection");
        }
        JNIReaderThread reader = (JNIReaderThread)this.readerMap.get(c);
        this.readerMap.remove(c);
        reader.removeConnection(c);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(256L, (Object)this, "ijavaorb", (Object)"removeConection");
        }
    }
}

