/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.InvalidNameSyntaxException;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.WsnName;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.omg.CosNaming.NameComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsnNameParser
implements NameParser,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent _tc = Tr.register(WsnNameParser.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static final boolean _debug;
    private static WsnNameParser _insNameParser;
    private static WsnNameParser _jndiNameParser;
    private final Hashtable<?, ?> _env;

    public static WsnNameParser getParser(Hashtable<?, ?> env) throws InvalidNameSyntaxException {
        String syntax = WsnName.syntaxProperty(env);
        return syntax.equals("jndi") ? _jndiNameParser : _insNameParser;
    }

    public static WsnNameParser getInsNameParser() {
        return _insNameParser;
    }

    public static WsnNameParser getJndiNameParser() {
        return _jndiNameParser;
    }

    private WsnNameParser(Hashtable<?, ?> env) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", "env=" + env);
        }
        this._env = env;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>");
        }
    }

    @Override
    public Name parse(String name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parse", "name=" + name);
        }
        WsnName wsnName = null;
        try {
            wsnName = new WsnName(name, this._env);
        }
        catch (InvalidNameException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "parse", "143", this, new Object[]{name});
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parse", e.toString());
            }
            throw e;
        }
        catch (InvalidNameSyntaxException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "parse", "149", this, new Object[]{name});
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parse", e.toString());
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parse", wsnName);
        }
        return wsnName;
    }

    public NameComponent[] parse(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parse", "name=" + name);
        }
        Object[] cosName = null;
        try {
            WsnName wsnName = new WsnName(name, this._env);
            cosName = wsnName.toCosName();
        }
        catch (InvalidNameException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "parse", "173", this, new Object[]{name});
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parse", e.toString());
            }
            throw e;
        }
        catch (InvalidNameSyntaxException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "parse", "179", this, new Object[]{name});
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parse", e.toString());
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parse", Arrays.toString(cosName));
        }
        return cosName;
    }

    public NameComponent[] stringToNC(String name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stringToNC", "name=" + name);
        }
        Object[] cosName = null;
        try {
            WsnName wsnName = new WsnName(name, this._env);
            cosName = wsnName.toCosName();
        }
        catch (InvalidNameException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "stringToNC", "203", this, new Object[]{name});
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "stringToNC", e.toString());
            }
            throw e;
        }
        catch (InvalidNameSyntaxException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "stringToNC", "209", this, new Object[]{name});
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "stringToNC", e.toString());
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stringToNC", Arrays.toString(cosName));
        }
        return cosName;
    }

    public String ncToString(NameComponent[] name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ncToString", "name=" + name);
        }
        String nameString = null;
        try {
            WsnName wsnName = new WsnName(name, this._env);
            nameString = wsnName.toString();
        }
        catch (InvalidNameException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "ncToString", "233", this, new Object[]{name});
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "ncToString", e.toString());
            }
            throw e;
        }
        catch (InvalidNameSyntaxException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "ncToString", "239", this, new Object[]{name});
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "ncToString", e.toString());
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ncToString", nameString);
        }
        return nameString;
    }

    public Name ncToName(NameComponent[] name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ncToName", "name=" + name);
        }
        WsnName wsnName = null;
        try {
            wsnName = new WsnName(name, this._env);
        }
        catch (InvalidNameException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "ncToName", "262", this, new Object[]{name});
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "ncToName", e.toString());
            }
            throw e;
        }
        catch (InvalidNameSyntaxException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "ncToName", "268", this, new Object[]{name});
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "ncToName", e.toString());
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ncToName", wsnName);
        }
        return wsnName;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[_env=");
        if (_debug) {
            stringBuilder.append(this._env);
        } else {
            stringBuilder.append(Helpers.mapToTerseString(this._env));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/WsnNameParser.java, WAS.naming.client, WAS70.SERV1, q0834.18, ver. 1.19");
        }
        CLASS_NAME = WsnNameParser.class.getName();
        _debug = Boolean.getBoolean("com.ibm.ws.naming.debug");
        _insNameParser = null;
        _jndiNameParser = null;
        Hashtable<?, ?> insEnv = Helpers.getINSEnvironment();
        _insNameParser = new WsnNameParser(insEnv);
        Hashtable<?, ?> jndiEnv = Helpers.getJNDIEnvironment();
        _jndiNameParser = new WsnNameParser(jndiEnv);
    }
}

