/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectURL;
import com.ibm.WsnBootstrap.Prop;
import com.ibm.WsnBootstrap.WsnNameService;
import com.ibm.WsnBootstrap.WsnNameServiceHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.ws.naming.ipbase.ContextID;
import com.ibm.ws.naming.ipbase.StringContextID;
import com.ibm.ws.naming.jcache.Cache;
import com.ibm.ws.naming.jcache.CacheEntryNotFoundException;
import com.ibm.ws.naming.jcache.CacheInvalidPropertyValueException;
import com.ibm.ws.naming.jcache.CacheManager;
import com.ibm.ws.naming.jndicos.CNContextImpl;
import com.ibm.ws.naming.ldap.WsnLdapInitCtxFactory;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.JavaObjectHolder;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.SecurityAuthentication;
import com.ibm.ws.naming.util.SecurityUtil;
import com.ibm.ws.naming.util.TransactionUtil;
import com.ibm.ws.naming.util.URLNameHelpers;
import com.ibm.ws.naming.util.WsnInitCtx;
import com.ibm.ws.naming.util.WsnName;
import com.ibm.ws.naming.util.WsnNameParser;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.WSEncoderDecoder;
import com.ibm.ws.util.StringUtils;
import java.net.MalformedURLException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.NotContextException;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.InitialContextFactory;
import javax.security.auth.Subject;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsnInitCtxFactory
implements InitialContextFactory {
    private static final TraceComponent _tc = Tr.register(WsnInitCtxFactory.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static final String SERVER_ROOT_CACHE_LOOKUP_NAME = "SERVER_ROOT";
    private static final String NODE_ROOT_CACHE_LOOKUP_NAME = "NODE_ROOT";
    private static final String CELL_ROOT_CACHE_LOOKUP_NAME = "CELL_ROOT";
    private static final String CELL_PERSISTENT_ROOT_CACHE_LOOKUP_NAME = "CELL_PERSISTENT_ROOT";
    private static final String TREE_ROOT_CACHE_LOOKUP_NAME = "TREE_ROOT";
    private static final String TREE_ROOT_PRIMARY_BINDING_NAME = "TREE_ROOT_PRIMARY_BINDING";
    private static final String LEGACY_ROOT_CACHE_LOOKUP_NAME = "LEGACY_ROOT";
    private static final String RIR_DEFAULT_ROOT_CACHE_LOOKUP_NAME = "RIR_DEFAULT_ROOT";
    private static final String IIOP_DEFAULT_ROOT_CACHE_LOOKUP_NAME = "IIOP_DEFAULT_ROOT";
    private static final String DEFAULT_PROVIDER_URL = "corbaloc:iiop:localhost";
    private static final String URL_SCHEME_CORBALOC = "corbaloc";
    private static final String URL_SCHEME_CORBANAME = "corbaname";
    private static final String URL_SCHEME_IIOP = "iiop";
    private static final String CONTEXT_KEY = "TargetContext=";
    private SecurityAuthentication _securityAuthentication = SecurityAuthentication.SIMPLE;
    private String _principal = null;
    private String _credentials = null;
    private boolean _jndiOnly = false;
    private boolean _securityEnabled = false;
    private WsnNameParser _nameParser = null;
    private ContextID[] _rootParentCtxIDs = null;
    private ContextID _rootCtxID = null;
    private Name _rootFullPrimaryNameForCaching = null;
    private String[] _rootCacheBindingNames = new String[0];

    public WsnInitCtxFactory() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "<init>");
        }
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInitialContext", Helpers.traceHashtable("starting env", env));
        }
        WsnInitCtx initCtx = new WsnInitCtx(env, this);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getInitialContext");
        }
        return initCtx;
    }

    protected Context getInitialContextInternal(Hashtable<?, ?> env) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInitialContextInternal", Helpers.traceHashtable("starting env", env));
        }
        CommonData cd = new CommonData(env);
        if (!(cd._wsnNSRootTypeProp.equals("defaultroot") || cd._wsnNSRootTypeProp.equals("bootstrapserverroot") || cd._wsnNSRootTypeProp.equals("bootstrapnoderoot") || cd._wsnNSRootTypeProp.equals("bootstraphostroot") || cd._wsnNSRootTypeProp.equals("cellroot") || cd._wsnNSRootTypeProp.equals("cellpersistentroot") || cd._wsnNSRootTypeProp.equals("legacydomainroot") || cd._wsnNSRootTypeProp.equals("treeinfrastructureroot"))) {
            ConfigurationException ce = new ConfigurationException("Value \"" + cd._wsnNSRootTypeProp + "\" specified for property " + "com.ibm.websphere.naming.namespaceroot" + " is not valid.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getInitialContextInternal", ce);
            }
            throw ce;
        }
        cd._omgOrb = Helpers.getOrb(cd._env);
        try {
            this.validateAuthenticationData(cd._env);
            if (this._securityEnabled) {
                this._credentials = this.decodeCredentials(cd._env);
            }
        }
        catch (NamingException ne) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getInitialContextInternal", ne.toString());
            }
            throw ne;
        }
        this.parseBootstrapUrl(cd);
        this._nameParser = WsnNameParser.getParser(cd._env);
        String cacheObject = Cache.cacheObjectPropertyValue(cd._env);
        cd._cachingEnabled = !cacheObject.equals("none");
        Iterator objAddrs = null;
        if (cd._wsnNSRootType == null) {
            this.disableCaching(cd);
        }
        if (cd._cachingEnabled) {
            if (cd._normalizedObjectUrl == null) {
                this.setCache(cd, null, -1);
            } else if (cd._normalizedObjectUrl.isRir()) {
                this.setCache(cd, null, -1);
            } else {
                objAddrs = cd._normalizedObjectUrl.getProtList();
            }
        }
        Context rootCtx = null;
        boolean gotRootFromCache = false;
        Name rootCacheLookupName = null;
        if (cd._cachingEnabled) {
            String rootCacheLookupNameString = IIOP_DEFAULT_ROOT_CACHE_LOOKUP_NAME;
            if (cd._wsnNSRootType.equals("defaultroot") && cd._normalizedObjectUrl != null && cd._normalizedObjectUrl.isRir()) {
                rootCacheLookupNameString = RIR_DEFAULT_ROOT_CACHE_LOOKUP_NAME;
            } else if (cd._wsnNSRootType.equals("cellroot")) {
                rootCacheLookupNameString = CELL_ROOT_CACHE_LOOKUP_NAME;
            } else if (cd._wsnNSRootType.equals("bootstraphostroot") || cd._wsnNSRootType.equals("bootstrapnoderoot")) {
                rootCacheLookupNameString = NODE_ROOT_CACHE_LOOKUP_NAME;
            } else if (cd._wsnNSRootType.equals("treeinfrastructureroot")) {
                rootCacheLookupNameString = TREE_ROOT_CACHE_LOOKUP_NAME;
            } else if (cd._wsnNSRootType.equals("bootstrapserverroot")) {
                rootCacheLookupNameString = SERVER_ROOT_CACHE_LOOKUP_NAME;
            } else if (cd._wsnNSRootType.equals("cellpersistentroot") || cd._wsnNSRootType.equals("legacydomainroot")) {
                rootCacheLookupNameString = CELL_PERSISTENT_ROOT_CACHE_LOOKUP_NAME;
            }
            do {
                if (objAddrs != null) {
                    ObjectURL.IIOPAddr iiopAddr = (ObjectURL.IIOPAddr)objAddrs.next();
                    this.setCache(cd, iiopAddr.getHost(), iiopAddr.getPort());
                }
                try {
                    rootCacheLookupName = this._nameParser.parse(rootCacheLookupNameString);
                    JavaObjectHolder cacheableReferenceHolder = new JavaObjectHolder(null);
                    CNContextImpl cachedCtx = (CNContextImpl)cd._cache.lookup(null, rootCacheLookupName, cacheableReferenceHolder);
                    rootCtx = new CNContextImpl(cd._env, cd._omgOrb, cachedCtx.getCosContext(), cachedCtx.getNameInNamespace(), cachedCtx.isContextNamePrimary(), cachedCtx.getContextID(), cd._cache, this._nameParser, this._securityAuthentication, this._principal, this._credentials, this._jndiOnly, this._securityEnabled);
                    gotRootFromCache = true;
                }
                catch (CacheEntryNotFoundException ex) {
                    // empty catch block
                }
            } while (objAddrs != null && objAddrs.hasNext());
        }
        if (rootCtx == null) {
            rootCtx = this.getRootJndiContext(cd);
        }
        if (cd._cachingEnabled && !gotRootFromCache) {
            if (rootCtx instanceof CNContextImpl && this._rootParentCtxIDs != null) {
                cd._cache.createSubcontext(null, this._rootFullPrimaryNameForCaching, this._rootParentCtxIDs, (CNContextImpl)rootCtx);
                for (String rootCacheBindingName : this._rootCacheBindingNames) {
                    Name rootBindingName = this._nameParser.parse(rootCacheBindingName);
                    cd._cache.bind(null, rootBindingName, new ContextID[0], rootCtx, null);
                }
            } else {
                this.disableCaching(cd);
            }
        }
        Context initCtx = rootCtx;
        java.lang.Object object = null;
        if (cd._targetContextName != null && cd._targetContextName.length() != 0) {
            try {
                WsnName insName = new WsnName(cd._targetContextName, Helpers.getINSEnvironment());
                WsnName targetName = new WsnName(insName.toCosName(), cd._env);
                object = rootCtx.lookup(targetName);
            }
            catch (NameNotFoundException ex) {
                RasUtil.logException((Throwable)ex, _tc, CLASS_NAME, "getInitialContextInternal", "590", this);
                NameNotFoundException nnfe = new NameNotFoundException("The provider URL \"" + cd._originalProviderUrl + "\" contains the lookup name \"" + cd._targetContextName + "\" which cannot be resolved by the initial " + "context factory.  See nested exception for more details.");
                nnfe.initCause(ex);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getInitialContextInternal", nnfe);
                }
                throw nnfe;
            }
            catch (NamingException ex) {
                RasUtil.logException((Throwable)ex, _tc, CLASS_NAME, "getInitialContextInternal", "608", this);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getInitialContextInternal", ex.toString());
                }
                throw ex;
            }
            if (object instanceof Context) {
                initCtx = (Context)object;
            } else {
                NotContextException nc = new NotContextException("The object bound to \"" + cd._targetContextName + "\" is not a context.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getInitialContextInternal", nc);
                }
                throw nc;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getInitialContextInternal", initCtx);
        }
        return initCtx;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateAuthenticationData(Hashtable<?, ?> env) throws NamingException {
        block18: {
            block17: {
                java.lang.Object credentials;
                block19: {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "validateAuthenticationData", "env=" + env);
                    }
                    if (env == null) break block18;
                    this._principal = Helpers.getStringProperty(env, "java.naming.security.principal");
                    credentials = env.get("java.naming.security.credentials");
                    String secAuth = Helpers.getStringProperty(env, "java.naming.security.authentication");
                    if (secAuth == null) break block19;
                    if (secAuth.equals(SecurityAuthentication.SIMPLE.getPropertyValue())) {
                        this._securityAuthentication = SecurityAuthentication.SIMPLE;
                        if (this._principal == null || credentials == null) {
                            String message = "The property java.naming.security.authentication is set to \"" + secAuth + "\" and either the principal or " + " credentials is not specified. Please provide both principal " + " and credentials to be authenticated.";
                            ConfigurationException ce = new ConfigurationException(message);
                            RasUtil.logException((Throwable)ce, _tc, CLASS_NAME, "validateAuthenticationData", "685", this);
                            if (_tc.isEntryEnabled()) {
                                Tr.exit(_tc, "validateAutenticationData", ce);
                            }
                            throw ce;
                        }
                        break block17;
                    } else if (secAuth.equals(SecurityAuthentication.NONE.getPropertyValue())) {
                        this._securityAuthentication = SecurityAuthentication.NONE;
                        break block17;
                    } else {
                        if (secAuth.equals(SecurityAuthentication.STRONG.getPropertyValue())) {
                            this._securityAuthentication = SecurityAuthentication.STRONG;
                            String message = "Strong security authentication is not supported. Only \"" + SecurityAuthentication.SIMPLE.getPropertyValue() + "\" and \"" + SecurityAuthentication.NONE.getPropertyValue() + "\" are currently supported.";
                            AuthenticationNotSupportedException anse = new AuthenticationNotSupportedException(message);
                            RasUtil.logException((Throwable)anse, _tc, CLASS_NAME, "validateAuthenticationData", "701", this);
                            if (_tc.isEntryEnabled()) {
                                Tr.exit(_tc, "validateAutenticationData", anse);
                            }
                            throw anse;
                        }
                        String message = "Value \"" + secAuth + "\" specified for property " + "java.naming.security.authentication" + " is not valid.";
                        ConfigurationException ce = new ConfigurationException(message);
                        RasUtil.logException((Throwable)ce, _tc, CLASS_NAME, "validateAuthenticationData", "710", this);
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "validateAutenticationData", ce);
                        }
                        throw ce;
                    }
                }
                if (this._principal != null && credentials != null) {
                    this._securityAuthentication = SecurityAuthentication.SIMPLE;
                } else if (this._principal == null && credentials == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "validateAuthenticationData", "no security related properties specified");
                    }
                    this._securityAuthentication = SecurityAuthentication.NONE;
                } else {
                    String message = "One or more security authentication properties were not specified. Please provide both principal and credentials to be authenticated.";
                    ConfigurationException ce = new ConfigurationException(message);
                    RasUtil.logException((Throwable)ce, _tc, CLASS_NAME, "validateAuthenticationData", "729", this);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "validateAutenticationData", ce);
                    }
                    throw ce;
                }
            }
            this._jndiOnly = Helpers.getBooleanProperty(env, "com.ibm.websphere.naming.jndi.security.jndionly", false, false);
        }
        boolean bl = this._securityEnabled = this._securityAuthentication == SecurityAuthentication.SIMPLE;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "validateAuthenticationData");
        }
    }

    private String decodeCredentials(Hashtable<?, ?> env) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "decodeCredentials");
        }
        String encodedCredentials = null;
        java.lang.Object credentials = env.get("java.naming.security.credentials");
        if (credentials instanceof String) {
            encodedCredentials = (String)credentials;
        } else if (credentials instanceof char[]) {
            encodedCredentials = String.valueOf((char[])credentials);
        } else if (credentials == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "decodeCredentials", "internal error - credentials should not be null!");
            }
            assert (false) : "internal error - credentials should not be null!";
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "decodeCredentials", "class=" + credentials.getClass().getName());
            }
            encodedCredentials = String.valueOf(credentials);
        }
        String decodedCredentials = null;
        if (encodedCredentials != null) {
            WSEncoderDecoder encoderDecoder = new WSEncoderDecoder();
            decodedCredentials = encoderDecoder.decode(encodedCredentials);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "decodeCredentials", StringUtils.maskPassword(decodedCredentials));
        }
        return decodedCredentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getRootJndiContext(CommonData cd) throws NamingException {
        Context rootCtx;
        block17: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getRootJndiContext");
            }
            rootCtx = null;
            TransactionUtil.TransactionWrapper txWrapper = null;
            try {
                txWrapper = TransactionUtil.suspend();
                Subject savedSubject = null;
                boolean restoreSubject = false;
                try {
                    if (this._securityEnabled) {
                        savedSubject = SecurityUtil.getRunAsSubject();
                        Subject subject = SecurityUtil.login(this._principal, this._credentials);
                        SecurityUtil.setRunAsSubject(subject);
                        restoreSubject = true;
                    }
                    if (cd._wsnNSRootType == null) {
                        rootCtx = this.getRootContextFromServer(cd, null, cd._normalizedObjectUrl);
                        break block17;
                    }
                    if (cd._normalizedObjectUrl == null || cd._normalizedObjectUrl.isRir()) {
                        String urlString = "corbaloc:rir:/WsnNameService";
                        ObjectURL wsnObjectUrl = ORB.createObjectURL((String)urlString);
                        rootCtx = this.getRootContextFromServer(cd, wsnObjectUrl, cd._normalizedObjectUrl);
                        break block17;
                    }
                    String objectKey = cd._normalizedObjectUrl.getKeyString();
                    String name = cd._normalizedObjectUrl.getStringName();
                    NamingException currentException = null;
                    Iterator objAddrs = cd._normalizedObjectUrl.getProtList();
                    while (rootCtx == null && objAddrs.hasNext()) {
                        currentException = null;
                        ObjectURL.IIOPAddr iiopAddr = (ObjectURL.IIOPAddr)objAddrs.next();
                        String urlString = "corbaloc:" + iiopAddr + "/" + "WsnNameService";
                        ObjectURL wsnObjectUrl = ORB.createObjectURL((String)urlString);
                        urlString = "corbaloc:" + iiopAddr + "/" + objectKey;
                        ObjectURL objectUrl = ORB.createObjectURL((String)urlString);
                        try {
                            rootCtx = this.getRootContextFromServer(cd, wsnObjectUrl, objectUrl);
                        }
                        catch (NamingException e) {
                            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "getRootJndiContext", "868", this);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "getRootJndiContext", "Could not connect to name server using URL " + this.objectToString(objectUrl));
                            }
                            currentException = e;
                        }
                        if (rootCtx != null) continue;
                        cd.clearWsnNSProperties();
                    }
                    if (currentException != null) {
                        Tr.warning(_tc, "jndiUnavailCommErr");
                        throw currentException;
                    }
                }
                finally {
                    if (restoreSubject && this._jndiOnly) {
                        SecurityUtil.setRunAsSubject(savedSubject);
                    }
                }
            }
            finally {
                TransactionUtil.resume(txWrapper);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getRootJndiContext", rootCtx);
        }
        return rootCtx;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Context getRootContextFromServer(CommonData cd, ObjectURL wsnObjectUrl, ObjectURL objectUrl) throws NamingException {
        Context rootCtx;
        block10: {
            block11: {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "getRootContextFromServer", new String[]{"wsnObjectUrl=" + wsnObjectUrl, "objectUrl=" + objectUrl});
                }
                rootCtx = null;
                cd._cache = null;
                WsnNameService wsnNS = this.getWsnNameService(cd, wsnObjectUrl);
                if (wsnNS == null) break block11;
                this.mergeWsnNSProperties(cd, wsnNS);
                if (cd._wsnIDLLevel == -1) {
                    cd._wsnIDLLevel = 0;
                }
                cd._wsnNSImplType = Helpers.getStringProperty(cd._env, "com.ibm.ws.naming.implementation", true);
                if (cd._wsnNSImplType.equals("WsnRdbCos") || cd._wsnNSImplType.equals("WsnIpCos")) {
                    rootCtx = this.getCosRootContext(cd, objectUrl);
                    break block10;
                } else if (cd._wsnNSImplType.equals("WsnLdap") || cd._wsnNSImplType.equals("WsnLdapCos")) {
                    if (cd._wsnNSRootType == null) {
                        String message = "Provider URL \"" + cd._originalProviderUrl + "\" contains an object key which is invalid for a WebSphere LDAP server.";
                        ConfigurationException ce = new ConfigurationException(message);
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "getRootContextFromServer", ce);
                        }
                        throw ce;
                    }
                    rootCtx = this.getLdapRootContext(cd);
                    break block10;
                } else {
                    String message = "Invalid implementation type \"" + cd._wsnNSImplType + "\" specified for environment property " + "com.ibm.ws.naming.implementation";
                    ConfigurationException ce = new ConfigurationException(message);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getRootContextFromServer", ce);
                    }
                    throw ce;
                }
            }
            rootCtx = this.getCosRootContext(cd, objectUrl);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getRootContextFromServer", rootCtx);
        }
        return rootCtx;
    }

    private Context getCosRootContext(CommonData cd, ObjectURL objectUrl) throws COMM_FAILURE, NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCosRootContext", "objectUrl=" + objectUrl);
        }
        NamingContext rootNC = null;
        String rootFullPrimaryNameString = null;
        ContextID rootCtxID = null;
        boolean wsnNC = true;
        try {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getCosRootContext", "IDL level=" + cd._wsnIDLLevel);
            }
            boolean isRir = objectUrl != null && objectUrl.isRir();
            Object rootObject = null;
            String sourceInfo = null;
            if (cd._wsnNSRootType != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getCosRootContext", "provider URL object key=" + cd._wsnNSRootType);
                }
                if ((cd._wsnNSRootType.equals("defaultroot") && !isRir && cd._wsnIDLLevel >= 1 || cd._wsnNSRootType.equals("bootstrapserverroot")) && cd._wsnServerRootIor != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getCosRootContext", "converting server root IOR to object");
                    }
                    rootObject = this.stringToObject(cd, cd._wsnServerRootIor);
                    rootFullPrimaryNameString = cd._wsnServerRootName;
                    this._rootParentCtxIDs = cd._wsnServerRootCtxIDs;
                    rootCtxID = cd._wsnServerRootCtxID;
                    sourceInfo = "bootstrapserverroot";
                    this.setCache(cd, objectUrl, new String[]{SERVER_ROOT_CACHE_LOOKUP_NAME, IIOP_DEFAULT_ROOT_CACHE_LOOKUP_NAME});
                } else if ((cd._wsnNSRootType.equals("defaultroot") && isRir && cd._wsnIDLLevel >= 1 || cd._wsnNSRootType.equals("cellroot")) && cd._wsnCellRootIor != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getCosRootContext", "converting cell root IOR to object");
                    }
                    rootObject = this.stringToObject(cd, cd._wsnCellRootIor);
                    rootFullPrimaryNameString = cd._wsnCellRootName;
                    this._rootParentCtxIDs = cd._wsnCellRootCtxIDs;
                    rootCtxID = cd._wsnCellRootCtxID;
                    sourceInfo = "cellroot";
                    this.setCache(cd, objectUrl, new String[]{CELL_ROOT_CACHE_LOOKUP_NAME, RIR_DEFAULT_ROOT_CACHE_LOOKUP_NAME});
                } else if ((cd._wsnNSRootType.equals("defaultroot") && !isRir && cd._wsnIDLLevel == 0 || cd._wsnNSRootType.equals("legacydomainroot") || cd._wsnNSRootType.equals("cellpersistentroot")) && cd._wsnCellPersistentRootIor != null) {
                    String[] stringArray;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getCosRootContext", "converting cell persistent root IOR to object");
                    }
                    rootObject = this.stringToObject(cd, cd._wsnCellPersistentRootIor);
                    rootFullPrimaryNameString = cd._wsnCellPersistentRootName;
                    this._rootParentCtxIDs = cd._wsnCellPersistentRootCtxIDs;
                    rootCtxID = cd._wsnCellPersistentRootCtxID;
                    sourceInfo = "legacydomainroot";
                    if (cd._wsnIDLLevel == 0) {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = LEGACY_ROOT_CACHE_LOOKUP_NAME;
                        stringArray = stringArray2;
                        stringArray2[1] = IIOP_DEFAULT_ROOT_CACHE_LOOKUP_NAME;
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = CELL_PERSISTENT_ROOT_CACHE_LOOKUP_NAME;
                        stringArray = stringArray3;
                        stringArray3[1] = LEGACY_ROOT_CACHE_LOOKUP_NAME;
                    }
                    this.setCache(cd, objectUrl, stringArray);
                } else if ((cd._wsnNSRootType.equals("defaultroot") && isRir && cd._wsnIDLLevel == 0 || cd._wsnNSRootType.equals("bootstraphostroot") || cd._wsnNSRootType.equals("bootstrapnoderoot")) && cd._wsnNodeRootIor != null) {
                    String[] stringArray;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getCosRootContext", "converting node root IOR to object");
                    }
                    rootObject = this.stringToObject(cd, cd._wsnNodeRootIor);
                    rootFullPrimaryNameString = cd._wsnNodeRootName;
                    this._rootParentCtxIDs = cd._wsnNodeRootCtxIDs;
                    rootCtxID = cd._wsnNodeRootCtxID;
                    sourceInfo = "bootstraphostroot";
                    if (cd._wsnIDLLevel == 0) {
                        String[] stringArray4 = new String[2];
                        stringArray4[0] = NODE_ROOT_CACHE_LOOKUP_NAME;
                        stringArray = stringArray4;
                        stringArray4[1] = RIR_DEFAULT_ROOT_CACHE_LOOKUP_NAME;
                    } else {
                        String[] stringArray5 = new String[1];
                        stringArray = stringArray5;
                        stringArray5[0] = NODE_ROOT_CACHE_LOOKUP_NAME;
                    }
                    this.setCache(cd, objectUrl, stringArray);
                } else if (cd._wsnNSRootType.equals("treeinfrastructureroot") && cd._wsnTreeRootIor != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getCosRootContext", "converting tree infrastructure root IOR to object");
                    }
                    rootObject = this.stringToObject(cd, cd._wsnTreeRootIor);
                    rootFullPrimaryNameString = cd._wsnTreeRootName;
                    this._rootParentCtxIDs = cd._wsnTreeRootCtxIDs;
                    rootCtxID = cd._wsnTreeRootCtxID;
                    sourceInfo = "treeinfrastructureroot";
                    this.setCache(cd, objectUrl, new String[]{TREE_ROOT_CACHE_LOOKUP_NAME});
                } else if (!cd._wsnNSRootType.equals("defaultroot") || cd._gotWsnNameService) {
                    String message = null;
                    message = cd._originalProviderUrl != null ? "Requested root type of \"" + cd._wsnNSRootType + "\" is not available using the provider URL \"" + cd._originalProviderUrl + "\"." : "Requested root type of \"" + cd._wsnNSRootType + "\" is not available. Since no provider URL was specified, " + "the default provider URL of \"" + this.objectToString(cd._normalizedObjectUrl) + "\" was used.";
                    NoInitialContextException ne = new NoInitialContextException(message);
                    throw ne;
                }
            }
            if (rootObject != null) {
                WsnName insName = new WsnName(rootFullPrimaryNameString, Helpers.getINSEnvironment());
                if (insName.size() == 0) {
                    this._rootFullPrimaryNameForCaching = new WsnName("", cd._env);
                    rootFullPrimaryNameString = "";
                } else {
                    this._rootFullPrimaryNameForCaching = new WsnName(insName.toCosName(), cd._env);
                    rootFullPrimaryNameString = this._rootFullPrimaryNameForCaching.toString();
                }
                this._rootFullPrimaryNameForCaching.add(0, TREE_ROOT_PRIMARY_BINDING_NAME);
            } else {
                if (objectUrl == null) {
                    rootObject = cd._omgOrb.resolve_initial_references("NameService");
                    sourceInfo = "resolve_initial_references(NameService)";
                } else {
                    String urlString = this.objectToString(objectUrl);
                    rootObject = this.stringToObject(cd, urlString);
                    sourceInfo = "string_to_object(" + urlString + ")";
                }
                this.disableCaching(cd);
                rootFullPrimaryNameString = "";
                wsnNC = false;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getCosRootContext", "root context selected using " + sourceInfo);
            }
            if (rootObject instanceof NamingContext) {
                rootNC = (NamingContext)rootObject;
            } else {
                String message;
                if (rootObject == null) {
                    message = "No initial reference returned by " + sourceInfo;
                    ServiceUnavailableException ne = new ServiceUnavailableException(message);
                    throw ne;
                }
                rootNC = CNContextImpl.narrowToNamingContext(cd._omgOrb, rootObject);
                if (rootNC == null) {
                    message = "Unable to narrow initial reference returned by " + sourceInfo + " to a NamingContext";
                    ServiceUnavailableException ne = new ServiceUnavailableException(message);
                    throw ne;
                }
            }
        }
        catch (BAD_PARAM e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "getCosRootContext", "1267", this);
            String message = null;
            message = cd._originalProviderUrl != null ? "Could not obtain initial context with the provider URL \"" + cd._originalProviderUrl + "\"." : "Could not obtain initial context with the default provider URL \"" + this.objectToString(cd._normalizedObjectUrl) + "\".";
            ServiceUnavailableException ne = new ServiceUnavailableException(message);
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getCosRootContext", (java.lang.Object)e);
            }
            throw ne;
        }
        catch (NamingException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "getCosRootContext", "1284", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getCosRootContext", e.toString());
            }
            throw e;
        }
        catch (Exception e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "getCosRootContext", "1289", this);
            NamingException ne = this.mapInitialReferenceFailure(cd, e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getCosRootContext", ne);
            }
            throw ne;
        }
        CNContextImpl ctx = null;
        ctx = !wsnNC ? new CNContextImpl(cd._env, cd._omgOrb, rootNC, rootFullPrimaryNameString, cd._cache, this._securityAuthentication, this._principal, this._credentials, this._jndiOnly, this._securityEnabled) : new CNContextImpl(cd._env, cd._omgOrb, rootNC, rootFullPrimaryNameString, true, rootCtxID, cd._cache, this._nameParser, this._securityAuthentication, this._principal, this._credentials, this._jndiOnly, this._securityEnabled);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCosRootContext", ctx);
        }
        return ctx;
    }

    private Context getLdapRootContext(CommonData cd) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getLdapRootContext");
        }
        WsnLdapInitCtxFactory icf = new WsnLdapInitCtxFactory();
        Context ctx = icf.getInitialContext(cd._env);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getLdapRootContext" + ctx);
        }
        return ctx;
    }

    private WsnNameService getWsnNameService(CommonData cd, ObjectURL objectUrl) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getWsnNameService", "objectUrl=" + objectUrl);
        }
        if (cd._ldapSkipBootstrap) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getWsnNameService", "_ldapSkipBootstrap=true - no attempt made to access WsnNameService bootstrap object");
            }
            return null;
        }
        if (objectUrl == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getWsnNameService", "null URL");
            }
            return null;
        }
        WsnNameService wsnNS = null;
        try {
            Object wsnNSObject = null;
            if (objectUrl.isRir()) {
                wsnNSObject = cd._omgOrb.resolve_initial_references("WsnNameService");
            } else {
                String urlString = this.objectToString(objectUrl);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getWsnNameService", "Attempting to connect to name server using URL " + urlString);
                }
                wsnNSObject = this.stringToObject(cd, urlString);
            }
            if (wsnNSObject != null) {
                wsnNS = WsnNameServiceHelper.narrow(wsnNSObject);
                cd._gotWsnNameService = true;
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getWsnNameService", "WsnNameService not found");
            }
        }
        catch (BAD_PARAM e) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "getWsnNameService", "Ignoring: " + (java.lang.Object)((java.lang.Object)e));
            }
        }
        catch (OBJECT_NOT_EXIST e) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "getWsnNameService", "Ignoring: " + (java.lang.Object)((java.lang.Object)e));
            }
        }
        catch (Exception e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "getWsnNameService", "1413", this);
            NamingException ne = this.mapInitialReferenceFailure(cd, e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getWsnNameService", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getWsnNameService", wsnNS);
        }
        return wsnNS;
    }

    private void mergeWsnNSProperties(CommonData cd, WsnNameService wsnNS) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "mergeWsnNSProperties", "wsnNS=" + wsnNS);
        }
        Prop[] props = null;
        try {
            props = wsnNS.getProperties();
        }
        catch (Exception e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "mergeWsnNSProperties", "1438", this);
            NamingException ne = new NamingException("Error getting WsnNameService properties");
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "mergeWsnNSProperties", ne);
            }
            throw ne;
        }
        for (Prop prop : props) {
            String key = prop.key;
            boolean traceIOR = true;
            if (key.equals("com.ibm.ws.naming.boot.treerootior")) {
                cd._wsnTreeRootIor = prop.value;
            } else if (key.equals("com.ibm.ws.naming.boot.noderootior")) {
                cd._wsnNodeRootIor = prop.value;
            } else if (key.equals("com.ibm.ws.naming.boot.domainrootior")) {
                cd._wsnCellRootIor = prop.value;
            } else if (key.equals("com.ibm.ws.naming.boot.legacyrootior")) {
                cd._wsnCellPersistentRootIor = prop.value;
            } else if (key.equals("com.ibm.ws.naming.boot.serverrootior")) {
                cd._wsnServerRootIor = prop.value;
            } else if (key.equals("com.ibm.ws.naming.boot.treerootname")) {
                cd._wsnTreeRootName = prop.value;
            } else if (key.equals("com.ibm.ws.naming.boot.noderootname")) {
                cd._wsnNodeRootName = prop.value;
            } else if (key.equals("com.ibm.ws.naming.boot.domainrootname")) {
                cd._wsnCellRootName = prop.value;
            } else if (key.equals("com.ibm.ws.naming.boot.legacyrootname")) {
                cd._wsnCellPersistentRootName = prop.value;
            } else if (key.equals("com.ibm.ws.naming.boot.serverrootname")) {
                cd._wsnServerRootName = prop.value;
            } else if (key.equals("com.ibm.ws.naming.boot.treerootctxids")) {
                cd._wsnTreeRootCtxIDs = WsnInitCtxFactory.toContextIDs(Helpers.stringToContextIDs(prop.value));
            } else if (key.equals("com.ibm.ws.naming.boot.noderootctxids")) {
                cd._wsnNodeRootCtxIDs = WsnInitCtxFactory.toContextIDs(Helpers.stringToContextIDs(prop.value));
            } else if (key.equals("com.ibm.ws.naming.boot.domainrootctxids")) {
                cd._wsnCellRootCtxIDs = WsnInitCtxFactory.toContextIDs(Helpers.stringToContextIDs(prop.value));
            } else if (key.equals("com.ibm.ws.naming.boot.legacyrootctxids")) {
                cd._wsnCellPersistentRootCtxIDs = WsnInitCtxFactory.toContextIDs(Helpers.stringToContextIDs(prop.value));
            } else if (key.equals("com.ibm.ws.naming.boot.serverrootctxids")) {
                cd._wsnServerRootCtxIDs = WsnInitCtxFactory.toContextIDs(Helpers.stringToContextIDs(prop.value));
            } else if (key.equals("com.ibm.ws.naming.boot.treerootctxid")) {
                cd._wsnTreeRootCtxID = new StringContextID(prop.value);
            } else if (key.equals("com.ibm.ws.naming.boot.noderootctxid")) {
                cd._wsnNodeRootCtxID = new StringContextID(prop.value);
            } else if (key.equals("com.ibm.ws.naming.boot.domainrootctxid")) {
                cd._wsnCellRootCtxID = new StringContextID(prop.value);
            } else if (key.equals("com.ibm.ws.naming.boot.legacyrootctxid")) {
                cd._wsnCellPersistentRootCtxID = new StringContextID(prop.value);
            } else if (key.equals("com.ibm.ws.naming.boot.serverrootctxid")) {
                cd._wsnServerRootCtxID = new StringContextID(prop.value);
            } else {
                traceIOR = false;
                if (key.equals("com.ibm.ws.naming.wsnidl.level")) {
                    cd._wsnIDLLevel = WsnInitCtxFactory.toInt(prop.value);
                } else {
                    cd._env.put(key, prop.value);
                }
            }
            if (!_tc.isEventEnabled() || !traceIOR) continue;
            Tr.event(_tc, "mergeWsnNSProperties", "root IOR from bootstrap host: " + key + " --> " + prop.value);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "mergeWsnNSProperties", Helpers.traceHashtable("merged env", cd._env));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "mergeWsnNSProperties");
        }
    }

    private Object stringToObject(CommonData cd, String string) throws COMM_FAILURE {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stringToObject", "string=" + string);
        }
        Object corbaObject = null;
        try {
            corbaObject = cd._omgOrb.string_to_object(string);
        }
        catch (COMM_FAILURE e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "stringToObject", "1526", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "stringToObject", (java.lang.Object)e);
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stringToObject", corbaObject);
        }
        return corbaObject;
    }

    private void setCache(CommonData cd, ObjectURL objectUrl, String[] rootCacheBindingNames) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setCache", new String[]{"objectUrl=" + objectUrl, "rootCacheBindingNames=", Arrays.toString(rootCacheBindingNames)});
        }
        if (cd._cachingEnabled) {
            Iterator iter;
            String host = null;
            int port = -1;
            if (objectUrl != null && !objectUrl.isRir() && (iter = objectUrl.getProtList()).hasNext()) {
                ObjectURL.IIOPAddr objAddr = (ObjectURL.IIOPAddr)iter.next();
                host = objAddr.getHost();
                port = objAddr.getPort();
            }
            this._rootCacheBindingNames = rootCacheBindingNames;
            this.setCache(cd, host, port);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setCache", "caching disabled");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setCache");
        }
    }

    private void setCache(CommonData cd, String bootstrapHost, int bootstrapPort) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setCache", new String[]{"bootstrapHost=" + bootstrapHost, "bootstrapPort=" + bootstrapPort});
        }
        if (cd._cachingEnabled) {
            try {
                String cacheNameProp = Cache.cacheNamePropertyValue(cd._env);
                if (cacheNameProp.equals("providerURL")) {
                    String cacheName = this.createCacheName(cd, bootstrapHost, bootstrapPort);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "setCache", "Getting cache: cacheName=" + cacheName);
                    }
                    cd._cache = CacheManager.getCacheUsingName(cacheName, cd._env);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "setCache", "Getting cache: cacheName (from env)=" + cacheNameProp);
                }
                cd._cache = CacheManager.getCache(cd._env);
            }
            catch (CacheInvalidPropertyValueException ex) {
                RasUtil.logException((Throwable)ex, _tc, CLASS_NAME, "setCache", "1613", this);
                NamingException nex = new NamingException("Bad JNDI cache property value");
                nex.initCause(ex);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "setCache", nex);
                }
                throw nex;
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setCache", "caching disabled");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setCache");
        }
    }

    private void disableCaching(CommonData cd) {
        cd._cachingEnabled = false;
        cd._cache = null;
    }

    private String createCacheName(CommonData cd, String hostname, int port) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createCacheName", new String[]{"hostname=" + hostname, "port=" + port});
        }
        String cacheName = null;
        if (hostname == null && port == -1) {
            cacheName = "rir:";
        } else {
            hostname = hostname == null || hostname.length() == 0 ? "<HOSTNAME NOT SPECIFIED>" : Helpers.normalizeHostForUrl(hostname);
            if (port == -1) {
                port = 2809;
            }
            cacheName = "iiop://" + hostname + ":" + port;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createCacheName", cacheName);
        }
        return cacheName;
    }

    private void parseBootstrapUrl(CommonData cd) throws NamingException {
        int colonIdx;
        String url;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseBootstrapUrl");
        }
        if ((url = (cd._originalProviderUrl = Helpers.getStringProperty(cd._env, "java.naming.provider.url"))) == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "parseBootstrapUrl", "provider URL not specified in environment");
            }
            url = DEFAULT_PROVIDER_URL;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "parseBootstrapUrl", "java.naming.provider.url=" + url);
        }
        if ((colonIdx = url.indexOf(58)) <= 0) {
            ConfigurationException ne = new ConfigurationException("Malformed provider URL \"" + url + "\"");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseBootstrapUrl", ne);
            }
            throw ne;
        }
        String scheme = url.substring(0, colonIdx);
        cd._normalizedUrlScheme = scheme.toLowerCase();
        if (cd._normalizedUrlScheme.equals(URL_SCHEME_CORBALOC) || cd._normalizedUrlScheme.equals(URL_SCHEME_CORBANAME)) {
            String escapedUrl = null;
            try {
                escapedUrl = URLNameHelpers.encodeCorbaURL(url);
            }
            catch (IllegalArgumentException iae) {
                ConfigurationException ne = new ConfigurationException("Malformed provider URL \"" + url + "\"");
                ne.initCause(iae);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "parseBootstrapUrl", ne);
                }
                throw ne;
            }
            try {
                cd._normalizedObjectUrl = ORB.createObjectURL((String)escapedUrl);
            }
            catch (BAD_PARAM e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "parseBootstrapUrl", "1722", this);
                ConfigurationException ne = new ConfigurationException("Malformed provider URL \"" + url + "\"");
                ne.initCause(e);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "parseBootstrapUrl", ne);
                }
                throw ne;
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "parseBootstrapUrl", "1729", this);
                ConfigurationException ne = new ConfigurationException("Unexpected error occurred while attempting to parse provider URL \"" + url + "\"");
                ne.initCause(t);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "parseBootstrapUrl", ne);
                }
                throw ne;
            }
        }
        if (cd._normalizedUrlScheme.equals(URL_SCHEME_IIOP)) {
            try {
                cd._normalizedObjectUrl = this.parseIiopUrl(cd, url);
            }
            catch (NamingException e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "parseBootstrapUrl", "1741", this);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "parseBootstrapUrl", e.toString());
                }
                throw e;
            }
            cd._normalizedUrlScheme = URL_SCHEME_CORBANAME;
        } else {
            ConfigurationException ne = new ConfigurationException("Unsupported scheme \"" + scheme + "\" in provider URL \"" + url + "\"");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseBootstrapUrl", ne);
            }
            throw ne;
        }
        this.normalizeUrl(cd);
        if (cd._normalizedObjectUrl != null) {
            String objectKey = cd._normalizedObjectUrl.getKeyString();
            cd._wsnNSRootType = objectKey == null || objectKey.length() == 0 || objectKey.equals("NameService") ? (cd._normalizedObjectUrl.isRir() ? "defaultroot" : cd._wsnNSRootTypeProp) : (objectKey.equals("NameServiceHostRoot") ? "bootstraphostroot" : (objectKey.equals("NameServiceLegacyRoot") ? "legacydomainroot" : (objectKey.equals("NameServiceTreeRoot") ? "treeinfrastructureroot" : (objectKey.equals("NameServiceNodeRoot") ? "bootstrapnoderoot" : (objectKey.equals("NameServiceCellPersistentRoot") ? "cellpersistentroot" : (objectKey.equals("NameServiceCellRoot") ? "cellroot" : (objectKey.equals("NameServiceServerRoot") ? "bootstrapserverroot" : null)))))));
            cd._wsnNSRootTypeProp = cd._wsnNSRootType != null ? cd._wsnNSRootType : "";
        } else {
            cd._wsnNSRootType = cd._wsnNSRootTypeProp;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "parseBootstrapUrl", "cd._wsnNSRootType=" + cd._wsnNSRootType);
        }
        if (_tc.isDebugEnabled()) {
            if (cd._normalizedObjectUrl != null) {
                Tr.debug(_tc, "parseBootstrapUrl", "normalized provider URL=" + this.objectToString(cd._normalizedObjectUrl));
            } else {
                Tr.debug(_tc, "parseBootstrapUrl", "no provider URL");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseBootstrapUrl");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ObjectURL parseIiopUrl(CommonData cd, String url) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseIiopUrl", "url=" + url);
        }
        ObjectURL objectURL = null;
        if (url == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseIiopUrl", objectURL);
            }
            return objectURL;
        }
        try {
            String addr = null;
            String context = null;
            String host = "localhost";
            String targetContextName = null;
            String portString = null;
            if (url.length() < 8 || !url.substring(5, 7).equals("//")) {
                MalformedURLException mue = new MalformedURLException("Malformed URL \"" + url + "\"");
                throw mue;
            }
            int idx = url.indexOf(47, 7);
            if (idx < 0) {
                addr = url.substring(7, url.length()).toLowerCase();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "parseIiopUrl", "no prepend specified");
                }
            } else {
                addr = idx == 7 ? "" : url.substring(7, idx).toLowerCase();
                context = url.substring(idx + 1);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "parseIiopUrl", "prepend specified");
                }
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "parseIiopUrl", "addr=" + addr + ", context=" + context);
            }
            if (addr.length() > 0) {
                idx = addr.indexOf(91);
                if (idx < 0) {
                    idx = addr.indexOf(58);
                    if (idx < 0) {
                        host = addr;
                    } else {
                        if (idx == 0) {
                            MalformedURLException mue = new MalformedURLException("Host name expected in URL \"" + url + "\"");
                            throw mue;
                        }
                        host = addr.substring(0, idx);
                        portString = addr.substring(idx + 1);
                    }
                } else {
                    if (idx != 0) {
                        MalformedURLException mue = new MalformedURLException("Invalid address specification in URL \"" + url + "\"");
                        throw mue;
                    }
                    idx = addr.indexOf(93);
                    if (idx < 0) {
                        MalformedURLException mue = new MalformedURLException("Invalid address specification in URL \"" + url + "\"");
                        throw mue;
                    }
                    host = addr.substring(0, idx + 1);
                    if (host.length() == 2) {
                        MalformedURLException mue = new MalformedURLException("Host name expected in URL \"" + url + "\"");
                        throw mue;
                    }
                    portString = addr.substring(idx + 1);
                    if (portString.length() > 0) {
                        if (!portString.startsWith(":")) {
                            MalformedURLException mue = new MalformedURLException("Invalid address specification in URL \"" + url + "\"");
                            throw mue;
                        }
                        portString = portString.substring(1);
                    } else {
                        portString = null;
                    }
                }
            }
            if (portString != null) {
                try {
                    int port = Integer.parseInt(portString);
                    if (port < 1 || port > 65535) {
                        MalformedURLException mue = new MalformedURLException("Invalid port specification in URL \"" + url + "\"");
                        throw mue;
                    }
                }
                catch (NumberFormatException e) {
                    RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "parseIiopUrl", "1969", this);
                    MalformedURLException mue = new MalformedURLException("Invalid port specification in URL \"" + url + "\"");
                    mue.initCause(e);
                    throw mue;
                }
            }
            if (context != null) {
                int questionIdx = context.indexOf(63);
                if (questionIdx >= 0) {
                    int keyIdx = context.indexOf(CONTEXT_KEY);
                    if (keyIdx <= 0) {
                        MalformedURLException mue = new MalformedURLException("Context lookup name expected in URL \"" + url + "\"");
                        throw mue;
                    }
                    targetContextName = context.substring(keyIdx + CONTEXT_KEY.length());
                } else {
                    targetContextName = context;
                }
                if (targetContextName != null && !targetContextName.equals("")) {
                    WsnName targetName = new WsnName(targetContextName, cd._env);
                    WsnName insName = new WsnName(targetName.toCosName(), Helpers.getINSEnvironment());
                    targetContextName = insName.toString();
                }
            }
            StringBuilder buffer = new StringBuilder("corbaname:iiop:");
            buffer.append(host);
            if (portString != null) {
                buffer.append(':');
                buffer.append(portString);
            }
            buffer.append('/');
            buffer.append("NameService");
            if (targetContextName != null && targetContextName.length() > 0) {
                String escapedName = null;
                try {
                    escapedName = URLNameHelpers.encodeString(targetContextName, true);
                }
                catch (IllegalArgumentException iae) {
                    MalformedURLException mue = new MalformedURLException("Malformed URL \"" + url + "\"");
                    mue.initCause(iae);
                    throw mue;
                }
                buffer.append('#');
                buffer.append(escapedName);
            }
            String corbanameUrl = buffer.toString();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "parseIiopUrl", "corbanameUrl=" + corbanameUrl);
            }
            objectURL = ORB.createObjectURL((String)corbanameUrl);
        }
        catch (Exception e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "parseIiopUrl", "2052", this);
            ConfigurationException ne = new ConfigurationException(e.toString());
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseIiopUrl", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseIiopUrl", objectURL);
        }
        return objectURL;
    }

    private void normalizeUrl(CommonData cd) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizeUrl");
        }
        if (cd._normalizedObjectUrl == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "normalizeUrl", "no URL to normalize");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "normalizeUrl");
            }
            return;
        }
        ObjectURL objectUrl = cd._normalizedObjectUrl;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "normalizeUrl", "normalizing URL " + this.objectToString(objectUrl));
        }
        StringBuilder buffer = new StringBuilder(cd._normalizedUrlScheme);
        buffer.append(':');
        try {
            String name;
            if (!objectUrl.isRir()) {
                Iterator objAddrs = objectUrl.getProtList();
                boolean more = objAddrs.hasNext();
                while (more) {
                    ObjectURL.ProtAddr protAddr = (ObjectURL.ProtAddr)objAddrs.next();
                    String prot = protAddr.getProtToken().toLowerCase();
                    if (!(protAddr instanceof ObjectURL.IIOPAddr)) {
                        String message = "Provider URL \"" + cd._originalProviderUrl + "\" contains an unrecognized protocol \"" + prot + "\"";
                        ConfigurationException ce = new ConfigurationException(message);
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "normalizeUrl", ce);
                        }
                        throw ce;
                    }
                    ObjectURL.IIOPAddr iiopAddr = (ObjectURL.IIOPAddr)protAddr;
                    String host = iiopAddr.getHost();
                    try {
                        java.lang.Object nameSyntax = cd._env.get("com.ibm.websphere.naming.name.syntax");
                        if ("ins".equals(nameSyntax)) {
                            Hashtable tempEnv = (Hashtable)cd._env.clone();
                            tempEnv.put("com.ibm.websphere.naming.name.syntax", "jndi");
                            host = JndiHelper.normalizeHostname(tempEnv, host);
                        } else {
                            host = JndiHelper.normalizeHostname(cd._env, host);
                        }
                    }
                    catch (Throwable t) {
                        RasUtil.logException(t, _tc, CLASS_NAME, "normalizeUrl", "2138", this);
                    }
                    buffer.append("iiop:");
                    buffer.append(iiopAddr.getMajor());
                    buffer.append('.');
                    buffer.append(iiopAddr.getMinor());
                    buffer.append('@');
                    buffer.append(Helpers.normalizeHostForUrl(host));
                    buffer.append(':');
                    buffer.append(iiopAddr.getPort());
                    more = objAddrs.hasNext();
                    if (!more) continue;
                    buffer.append(',');
                }
            } else {
                buffer.append("rir:");
            }
            String objectKey = objectUrl.getKeyString();
            if (objectKey == null || objectKey.length() == 0) {
                objectKey = "NameService";
            }
            buffer.append('/');
            buffer.append(objectKey);
            String urlString = buffer.toString();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "normalizeUrl", "urlString=" + urlString);
            }
            if (objectUrl.isCorbaname() && (name = objectUrl.getStringName()) != null && name.length() > 0) {
                cd._targetContextName = URLNameHelpers.decodeString(name);
            }
            cd._normalizedObjectUrl = ORB.createObjectURL((String)urlString);
            String normalizedUrlString = this.objectToString(cd._normalizedObjectUrl);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "normalizeUrl", "normalizedUrlString=" + normalizedUrlString);
            }
        }
        catch (ConfigurationException ce) {
            RasUtil.logException((Throwable)ce, _tc, CLASS_NAME, "normalizeUrl", "2187", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "normalizeUrl", ce.toString());
            }
            throw ce;
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "normalizeUrl", "2192", this);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizeUrl");
        }
    }

    private NamingException mapInitialReferenceFailure(CommonData cd, Exception rootException) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "mapInitialReferenceFailure", "rootException=" + rootException);
        }
        String cause = null;
        cause = cd._originalProviderUrl != null ? "A communication failure occurred while attempting to obtain an initial context with the provider URL: \"" + cd._originalProviderUrl + "\".  " + "Make sure that any bootstrap address information in the URL is correct and " + "that the target name server is running.  A bootstrap address with no port " + "specification defaults to port 2809.  Possible causes other than an incorrect " + "bootstrap address or unavailable name server include the network environment " + "and workstation network configuration." : "Could not obtain an initial context due to a communication failure. Since no provider URL was specified, the default provider URL of \"" + this.objectToString(cd._normalizedObjectUrl) + "\" was used.  " + "Make sure that any bootstrap address information in the URL is correct and " + "that the target name server is running.  Possible causes other than an " + "incorrect bootstrap address or unavailable name server include the network " + "environment and workstation network configuration.";
        NamingException ne = null;
        ne = rootException instanceof COMM_FAILURE ? new CommunicationException(cause) : new ServiceUnavailableException(cause);
        ne.initCause(rootException);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "mapInitialReferenceFailure", ne.toString());
        }
        return ne;
    }

    private static ContextID[] toContextIDs(String[] ctxIDStrings) {
        ContextID[] ctxIDs = null;
        if (ctxIDStrings != null) {
            ctxIDs = new ContextID[ctxIDStrings.length];
            for (int i = 0; i < ctxIDs.length; ++i) {
                ctxIDs[i] = new StringContextID(ctxIDStrings[i]);
            }
        } else {
            ctxIDs = new ContextID[]{};
        }
        return ctxIDs;
    }

    private static int toInt(String string) {
        int integer = -1;
        try {
            integer = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "toInt", "2266");
        }
        return integer;
    }

    private String objectToString(final java.lang.Object object) {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return object.toString();
            }
        });
        return string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[_securityAuthentication=");
        stringBuilder.append((java.lang.Object)this._securityAuthentication);
        stringBuilder.append(", _principal=");
        stringBuilder.append(this._principal);
        stringBuilder.append(", _credentials=");
        stringBuilder.append(StringUtils.maskPassword(this._credentials));
        stringBuilder.append(", _jndiOnly=");
        stringBuilder.append(this._jndiOnly);
        stringBuilder.append(", _securityEnabled=");
        stringBuilder.append(this._securityEnabled);
        stringBuilder.append(", _nameParser=");
        stringBuilder.append(this._nameParser);
        stringBuilder.append(", _rootParentCtxIDs=");
        stringBuilder.append(Arrays.toString(this._rootParentCtxIDs));
        stringBuilder.append(", _rootCtxID=");
        stringBuilder.append(this._rootCtxID);
        stringBuilder.append(", _rootFullPrimaryNameForCaching=");
        stringBuilder.append(this._rootFullPrimaryNameForCaching);
        stringBuilder.append(",_rootCacheBindingNames=");
        stringBuilder.append(Arrays.toString(this._rootCacheBindingNames));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/WsnInitCtxFactory.java, WAS.naming.client, WAS70.SERV1, q0834.18, ver. 1.73");
        }
        CLASS_NAME = WsnInitCtxFactory.class.getName();
    }

    static class CommonData {
        final Hashtable _env;
        String _wsnNSImplType = null;
        String _wsnNSRootType = null;
        String _wsnNSRootTypeProp = null;
        boolean _gotWsnNameService = false;
        String _wsnTreeRootIor = null;
        String _wsnNodeRootIor = null;
        String _wsnCellRootIor = null;
        String _wsnCellPersistentRootIor = null;
        String _wsnServerRootIor = null;
        String _wsnTreeRootName = null;
        String _wsnNodeRootName = null;
        String _wsnCellRootName = null;
        String _wsnCellPersistentRootName = null;
        String _wsnServerRootName = null;
        ContextID[] _wsnTreeRootCtxIDs = null;
        ContextID[] _wsnNodeRootCtxIDs = null;
        ContextID[] _wsnCellRootCtxIDs = null;
        ContextID[] _wsnCellPersistentRootCtxIDs = null;
        ContextID[] _wsnServerRootCtxIDs = null;
        ContextID _wsnTreeRootCtxID = null;
        ContextID _wsnNodeRootCtxID = null;
        ContextID _wsnCellRootCtxID = null;
        ContextID _wsnCellPersistentRootCtxID = null;
        ContextID _wsnServerRootCtxID = null;
        int _wsnIDLLevel = -1;
        public org.omg.CORBA.ORB _omgOrb = null;
        public String _originalProviderUrl = null;
        public String _normalizedUrlScheme = null;
        public ObjectURL _normalizedObjectUrl = null;
        public String _targetContextName = null;
        public boolean _cachingEnabled = false;
        public Cache _cache = null;
        public boolean _ldapSkipBootstrap = false;

        CommonData(Hashtable env) throws NamingException {
            String ldapConfig;
            this._env = env;
            this._wsnNSRootTypeProp = Helpers.getStringProperty(this._env, "com.ibm.websphere.naming.namespaceroot", false, "defaultroot");
            String implType = Helpers.getStringProperty(this._env, "com.ibm.ws.naming.implementation", false);
            if (implType != null && (implType.equals("WsnLdap") || implType.equals("WsnLdapCos")) && (ldapConfig = Helpers.getStringProperty(this._env, "com.ibm.ws.naming.ldap.config", false)) != null && ldapConfig.equals("local")) {
                this._ldapSkipBootstrap = true;
                this._wsnNSImplType = implType;
            }
        }

        public void clearWsnNSProperties() {
            this._gotWsnNameService = false;
            this._wsnTreeRootIor = null;
            this._wsnNodeRootIor = null;
            this._wsnCellRootIor = null;
            this._wsnCellPersistentRootIor = null;
            this._wsnServerRootIor = null;
            this._wsnTreeRootName = null;
            this._wsnNodeRootName = null;
            this._wsnCellRootName = null;
            this._wsnCellPersistentRootName = null;
            this._wsnServerRootName = null;
            this._wsnTreeRootCtxIDs = null;
            this._wsnNodeRootCtxIDs = null;
            this._wsnCellRootCtxIDs = null;
            this._wsnCellPersistentRootCtxIDs = null;
            this._wsnServerRootCtxIDs = null;
            this._wsnTreeRootCtxID = null;
            this._wsnNodeRootCtxID = null;
            this._wsnCellRootCtxID = null;
            this._wsnCellPersistentRootCtxID = null;
            this._wsnServerRootCtxID = null;
            this._wsnIDLLevel = -1;
        }
    }
}

