/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public class URLNameHelpers {
    private static final TraceComponent _tc = Tr.register(URLNameHelpers.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String RFC2396 = "-_.!~*'();/:?@&=+$,";
    private static final String[] hex;

    protected URLNameHelpers() {
    }

    public static String encodeCorbaURL(String inURL) {
        String escapedObjectKey;
        String escapedStringifiedName;
        int index;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "encodeCorbaURL()", "inURL = " + inURL);
        }
        if ((index = inURL.indexOf("#")) > -1) {
            escapedStringifiedName = URLNameHelpers.encodeString(inURL.substring(index + 1), false);
            inURL = inURL.substring(0, index);
        } else {
            escapedStringifiedName = null;
        }
        index = inURL.indexOf("/");
        if (index > -1) {
            escapedObjectKey = URLNameHelpers.encodeString(inURL.substring(index + 1), false);
            inURL = inURL.substring(0, index);
        } else {
            escapedObjectKey = null;
        }
        StringBuffer buff = new StringBuffer(inURL);
        if (escapedObjectKey != null) {
            buff.append('/');
            buff.append(escapedObjectKey);
        }
        if (escapedStringifiedName != null) {
            buff.append('#');
            buff.append(escapedStringifiedName);
        }
        String escapedURL = buff.toString();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "encodeCorbaURL()", "escapedURL = " + escapedURL);
        }
        return escapedURL;
    }

    public static String encodeString(String inString, boolean interpretPercentSignLiterally) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "encodeString()", new String[]{"inString = " + inString, "interpretPercentSignLiterally = " + interpretPercentSignLiterally});
        }
        String tmpString = inString;
        if (!interpretPercentSignLiterally) {
            tmpString = URLNameHelpers.decodeRFC2396(inString);
        }
        String escapedString = URLNameHelpers.encodeRFC2396(tmpString);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "encodeString()", "escapedString = " + escapedString);
        }
        return escapedString;
    }

    public static String decodeString(String escaped) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "decodeString()", "escaped = " + escaped);
        }
        String unescaped = URLNameHelpers.decodeRFC2396(escaped);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "decodeString()", "unescaped= " + unescaped);
        }
        return unescaped;
    }

    private static String decodeRFC2396(String escaped) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "decodeRFC2396()", "input=" + escaped);
        }
        if (escaped == null) {
            return null;
        }
        StringBuffer unescaped = new StringBuffer();
        int l = escaped.length();
        int ch = -1;
        int sumb = 0;
        int more = -1;
        for (int i = 0; i < l; ++i) {
            int b;
            char c = escaped.charAt(i);
            ch = c;
            switch (c) {
                case '%': {
                    if (i + 2 >= escaped.length()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Incomplete escape sequence in URL.", escaped);
                        }
                        throw new IllegalArgumentException("Incomplete escape sequence in URL: " + escaped);
                    }
                    int hb = (Character.isDigit((char)(ch = (int)escaped.charAt(++i))) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = escaped.charAt(++i);
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    b = hb << 4 | lb;
                    break;
                }
                case '+': {
                    b = 32;
                    break;
                }
                default: {
                    b = ch;
                }
            }
            if ((b & 0xC0) == 128) {
                sumb = sumb << 6 | b & 0x3F;
                if (--more != 0) continue;
                unescaped.append((char)sumb);
                continue;
            }
            if ((b & 0x80) == 0) {
                unescaped.append((char)b);
                continue;
            }
            if ((b & 0xE0) == 192) {
                sumb = b & 0x1F;
                more = 1;
                continue;
            }
            if ((b & 0xF0) == 224) {
                sumb = b & 0xF;
                more = 2;
                continue;
            }
            if ((b & 0xF8) == 240) {
                sumb = b & 7;
                more = 3;
                continue;
            }
            if ((b & 0xFC) == 248) {
                sumb = b & 3;
                more = 4;
                continue;
            }
            sumb = b & 1;
            more = 5;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "decodeRFC2396()", "output=" + unescaped.toString());
        }
        return unescaped.toString();
    }

    private static String encodeRFC2396(String unescaped) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "encodeRFC2396()", "input=" + unescaped);
        }
        StringBuffer escaped = new StringBuffer();
        int len = unescaped.length();
        for (int i = 0; i < len; ++i) {
            char ch = unescaped.charAt(i);
            if ('A' <= ch && ch <= 'Z') {
                escaped.append(ch);
                continue;
            }
            if ('a' <= ch && ch <= 'z') {
                escaped.append(ch);
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                escaped.append(ch);
                continue;
            }
            if (ch == ' ') {
                escaped.append('+');
                continue;
            }
            if (RFC2396.indexOf(ch) >= 0) {
                escaped.append(ch);
                continue;
            }
            if (ch <= '\u007f') {
                escaped.append(hex[ch]);
                continue;
            }
            if (ch <= '\u07ff') {
                escaped.append(hex[0xC0 | ch >> 6]);
                escaped.append(hex[0x80 | ch & 0x3F]);
                continue;
            }
            escaped.append(hex[0xE0 | ch >> 12]);
            escaped.append(hex[0x80 | ch >> 6 & 0x3F]);
            escaped.append(hex[0x80 | ch & 0x3F]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "encodeRFC2396()", "output=" + escaped);
        }
        return escaped.toString();
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/URLNameHelpers.java, WAS.naming.client, WAS70.SERV1, q0834.18, ver. 1.3");
        }
        hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2a", "%2b", "%2c", "%2d", "%2e", "%2f", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3a", "%3b", "%3c", "%3d", "%3e", "%3f", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4a", "%4b", "%4c", "%4d", "%4e", "%4f", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5a", "%5b", "%5c", "%5d", "%5e", "%5f", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6a", "%6b", "%6c", "%6d", "%6e", "%6f", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7a", "%7b", "%7c", "%7d", "%7e", "%7f", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%a7", "%a8", "%a9", "%aa", "%ab", "%ac", "%ad", "%ae", "%af", "%b0", "%b1", "%b2", "%b3", "%b4", "%b5", "%b6", "%b7", "%b8", "%b9", "%ba", "%bb", "%bc", "%bd", "%be", "%bf", "%c0", "%c1", "%c2", "%c3", "%c4", "%c5", "%c6", "%c7", "%c8", "%c9", "%ca", "%cb", "%cc", "%cd", "%ce", "%cf", "%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", "%d8", "%d9", "%da", "%db", "%dc", "%dd", "%de", "%df", "%e0", "%e1", "%e2", "%e3", "%e4", "%e5", "%e6", "%e7", "%e8", "%e9", "%ea", "%eb", "%ec", "%ed", "%ee", "%ef", "%f0", "%f1", "%f2", "%f3", "%f4", "%f5", "%f6", "%f7", "%f8", "%f9", "%fa", "%fb", "%fc", "%fd", "%fe", "%ff"};
    }
}

