/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.uow.UOWManager;
import com.ibm.ws.uow.UOWManagerFactory;
import com.ibm.ws.uow.UOWToken;

public final class TransactionUtil {
    private static final TraceComponent _tc = Tr.register(TransactionUtil.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;

    public static TransactionWrapper suspend() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "suspend");
        }
        TransactionWrapper wrapper = new TransactionWrapper();
        try {
            UOWManager manager = UOWManagerFactory.getUOWManager();
            if (manager != null) {
                wrapper.setManager(manager);
                UOWToken token = manager.suspendAll();
                wrapper.setToken(token);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "suspend", "current transaction suspended");
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "suspend", "no transaction to suspend");
            }
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "suspend", "84");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "suspend");
        }
        return wrapper;
    }

    public static void resume(TransactionWrapper wrapper) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "resume", "wrapper=" + wrapper);
        }
        if (wrapper != null) {
            UOWManager manager = wrapper.getManager();
            UOWToken token = wrapper.getToken();
            if (manager != null && token != null) {
                try {
                    manager.resumeAll(token);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "resume", "resumed suspended transaction");
                    }
                }
                catch (Throwable t) {
                    RasUtil.logException(t, _tc, CLASS_NAME, "resume", "115");
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "resume", "no transaction to resume");
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "resume", "transaction wrapper is null");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "resume");
        }
    }

    private TransactionUtil() {
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/TransactionUtil.java, WAS.naming.client, WAS70.SERV1, q0834.18, ver. 1.5");
        }
        CLASS_NAME = TransactionUtil.class.getName();
    }

    public static class TransactionWrapper {
        private UOWManager _manager = null;
        private UOWToken _token = null;

        public TransactionWrapper() {
        }

        public TransactionWrapper(UOWManager manager, UOWToken token) {
            this._manager = manager;
            this._token = token;
        }

        public UOWManager getManager() {
            return this._manager;
        }

        void setManager(UOWManager manager) {
            this._manager = manager;
        }

        public UOWToken getToken() {
            return this._token;
        }

        void setToken(UOWToken token) {
            this._token = token;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append(this.getClass().getName());
            stringBuilder.append('@');
            stringBuilder.append(Integer.toHexString(this.hashCode()));
            stringBuilder.append('[');
            stringBuilder.append("_manager=");
            stringBuilder.append(this._manager);
            stringBuilder.append(", _token=");
            stringBuilder.append(this._token);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

