/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.WsnOptimizedNaming.ReferenceProperty;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.RasUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.Object;

public final class ReferenceData {
    private static final TraceComponent _tc = Tr.register(ReferenceData.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static final String ENCODING_UTF8 = "UTF-8";
    public static final String FACTORY_CLASS_NAME = "factoryClassName";
    public static final String EXEC_FACTORY_IN_SR = "execFactoryInSR";
    public static final String OBJECT_CLASS_NAME = "className";
    public static final String HOSTING_NODE = "hostingNode";
    public static final String HOSTING_SERVER = "hostingServer";
    public static final String CACHEABLE = "cacheable";
    public static final String STRING_HEADER = "R-E~F!E#R$E%N^C*E_D(A)T+A:";
    private Properties _properties = new Properties();
    private Object _cachedCorbaObject = null;
    private Any _cachedJavaObject = null;

    public ReferenceData(String factoryClassName, String referenceObjectClassName, boolean cacheable, Properties additionalProperties) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", new String[]{"factoryClassName=" + factoryClassName, "referenceObjectClassName=" + referenceObjectClassName, "cacheable=" + cacheable, "additionalProperties=" + additionalProperties});
        }
        this.setFactoryClassName(factoryClassName);
        this.setReferenceObjectClassName(referenceObjectClassName);
        this.setCacheable(cacheable);
        if (additionalProperties != null) {
            this._properties.putAll((Map<?, ?>)additionalProperties);
        }
        this.validate();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>");
        }
    }

    public ReferenceData(ReferenceProperty[] properties) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", "properties=" + Arrays.toString(properties));
        }
        for (int i = 0; i < properties.length; ++i) {
            ReferenceProperty property = properties[i];
            if (property == null) {
                NamingException ne = new NamingException("Null property at index " + i + " in array " + Arrays.toString(properties));
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "<init>", ne);
                }
                throw ne;
            }
            if (property.key == null) {
                NamingException ne = new NamingException("Null property key at index " + i + " in array " + Arrays.toString(properties));
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "<init>", ne);
                }
                throw ne;
            }
            if (property.value == null) {
                NamingException ne = new NamingException("Null property value at index " + i + " in array " + Arrays.toString(properties));
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "<init>", ne);
                }
                throw ne;
            }
            this._properties.setProperty(property.key, property.value);
        }
        this.validate();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>");
        }
    }

    public ReferenceData(String referenceDataString) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", "referenceDataString=" + referenceDataString);
        }
        this._properties = this.parseReferenceDataString(referenceDataString);
        this.validate();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>");
        }
    }

    public void setFactoryClassName(String factoryClassName) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setFactoryClassName", "factoryClassName=" + factoryClassName);
        }
        this._properties.setProperty(FACTORY_CLASS_NAME, factoryClassName);
    }

    public String getFactoryClassName() throws NamingException {
        String factoryClassName = this._properties.getProperty(FACTORY_CLASS_NAME);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getFactoryClassName", factoryClassName);
        }
        return factoryClassName;
    }

    public void setFactoryIsExecutedInSR(boolean execFactoryInSR) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setFactoryIsExecutedInSR", "execFactoryInSR=" + execFactoryInSR);
        }
        this._properties.setProperty(EXEC_FACTORY_IN_SR, Boolean.toString(execFactoryInSR));
    }

    public boolean isFactoryExecutedInSR() throws NamingException {
        boolean execFactoryInSR = Boolean.parseBoolean(this._properties.getProperty(EXEC_FACTORY_IN_SR));
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "isFactoryExecutedInSR", Boolean.toString(execFactoryInSR));
        }
        return execFactoryInSR;
    }

    public void setReferenceObjectClassName(String className) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setReferenceObjectClassName", "className=" + className);
        }
        this._properties.setProperty(OBJECT_CLASS_NAME, className);
    }

    public String getReferenceObjectClassName() throws NamingException {
        String className = this._properties.getProperty(OBJECT_CLASS_NAME);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getReferenceObjectClassName", className);
        }
        return className;
    }

    public void setCacheable(boolean cacheable) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setCacheable", "cacheable=" + cacheable);
        }
        this._properties.setProperty(CACHEABLE, Boolean.toString(cacheable));
    }

    public boolean isCacheable() {
        boolean cacheable = Boolean.parseBoolean(this._properties.getProperty(CACHEABLE));
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "isCacheable", Boolean.toString(cacheable));
        }
        return cacheable;
    }

    public void setHostingNode(String nodeName) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setHostingNode", "nodeName=" + nodeName);
        }
        if (nodeName != null) {
            this._properties.setProperty(HOSTING_NODE, nodeName);
        } else {
            this._properties.remove(HOSTING_NODE);
        }
    }

    public String getHostingNode() throws NamingException {
        String nodeName = this._properties.getProperty(HOSTING_NODE);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getHostingNode", "nodeName=" + nodeName);
        }
        return nodeName;
    }

    public void setHostingServer(String serverName) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setHostingServer", "serverName=" + serverName);
        }
        if (serverName == null) {
            NamingException ne = new NamingException("Server name cannot be null");
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "setHostingServer", ne);
            }
            throw ne;
        }
        this._properties.setProperty(HOSTING_SERVER, serverName);
    }

    public String getHostingServer() throws NamingException {
        String serverName = this._properties.getProperty(HOSTING_SERVER);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getHostingServer", "serverName=" + serverName);
        }
        return serverName;
    }

    public void setProperty(String propertyName, String propertyValue) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setProperty", new String[]{"propertyName=" + propertyName, "propertyValue=" + propertyValue});
        }
        if (propertyName == null) {
            NamingException ne = new NamingException("Property name cannot be null");
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "setProperty", ne);
            }
            throw ne;
        }
        if (propertyValue == null) {
            NamingException ne = new NamingException("Property value cannot be null");
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "setProperty", ne);
            }
            throw ne;
        }
        this._properties.setProperty(propertyName, propertyValue);
    }

    public String getProperty(String propertyName) throws NamingException {
        if (propertyName == null) {
            throw new NamingException("Property name cannot be null");
        }
        String propertyValue = this._properties.getProperty(propertyName);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getProperty", new String[]{"propertyName=" + propertyName, "propertyValue=" + propertyValue});
        }
        return propertyValue;
    }

    public Properties getProperties() {
        return this._properties;
    }

    public void cacheObject(Object corbaObjToCache, Any javaObjToCache) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "cacheObject", new String[]{"corbaObjToCache=" + corbaObjToCache, "javaObjToCache=" + javaObjToCache});
        }
        this._cachedCorbaObject = corbaObjToCache;
        this._cachedJavaObject = javaObjToCache;
    }

    public Object getCachedObject(AnyHolder javaObjHolder) {
        javaObjHolder.value = this._cachedJavaObject;
        return this._cachedCorbaObject;
    }

    public ReferenceProperty[] toReferenceProperties() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "toReferenceProperties");
        }
        this.validate();
        ArrayList<ReferenceProperty> list = new ArrayList<ReferenceProperty>(this._properties.size());
        for (Map.Entry<java.lang.Object, java.lang.Object> entry : this._properties.entrySet()) {
            ReferenceProperty referenceProperty = new ReferenceProperty((String)entry.getKey(), (String)entry.getValue());
            list.add(referenceProperty);
        }
        java.lang.Object[] referenceProperties = list.toArray(new ReferenceProperty[list.size()]);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "toReferenceProperties", Arrays.toString(referenceProperties));
        }
        return referenceProperties;
    }

    public void validate() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "validate");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "validate", "_properties=" + this._properties);
        }
        if (this._properties.getProperty(FACTORY_CLASS_NAME) == null) {
            NamingException ne = new NamingException("Factory class name property not set");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "validate", ne);
            }
            throw ne;
        }
        if (this._properties.getProperty(OBJECT_CLASS_NAME) == null) {
            NamingException ne = new NamingException("Object class name property not set");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "validate", ne);
            }
            throw ne;
        }
        String execFactoryInSR = this._properties.getProperty(EXEC_FACTORY_IN_SR);
        if (execFactoryInSR != null && !execFactoryInSR.equalsIgnoreCase(Boolean.TRUE.toString()) && !execFactoryInSR.equalsIgnoreCase(Boolean.FALSE.toString())) {
            NamingException ne = new NamingException("Invalid value \"" + execFactoryInSR + "\" for property \"" + EXEC_FACTORY_IN_SR + "\"");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "validate", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "validate");
        }
    }

    public String toReferenceDataString() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "toReferenceDataString");
        }
        StringBuilder stringBuilder = new StringBuilder(STRING_HEADER);
        stringBuilder.append('{');
        for (Map.Entry<java.lang.Object, java.lang.Object> entry : this._properties.entrySet()) {
            stringBuilder.append("{{");
            stringBuilder.append(this.encodeString((String)entry.getKey()));
            stringBuilder.append("}{");
            stringBuilder.append(this.encodeString((String)entry.getValue()));
            stringBuilder.append("}}");
        }
        stringBuilder.append('}');
        String referenceDataString = stringBuilder.toString();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "toReferenceDataString", referenceDataString);
        }
        return referenceDataString;
    }

    private Properties parseReferenceDataString(String referenceDataString) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseReferenceDataString", "referenceDataString=" + referenceDataString);
        }
        Properties properties = new Properties();
        if (referenceDataString == null) {
            NamingException ne = new NamingException("Reference data string cannot be null");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseReferenceDataString", ne);
            }
            throw ne;
        }
        if (!referenceDataString.startsWith(STRING_HEADER)) {
            NamingException ne = new NamingException("Reference data string \"" + referenceDataString + "\" is invalid; header not found");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseReferenceDataString", ne);
            }
            throw ne;
        }
        char[] referenceDataCharArray = referenceDataString.toCharArray();
        int index = STRING_HEADER.length();
        if (index >= referenceDataCharArray.length) {
            NamingException ne = new NamingException("Reference data string \"" + referenceDataString + "\" is invalid; no data follows header");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseReferenceDataString", ne);
            }
            throw ne;
        }
        if (referenceDataCharArray[index] != '{') {
            NamingException ne = new NamingException("Reference data string \"" + referenceDataString + "\" is invalid; expected '{' character at index " + index);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseReferenceDataString", ne);
            }
            throw ne;
        }
        ++index;
        while (index < referenceDataCharArray.length && referenceDataCharArray[index] != '}') {
            if (referenceDataCharArray[index] != '{') {
                NamingException ne = new NamingException("Reference data string \"" + referenceDataString + "\" is invalid; expected '{' character at index " + index);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "parseReferenceDataString", ne);
                }
                throw ne;
            }
            int endIndex = this.parseString(referenceDataCharArray, ++index);
            String key = referenceDataString.substring(index + 1, endIndex);
            index = endIndex + 1;
            endIndex = this.parseString(referenceDataCharArray, index);
            String value = referenceDataString.substring(index + 1, endIndex);
            index = endIndex + 1;
            String propertyName = this.decodeString(key);
            String propertyValue = this.decodeString(value);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "parseReferenceDataString", "propertyName=" + propertyName + ", propertyValue=" + propertyValue);
            }
            properties.setProperty(propertyName, propertyValue);
            if (index < referenceDataCharArray.length && referenceDataCharArray[index] != '}') {
                NamingException ne = new NamingException("Reference data string \"" + referenceDataString + "\" is invalid; expected '}' character at index " + index);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "parseReferenceDataString", ne);
                }
                throw ne;
            }
            ++index;
        }
        if (index >= referenceDataCharArray.length) {
            NamingException ne = new NamingException("Reference data string \"" + referenceDataString + "\" is invalid; unexpected end of string");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseReferenceDataString", ne);
            }
            throw ne;
        }
        if (referenceDataCharArray[index] != '}') {
            NamingException ne = new NamingException("Reference data string \"" + referenceDataString + "\" is invalid; expected '}' character at index " + index);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseReferenceDataString", ne);
            }
            throw ne;
        }
        if (index < referenceDataCharArray.length - 1) {
            NamingException ne = new NamingException("Reference data string \"" + referenceDataString + "\" is invalid; expected end of string after index " + index);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseReferenceDataString", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseReferenceDataString", properties);
        }
        return properties;
    }

    private int parseString(char[] referenceDataCharArray, int index) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseString", "index=" + index);
        }
        if (index < referenceDataCharArray.length && referenceDataCharArray[index] != '{') {
            NamingException ne = new NamingException("Reference data string \"" + String.valueOf(referenceDataCharArray) + "\" is invalid; expected '{' character at index " + index);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseString", ne);
            }
            throw ne;
        }
        ++index;
        while (index < referenceDataCharArray.length && referenceDataCharArray[index] != '}') {
            ++index;
        }
        if (index >= referenceDataCharArray.length) {
            NamingException ne = new NamingException("Reference data string \"" + String.valueOf(referenceDataCharArray) + "\" is invalid; unexpected end of string");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "parseString", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseString", Integer.toString(index));
        }
        return index;
    }

    private String encodeString(String string) {
        String encodedString;
        block2: {
            encodedString = null;
            try {
                encodedString = URLEncoder.encode(string, ENCODING_UTF8);
            }
            catch (UnsupportedEncodingException uee) {
                RasUtil.logException((Throwable)uee, _tc, CLASS_NAME, "encodeString", "877", this);
                if ($assertionsDisabled) break block2;
                throw new AssertionError((java.lang.Object)("error encoding string \"" + string + "\": " + uee));
            }
        }
        return encodedString;
    }

    private String decodeString(String string) throws NamingException {
        String decodedString = null;
        try {
            decodedString = URLDecoder.decode(string, ENCODING_UTF8);
        }
        catch (IllegalArgumentException iae) {
            RasUtil.logException((Throwable)iae, _tc, CLASS_NAME, "decodeString", "894", this);
            NamingException ne = new NamingException("Error decoding string \"" + string + "\"");
            ne.initCause(iae);
            throw ne;
        }
        catch (UnsupportedEncodingException uee) {
            RasUtil.logException((Throwable)uee, _tc, CLASS_NAME, "decodeString", "899", this);
            NamingException ne = new NamingException("Error decoding string \"" + string + "\"");
            ne.initCause(uee);
            throw ne;
        }
        return decodedString;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[_properties=");
        stringBuilder.append(this._properties);
        stringBuilder.append(", _cachedCorbaObject=");
        stringBuilder.append(this._cachedCorbaObject);
        stringBuilder.append(", _cachedJavaObject=");
        stringBuilder.append(this._cachedJavaObject);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/ws/naming/util/ReferenceData.java, WAS.naming, WAS70.SERV1, q0834.18, ver. 1.4.1.4");
        }
        CLASS_NAME = ReferenceData.class.getName();
    }
}

