/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public final class RasUtil {
    private static final TraceComponent _tc = Tr.register(RasUtil.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final boolean _debug;
    private static final Map<Throwable, Long> map;

    public static void logException(Throwable throwable, TraceComponent tc, String className, String method2, String probeId) {
        RasUtil.logException(throwable, tc, className, method2, probeId, null, null, false);
    }

    public static void logException(Throwable throwable, TraceComponent tc, String className, String method2, String probeId, Object[] objectArray) {
        RasUtil.logException(throwable, tc, className, method2, probeId, null, objectArray, false);
    }

    public static void logException(Throwable throwable, TraceComponent tc, String className, String method2, String probeId, Object callerThis) {
        RasUtil.logException(throwable, tc, className, method2, probeId, callerThis, null, false);
    }

    public static void logException(Throwable throwable, TraceComponent tc, String className, String method2, String probeId, Object callerThis, Object[] objectArray) {
        RasUtil.logException(throwable, tc, className, method2, probeId, callerThis, objectArray, false);
    }

    public static void logException(Throwable throwable, TraceComponent tc, String className, String method2, String probeId, Object callerThis, Object[] objectArray, boolean force) {
        if (!force && (throwable instanceof NotFound || throwable instanceof NameNotFoundException || throwable instanceof AlreadyBound || throwable instanceof NameAlreadyBoundException || map.containsKey(throwable))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, method2, _debug ? throwable : throwable.toString());
            }
        } else {
            String sourceId = className + '.' + method2;
            Manager.Ffdc.log(throwable, RasUtil.class, sourceId, probeId, callerThis, objectArray);
            if (tc.isEventEnabled()) {
                Tr.event(tc, method2, new Object[]{"FFDC: sourceId=" + sourceId + ", probeId=" + probeId, throwable});
            }
            map.put(throwable, System.currentTimeMillis());
        }
        if (throwable instanceof UnknownException) {
            UnknownException corbaUnknownException = (UnknownException)throwable;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, method2, new Object[]{"Root cause of org.omg.CORBA.portable.UnknownException:", corbaUnknownException.originalEx});
            }
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/ws/naming/util/RasUtil.java, WAS.naming, WAS70.SERV1, q0834.18, ver. 1.2");
        }
        _debug = Boolean.getBoolean("com.ibm.ws.naming.debug");
        map = Collections.synchronizedMap(new WeakHashMap());
    }
}

