/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.websphere.naming.WsnBatchCompleteResults;
import com.ibm.websphere.naming.WsnBatchModeContext;
import com.ibm.websphere.naming.WsnBatchResult;
import com.ibm.websphere.naming.WsnOptimizedJndiContext;
import com.ibm.ws.naming.jbatch.BatchModeNotSupported;
import com.ibm.ws.naming.jbatch.WsnBatchModeCNContext;
import com.ibm.ws.naming.jndicos.CNContext;
import com.ibm.ws.naming.util.CommonHelpers;
import com.ibm.ws.naming.util.NameFormatHelper;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.ReferenceData;
import java.util.Enumeration;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class JndiHelperExt
extends JndiHelper {
    private static final TraceComponent _tc = Tr.register(JndiHelperExt.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;

    private JndiHelperExt() {
    }

    public static void recursiveBindIOR(Context startingContext, Name name, String iorString, boolean isContext, String className) throws NamingException {
        JndiHelperExt.recursiveBindIOR(JndiHelper.Operation.BIND, startingContext, name, iorString, isContext, className);
    }

    public static void recursiveBindIOR(Context startingContext, String name, String iorString, boolean isContext, String className) throws NamingException {
        NameParser parser2 = startingContext.getNameParser("");
        Name jndiName = parser2.parse(name);
        JndiHelperExt.recursiveBindIOR(startingContext, jndiName, iorString, isContext, className);
    }

    public static void recursiveRebindIOR(Context startingContext, Name name, String iorString, boolean isContext, String className) throws NamingException {
        JndiHelperExt.recursiveBindIOR(JndiHelper.Operation.REBIND, startingContext, name, iorString, isContext, className);
    }

    public static void recursiveRebindIOR(Context startingContext, String name, String iorString, boolean isContext, String className) throws NamingException {
        NameParser parser2 = startingContext.getNameParser("");
        Name jndiName = parser2.parse(name);
        JndiHelperExt.recursiveBindIOR(startingContext, jndiName, iorString, isContext, className);
    }

    public static void recursiveBindReference(Context startingContext, Name name, ReferenceData referenceData) throws NamingException {
        JndiHelperExt.recursiveBindReference(JndiHelper.Operation.BIND, startingContext, name, referenceData);
    }

    public static void recursiveBindReference(Context startingContext, String name, ReferenceData referenceData) throws NamingException {
        NameParser parser2 = startingContext.getNameParser("");
        Name jndiName = parser2.parse(name);
        JndiHelperExt.recursiveBindReference(startingContext, jndiName, referenceData);
    }

    public static void recursiveRebindReference(Context startingContext, Name name, ReferenceData referenceData) throws NamingException {
        JndiHelperExt.recursiveBindReference(JndiHelper.Operation.BIND, startingContext, name, referenceData);
    }

    public static void recursiveRebindReference(Context startingContext, String name, ReferenceData referenceData) throws NamingException {
        NameParser parser2 = startingContext.getNameParser("");
        Name jndiName = parser2.parse(name);
        JndiHelperExt.recursiveRebindReference(startingContext, jndiName, referenceData);
    }

    private static void recursiveBindIOR(JndiHelper.Operation operation, Context startingContext, Name name, String iorString, boolean isContext, String className) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "recursiveBindIOR", new String[]{"operation=" + (Object)((Object)operation), "startingContext=" + startingContext, "name=" + name, "iorString=" + iorString, "isContext=" + isContext, "className=" + className});
        }
        boolean useBatch = false;
        WsnBatchModeCNContext batchCNCtx = null;
        startingContext = (Context)CommonHelpers.extractCtxImplFromInitCtx(startingContext);
        try {
            Context urlCtx = CommonHelpers.getContextIfUrlName(name, startingContext.getEnvironment());
            if (urlCtx != null) {
                startingContext = urlCtx;
                NameParser parser2 = urlCtx.getNameParser("");
                String scheme = NameFormatHelper.getUrlScheme(name);
                String nameString = name.toString();
                nameString = nameString.substring(scheme.length() + 1);
                name = parser2.parse(nameString);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "recursiveBindIOR", "URL name: new starting context=" + startingContext.getNameInNamespace() + ", name=" + nameString);
                }
            }
        }
        catch (NamingException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "recursiveBindIOR", "384");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "recursiveBindIOR", e.toString());
            }
            throw e;
        }
        if (startingContext instanceof WsnBatchModeCNContext) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "recursiveBindIOR", "starting context instance of WsnBatchModeCNContext");
            }
            batchCNCtx = (WsnBatchModeCNContext)startingContext;
            startingContext = batchCNCtx.getNonBatchModeContext();
        }
        if (startingContext instanceof WsnOptimizedJndiContext && !((WsnOptimizedJndiContext)((Object)startingContext)).isLocal()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "recursiveBindIOR", "context is not local");
            }
            useBatch = true;
            if (batchCNCtx == null) {
                try {
                    WsnBatchModeContext batchCtx = ((WsnOptimizedJndiContext)((Object)startingContext)).getBatchModeContext();
                    if (batchCtx instanceof WsnBatchModeCNContext) {
                        batchCNCtx = (WsnBatchModeCNContext)batchCtx;
                    } else {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "recursiveBindIOR", "batch context is not extended - cannot batch");
                        }
                        useBatch = false;
                    }
                }
                catch (BatchModeNotSupported e) {
                    RasUtil.logException(e, _tc, CLASS_NAME, "recursiveBindIOR", "429");
                    batchCNCtx = null;
                    useBatch = false;
                }
            }
        }
        Context retCtx = null;
        Name namePrefix = name.getPrefix(name.size() - 1);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "recursiveBindIOR", "useBatch=" + useBatch);
        }
        if (useBatch) {
            WsnBatchResult result;
            if (namePrefix.size() > 0) {
                JndiHelperExt.batchCreateSubcontextsDriver(batchCNCtx, namePrefix);
            }
            if (operation == JndiHelper.Operation.BIND) {
                batchCNCtx.bindIOR(name, iorString, isContext, className);
            } else {
                batchCNCtx.rebindIOR(name, iorString, isContext, className);
            }
            WsnBatchCompleteResults bcr = batchCNCtx.executeBatchedOperations();
            Enumeration<WsnBatchResult> vEnum = bcr.getResultEnumeration();
            if (namePrefix.size() > 0) {
                retCtx = JndiHelperExt.getSubcontextFromBatchResults(startingContext, vEnum, namePrefix.size());
            }
            if (!(result = vEnum.nextElement()).getResult()) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "recursiveBindIOR", "Throwing exception: " + result.getException());
                }
                throw result.getException();
            }
        } else {
            CNContext cnCtx = null;
            if (!(startingContext instanceof CNContext)) {
                OperationNotSupportedException ne = new OperationNotSupportedException("IOR bindings not supported by starting context.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "recursiveBindIOR", ne);
                }
                throw ne;
            }
            cnCtx = (CNContext)startingContext;
            if (namePrefix.size() > 0) {
                retCtx = JndiHelperExt.createSubcontextsDriver(startingContext, namePrefix);
            }
            if (operation == JndiHelper.Operation.BIND) {
                cnCtx.bindIOR(name, iorString, isContext, className);
            } else {
                cnCtx.rebindIOR(name, iorString, isContext, className);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "recursiveBindIOR");
        }
    }

    private static void recursiveBindReference(JndiHelper.Operation operation, Context startingContext, Name name, ReferenceData referenceData) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "recursiveBindReference", new String[]{"operation=" + (Object)((Object)operation), "startingContext=" + startingContext, "name=" + name, "referenceData=" + referenceData});
        }
        boolean useBatch = false;
        WsnBatchModeCNContext batchCNCtx = null;
        startingContext = (Context)CommonHelpers.extractCtxImplFromInitCtx(startingContext);
        try {
            Context urlCtx = CommonHelpers.getContextIfUrlName(name, startingContext.getEnvironment());
            if (urlCtx != null) {
                startingContext = urlCtx;
                NameParser parser2 = urlCtx.getNameParser("");
                String scheme = NameFormatHelper.getUrlScheme(name);
                String nameString = name.toString();
                nameString = nameString.substring(scheme.length() + 1);
                name = parser2.parse(nameString);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "recursiveBindReference", "URL name: new starting context=" + startingContext.getNameInNamespace() + ", name=" + nameString);
                }
            }
        }
        catch (NamingException e) {
            RasUtil.logException(e, _tc, CLASS_NAME, "recursiveBindReference", "548");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "recursiveBindReference", e.toString());
            }
            throw e;
        }
        if (startingContext instanceof WsnBatchModeCNContext) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "recursiveBindReference", "starting context instance of WsnBatchModeCNContext");
            }
            batchCNCtx = (WsnBatchModeCNContext)startingContext;
            startingContext = batchCNCtx.getNonBatchModeContext();
        }
        if (startingContext instanceof WsnOptimizedJndiContext && !((WsnOptimizedJndiContext)((Object)startingContext)).isLocal()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "recursiveBindReference", "context is not local");
            }
            useBatch = true;
            if (batchCNCtx == null) {
                try {
                    WsnBatchModeContext batchCtx = ((WsnOptimizedJndiContext)((Object)startingContext)).getBatchModeContext();
                    if (batchCtx instanceof WsnBatchModeCNContext) {
                        batchCNCtx = (WsnBatchModeCNContext)batchCtx;
                    } else {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "recursiveBindReference", "batch context is not extended - cannot batch");
                        }
                        useBatch = false;
                    }
                }
                catch (BatchModeNotSupported e) {
                    RasUtil.logException(e, _tc, CLASS_NAME, "recursiveBindReference", "594");
                    batchCNCtx = null;
                    useBatch = false;
                }
            }
        }
        Context retCtx = null;
        Name namePrefix = name.getPrefix(name.size() - 1);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "recursiveBindReference", "useBatch=" + useBatch);
        }
        if (useBatch) {
            WsnBatchResult result;
            if (namePrefix.size() > 0) {
                JndiHelperExt.batchCreateSubcontextsDriver(batchCNCtx, namePrefix);
            }
            if (operation == JndiHelper.Operation.BIND) {
                batchCNCtx.bindReference(name, referenceData);
            } else {
                batchCNCtx.rebindReference(name, referenceData);
            }
            WsnBatchCompleteResults bcr = batchCNCtx.executeBatchedOperations();
            Enumeration<WsnBatchResult> vEnum = bcr.getResultEnumeration();
            if (namePrefix.size() > 0) {
                retCtx = JndiHelperExt.getSubcontextFromBatchResults(startingContext, vEnum, namePrefix.size());
            }
            if (!(result = vEnum.nextElement()).getResult()) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "recursiveBindReference", "Throwing exception: " + result.getException());
                }
                throw result.getException();
            }
        } else {
            CNContext cnCtx = null;
            if (!(startingContext instanceof CNContext)) {
                OperationNotSupportedException ne = new OperationNotSupportedException("Reference bindings not supported by starting context.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "recursiveBindReference", ne);
                }
                throw ne;
            }
            cnCtx = (CNContext)startingContext;
            if (namePrefix.size() > 0) {
                retCtx = JndiHelperExt.createSubcontextsDriver(startingContext, namePrefix);
            }
            if (operation == JndiHelper.Operation.BIND) {
                cnCtx.bindReference(name, referenceData);
            } else {
                cnCtx.rebindReference(name, referenceData);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "recursiveBindReference");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/ws/naming/util/JndiHelperExt.java, WAS.naming, WAS70.SERV1, q0834.18, ver. 1.6");
        }
        CLASS_NAME = JndiHelperExt.class.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        REFERENCE,
        IOR;

    }
}

