/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.NameFormatHelper;
import com.ibm.ws.naming.util.RasUtil;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public abstract class CorbaURLContext
implements Context {
    private static final TraceComponent _tc = Tr.register(CorbaURLContext.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    protected static Hashtable _insEnv;
    protected static Hashtable _jndiEnv;
    protected Hashtable _env = null;
    protected String _fullName = null;
    protected String _providerUrl = null;
    protected String _stringifiedName = null;
    protected Context _initCtx = null;
    private static final String METHOD_setupForLookup = "setupForLookup()";
    private static final String METHOD_setupForOtherNamingOperations = "setupForOtherNamingOperations()";
    private static final String METHOD_getInitialContext = "getInitialContext()";
    private static final String METHOD_bindS = "bind(String, Object)";
    private static final String METHOD_rebind = "rebind(String, Object)";
    private static final String METHOD_unbind = "unbind(String, Object)";
    private static final String METHOD_createSubcontext = "createSubcontext(String)";
    private static final String METHOD_destroySubcontext = "destroySubcontext(String)";
    private static final String METHOD_getNameParser = "getNameParser(String)";
    private static final String METHOD_list = "list(String)";
    private static final String METHOD_listBindings = "listBindings(String)";
    private static final String METHOD_lookup = "lookup(String)";
    private static final String METHOD_rename = "rename(String, String)";

    public CorbaURLContext(Hashtable env) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "CorbaURLContext(Hashtable) - ctor");
        }
        this._env = env != null ? (Hashtable)env.clone() : new Hashtable();
    }

    protected void setupForLookup(String inName, String inMethod) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_setupForLookup, "inName=" + inName);
        }
        if (this._fullName == null || !this._fullName.equals(inName)) {
            String[] providerUrlAndStrName = this.getProviderURLAndName(inName);
            this._providerUrl = providerUrlAndStrName[0];
            this._stringifiedName = providerUrlAndStrName[1];
            this._fullName = inName;
            this.throwIfNullStrName(this._stringifiedName, inMethod);
            this._initCtx = this.getInitialContext();
        }
        Tr.exit(_tc, METHOD_setupForLookup);
    }

    protected void setupForOtherNamingOperations(String inName, String inMethod) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_setupForOtherNamingOperations, "inName=" + inName);
        }
        if (this._fullName == null || !this._fullName.equals(inName)) {
            String[] providerUrlAndStrName = this.getProviderURLAndName(inName);
            this._providerUrl = providerUrlAndStrName[0];
            this._stringifiedName = providerUrlAndStrName[1];
            this._fullName = inName;
            this.throwIfNullOrEmptyStrName(this._stringifiedName, inMethod);
            this._initCtx = this.getInitialContext();
        }
        Tr.exit(_tc, METHOD_setupForOtherNamingOperations);
    }

    private void throwIfNullStrName(String strName, String inMethod) throws NamingException {
        if (strName == null) {
            String errMsg = "A null name is not allowed for the method " + inMethod + ": ";
            Tr.debug(_tc, errMsg + this._fullName);
            throw new InvalidNameException(errMsg + this._fullName);
        }
    }

    private void throwIfNullOrEmptyStrName(String strName, String inMethod) throws NamingException {
        String errMsg = null;
        this.throwIfNullStrName(strName, inMethod);
        if (strName.length() == 0) {
            errMsg = this.setErrMsgForEmptyStrName(inMethod);
            Tr.debug(_tc, errMsg + this._fullName);
            throw new InvalidNameException(errMsg + this._fullName);
        }
    }

    private Context getInitialContext() throws NamingException {
        Tr.entry(_tc, METHOD_getInitialContext);
        this._env.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
        this._env.put("java.naming.provider.url", this._providerUrl);
        InitialContext initCtx = null;
        try {
            initCtx = new InitialContext(this._env);
        }
        catch (NamingException ne) {
            RasUtil.logException((Throwable)ne, _tc, CLASS_NAME, "getInitialContext", "203", this);
            String cause = "Failed to get the initial context";
            Tr.debug(_tc, METHOD_getInitialContext, new Object[]{cause, "name=" + this._fullName});
            Tr.exit(_tc, METHOD_getInitialContext);
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, METHOD_getInitialContext, "initCtx name path=" + initCtx.getNameInNamespace());
        }
        return initCtx;
    }

    public void bind(Name inName, Object obj) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "bind(Name, Object)", "inName=" + inName);
        }
        this.bind(inName.toString(), obj);
    }

    public void bind(String inName, Object obj) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_bindS, "inName=" + inName);
        }
        this.setupForOtherNamingOperations(inName, METHOD_bindS);
        this._initCtx.bind(this._stringifiedName, obj);
        Tr.exit(_tc, METHOD_bindS);
    }

    public void rebind(Name inName, Object obj) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "rebind(Name, Object)", "inName=" + inName);
        }
        this.rebind(inName.toString(), obj);
    }

    public void rebind(String inName, Object obj) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_rebind, "inName=" + inName);
        }
        this.setupForOtherNamingOperations(inName, METHOD_rebind);
        this._initCtx.rebind(this._stringifiedName, obj);
        Tr.exit(_tc, METHOD_rebind);
    }

    public void unbind(Name inName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "unbind(Name, Object)", "inName=" + inName);
        }
        this.unbind(inName.toString());
    }

    public void unbind(String inName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_unbind, "inName=" + inName);
        }
        this.setupForOtherNamingOperations(inName, METHOD_unbind);
        this._initCtx.unbind(this._stringifiedName);
        Tr.exit(_tc, METHOD_unbind);
    }

    public Name composeName(Name inName, Name inPrefix) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "composeName(Name, Name)", "inName=" + inName + " inPrefix=" + inPrefix);
        }
        return inName;
    }

    public String composeName(String inName, String inPrefix) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "composeName(String, String)", "inName=" + inName + " inPrefix=" + inPrefix);
        }
        return inName;
    }

    public Context createSubcontext(Name inName) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "createSubcontext(Name)", "inName=" + inName);
        }
        Context retCtx = this.createSubcontext(inName.toString());
        return retCtx;
    }

    public Context createSubcontext(String inName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_createSubcontext, "inName=" + inName);
        }
        this.setupForOtherNamingOperations(inName, METHOD_createSubcontext);
        Context retCtx = null;
        retCtx = this._initCtx.createSubcontext(this._stringifiedName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createSubcontext(String)Context name = " + retCtx.getNameInNamespace());
        }
        return retCtx;
    }

    public void destroySubcontext(Name inName) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "destroySubcontext(Name)", "inName=" + inName);
        }
        this.destroySubcontext(inName.toString());
    }

    public void destroySubcontext(String inName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_destroySubcontext, "inName=" + inName);
        }
        this.setupForOtherNamingOperations(inName, METHOD_destroySubcontext);
        this._initCtx.destroySubcontext(this._stringifiedName);
        Tr.exit(_tc, METHOD_destroySubcontext);
    }

    public NameParser getNameParser(Name inName) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getNameParser(Name)", " inName=" + inName);
        }
        NameParser retParser = this.getNameParser(inName.toString());
        return retParser;
    }

    public NameParser getNameParser(String inName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_getNameParser, "inName=" + inName);
        }
        this.setupForLookup(inName, METHOD_getNameParser);
        NameParser retParser = this._initCtx.getNameParser(this._stringifiedName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, METHOD_getNameParser, "retParser = " + retParser);
        }
        return retParser;
    }

    public NamingEnumeration list(Name inName) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "list(Name)", "inName=" + inName);
        }
        NamingEnumeration retEnum = this.list(inName.toString());
        return retEnum;
    }

    public NamingEnumeration list(String inName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_list, "inName=" + inName);
        }
        this.setupForLookup(inName, METHOD_list);
        NamingEnumeration<NameClassPair> retEnum = this._initCtx.list(this._stringifiedName);
        Tr.exit(_tc, METHOD_list);
        return retEnum;
    }

    public NamingEnumeration listBindings(Name inName) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "listBinding(Name)", "inName=" + inName);
        }
        NamingEnumeration retEnum = this.listBindings(inName.toString());
        return retEnum;
    }

    public NamingEnumeration listBindings(String inName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_listBindings, "inName=" + inName);
        }
        this.setupForLookup(inName, METHOD_listBindings);
        NamingEnumeration<Binding> retEnum = this._initCtx.listBindings(this._stringifiedName);
        Tr.exit(_tc, METHOD_listBindings);
        return retEnum;
    }

    public Object lookup(Name inName) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "lookup(Name)", "inName=" + inName);
        }
        Object retObj = this.lookup(inName.toString());
        return retObj;
    }

    public Object lookup(String inName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_lookup, "inName=" + inName);
        }
        this.setupForLookup(inName, METHOD_lookup);
        Object retObj = this._initCtx.lookup(this._stringifiedName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, METHOD_lookup, "retObj = " + retObj);
        }
        return retObj;
    }

    public Object lookupLink(Name name) throws NamingException {
        OperationNotSupportedException ne = new OperationNotSupportedException();
        throw Helpers.logJndiContextException((Throwable)ne, (Context)this, "lookupLink(Name)", name, null);
    }

    public Object lookupLink(String name) throws NamingException {
        OperationNotSupportedException ne = new OperationNotSupportedException();
        throw Helpers.logJndiContextException((Throwable)ne, (Context)this, "lookupLink(String)", name, null);
    }

    public void rename(Name inOldName, Name inNewName) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "rename(Name, Name)", "inOldName=" + inOldName + "inNewName=" + inNewName);
        }
        this.rename(inOldName.toString(), inNewName.toString());
    }

    public void rename(String inOldName, String inNewName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_rename, "inOldName=" + inOldName + "inNewName=" + inNewName);
        }
        if (inOldName.compareTo(inNewName) == 0) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, METHOD_rename, "The old and new names are the same");
            }
            return;
        }
        this.setupForOtherNamingOperations(inOldName, METHOD_rename);
        String[] newCorbalocAndStrName = this.getProviderURLAndName(inNewName);
        if (!NameFormatHelper.isUrl(inNewName) || !this._providerUrl.equals(newCorbalocAndStrName[0])) {
            throw new OperationNotSupportedException("Do not support rename cross different name spaces:" + inOldName + " " + inNewName);
        }
        this._initCtx.rename(this._stringifiedName, newCorbalocAndStrName[1]);
        Tr.exit(_tc, METHOD_rename);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Hashtable getEnvironment() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void close() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected abstract String setErrMsgForEmptyStrName(String var1);

    protected abstract String[] getProviderURLAndName(String var1) throws NamingException;

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/CorbaURLContext.java, WAS.naming.client, WAS70.SERV1, q0834.18, ver. 1.15");
        }
        CLASS_NAME = CorbaURLContext.class.getName();
        _insEnv = Helpers.getINSEnvironment();
        _jndiEnv = Helpers.getJNDIEnvironment();
    }
}

