/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.ldap.WsnLdapHelpers;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.WsnNameParser;
import com.ibm.ws.naming.util.WsnNamingEnumeration;
import java.util.Hashtable;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.omg.CosNaming.NameComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsnLdapNameEnumeration
extends WsnNamingEnumeration<NameClassPair> {
    private static final TraceComponent _tc = Tr.register(WsnLdapNameEnumeration.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private final NamingEnumeration<SearchResult> _searchResults;

    public WsnLdapNameEnumeration(Hashtable<?, ?> env, NamingEnumeration<SearchResult> searchResults, WsnNameParser parser2, boolean initialize) throws NamingException {
        super(env, parser2);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", new String[]{"env=" + env, "searchResults=" + searchResults, "parser=" + parser2, "initialize=" + initialize});
        }
        this._searchResults = searchResults;
        if (initialize) {
            this.init();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>");
        }
    }

    @Override
    protected Boolean doInit() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doInit");
        }
        Boolean more = null;
        try {
            more = this.doNextBatch();
        }
        catch (NamingException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doInit", "111", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doInit", e.toString());
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doInit", more);
        }
        return more;
    }

    @Override
    protected void doClose() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "doClose");
        }
    }

    @Override
    protected Boolean doNextBatch() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doNextBatch");
        }
        Boolean more = null;
        for (int i = 0; i < this._batchSize && this._searchResults.hasMoreElements(); ++i) {
            SearchResult searchResult = (SearchResult)this._searchResults.nextElement();
            try {
                this._batch.offer(this.jndiBindingData(searchResult));
                continue;
            }
            catch (NamingException e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doNextBatch", "143", this);
                this._batch.offer(e);
                continue;
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "doNextBatch", "146", this);
                NamingException ne = new NamingException("Unexpected exception occurred.");
                ne.initCause(t);
                this._batch.offer(ne);
            }
        }
        if (!this._searchResults.hasMoreElements()) {
            more = Boolean.FALSE;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doNextBatch", more);
        }
        return more;
    }

    private NameClassPair jndiBindingData(SearchResult searchResult) throws NamingException {
        Attributes attributes;
        Attribute nameAttribute;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "jndiBindingData", "searchResult=" + searchResult);
        }
        if ((nameAttribute = (attributes = searchResult.getAttributes()).get("ibm-wsnName")) == null) {
            NamingException ne = new NamingException("Search result does not contain the attribute ibm-wsnName");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "jndiBindingData", ne);
            }
            throw ne;
        }
        String insString = (String)nameAttribute.get();
        WsnNameParser insNameParser = WsnNameParser.getInsNameParser();
        NameComponent[] cosName = insNameParser.stringToNC(insString);
        String name = this._nameParser.ncToString(cosName);
        String className = WsnLdapHelpers.getStringFromAttribute(attributes, "javaClassName", false);
        NameClassPair nameClassPair = new NameClassPair(name, className);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "jndiBindingData", nameClassPair);
        }
        return nameClassPair;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(", _searchResults=");
        stringBuilder.append(this._searchResults);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/ldap/WsnLdapNameEnumeration.java, WAS.naming.client, WAS70.SERV1, q0834.18, ver. 1.20");
        }
        CLASS_NAME = WsnLdapNameEnumeration.class.getName();
    }
}

