/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.jndicos;

import com.ibm.ExtendedNaming.NamingContext;
import com.ibm.ExtendedNaming.NamingContextHelper;
import com.ibm.WsnOptimizedNaming.ContextIDStringsHolder;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.CannotInstantiateObjectException;
import com.ibm.websphere.naming.DestroyProtectedContextException;
import com.ibm.websphere.naming.WriteProtectedContextException;
import com.ibm.websphere.naming.WsnBatchModeContext;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.ws.naming.ipbase.ContextID;
import com.ibm.ws.naming.ipbase.StringContextID;
import com.ibm.ws.naming.ipbase.UuidContext;
import com.ibm.ws.naming.jbatch.BatchModeNotSupported;
import com.ibm.ws.naming.jbatch.WsnBatchModeCNContextImpl;
import com.ibm.ws.naming.jcache.Cache;
import com.ibm.ws.naming.jcache.CacheEntryNotFoundException;
import com.ibm.ws.naming.jndicos.CNBindingEnumeration;
import com.ibm.ws.naming.jndicos.CNContext;
import com.ibm.ws.naming.jndicos.CNEnumeration;
import com.ibm.ws.naming.jndicos.CNNameEnumeration;
import com.ibm.ws.naming.util.BooleanWrapper;
import com.ibm.ws.naming.util.CacheableReference;
import com.ibm.ws.naming.util.CannotBindObjectException;
import com.ibm.ws.naming.util.CannotDestroySubcontextException;
import com.ibm.ws.naming.util.CannotUnbindSubcontextException;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.InvalidObjectException;
import com.ibm.ws.naming.util.JavaObjectHolder;
import com.ibm.ws.naming.util.NameFormatHelper;
import com.ibm.ws.naming.util.NameServerObjectFactoryException;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.ReferenceData;
import com.ibm.ws.naming.util.RetryableAction;
import com.ibm.ws.naming.util.RetryableActionException;
import com.ibm.ws.naming.util.RetryableExceptionAction;
import com.ibm.ws.naming.util.SecurityAuthentication;
import com.ibm.ws.naming.util.SecurityUtil;
import com.ibm.ws.naming.util.Serialization;
import com.ibm.ws.naming.util.TransactionUtil;
import com.ibm.ws.naming.util.UnresolvedURLException;
import com.ibm.ws.naming.util.WsnName;
import com.ibm.ws.naming.util.WsnNameParser;
import com.ibm.ws.util.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;
import javax.security.auth.Subject;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.BindingTypeHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NameHolder;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.CosPropertyService.InvalidPropertyName;
import org.omg.CosPropertyService.PropertyNotFound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNContextImpl
implements CNContext {
    private static final TraceComponent _tc = Tr.register(CNContextImpl.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static final String NAME_DELIMITER = "/";
    static final String CLASSNAME_FOR_NULLOBJ = "org.omg.CORBA.Object";
    static final String CLASSNAME_FOR_JAVAOBJ = "java.lang.Object";
    protected final Hashtable _env;
    protected final ORB _orb;
    protected final org.omg.CosNaming.NamingContext _corbaNC;
    protected org.omg.ExtendedNaming.NamingContext _omgExtNC = null;
    protected NamingContext _ibmExtNC = null;
    protected com.ibm.WsnOptimizedNaming.NamingContext _wsOptNC = null;
    protected WsnBatchModeContext _batchModeContext = null;
    protected String _contextName = null;
    protected boolean _contextNameIsPrimary = false;
    protected final ContextID _contextID;
    protected final Cache _cache;
    protected final WsnNameParser _parser;
    protected final SecurityAuthentication _securityAuthentication;
    protected final String _principal;
    protected final String _credentials;
    protected final boolean _jndiOnly;
    protected final boolean _securityEnabled;
    protected final int _serverType;
    protected final boolean _caching;
    protected volatile boolean _closed = false;

    public static org.omg.CosNaming.NamingContext narrowToNamingContext(ORB orb, final Object obj) throws BAD_PARAM {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "narrowToNamingContext");
        }
        org.omg.CosNaming.NamingContext nc = Helpers.retry(new RetryableAction<org.omg.CosNaming.NamingContext>(){

            @Override
            public org.omg.CosNaming.NamingContext run() {
                java.lang.Object nc;
                block13: {
                    nc = null;
                    try {
                        nc = org.omg.CosNaming.NamingContextHelper.narrow((Object)obj);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "narrowToNamingContext", "object narrowed to org.omg.CosNaming.NamingContext");
                        }
                    }
                    catch (BAD_PARAM e) {
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "narrowToNamingContext", e.toString());
                        }
                        throw e;
                    }
                    try {
                        nc = com.ibm.WsnOptimizedNaming.NamingContextHelper.narrow((Object)nc);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "narrowToNamingContext", "object narrowed to v4.0+ NamingContext");
                        }
                    }
                    catch (BAD_PARAM e) {
                        try {
                            nc = org.omg.ExtendedNaming.NamingContextHelper.narrow((Object)nc);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "narrowToNamingContext", "object narrowed to v3.5 NamingContext");
                            }
                        }
                        catch (BAD_PARAM e2) {
                            try {
                                nc = NamingContextHelper.narrow((Object)nc);
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "narrowToNamingContext", "Object narrowed to CB NamingContext");
                                }
                            }
                            catch (BAD_PARAM e3) {
                                if (!_tc.isDebugEnabled()) break block13;
                                Tr.debug(_tc, "narrowToNamingContext", "object is not a known NamingContext subclass.");
                            }
                        }
                    }
                }
                return nc;
            }
        });
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "narrowToNamingContext", nc);
        }
        return nc;
    }

    public static Context checkForUrlContext(Name name, Hashtable<?, ?> env) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "checkForUrlContext", new String[]{"name=" + name, "env=" + env});
        }
        Context retCtx = null;
        if (NameFormatHelper.isUrl(name)) {
            String scheme;
            String tmpScheme = scheme = NameFormatHelper.getUrlScheme(name);
            try {
                retCtx = NamingManager.getURLContext(tmpScheme, env);
            }
            catch (NamingException e) {
                RasUtil.logException(e, _tc, CLASS_NAME, "checkForUrlContext", "460");
                Tr.warning(_tc, "urlGetUrlCtxErr", scheme);
                NamingException ne = new NamingException("checkForUrlContext: " + name);
                ne.initCause(e);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "checkForUrlContext", ne);
                }
                throw ne;
            }
            if (retCtx == null) {
                ConfigurationException ne = new ConfigurationException("NamingManager.getURLContext cannot find the factory for this scheme: " + scheme);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "checkForUrlContext", ne);
                }
                throw ne;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "checkForUrlContext", retCtx);
        }
        return retCtx;
    }

    public static void validateName(Name name) throws InvalidNameException {
        if (name == null || name.isEmpty()) {
            throw new InvalidNameException("A null or empty name was supplied.");
        }
    }

    public CNContextImpl(Hashtable<?, ?> env, ORB orb, org.omg.CosNaming.NamingContext currentNC, String contextName, Cache cache, SecurityAuthentication securityAuthentication, String principal, String credentials, boolean jndiOnly, boolean securityEnabled) throws NamingException {
        this(env, orb, currentNC, contextName, true, new StringContextID("ROOT CONTEXT"), cache, WsnNameParser.getParser(env), securityAuthentication, principal, credentials, jndiOnly, securityEnabled);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "<init>", "root context");
        }
    }

    public CNContextImpl(Hashtable<?, ?> env, ORB orb, org.omg.CosNaming.NamingContext currentNC, String contextName, boolean nameIsPrimary, ContextID contextID, Cache cache, WsnNameParser nameParser, SecurityAuthentication securityAuthentication, String principal, String credentials, boolean jndiOnly, boolean securityEnabled) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", new String[]{"env=" + env, "orb=" + orb, "currentNC=" + currentNC, "contextName=" + contextName, "nameIsPrimary=" + nameIsPrimary, "contextID=" + contextID, "cache=" + cache, "nameParser=" + nameParser, "securityAuthentication=" + (java.lang.Object)((java.lang.Object)securityAuthentication), "principal=" + principal, "credentials=" + StringUtils.maskPassword(credentials), "jndiOnly=" + jndiOnly, "securityEnabled=" + securityEnabled});
        }
        this._env = (Hashtable)env.clone();
        this._orb = orb;
        this._corbaNC = currentNC;
        this.setContextName(contextName, nameIsPrimary);
        this._contextID = contextID;
        this._cache = cache;
        this._parser = nameParser;
        this._securityAuthentication = securityAuthentication;
        this._principal = principal;
        this._credentials = credentials;
        this._jndiOnly = jndiOnly;
        this._securityEnabled = securityEnabled;
        int serverType = 0;
        boolean caching = false;
        if (this._corbaNC instanceof com.ibm.WsnOptimizedNaming.NamingContext) {
            this._wsOptNC = (com.ibm.WsnOptimizedNaming.NamingContext)this._corbaNC;
            serverType = 3;
            if (cache != null) {
                caching = true;
            }
        } else if (this._corbaNC instanceof org.omg.ExtendedNaming.NamingContext) {
            this._omgExtNC = (org.omg.ExtendedNaming.NamingContext)this._corbaNC;
            serverType = 2;
        } else if (this._corbaNC instanceof NamingContext) {
            this._ibmExtNC = (NamingContext)this._corbaNC;
            serverType = 1;
        }
        this._serverType = serverType;
        this._caching = caching;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "<init>", new String[]{"_serverType=" + this._serverType, "_caching=" + this._caching});
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>");
        }
    }

    @Override
    public boolean supportsBatchMode() {
        return this._serverType == 3;
    }

    @Override
    public WsnBatchModeContext getBatchModeContext() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getBatchModeContext");
        }
        if (!this.supportsBatchMode()) {
            BatchModeNotSupported ne = new BatchModeNotSupported("Server does not support batch operations.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getBatchModeContext", ne);
            }
            throw ne;
        }
        if (this._batchModeContext == null) {
            this._batchModeContext = new WsnBatchModeCNContextImpl(this._env, this._orb, this._corbaNC, this._contextName, this._contextNameIsPrimary, this._contextID, this._cache, this._parser, this._securityAuthentication, this._principal, this._credentials, this._jndiOnly, this._securityEnabled);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getBatchModeContext", this._batchModeContext);
        }
        return this._batchModeContext;
    }

    @Override
    public java.lang.Object lookup(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "lookup", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "lookup", namingException);
            }
            throw namingException;
        }
        java.lang.Object object = null;
        try {
            object = this.lookupExt(name, new BooleanWrapper(false), new JavaObjectHolder());
        }
        catch (NamingException ne) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "lookup", ne.toString());
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "lookup", object);
        }
        return object;
    }

    @Override
    public java.lang.Object lookup(String name) throws NamingException {
        return this.lookup(this._parser.parse(name));
    }

    @Override
    public void bind(Name name, java.lang.Object object) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "bind", new String[]{"name=" + name, "object=" + object});
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "bind", namingException);
            }
            throw namingException;
        }
        try {
            CNContextImpl.validateName(name);
            Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
            if (urlCtx != null) {
                urlCtx.bind(name, object);
            } else {
                this.doBind(name, object);
            }
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "bind", "684", this);
            NamingException ne = Helpers.logJndiContextException(t, (Context)this, "bind", name, "Object to bind: " + object);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "bind", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "bind");
        }
    }

    @Override
    public void bind(String name, java.lang.Object object) throws NamingException {
        this.bind(this._parser.parse(name), object);
    }

    @Override
    public void rebind(Name name, java.lang.Object object) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "rebind", new String[]{"name=" + name, "object=" + object});
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "rebind", namingException);
            }
            throw namingException;
        }
        CNContextImpl.validateName(name);
        try {
            Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
            if (urlCtx != null) {
                urlCtx.rebind(name, object);
            } else {
                this.doRebind(name, object);
            }
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "rebind", "731", this);
            NamingException ne = Helpers.logJndiContextException(t, (Context)this, "rebind", name, "Object to bind: " + object);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "rebind", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "rebind");
        }
    }

    @Override
    public void rebind(String name, java.lang.Object object) throws NamingException {
        this.rebind(this._parser.parse(name), object);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "unbind", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "unbind", namingException);
            }
            throw namingException;
        }
        try {
            CNContextImpl.validateName(name);
            Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
            if (urlCtx != null) {
                urlCtx.unbind(name);
            } else {
                this.doUnbind(name);
            }
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "unbind", "778", this);
            NamingException ne = Helpers.logJndiContextException(t, (Context)this, "unbind", name, null);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "unbind", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "unbind");
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(this._parser.parse(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        block10: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "rename", new String[]{"oldName=" + oldName, "newName=" + newName});
            }
            if (this._closed) {
                NamingException namingException = new NamingException("Context closed");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "rename", namingException);
                }
                throw namingException;
            }
            try {
                CNContextImpl.validateName(oldName);
                CNContextImpl.validateName(newName);
                boolean oldIsUrl = NameFormatHelper.isUrl(oldName);
                boolean newIsUrl = NameFormatHelper.isUrl(newName);
                if (oldIsUrl && newIsUrl) {
                    Context urlCtxOld = CNContextImpl.checkForUrlContext(oldName, this._env);
                    urlCtxOld.rename(oldName, newName);
                    break block10;
                }
                if (!oldIsUrl && !newIsUrl) {
                    this.doRename(oldName, newName);
                    break block10;
                }
                OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException("Crossing name spaces is not supported: " + oldName + " " + newName);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "rename", operationNotSupportedException);
                }
                throw operationNotSupportedException;
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "rename", "836", this);
                NamingException ne = Helpers.logJndiContextException(t, (Context)this, "rename", oldName, "New name: " + newName);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "rename", ne);
                }
                throw ne;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "rename");
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(this._parser.parse(oldName), this._parser.parse(newName));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createSubcontext", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createSubcontext", namingException);
            }
            throw namingException;
        }
        Context newContext = null;
        try {
            CNContextImpl.validateName(name);
            Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
            newContext = urlCtx != null ? urlCtx.createSubcontext(name) : this.doCreateSubcontext(name);
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "createSubcontext", "885", this);
            NamingException ne = Helpers.logJndiContextException(t, (Context)this, "createSubcontext", name, null);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createSubcontext", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createSubcontext", newContext);
        }
        return newContext;
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this._parser.parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroySubcontext", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "destroySubcontext", namingException);
            }
            throw namingException;
        }
        try {
            CNContextImpl.validateName(name);
            Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
            if (urlCtx != null) {
                urlCtx.destroySubcontext(name);
            } else {
                this.doDestroySubcontext(name);
            }
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "destroySubcontext", "934", this);
            NamingException ne = Helpers.logJndiContextException(t, (Context)this, "destroySubcontext", name, null);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "destroySubcontext", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroySubcontext");
        }
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this._parser.parse(name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "list", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "list", namingException);
            }
            throw namingException;
        }
        if (name == null) {
            InvalidNameException ne = new InvalidNameException("Name cannot be null.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "list", ne);
            }
            throw ne;
        }
        NamingEnumeration namingEnumeration = null;
        try {
            Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
            namingEnumeration = urlCtx != null ? urlCtx.list(name) : this.doList(name, EnumType.NAME);
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "list", "989", this);
            NamingException ne = Helpers.logJndiContextException(t, (Context)this, "list", name, null);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "list", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "list", namingEnumeration);
        }
        return namingEnumeration;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(this._parser.parse(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "listBindings", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "listBindings", namingException);
            }
            throw namingException;
        }
        if (name == null) {
            InvalidNameException ne = new InvalidNameException("Name cannot be null.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "listBindings", ne);
            }
            throw ne;
        }
        NamingEnumeration namingEnumeration = null;
        try {
            Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
            namingEnumeration = urlCtx != null ? urlCtx.listBindings(name) : this.doList(name, EnumType.BINDING);
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "listBindings", "1046", this);
            NamingException ne = Helpers.logJndiContextException(t, (Context)this, "listBindings", name, null);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "listBindings", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "listBindings", namingEnumeration);
        }
        return namingEnumeration;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(this._parser.parse(name));
    }

    @Override
    public java.lang.Object lookupLink(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "lookupLink", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "lookupLink", namingException);
            }
            throw namingException;
        }
        java.lang.Object object = null;
        try {
            Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
            if (urlCtx == null) {
                OperationNotSupportedException ne = new OperationNotSupportedException("Not a URL context.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "lookupLink", ne);
                }
                throw ne;
            }
            object = urlCtx.lookupLink(name);
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "lookupLink", "1098", this);
            NamingException ne = Helpers.logJndiContextException(t, (Context)this, "lookupLink", name, null);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "lookupLink", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "lookupLink", object);
        }
        return object;
    }

    @Override
    public java.lang.Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this._parser.parse(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        NameParser nameParser;
        block13: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getNameParser", "name=" + name);
            }
            if (this._closed) {
                NamingException namingException = new NamingException("Context closed");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getNameParser", namingException);
                }
                throw namingException;
            }
            if (name == null) {
                InvalidNameException ne = new InvalidNameException("Name cannot be null.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getNameParser", ne);
                }
                throw ne;
            }
            nameParser = null;
            try {
                if (name.isEmpty()) {
                    nameParser = this._parser;
                    break block13;
                }
                Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
                if (urlCtx != null) {
                    nameParser = urlCtx.getNameParser(name);
                    break block13;
                }
                java.lang.Object targetCtx = this.lookup(name);
                if (targetCtx instanceof Context) {
                    nameParser = ((Context)targetCtx).getNameParser("");
                    break block13;
                }
                NotContextException ne = new NotContextException("The object bound with the name \"" + name + "\" relative to the context \"" + this.getContextName() + "\" is not a context.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getNameParser", ne);
                }
                throw ne;
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "getNameParser", "1170", this);
                NamingException ne = Helpers.logJndiContextException(t, (Context)this, "getNameParser", name, null);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getNameParser", ne);
                }
                throw ne;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNameParser", nameParser);
        }
        return nameParser;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(this._parser.parse(name));
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "composeName", new String[]{"name=" + name, "prefix=" + prefix});
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "composeName", namingException);
            }
            throw namingException;
        }
        Helpers.throwIfNull(name, "composeName", (Context)this);
        Helpers.throwIfNull(prefix, "composeName", (Context)this);
        Name newName = null;
        try {
            Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
            if (urlCtx != null) {
                newName = urlCtx.composeName(name, prefix);
            } else {
                newName = new WsnName("", this._env);
                newName.addAll(prefix);
                newName.addAll(name);
            }
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "composeName", "1226", this);
            NamingException ne = Helpers.logJndiContextException(t, (Context)this, "composeName", name, "Prefix: " + prefix);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "composeName", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "composeName", newName);
        }
        return newName;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(this._parser.parse(name), this._parser.parse(prefix)).toString();
    }

    @Override
    public java.lang.Object addToEnvironment(String propertyName, java.lang.Object propertyValue) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addToEnvironment", new String[]{"propertyName=" + propertyName, "propertyValue=" + propertyValue});
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "addToEnvironment", namingException);
            }
            throw namingException;
        }
        if (propertyName == null || propertyValue == null) {
            NamingException ne = new NamingException("A null property name or value was supplied.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "addToEnvironment", ne);
            }
            throw ne;
        }
        java.lang.Object previousValue = null;
        try {
            previousValue = this._env.put(propertyName, propertyValue);
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "addToEnvironment", "1284", this);
            NamingException ne = Helpers.logJndiContextException(t, (Context)this, "addToEnvironment", (Name)null, "Property name: \"" + propertyName + "\", property value: \"" + propertyValue + "\"");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "addToEnvironment", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addToEnvironment", previousValue);
        }
        return previousValue;
    }

    @Override
    public java.lang.Object removeFromEnvironment(String propertyName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeFromEnvironment", "propertyName=" + propertyName);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "removeFromEnvironment", namingException);
            }
            throw namingException;
        }
        if (propertyName == null) {
            NamingException ne = new NamingException("A null property name was supplied.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "removeFromEnvironment", ne);
            }
            throw ne;
        }
        java.lang.Object previousValue = null;
        try {
            previousValue = this._env.remove(propertyName);
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "removeFromEnvironment", "1326", this);
            NamingException ne = Helpers.logJndiContextException(t, (Context)this, "removeFromEnvironment", (Name)null, "Property name: \"" + propertyName);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "removeFromEnvironment", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeFromEnvironment", previousValue);
        }
        return previousValue;
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getEnvironment");
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getEnvironment", namingException);
            }
            throw namingException;
        }
        Hashtable newEnvironment = null;
        try {
            newEnvironment = (Hashtable)this._env.clone();
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "getEnvironment", "1361", this);
            NamingException ne = Helpers.logJndiContextException(t, (Context)this, "getEnvironment", (Name)null, null);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getEnvironment", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEnvironment", newEnvironment);
        }
        return newEnvironment;
    }

    @Override
    public void close() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "close");
        }
        this._closed = true;
        this._omgExtNC = null;
        this._ibmExtNC = null;
        this._wsOptNC = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "close");
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNameInNamespace");
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getNameInNamespace", namingException);
            }
            throw namingException;
        }
        String nins = this.getContextName();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNameInNamespace", nins);
        }
        return nins;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public java.lang.Object lookupExt(Name name, BooleanWrapper haveExtendedData, JavaObjectHolder javaObjHolder) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "lookupExt", "name=" + name);
        }
        if (this._closed) {
            NamingException namingException = new NamingException("Context closed");
            if (!_tc.isEntryEnabled()) throw namingException;
            Tr.exit(_tc, "lookupExt", namingException);
            throw namingException;
        }
        java.lang.Object object = null;
        int pmiStatus = 2;
        java.lang.Object pmiContext = null;
        boolean pmiEnabled = false;
        try {
            if (name != null && name.isEmpty()) {
                pmiEnabled = PmiReqMetrics.isComponentEnabled(6, 3);
            }
            if (pmiEnabled) {
                try {
                    String[] pmiCtxVals = new String[]{name != null ? name.toString() : null};
                    pmiContext = PmiReqMetrics.reqStart(6, 3, pmiCtxVals);
                }
                catch (Exception e) {
                    RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "lookupExt", "1476", this);
                    pmiEnabled = false;
                }
            }
            if (name == null) {
                InvalidNameException ne = new InvalidNameException("A null name was supplied.");
                if (!_tc.isEntryEnabled()) throw ne;
                Tr.exit(_tc, "lookupExt", ne);
                throw ne;
            }
            if (!name.isEmpty()) {
                Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
                if (urlCtx != null) {
                    object = urlCtx.lookup(name);
                } else {
                    if (javaObjHolder == null) {
                        javaObjHolder = new JavaObjectHolder();
                    }
                    object = this.doLookup(name, haveExtendedData, javaObjHolder);
                }
            } else {
                object = this.cloneContext();
            }
            pmiStatus = 0;
        }
        catch (Throwable t) {
            try {
                RasUtil.logException(t, _tc, CLASS_NAME, "lookupExt", "1507", this);
                NamingException ne = Helpers.logJndiContextException(t, (Context)this, "lookupExt", name, null);
                if (!_tc.isEntryEnabled()) throw ne;
                Tr.exit(_tc, "lookupExt", ne);
                throw ne;
            }
            catch (Throwable throwable) {
                try {
                    if (!pmiEnabled) throw throwable;
                    PmiReqMetrics.reqStop(pmiContext, 6, 3, pmiStatus);
                    throw throwable;
                }
                catch (Exception e) {
                    RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "lookupExt", "1520", this);
                }
                throw throwable;
            }
        }
        try {
            if (pmiEnabled) {
                PmiReqMetrics.reqStop(pmiContext, 6, 3, pmiStatus);
            }
        }
        catch (Exception e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "lookupExt", "1520", this);
        }
        if (!_tc.isEntryEnabled()) return object;
        Tr.exit(_tc, "lookupExt", object);
        return object;
    }

    @Override
    public java.lang.Object lookupExt(String name, BooleanWrapper haveExtendedData, JavaObjectHolder javaObjHolder) throws NamingException {
        return this.lookupExt(this._parser.parse(name), haveExtendedData, javaObjHolder);
    }

    @Override
    public void bindIOR(Name name, String ior, boolean isContext, String className) throws NamingException {
        this.bindIOR(Operation.BIND, "bindIOR", name, ior, isContext, className);
    }

    @Override
    public void bindIOR(String name, String ior, boolean isContext, String className) throws NamingException {
        this.bindIOR(Operation.BIND, "bindIOR", this._parser.parse(name), ior, isContext, className);
    }

    @Override
    public void rebindIOR(Name name, String ior, boolean isContext, String className) throws NamingException {
        this.bindIOR(Operation.REBIND, "rebindIOR", name, ior, isContext, className);
    }

    @Override
    public void rebindIOR(String name, String ior, boolean isContext, String className) throws NamingException {
        this.bindIOR(Operation.REBIND, "rebindIOR", this._parser.parse(name), ior, isContext, className);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void bindIOR(Operation operation, String method2, Name name, String ior, boolean isContext, String className) throws NamingException {
        block16: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "bindIOR", new String[]{"operation=" + (java.lang.Object)((java.lang.Object)operation), "method=" + method2, "name=" + name, "ior=" + ior, "isContext=" + isContext, "className=" + className});
            }
            if (this._closed) {
                NamingException namingException = new NamingException("Context closed");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "bindIOR", namingException);
                }
                throw namingException;
            }
            if (ior == null || ior.length() == 0) {
                NamingException ne = new NamingException("IOR string is null or empty.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "bindIOR", ne);
                }
                throw ne;
            }
            try {
                CNContextImpl.validateName(name);
                Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
                if (urlCtx != null) {
                    if (urlCtx instanceof CNContext) {
                        CNContext cnCtx = (CNContext)urlCtx;
                        if (operation == Operation.BIND) {
                            cnCtx.bindIOR(name, ior, isContext, className);
                            break block16;
                        } else {
                            cnCtx.rebindIOR(name, ior, isContext, className);
                        }
                        break block16;
                    }
                    OperationNotSupportedException ne = new OperationNotSupportedException("URL " + name + " does not resolve to a context which supports IOR bindings.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "bindIOR", ne);
                    }
                    throw ne;
                }
                if (operation == Operation.BIND) {
                    this.doBindIOR(name, ior, isContext, className);
                } else {
                    this.doRebindIOR(name, ior, isContext, className);
                }
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "rebindIOR", "1631", this);
                NamingException ne = Helpers.logJndiContextException(t, (Context)this, method2, name, "IOR to bind: " + ior);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "bindIOR", ne);
                }
                throw ne;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "bindIOR");
        }
    }

    @Override
    public void bindReference(Name name, ReferenceData referenceData) throws NamingException {
        this.bindReference(Operation.BIND, "bindReference", name, referenceData);
    }

    @Override
    public void bindReference(String name, ReferenceData referenceData) throws NamingException {
        this.bindReference(this._parser.parse(name), referenceData);
    }

    @Override
    public void rebindReference(Name name, ReferenceData referenceData) throws NamingException {
        this.bindReference(Operation.REBIND, "rebindReference", name, referenceData);
    }

    @Override
    public void rebindReference(String name, ReferenceData referenceData) throws NamingException {
        this.rebindReference(this._parser.parse(name), referenceData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void bindReference(Operation operation, String method2, Name name, ReferenceData referenceData) throws NamingException {
        block14: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "bindReference", new String[]{"operation=" + (java.lang.Object)((java.lang.Object)operation), "method=" + method2, "name=" + name, "referenceData=" + referenceData});
            }
            if (this._closed) {
                NamingException namingException = new NamingException("Context closed");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "bindReference", namingException);
                }
                throw namingException;
            }
            try {
                CNContextImpl.validateName(name);
                if (referenceData == null) {
                    NamingException ne = new NamingException("Reference data is null.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "bindReference", ne);
                    }
                    throw ne;
                }
                referenceData.validate();
                Context urlCtx = CNContextImpl.checkForUrlContext(name, this._env);
                if (urlCtx != null) {
                    if (urlCtx instanceof CNContext) {
                        CNContext cnCtx = (CNContext)urlCtx;
                        if (operation == Operation.BIND) {
                            cnCtx.bindReference(name, referenceData);
                            break block14;
                        } else {
                            cnCtx.rebindReference(name, referenceData);
                        }
                        break block14;
                    }
                    OperationNotSupportedException ne = new OperationNotSupportedException("URL " + name + " does not resolve to a context which supports reference bindings.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "bindReference", ne);
                    }
                    throw ne;
                }
                this.doBindReference(operation, method2, name, referenceData);
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "bindReference", "1732", this);
                NamingException ne = Helpers.logJndiContextException(t, (Context)this, method2, name, "Reference data: " + referenceData);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "bindReference", ne);
                }
                throw ne;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "bindReference");
        }
    }

    protected java.lang.Object doLookup(Name name, BooleanWrapper haveExtendedData, JavaObjectHolder javaObjHolder) throws NamingException {
        return this.doLookup(name, true, haveExtendedData, javaObjHolder);
    }

    protected java.lang.Object doLookup(Name name, boolean processReferences, BooleanWrapper haveExtendedData, JavaObjectHolder javaObjHolder) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doLookup", new String[]{"name=" + name, "processReferences=" + processReferences});
        }
        java.lang.Object object = null;
        javaObjHolder.value = null;
        haveExtendedData.value = true;
        ContextIDStringsHolder ctxIDStringsHolder = new ContextIDStringsHolder();
        try {
            object = this.cacheLookup(name, ctxIDStringsHolder.value, javaObjHolder);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doLookup", new java.lang.Object[]{"cached object", object});
            }
            return object;
        }
        catch (CacheEntryNotFoundException e) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "lookup", e.toString());
            }
            StringHolder ctxIDStringHolder = new StringHolder();
            AnyHolder anyHolder = new AnyHolder();
            StringHolder classNameHolder = new StringHolder();
            NameHolder primaryContextNameHolder = new NameHolder();
            BooleanHolder objectMightBeAContext = new BooleanHolder();
            try {
                object = this.cosResolve(this._parser.parse(name), ctxIDStringsHolder, ctxIDStringHolder, anyHolder, classNameHolder, primaryContextNameHolder, objectMightBeAContext);
            }
            catch (NotFound e2) {
                NamingException ne = this.mapNotFoundException(e2, name);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doLookup", ne);
                }
                throw ne;
            }
            catch (InvalidName e3) {
                RasUtil.logException((Throwable)e3, _tc, CLASS_NAME, "doLookup", "1799", this);
                InvalidNameException ne = new InvalidNameException(name.toString());
                ne.initCause(e3);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doLookup", ne);
                }
                throw ne;
            }
            catch (INV_OBJREF e4) {
                RasUtil.logException((Throwable)e4, _tc, CLASS_NAME, "doLookup", "1806", this);
                NamingException ne = this.mapINV_OBJREF(e4, name);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doLookup", ne.toString());
                }
                throw ne;
            }
            catch (NO_PERMISSION e5) {
                RasUtil.logException((Throwable)e5, _tc, CLASS_NAME, "doLookup", "1813", this);
                NoPermissionException ne = new NoPermissionException("NO_PERMISSION exception caught");
                ne.initCause(e5);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doLookup", ne);
                }
                throw ne;
            }
            catch (Exception e6) {
                RasUtil.logException((Throwable)e6, _tc, CLASS_NAME, "doLookup", "1820", this);
                if (e6 instanceof UNKNOWN) {
                    UNKNOWN ue = (UNKNOWN)e6;
                    if (ue.minor == 1229066372) {
                        NameServerObjectFactoryException ne = new NameServerObjectFactoryException("Object bound under the name \"" + name + "\" in the context \"" + this.getContextName() + "\" could not be resolved due to an internal name server error.");
                        ne.initCause((Throwable)ue);
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "doLookup", ne);
                        }
                        throw ne;
                    }
                }
                NamingException ne = new NamingException("Error during resolve");
                ne.initCause(e6);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doLookup", ne);
                }
                throw ne;
            }
            try {
                object = this.processResolveResults(this._parser.parse(name), name.toString(), object, anyHolder.value, objectMightBeAContext.value, classNameHolder.value, primaryContextNameHolder.value, ctxIDStringHolder.value, ctxIDStringsHolder.value, javaObjHolder);
            }
            catch (NamingException e7) {
                RasUtil.logException((Throwable)e7, _tc, CLASS_NAME, "doLookup", "1848", this);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doLookup", e7.toString());
                }
                throw e7;
            }
            java.lang.Object result = null;
            result = !processReferences && javaObjHolder.value != null ? javaObjHolder.value : object;
            if (!this._caching || !Helpers.isCacheable(ctxIDStringsHolder.value)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "doLookup", "not returning extended lookup data");
                }
                haveExtendedData.value = false;
                javaObjHolder.value = null;
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doLookup", result);
            }
            return result;
        }
    }

    protected void doBind(Name name, java.lang.Object obj) throws NamingException {
        java.lang.Object objToCache;
        ContextIDStringsHolder ctxIDStringsHolder;
        block31: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "doBind", new String[]{"name=" + name, "obj=" + obj});
            }
            ctxIDStringsHolder = new ContextIDStringsHolder();
            objToCache = obj;
            try {
                if (obj != null) {
                    obj = Helpers.extractCtxImplFromInitCtx(obj);
                    objToCache = obj = Helpers.processRemoteObjectForBinding(obj, this._orb);
                    String className = obj.getClass().getName();
                    if (obj instanceof Object) {
                        this.cosBindCorbaObject(this._parser.parse(name), (Object)obj, className, ctxIDStringsHolder);
                        break block31;
                    }
                    if (obj instanceof CNContextImpl) {
                        this.cosBindContext(this._parser.parse(name), ((CNContextImpl)obj).getCosContext(), ctxIDStringsHolder);
                        break block31;
                    }
                    byte[] serializedObject = null;
                    try {
                        StringBuffer classNameBuff = new StringBuffer(64);
                        serializedObject = (byte[])Helpers.processJavaObjectForBinding(obj, true, classNameBuff);
                        className = classNameBuff.toString();
                    }
                    catch (IOException e) {
                        RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doBind", "1915", this);
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "doBind", e);
                        }
                        throw e;
                    }
                    catch (CannotBindObjectException e) {
                        RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doBind", "1920", this);
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "doBind", e);
                        }
                        throw e;
                    }
                    objToCache = serializedObject;
                    this.cosBindJavaObject(this._parser.parse(name), className, serializedObject, ctxIDStringsHolder);
                    break block31;
                }
                this.cosBindCorbaObject(this._parser.parse(name), null, CLASSNAME_FOR_NULLOBJ, ctxIDStringsHolder);
            }
            catch (InvalidName in) {
                RasUtil.logException((Throwable)in, _tc, CLASS_NAME, "doBind", "1937", this);
                InvalidNameException ne = new InvalidNameException(name.toString());
                ne.initCause(in);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doBind", ne);
                }
                throw ne;
            }
            catch (NotFound nf) {
                RasUtil.logException((Throwable)nf, _tc, CLASS_NAME, "doBind", "1944", this);
                NamingException ne = this.mapNotFoundException(nf, name);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doBind", ne);
                }
                throw ne;
            }
            catch (AlreadyBound ab) {
                RasUtil.logException((Throwable)ab, _tc, CLASS_NAME, "doBind", "1951", this);
                NameAlreadyBoundException ne = new NameAlreadyBoundException(name.toString());
                ne.initCause(ab);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doBind", ne);
                }
                throw ne;
            }
            catch (NamingException e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doBind", "1958", this);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doBind", e.toString());
                }
                throw e;
            }
            catch (INV_OBJREF e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doBind", "1963", this);
                NamingException ne = this.mapINV_OBJREF(e, name);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doBind", ne.toString());
                }
                throw ne;
            }
            catch (IMP_LIMIT e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doBind", "1970", this);
                NamingException ne = this.mapIMP_LIMIT(e, "bind", name, false);
                if (ne == null) {
                    ne = new NamingException("Cannot bind \"" + name + "\" from context \"" + this.getContextName() + "\".  Received an unexpected org.omg.CORBA.IMP_LIMIT exception.");
                    ne.initCause(e);
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doBind", ne);
                }
                throw ne;
            }
            catch (NO_PERMISSION e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doBind", "1981", this);
                NoPermissionException ne = new NoPermissionException("NO_PERMISSION exception caught");
                ne.initCause(e);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doBind", ne);
                }
                throw ne;
            }
            catch (Exception e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doBind", "1988", this);
                NamingException ne = new NamingException(name.toString());
                ne.initCause(e);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doBind", ne);
                }
                throw ne;
            }
        }
        if (this._caching) {
            ContextID[] ctxIDs = this.stringsToContextIDs(ctxIDStringsHolder.value);
            if (objToCache instanceof CNContextImpl) {
                this._cache.createSubcontext(this, name, ctxIDs, (CNContextImpl)objToCache);
            } else {
                this._cache.bind(this, name, ctxIDs, objToCache, null);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doBind");
        }
    }

    protected void doRebind(Name name, java.lang.Object obj) throws NamingException {
        java.lang.Object objToCache;
        ContextIDStringsHolder ctxIDStringsHolder;
        block27: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "doRebind", new String[]{"name=" + name, "obj=" + obj});
            }
            ctxIDStringsHolder = new ContextIDStringsHolder();
            objToCache = obj;
            try {
                objToCache = obj = Helpers.extractCtxImplFromInitCtx(obj);
                if (obj != null) {
                    objToCache = obj = Helpers.processRemoteObjectForBinding(obj, this._orb);
                    String className = obj.getClass().getName();
                    if (obj instanceof Object) {
                        this.cosRebindCorbaObject(this._parser.parse(name), (Object)obj, className, ctxIDStringsHolder);
                        break block27;
                    }
                    if (obj instanceof CNContextImpl) {
                        this.cosRebindContext(this._parser.parse(name), ((CNContextImpl)obj).getCosContext(), ctxIDStringsHolder);
                        break block27;
                    }
                    byte[] serializedObject = null;
                    try {
                        StringBuffer classNameBuff = new StringBuffer(64);
                        serializedObject = (byte[])Helpers.processJavaObjectForBinding(obj, true, classNameBuff);
                        className = classNameBuff.toString();
                    }
                    catch (IOException e) {
                        RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRebind", "2048", this);
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "doRebind", e);
                        }
                        throw e;
                    }
                    catch (CannotBindObjectException e) {
                        RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRebind", "2053", this);
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "doRebind", e);
                        }
                        throw e;
                    }
                    objToCache = serializedObject;
                    this.cosRebindJavaObject(this._parser.parse(name), className, serializedObject, ctxIDStringsHolder);
                    break block27;
                }
                this.cosRebindCorbaObject(this._parser.parse(name), null, CLASSNAME_FOR_NULLOBJ, ctxIDStringsHolder);
            }
            catch (InvalidName in) {
                RasUtil.logException((Throwable)in, _tc, CLASS_NAME, "doRebind", "2070", this);
                InvalidNameException ne = new InvalidNameException(name.toString());
                ne.initCause(in);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doRebind", ne);
                }
                throw ne;
            }
            catch (NotFound nf) {
                RasUtil.logException((Throwable)nf, _tc, CLASS_NAME, "doRebind", "2077", this);
                NamingException ne = this.mapNotFoundException(nf, name);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doRebind", ne);
                }
                throw ne;
            }
            catch (IMP_LIMIT e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRebind", "2084", this);
                NamingException ne = this.mapIMP_LIMIT(e, "rebind", name, false);
                if (ne == null) {
                    ne = new CannotUnbindSubcontextException("Cannot unbind context \"" + name + "\". The existing binding is a primary context binding.");
                    ne.initCause(e);
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doRebind", ne);
                }
                throw ne;
            }
            catch (INV_OBJREF e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRebind", "2095", this);
                NamingException ne = this.mapINV_OBJREF(e, name);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doRebind", ne.toString());
                }
                throw ne;
            }
            catch (NamingException e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRebind", "2102", this);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doRebind", e.toString());
                }
                throw e;
            }
            catch (NO_PERMISSION e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRebind", "2107", this);
                NoPermissionException ne = new NoPermissionException("NO_PERMISSION exception caught");
                ne.initCause(e);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doRebind", ne);
                }
                throw ne;
            }
            catch (Exception e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRebind", "2114", this);
                NamingException ne = new NamingException(name.toString());
                ne.initCause(e);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "doRebind", ne);
                }
                throw ne;
            }
        }
        if (this._caching) {
            ContextID[] ctxIDs = this.stringsToContextIDs(ctxIDStringsHolder.value);
            this._cache.rebind(this, name, ctxIDs, objToCache, null);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doRebind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUnbind(Name name) throws NamingException {
        Name nameToSubcontext;
        CNContextImpl targetCtx;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doUnbind", "name=" + name);
        }
        if (name.size() > 1 && (targetCtx = this.resolveContext(nameToSubcontext = name.getPrefix(name.size() - 1))) == null) {
            NotContextException ne = new NotContextException("The object bound with the name \"" + nameToSubcontext + "\" relative to the context \"" + this.getContextName() + "\" is not a context.");
            if (!_tc.isEntryEnabled()) throw ne;
            Tr.exit(_tc, "doUnind", ne);
            throw ne;
        }
        TransactionUtil.TransactionWrapper txWrapper = null;
        try {
            txWrapper = TransactionUtil.suspend();
            Subject savedSubject = null;
            boolean restoreSubject = false;
            try {
                if (this._securityEnabled) {
                    savedSubject = SecurityUtil.getRunAsSubject();
                    Subject subject = this.login();
                    SecurityUtil.setRunAsSubject(subject);
                    restoreSubject = true;
                }
                this._corbaNC.unbind(this._parser.parse(name));
            }
            catch (NotFound e) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "doUnbind", "eat NotFound exception per JNDI spec");
                }
            }
            catch (InvalidName e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doUnbind", "2186", this);
                InvalidNameException ne = new InvalidNameException(name.toString());
                ne.initCause(e);
                if (!_tc.isEntryEnabled()) throw ne;
                Tr.exit(_tc, "doUnbind", ne);
                throw ne;
                catch (IMP_LIMIT e2) {
                    RasUtil.logException((Throwable)e2, _tc, CLASS_NAME, "doUnbind", "2193", this);
                    NamingException ne2 = this.mapIMP_LIMIT(e2, "unbind", name, false);
                    if (ne2 == null) {
                        ne2 = new CannotUnbindSubcontextException("Cannot unbind context \"" + name + "\". A context can be unbound only from a context from which it was bound.");
                        ne2.initCause(e2);
                    }
                    if (!_tc.isEntryEnabled()) throw ne2;
                    Tr.exit(_tc, "doUnbind", ne2);
                    throw ne2;
                }
                catch (INV_OBJREF e3) {
                    RasUtil.logException((Throwable)e3, _tc, CLASS_NAME, "doUnbind", "2204", this);
                    NamingException ne3 = this.mapINV_OBJREF(e3, name);
                    if (!_tc.isEntryEnabled()) throw ne3;
                    Tr.exit(_tc, "doUnbind", ne3.toString());
                    throw ne3;
                }
                catch (NO_PERMISSION e4) {
                    RasUtil.logException((Throwable)e4, _tc, CLASS_NAME, "doUnbind", "2211", this);
                    NoPermissionException ne4 = new NoPermissionException("NO_PERMISSION exception caught");
                    ne4.initCause(e4);
                    if (!_tc.isEntryEnabled()) throw ne4;
                    Tr.exit(_tc, "doUnbind", ne4);
                    throw ne4;
                }
                catch (Exception e5) {
                    RasUtil.logException((Throwable)e5, _tc, CLASS_NAME, "doUnbind", "2218", this);
                    NamingException ne5 = new NamingException(e5.toString());
                    ne5.initCause(e5);
                    if (!_tc.isEntryEnabled()) throw ne5;
                    Tr.exit(_tc, "doUnbind", ne5);
                    throw ne5;
                }
            }
            finally {
                if (restoreSubject && this._jndiOnly) {
                    SecurityUtil.setRunAsSubject(savedSubject);
                }
            }
        }
        finally {
            TransactionUtil.resume(txWrapper);
        }
        if (this._caching) {
            this._cache.unbind(this, name, null);
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "doUnbind");
    }

    protected void doRename(Name oldName, Name newName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doRename", new String[]{"oldName=" + oldName, "newName=" + newName});
        }
        java.lang.Object object = this.doLookup(oldName, false, new BooleanWrapper(false), new JavaObjectHolder());
        this.doUnbind(oldName);
        boolean restoreOldBinding = false;
        try {
            this.doBind(newName, object);
        }
        catch (NameAlreadyBoundException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRename", "2261", this);
            restoreOldBinding = true;
            NameAlreadyBoundException ne = new NameAlreadyBoundException("Error renaming \"" + oldName + "\" to \"" + newName + "\"");
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doRename", ne);
            }
            throw ne;
        }
        catch (NamingException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRename", "2270", this);
            restoreOldBinding = true;
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doRename", e.toString());
            }
            throw e;
        }
        catch (Exception e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRename", "2276", this);
            restoreOldBinding = true;
            NamingException ne = new NamingException("Error renaming \"" + oldName + "\" to \"" + newName + "\"");
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doRename", ne);
            }
            throw ne;
        }
        finally {
            if (restoreOldBinding) {
                try {
                    this.doBind(oldName, object);
                }
                catch (Exception e) {
                    RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRename", "2289", this);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doRename");
        }
    }

    protected Context doCreateSubcontext(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doCreateSubcontext", "name=" + name);
        }
        org.omg.CosNaming.NamingContext newNC = null;
        ContextIDStringsHolder ctxIDStringsHolder = new ContextIDStringsHolder();
        StringHolder ctxIDStringHolder = new StringHolder();
        NameHolder ctxPrimaryNameHolder = new NameHolder();
        try {
            newNC = this.cosBindNewContext(this._parser.parse(name), ctxIDStringsHolder, ctxIDStringHolder, ctxPrimaryNameHolder);
        }
        catch (AlreadyBound e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doCreateSubcontext", "2312", this);
            NameAlreadyBoundException ne = new NameAlreadyBoundException(name.toString());
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doCreateSubcontext", ne);
            }
            throw ne;
        }
        catch (NotFound nf) {
            RasUtil.logException((Throwable)nf, _tc, CLASS_NAME, "doCreateSubcontext", "2319", this);
            NamingException ne = this.mapNotFoundException(nf, name);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doCreateSubcontext", ne);
            }
            throw ne;
        }
        catch (INV_OBJREF e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doCreateSubcontext", "2326", this);
            NamingException ne = this.mapINV_OBJREF(e, name);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doCreateSubcontext", ne.toString());
            }
            throw ne;
        }
        catch (IMP_LIMIT e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doCreateSubcontext", "2333", this);
            NamingException ne = this.mapIMP_LIMIT(e, "createSubcontext", name, false);
            if (ne == null) {
                ne = new NamingException("Cannot create subcontext \"" + name + "\" from context \"" + this.getContextName() + "\".  Received an unexpected org.omg.CORBA.IMP_LIMIT exception.");
                ne.initCause(e);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doCreateSubcontext", ne);
            }
            throw ne;
        }
        catch (NO_PERMISSION e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doCreateSubcontext", "2344", this);
            NoPermissionException ne = new NoPermissionException("NO_PERMISSION exception caught");
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doCreateSubcontext", ne);
            }
            throw ne;
        }
        catch (Exception e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doCreateSubcontext", "2351", this);
            NamingException ne = new NamingException(e.toString());
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doCreateSubcontext", ne);
            }
            throw ne;
        }
        try {
            newNC = CNContextImpl.narrowToNamingContext(this._orb, (Object)newNC);
        }
        catch (BAD_PARAM e) {
            // empty catch block
        }
        StringContextID ctxID = new StringContextID(ctxIDStringHolder.value);
        String ctxName = null;
        boolean newContextNameIsPrimary = false;
        if (ctxPrimaryNameHolder.value.length > 0) {
            try {
                ctxName = this._parser.ncToString(ctxPrimaryNameHolder.value);
                newContextNameIsPrimary = true;
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "doCreateSubcontext", "2380", this);
            }
        }
        if (ctxName == null) {
            ctxName = this.fullyQualifiedName(name.toString());
        }
        CNContextImpl subCtx = new CNContextImpl(this._env, this._orb, newNC, ctxName, newContextNameIsPrimary, ctxID, this._cache, this._parser, this._securityAuthentication, this._principal, this._credentials, this._jndiOnly, this._securityEnabled);
        if (this._caching) {
            ContextID[] ctxIDs = this.stringsToContextIDs(ctxIDStringsHolder.value);
            this._cache.createSubcontext(this, name, ctxIDs, subCtx);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doCreateSubcontext", subCtx);
        }
        return subCtx;
    }

    protected void doDestroySubcontext(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doDestroySubcontext", "name=" + name);
        }
        try {
            this.cosDestroy(this._parser.parse(name));
        }
        catch (InvalidName e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doDestroySubcontext", "2414", this);
            InvalidNameException ne = new InvalidNameException(name.toString());
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doDestroySubcontext", ne);
            }
            throw ne;
        }
        catch (NotEmpty e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doDestroySubcontext", "2421", this);
            ContextNotEmptyException ne = new ContextNotEmptyException(name.toString());
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doDestroySubcontext", ne);
            }
            throw ne;
        }
        catch (NotFound e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doDestroySubcontext", "2430", this);
            NamingException ne = this.mapNotFoundException(e, name);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doDestroySubcontext", ne);
            }
            throw ne;
        }
        catch (NameNotFoundException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doDestroySubcontext", "2439", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doDestroySubcontext", e.toString());
            }
            throw e;
        }
        catch (NamingException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doDestroySubcontext", "2444", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doDestroySubcontext", e.toString());
            }
            throw e;
        }
        catch (INV_OBJREF e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doDestroySubcontext", "2449", this);
            NamingException ne = this.mapINV_OBJREF(e, name);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doDestroySubcontext", ne.toString());
            }
            throw ne;
        }
        catch (NO_PERMISSION e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doDestroySubcontext", "2456", this);
            NoPermissionException ne = new NoPermissionException("NO_PERMISSION exception caught");
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doDestroySubcontext", ne);
            }
            throw ne;
        }
        catch (Exception e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doDestroySubcontext", "2463", this);
            NamingException ne = new NamingException("Error destroying subcontext \"" + name + "\"");
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doDestroySubcontext", ne);
            }
            throw ne;
        }
        if (this._caching) {
            this._cache.destroySubcontext(this, name, null);
        }
        if (this._serverType != 3) {
            this.doUnbind(name);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doDestroySubcontext");
        }
    }

    protected NamingEnumeration doList(Name name, EnumType enumType) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doList", new String[]{"name=" + name, "enumType=" + (java.lang.Object)((java.lang.Object)enumType)});
        }
        if (enumType == EnumType.NAME && (this._serverType == 0 || this._serverType == 1)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "doList", "switching from name enum to binding enum to obtain class names; serverType=" + this._serverType);
            }
            enumType = EnumType.BINDING;
        }
        CNContextImpl targetCtx = null;
        CNEnumeration namingEnumeration = null;
        targetCtx = name.size() != 0 ? this.resolveContext(name) : this;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "doList", "targetCtx=" + targetCtx);
        }
        if (targetCtx != null) {
            namingEnumeration = enumType == EnumType.NAME ? new CNNameEnumeration(targetCtx, this._parser) : new CNBindingEnumeration(targetCtx, this._parser);
        } else {
            NotContextException ne = new NotContextException("The object bound with the name \"" + name + "\" relative to the context \"" + this.getContextName() + "\" is not a context.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doList", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doList", namingEnumeration);
        }
        return namingEnumeration;
    }

    protected void doBindIOR(Name name, String ior, boolean isContext, String className) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doBindIOR", new String[]{"name=" + name, "ior=" + ior, "isContext=" + isContext, "className=" + className});
        }
        try {
            this.cosBindIOR(Operation.BIND, this._parser.parse(name), ior, isContext, className);
        }
        catch (InvalidName in) {
            RasUtil.logException((Throwable)in, _tc, CLASS_NAME, "doBindIOR", "2546", this);
            InvalidNameException ne = new InvalidNameException(name.toString());
            ne.initCause(in);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindIOR", ne);
            }
            throw ne;
        }
        catch (NotFound nf) {
            RasUtil.logException((Throwable)nf, _tc, CLASS_NAME, "doBindIOR", "2553", this);
            NamingException ne = this.mapNotFoundException(nf, name);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindIOR", ne);
            }
            throw ne;
        }
        catch (AlreadyBound ab) {
            RasUtil.logException((Throwable)ab, _tc, CLASS_NAME, "doBindIOR", "2560", this);
            NameAlreadyBoundException ne = new NameAlreadyBoundException(name.toString());
            ne.initCause(ab);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindIOR", ne);
            }
            throw ne;
        }
        catch (NamingException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doBindIOR", "2567", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindIOR", e.toString());
            }
            throw e;
        }
        catch (INV_OBJREF e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doBindIOR", "2572", this);
            NamingException ne = this.mapINV_OBJREF(e, name);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindIOR", ne.toString());
            }
            throw ne;
        }
        catch (IMP_LIMIT e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doBindIOR", "2579", this);
            NamingException ne = this.mapIMP_LIMIT(e, "bindIOR", name, false);
            if (ne == null) {
                ne = new NamingException("Cannot bind \"" + name + "\" from context \"" + this.getContextName() + "\".  Received an unexpected org.omg.CORBA.IMP_LIMIT exception.");
                ne.initCause(e);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindIOR", ne);
            }
            throw ne;
        }
        catch (NO_PERMISSION e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doBindIOR", "2590", this);
            NoPermissionException ne = new NoPermissionException("NO_PERMISSION exception caught");
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindIOR", ne);
            }
            throw ne;
        }
        catch (Exception e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doBindIOR", "2597", this);
            NamingException ne = new NamingException(name.toString());
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindIOR", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doBindIOR");
        }
    }

    protected void doRebindIOR(Name name, String ior, boolean isContext, String className) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doRebindIOR", new String[]{"name=" + name, "ior=" + ior, "isContext=" + isContext, "className=" + className});
        }
        try {
            this.cosBindIOR(Operation.REBIND, this._parser.parse(name), ior, isContext, className);
        }
        catch (InvalidName in) {
            RasUtil.logException((Throwable)in, _tc, CLASS_NAME, "doRebindIOR", "2619", this);
            InvalidNameException ne = new InvalidNameException(name.toString());
            ne.initCause(in);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doRebindIOR", ne);
            }
            throw ne;
        }
        catch (NotFound nf) {
            RasUtil.logException((Throwable)nf, _tc, CLASS_NAME, "doRebindIOR", "2626", this);
            NamingException ne = this.mapNotFoundException(nf, name);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doRebindIOR", ne);
            }
            throw ne;
        }
        catch (NamingException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRebindIOR", "2633", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doRebindIOR", e.toString());
            }
            throw e;
        }
        catch (INV_OBJREF e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRebindIOR", "2638", this);
            NamingException ne = this.mapINV_OBJREF(e, name);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doRebindIOR", ne.toString());
            }
            throw ne;
        }
        catch (IMP_LIMIT e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRebindIOR", "2645", this);
            NamingException ne = this.mapIMP_LIMIT(e, "rebindIOR", name, false);
            if (ne == null) {
                ne = new NamingException("Cannot bind \"" + name + "\" from context \"" + this.getContextName() + "\".  Received an unexpected org.omg.CORBA.IMP_LIMIT exception.");
                ne.initCause(e);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doRebindIOR", ne);
            }
            throw ne;
        }
        catch (NO_PERMISSION e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRebindIOR", "2656", this);
            NoPermissionException ne = new NoPermissionException("NO_PERMISSION exception caught");
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doRebindIOR", ne);
            }
            throw ne;
        }
        catch (Exception e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doRebindIOR", "2663", this);
            NamingException ne = new NamingException(name.toString());
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doRebindIOR", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doRebindIOR");
        }
    }

    protected void doBindReference(Operation operation, String method2, Name name, ReferenceData referenceData) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doBindReference", new String[]{"operation=" + (java.lang.Object)((java.lang.Object)operation), "method=" + method2, "name=" + name, "referenceData=" + referenceData});
        }
        try {
            this.cosBindReference(operation, this._parser.parse(name), referenceData);
        }
        catch (InvalidName in) {
            RasUtil.logException((Throwable)in, _tc, CLASS_NAME, "doBindReference", "2685", this);
            InvalidNameException ne = new InvalidNameException(name.toString());
            ne.initCause(in);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindReference", ne);
            }
            throw ne;
        }
        catch (NotFound nf) {
            RasUtil.logException((Throwable)nf, _tc, CLASS_NAME, "doBindReference", "2692", this);
            NamingException ne = this.mapNotFoundException(nf, name);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindReference", ne);
            }
            throw ne;
        }
        catch (AlreadyBound ab) {
            RasUtil.logException((Throwable)ab, _tc, CLASS_NAME, "doBindReference", "2699", this);
            NameAlreadyBoundException ne = new NameAlreadyBoundException(name.toString());
            ne.initCause(ab);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindReference", ne);
            }
            throw ne;
        }
        catch (NamingException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doBindReference", "2706", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindReference", e.toString());
            }
            throw e;
        }
        catch (INV_OBJREF e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doBindReference", "2711", this);
            NamingException ne = this.mapINV_OBJREF(e, name);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindReference", ne.toString());
            }
            throw ne;
        }
        catch (IMP_LIMIT e) {
            NamingException ne = this.mapIMP_LIMIT(e, method2, name, false);
            if (ne == null) {
                ne = new NamingException("Cannot bind \"" + name + "\" from context \"" + this.getContextName() + "\".  Received an unexpected org.omg.CORBA.IMP_LIMIT exception.");
                ne.initCause(e);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindReference", ne);
            }
            throw ne;
        }
        catch (NO_PERMISSION e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "doBindReference", "2728", this);
            NoPermissionException ne = new NoPermissionException("CORBA NO_PERMISSION");
            ne.initCause(e);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindReference", ne);
            }
            throw ne;
        }
        catch (Throwable t) {
            RasUtil.logException(t, _tc, CLASS_NAME, "doBindReference", "2735", this);
            NamingException ne = new NamingException(name.toString());
            ne.initCause(t);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doBindReference", ne);
            }
            throw ne;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doBindReference");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object cosResolve(final NameComponent[] name, final ContextIDStringsHolder ctxIDStringsHolder, final StringHolder ctxIDStringHolder, final AnyHolder anyHolder, final StringHolder classNameHolder, final NameHolder primaryContextNameHolder, BooleanHolder objectMightBeAContext) throws CannotProceed, InvalidName, NotFound, NamingException {
        Object retObj;
        block21: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "cosResolve", "name=" + this._parser.ncToString(name));
            }
            retObj = null;
            StringHolder propNameHolder = new StringHolder();
            final BindingTypeHolder bindingTypeHolder = new BindingTypeHolder();
            final BindingTypeHolder actualObjectTypeHolder = new BindingTypeHolder();
            objectMightBeAContext.value = true;
            TransactionUtil.TransactionWrapper txWrapper = null;
            try {
                txWrapper = TransactionUtil.suspend();
                Subject savedSubject = null;
                boolean restoreSubject = false;
                try {
                    if (this._securityEnabled) {
                        savedSubject = SecurityUtil.getRunAsSubject();
                        Subject subject = this.login();
                        SecurityUtil.setRunAsSubject(subject);
                        restoreSubject = true;
                    }
                    if (this._serverType == 3) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "cosResolve", "calling resolve_complete_info");
                        }
                        try {
                            retObj = Helpers.retry(new RetryableExceptionAction<Object>(){

                                @Override
                                public Object run() throws CannotProceed, InvalidName, NotFound {
                                    return CNContextImpl.this._wsOptNC.resolve_complete_info(name, ctxIDStringsHolder, ctxIDStringHolder, anyHolder, classNameHolder, primaryContextNameHolder, bindingTypeHolder, actualObjectTypeHolder);
                                }
                            });
                        }
                        catch (RetryableActionException rae) {
                            Throwable cause = rae.getCause();
                            if (cause instanceof NotFound) {
                                throw (NotFound)cause;
                            }
                            if (cause instanceof CannotProceed) {
                                throw (CannotProceed)cause;
                            }
                            if (cause instanceof InvalidName) {
                                throw (InvalidName)cause;
                            }
                            assert (false) : "unexpected checked exception";
                            RasUtil.logException((Throwable)rae, _tc, CLASS_NAME, "cosResolve", "2809", this);
                        }
                        if (retObj != null || anyHolder.value.type().kind() == TCKind.tk_null) {
                            anyHolder.value = null;
                        }
                        if (bindingTypeHolder.value == BindingType.nobject) {
                            objectMightBeAContext.value = false;
                        }
                        break block21;
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cosResolve", "calling resolve");
                    }
                    NameComponent[] tmpname = name;
                    retObj = this._corbaNC.resolve(tmpname);
                    ctxIDStringsHolder.value = null;
                    ctxIDStringHolder.value = null;
                    anyHolder.value = null;
                    classNameHolder.value = null;
                    primaryContextNameHolder.value = new NameComponent[0];
                }
                finally {
                    if (restoreSubject && this._jndiOnly) {
                        SecurityUtil.setRunAsSubject(savedSubject);
                    }
                }
            }
            finally {
                TransactionUtil.resume(txWrapper);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cosResolve", retObj);
        }
        return retObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cosBindCorbaObject(NameComponent[] name, Object obj, String className, ContextIDStringsHolder ctxIDStringsHolder) throws AlreadyBound, CannotProceed, NotFound, InvalidName, NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cosBindCorbaObject", new String[]{"name=" + this._parser.ncToString(name), "obj=" + obj});
        }
        if (className == null) {
            className = "";
        }
        TransactionUtil.TransactionWrapper txWrapper = null;
        try {
            txWrapper = TransactionUtil.suspend();
            Subject savedSubject = null;
            boolean restoreSubject = false;
            try {
                if (this._securityEnabled) {
                    savedSubject = SecurityUtil.getRunAsSubject();
                    Subject subject = this.login();
                    SecurityUtil.setRunAsSubject(subject);
                    restoreSubject = true;
                }
                if (this._serverType == 3) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cosBindCorbaObject", "calling bind_corba_object");
                    }
                    this._wsOptNC.bind_corba_object(name, obj, className, ctxIDStringsHolder);
                } else {
                    name = this.prepareName(name, className);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cosBindCorbaObject", "calling bind");
                    }
                    this._corbaNC.bind(name, obj);
                }
            }
            finally {
                if (restoreSubject && this._jndiOnly) {
                    SecurityUtil.setRunAsSubject(savedSubject);
                }
            }
        }
        finally {
            TransactionUtil.resume(txWrapper);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cosBindCorbaObject");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cosBindContext(NameComponent[] name, org.omg.CosNaming.NamingContext obj, ContextIDStringsHolder ctxIDStringsHolder) throws AlreadyBound, CannotProceed, NotFound, InvalidName, NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cosBindContext", new String[]{"name=" + this._parser.ncToString(name), "obj=" + obj});
        }
        TransactionUtil.TransactionWrapper txWrapper = null;
        try {
            txWrapper = TransactionUtil.suspend();
            Subject savedSubject = null;
            boolean restoreSubject = false;
            try {
                if (this._securityEnabled) {
                    savedSubject = SecurityUtil.getRunAsSubject();
                    Subject subject = this.login();
                    SecurityUtil.setRunAsSubject(subject);
                    restoreSubject = true;
                }
                if (this._serverType == 3) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cosBindContext", "calling bind_corba_context");
                    }
                    this._wsOptNC.bind_corba_context(name, obj, "javax.naming.Context", ctxIDStringsHolder);
                } else {
                    name = this.prepareName(name, "javax.naming.Context");
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cosBindContext", "calling bind_context");
                    }
                    this._corbaNC.bind_context(name, obj);
                    ctxIDStringsHolder.value = null;
                }
            }
            finally {
                if (restoreSubject && this._jndiOnly) {
                    SecurityUtil.setRunAsSubject(savedSubject);
                }
            }
        }
        finally {
            TransactionUtil.resume(txWrapper);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cosBindContext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cosBindJavaObject(NameComponent[] name, String className, byte[] serializedObject, ContextIDStringsHolder ctxIDStringsHolder) throws AlreadyBound, CannotProceed, NotFound, InvalidName, NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cosBindJavaObject", new String[]{"name=" + this._parser.ncToString(name), "className=" + className});
        }
        if (className == null) {
            className = "";
        }
        Any propertyValue = this.createReferencePropertyValue(serializedObject);
        TransactionUtil.TransactionWrapper txWrapper = null;
        try {
            txWrapper = TransactionUtil.suspend();
            Subject savedSubject = null;
            boolean restoreSubject = false;
            try {
                if (this._securityEnabled) {
                    savedSubject = SecurityUtil.getRunAsSubject();
                    Subject subject = this.login();
                    SecurityUtil.setRunAsSubject(subject);
                    restoreSubject = true;
                }
                if (this._serverType == 3) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cosBindJavaObject", "calling bind_java_object");
                    }
                    this._wsOptNC.bind_java_object(name, className, propertyValue, ctxIDStringsHolder);
                } else {
                    this.enforcePropertySupport();
                    NameComponent[] tempName = this.prepareName(name, className);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cosBindJavaObject", "calling bind");
                    }
                    this._corbaNC.bind(tempName, null);
                    this.setReferencePropertyValue(name, propertyValue);
                    ctxIDStringsHolder.value = null;
                }
            }
            finally {
                if (restoreSubject && this._jndiOnly) {
                    SecurityUtil.setRunAsSubject(savedSubject);
                }
            }
        }
        finally {
            TransactionUtil.resume(txWrapper);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cosBindJavaObject");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cosRebindCorbaObject(NameComponent[] name, Object obj, String className, ContextIDStringsHolder ctxIDStringsHolder) throws CannotProceed, NotFound, InvalidName, NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cosRebindCorbaObject", new String[]{"name=" + this._parser.ncToString(name), "obj=" + obj, "className=" + className});
        }
        if (className == null) {
            className = "";
        }
        TransactionUtil.TransactionWrapper txWrapper = null;
        try {
            txWrapper = TransactionUtil.suspend();
            Subject savedSubject = null;
            boolean restoreSubject = false;
            try {
                if (this._securityEnabled) {
                    savedSubject = SecurityUtil.getRunAsSubject();
                    Subject subject = this.login();
                    SecurityUtil.setRunAsSubject(subject);
                    restoreSubject = true;
                }
                if (this._serverType == 3) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cosRebindCorbaObject", "calling rebind_corba_object");
                    }
                    this._wsOptNC.rebind_corba_object(name, obj, className, ctxIDStringsHolder);
                } else {
                    name = this.prepareName(name, className);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cosRebindCorbaObject", "calling rebind");
                    }
                    this._corbaNC.rebind(name, obj);
                    ctxIDStringsHolder.value = null;
                }
            }
            finally {
                if (restoreSubject && this._jndiOnly) {
                    SecurityUtil.setRunAsSubject(savedSubject);
                }
            }
        }
        finally {
            TransactionUtil.resume(txWrapper);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cosRebindCorbaObject");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cosRebindContext(NameComponent[] name, org.omg.CosNaming.NamingContext obj, ContextIDStringsHolder ctxIDStringsHolder) throws CannotProceed, NotFound, InvalidName, NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cosRebindContext", new String[]{"name=" + this._parser.ncToString(name), "obj=" + obj});
        }
        TransactionUtil.TransactionWrapper txWrapper = null;
        try {
            txWrapper = TransactionUtil.suspend();
            Subject savedSubject = null;
            boolean restoreSubject = false;
            try {
                if (this._securityEnabled) {
                    savedSubject = SecurityUtil.getRunAsSubject();
                    Subject subject = this.login();
                    SecurityUtil.setRunAsSubject(subject);
                    restoreSubject = true;
                }
                if (this._serverType == 3) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cosRebindContext", "calling rebind_corba_context");
                    }
                    this._wsOptNC.rebind_corba_context(name, obj, "javax.naming.Context", ctxIDStringsHolder);
                } else {
                    name = this.prepareName(name, "javax.naming.Context");
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cosRebindContext", "calling rebind_context");
                    }
                    this._corbaNC.rebind_context(name, obj);
                    ctxIDStringsHolder.value = null;
                }
            }
            finally {
                if (restoreSubject && this._jndiOnly) {
                    SecurityUtil.setRunAsSubject(savedSubject);
                }
            }
        }
        finally {
            TransactionUtil.resume(txWrapper);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cosRebindContext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cosRebindJavaObject(NameComponent[] name, String className, byte[] serializedObject, ContextIDStringsHolder ctxIDStringsHolder) throws CannotProceed, InvalidName, NotFound, NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cosRebindJavaObject", new String[]{"name=" + this._parser.ncToString(name), "className=" + className});
        }
        if (className == null) {
            className = "";
        }
        Any propertyValue = this.createReferencePropertyValue(serializedObject);
        TransactionUtil.TransactionWrapper txWrapper = null;
        try {
            txWrapper = TransactionUtil.suspend();
            Subject savedSubject = null;
            boolean restoreSubject = false;
            try {
                if (this._securityEnabled) {
                    savedSubject = SecurityUtil.getRunAsSubject();
                    Subject subject = this.login();
                    SecurityUtil.setRunAsSubject(subject);
                    restoreSubject = true;
                }
                if (this._serverType == 3) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cosRebindJavaObject", "calling rebind_java_object");
                    }
                    this._wsOptNC.rebind_java_object(name, className, propertyValue, ctxIDStringsHolder);
                } else {
                    this.enforcePropertySupport();
                    NameComponent[] tempName = this.prepareName(name, className);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cosRebindJavaObject", "calling rebind");
                    }
                    this._corbaNC.rebind(tempName, null);
                    this.setReferencePropertyValue(name, propertyValue);
                    ctxIDStringsHolder.value = null;
                }
            }
            finally {
                if (restoreSubject && this._jndiOnly) {
                    SecurityUtil.setRunAsSubject(savedSubject);
                }
            }
        }
        finally {
            TransactionUtil.resume(txWrapper);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cosRebindJavaObject");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.omg.CosNaming.NamingContext cosBindNewContext(NameComponent[] name, ContextIDStringsHolder ctxIDStringsHolder, StringHolder ctxIDStringHolder, NameHolder ctxPrimaryNameHolder) throws AlreadyBound, CannotProceed, NotFound, InvalidName, NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cosBindNewContext", "name=" + this._parser.ncToString(name));
        }
        org.omg.CosNaming.NamingContext retNC = null;
        TransactionUtil.TransactionWrapper txWrapper = null;
        try {
            txWrapper = TransactionUtil.suspend();
            Subject savedSubject = null;
            boolean restoreSubject = false;
            try {
                if (this._securityEnabled) {
                    savedSubject = SecurityUtil.getRunAsSubject();
                    Subject subject = this.login();
                    SecurityUtil.setRunAsSubject(subject);
                    restoreSubject = true;
                }
                if (this._serverType == 3) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cosBindNewContext", "calling bind_new_corba_context");
                    }
                    retNC = this._wsOptNC.bind_new_corba_context(name, "javax.naming.Context", ctxIDStringsHolder, ctxIDStringHolder, ctxPrimaryNameHolder);
                } else {
                    name = this.prepareName(name, "javax.naming.Context");
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cosBindNewContext", "calling bind_new_context");
                    }
                    retNC = this._corbaNC.bind_new_context(name);
                    ctxIDStringsHolder.value = null;
                    ctxIDStringHolder.value = null;
                    ctxPrimaryNameHolder.value = new NameComponent[0];
                }
            }
            finally {
                if (restoreSubject && this._jndiOnly) {
                    SecurityUtil.setRunAsSubject(savedSubject);
                }
            }
        }
        finally {
            TransactionUtil.resume(txWrapper);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cosBindNewContext", retNC);
        }
        return retNC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cosDestroy(NameComponent[] name) throws CannotProceed, NotEmpty, NotFound, InvalidName, NamingException {
        block36: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "cosDestroy", "name=" + this._parser.ncToString(name));
            }
            TransactionUtil.TransactionWrapper txWrapper = null;
            if (this._serverType == 3) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "cosDestroy", "calling destroy_if_primary_name");
                }
                try {
                    txWrapper = TransactionUtil.suspend();
                    Subject savedSubject = null;
                    boolean restoreSubject = false;
                    try {
                        if (this._securityEnabled) {
                            savedSubject = SecurityUtil.getRunAsSubject();
                            Subject subject = this.login();
                            SecurityUtil.setRunAsSubject(subject);
                            restoreSubject = true;
                        }
                        this._wsOptNC.destroy_if_primary_name(name);
                        break block36;
                    }
                    catch (IMP_LIMIT e) {
                        RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "cosDestroy", "3299", this);
                        NamingException ne = this.mapIMP_LIMIT(e, "destroySubcontext", this._parser.ncToName(name), true);
                        if (ne == null) {
                            ne = new CannotDestroySubcontextException("Cannot destroy context \"" + this._parser.ncToString(name) + "\". " + "A context can be destroyed only from a context from which it was created.");
                            ne.initCause(e);
                        }
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "cosDestroy", ne);
                        }
                        throw ne;
                    }
                    finally {
                        if (restoreSubject && this._jndiOnly) {
                            SecurityUtil.setRunAsSubject(savedSubject);
                        }
                    }
                }
                finally {
                    TransactionUtil.resume(txWrapper);
                }
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "cosDestroy", "calling destroy");
            }
            String nameString = this._parser.ncToString(name);
            try {
                txWrapper = TransactionUtil.suspend();
                Subject savedSubject = null;
                boolean restoreSubject = false;
                try {
                    if (this._securityEnabled) {
                        savedSubject = SecurityUtil.getRunAsSubject();
                        Subject subject = this.login();
                        SecurityUtil.setRunAsSubject(subject);
                        restoreSubject = true;
                    }
                    CNContextImpl contextToDestroy = null;
                    try {
                        contextToDestroy = this.resolveContext(this._parser.ncToName(name));
                    }
                    catch (NameNotFoundException e) {
                        NameComponent[] parentName = new NameComponent[name.length - 1];
                        System.arraycopy(name, 0, parentName, 0, name.length - 1);
                        CNContextImpl parent = this.resolveContext(this._parser.ncToName(parentName));
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "cosDestroy");
                        }
                        if (restoreSubject && this._jndiOnly) {
                            SecurityUtil.setRunAsSubject(savedSubject);
                        }
                        TransactionUtil.resume(txWrapper);
                        return;
                    }
                    if (contextToDestroy != null) {
                        CNContextImpl tmpCtx = contextToDestroy;
                        tmpCtx._corbaNC.destroy();
                        break block36;
                    }
                    NotContextException ne = new NotContextException("The object bound with the name \"" + nameString + "\" relative to the context \"" + this.getContextName() + "\" is not a context.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "cosDestroy", ne);
                    }
                    throw ne;
                }
                catch (IMP_LIMIT e) {
                    RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "cosDestroy", "3371", this);
                    NamingException ne = this.mapIMP_LIMIT(e, "destroySubcontext", this._parser.ncToName(name), true);
                    if (ne != null) {
                        throw ne;
                    }
                }
                finally {
                    if (restoreSubject && this._jndiOnly) {
                        SecurityUtil.setRunAsSubject(savedSubject);
                    }
                }
            }
            finally {
                TransactionUtil.resume(txWrapper);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cosDestroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cosBindIOR(Operation operation, NameComponent[] name, String stringifiedIOR, boolean isContext, String className) throws AlreadyBound, CannotProceed, NotFound, InvalidName, OperationNotSupportedException, NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cosBindIOR", new String[]{"operation=" + (java.lang.Object)((java.lang.Object)operation), "name=" + this._parser.ncToString(name), "stringifiedIOR=" + stringifiedIOR, "isContext=" + isContext, "className=" + className});
        }
        if (this._wsOptNC == null) {
            OperationNotSupportedException ne = new OperationNotSupportedException("IOR bindings are not supported by the server NamingContext implementation corresponding to this JNDI Context.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "cosBindIOR", ne);
            }
            throw ne;
        }
        if (className == null) {
            className = isContext ? "javax.naming.Context" : CLASSNAME_FOR_NULLOBJ;
        }
        TransactionUtil.TransactionWrapper txWrapper = null;
        try {
            txWrapper = TransactionUtil.suspend();
            Subject savedSubject = null;
            boolean restoreSubject = false;
            try {
                boolean iorBindingsSupported;
                block27: {
                    if (this._securityEnabled) {
                        savedSubject = SecurityUtil.getRunAsSubject();
                        Subject subject = this.login();
                        SecurityUtil.setRunAsSubject(subject);
                        restoreSubject = true;
                    }
                    iorBindingsSupported = true;
                    if (this._wsOptNC != null) {
                        try {
                            if (isContext) {
                                if (operation == Operation.BIND) {
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "cosBindIOR", "calling bind_corba_context_via_ior_string");
                                    }
                                    this._wsOptNC.bind_corba_context_via_ior_string(name, stringifiedIOR, className);
                                } else {
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "cosBindIOR", "calling rebind_corba_context_via_ior_string");
                                    }
                                    this._wsOptNC.rebind_corba_context_via_ior_string(name, stringifiedIOR, className);
                                }
                                break block27;
                            }
                            if (operation == Operation.BIND) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "cosBindIOR", "calling bind_corba_object_via_ior_string");
                                }
                                this._wsOptNC.bind_corba_object_via_ior_string(name, stringifiedIOR, className);
                                break block27;
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "cosBindIOR", "calling rebind_corba_object_via_ior_string");
                            }
                            this._wsOptNC.rebind_corba_object_via_ior_string(name, stringifiedIOR, className);
                        }
                        catch (BAD_OPERATION e) {
                            iorBindingsSupported = false;
                        }
                    } else {
                        iorBindingsSupported = false;
                    }
                }
                if (!iorBindingsSupported) {
                    OperationNotSupportedException ne = new OperationNotSupportedException("IOR bindings are not supported by the server NamingContext implementation corresponding to this JNDI Context.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "cosBindIOR", ne);
                    }
                    throw ne;
                }
            }
            finally {
                if (restoreSubject && this._jndiOnly) {
                    SecurityUtil.setRunAsSubject(savedSubject);
                }
            }
        }
        finally {
            TransactionUtil.resume(txWrapper);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cosBindIOR");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cosBindReference(Operation operation, NameComponent[] name, ReferenceData referenceData) throws AlreadyBound, CannotProceed, NotFound, InvalidName, OperationNotSupportedException, NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cosBindReference", new String[]{"operation=" + (java.lang.Object)((java.lang.Object)operation), "name=" + this._parser.ncToString(name), "referenceData=" + referenceData});
        }
        TransactionUtil.TransactionWrapper txWrapper = null;
        try {
            txWrapper = TransactionUtil.suspend();
            boolean referenceBindingsSupported = true;
            Subject savedSubject = null;
            boolean restoreSubject = false;
            try {
                block17: {
                    if (this._securityEnabled) {
                        savedSubject = SecurityUtil.getRunAsSubject();
                        Subject subject = this.login();
                        SecurityUtil.setRunAsSubject(subject);
                        restoreSubject = true;
                    }
                    if (this._wsOptNC != null) {
                        try {
                            if (operation == Operation.BIND) {
                                this._wsOptNC.bind_reference(name, referenceData.toReferenceProperties());
                                break block17;
                            }
                            this._wsOptNC.rebind_reference(name, referenceData.toReferenceProperties());
                        }
                        catch (BAD_OPERATION e) {
                            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "cosBindReference", "3536", this);
                            referenceBindingsSupported = false;
                        }
                    } else {
                        referenceBindingsSupported = false;
                    }
                }
                if (!referenceBindingsSupported) {
                    OperationNotSupportedException ne = new OperationNotSupportedException("Reference bindings are not supported by the server NamingContext implementation corresponding to this JNDI Context.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "cosBindReference", ne);
                    }
                    throw ne;
                }
            }
            finally {
                if (restoreSubject && this._jndiOnly) {
                    SecurityUtil.setRunAsSubject(savedSubject);
                }
            }
        }
        finally {
            TransactionUtil.resume(txWrapper);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cosBindReference");
        }
    }

    protected java.lang.Object processResolveResults(NameComponent[] name, String nameString, java.lang.Object obj, Any javaObjAny, boolean objectMightBeAContext, String className, NameComponent[] primaryContextName, String ctxIDString, String[] parentCtxIDStrings, JavaObjectHolder unprocessedJavaObject) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processResolveResults", new String[]{"name=" + this._parser.ncToString(name), "nameString=" + nameString, "obj=" + obj, "javaObjAny=" + javaObjAny, "objectMightBeAContext=" + objectMightBeAContext, "className=" + className, "primaryContextName=" + Arrays.toString(primaryContextName), "ctxIDString=" + ctxIDString, "parentCtxIDStrings=" + Arrays.toString(parentCtxIDStrings)});
        }
        BooleanWrapper isCacheableReference = new BooleanWrapper(false);
        java.lang.Object objToCache = obj;
        if (obj != null) {
            org.omg.CosNaming.NamingContext ncObj = null;
            if (objectMightBeAContext) {
                try {
                    ncObj = CNContextImpl.narrowToNamingContext(this._orb, (Object)obj);
                }
                catch (BAD_PARAM e) {
                    // empty catch block
                }
            }
            if (ncObj != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "processResolveResults", "obj is context");
                }
                StringContextID ctxID = null;
                if (ctxIDString != null) {
                    ctxID = new StringContextID(ctxIDString);
                }
                String ctxName = null;
                boolean contextNameIsPrimary = false;
                if (primaryContextName.length > 0) {
                    try {
                        ctxName = this._parser.ncToString(primaryContextName);
                        contextNameIsPrimary = true;
                    }
                    catch (Throwable t) {
                        RasUtil.logException(t, _tc, CLASS_NAME, "processResolveResults", "3625", this);
                    }
                }
                if (ctxName == null) {
                    ctxName = this.fullyQualifiedName(nameString);
                }
                objToCache = obj = new CNContextImpl(this._env, this._orb, ncObj, ctxName, contextNameIsPrimary, ctxID, this._cache, this._parser, this._securityAuthentication, this._principal, this._credentials, this._jndiOnly, this._securityEnabled);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "processResolveResults", "obj is non-context remote");
            }
        } else {
            if (this.serverHasPropertySupport()) {
                java.lang.Object any = null;
                try {
                    javaObjAny = this.getReferencePropertyValue(name);
                }
                catch (PropertyNotFound ex) {
                    RasUtil.logException((Throwable)((java.lang.Object)ex), _tc, CLASS_NAME, "processResolveResults", "3656", this);
                }
                catch (NotFound ex) {
                    RasUtil.logException((Throwable)ex, _tc, CLASS_NAME, "processResolveResults", "3658", this);
                }
            }
            if (javaObjAny != null && javaObjAny.type().kind() != TCKind.tk_null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "processResolveResults", "obj is a Java object");
                }
                byte[] serializedObject = this.extractReferencePropertyValue(javaObjAny);
                objToCache = serializedObject;
                try {
                    obj = Helpers.processSerializedObjectForLookup(serializedObject, this, nameString, className, this._env, unprocessedJavaObject, isCacheableReference);
                }
                catch (UnresolvedURLException e) {
                    RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "processResolveResults", "3677", this);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "processResolveResults", e);
                    }
                    throw e;
                }
                catch (CannotInstantiateObjectException e) {
                    RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "processResolveResults", "3682", this);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "processResolveResults", e);
                    }
                    throw e;
                }
                catch (InvalidObjectException e) {
                    RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "processResolveResults", "3687", this);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "processResolveResults", e);
                    }
                    throw e;
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "processResolveResults", "obj is null");
            }
        }
        if (this._caching) {
            if (Helpers.isCacheable(parentCtxIDStrings)) {
                Name jndiName = this._parser.parse(nameString);
                ContextID[] ctxIDs = this.stringsToContextIDs(parentCtxIDStrings);
                if (objToCache instanceof CNContextImpl) {
                    this._cache.createSubcontext(this, jndiName, ctxIDs, (CNContextImpl)objToCache);
                } else {
                    CacheableReference cacheableReference = null;
                    if (isCacheableReference.value) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "processResolveResults", "Caching CacheableReference results.");
                        }
                        objToCache = obj;
                        cacheableReference = (CacheableReference)unprocessedJavaObject.value;
                    }
                    this._cache.bind(this, jndiName, ctxIDs, objToCache, cacheableReference);
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "processResolveResults", "object cannot be cached");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processResolveResults", obj);
        }
        return obj;
    }

    private CNContextImpl resolveContext(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "resolveContext", "name=" + name);
        }
        java.lang.Object object = null;
        try {
            object = this.cacheLookup(name, null, new JavaObjectHolder());
        }
        catch (CacheEntryNotFoundException e) {
            object = this.lookup(name);
        }
        CNContextImpl cnCtx = null;
        if (object instanceof CNContextImpl) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "resolveContext", "resolved object is a CNContextImpl");
            }
            cnCtx = (CNContextImpl)object;
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "resolveContext", "resolved object is not a CNContextImpl");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "resolveContext", cnCtx);
        }
        return cnCtx;
    }

    protected ContextID[] stringsToContextIDs(String[] strings) {
        ContextID[] contextIDs = new ContextID[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            contextIDs[i] = new StringContextID(strings[i]);
        }
        return contextIDs;
    }

    @Override
    public org.omg.CosNaming.NamingContext getCosContext() {
        return this._corbaNC;
    }

    @Override
    public int getServerType() {
        return this._serverType;
    }

    protected boolean serverHasPropertySupport() {
        return this._serverType == 2 || this._serverType == 1;
    }

    protected void enforcePropertySupport() throws OperationNotSupportedException {
        if (!this.serverHasPropertySupport()) {
            OperationNotSupportedException onse = new OperationNotSupportedException("Cannot perform this operation with an unknown org.omg.CosNaming.NamingContext implementation.");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "enforcePropertySupport", onse);
            }
            throw onse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Any getReferencePropertyValue(NameComponent[] name) throws NotFound, PropertyNotFound, NamingException {
        Any any;
        block18: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getReferencePropertyValue");
            }
            any = null;
            TransactionUtil.TransactionWrapper txWrapper = null;
            try {
                txWrapper = TransactionUtil.suspend();
                Subject savedSubject = null;
                boolean restoreSubject = false;
                try {
                    if (this._securityEnabled) {
                        savedSubject = SecurityUtil.getRunAsSubject();
                        Subject subject = this.login();
                        SecurityUtil.setRunAsSubject(subject);
                        restoreSubject = true;
                    }
                    if (this._serverType == 2) {
                        any = this._omgExtNC.get_property_value(name, "::Reference");
                        break block18;
                    }
                    if (this._serverType == 1) {
                        any = this._ibmExtNC.get_property_value(name, "StreamedObjectValue");
                        break block18;
                    }
                    OperationNotSupportedException ne = new OperationNotSupportedException("Cannot perform this operation with an unknown org.omg.CosNaming.NamingContext implementation.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getReferencePropertyValue", ne);
                    }
                    throw ne;
                }
                catch (InvalidPropertyName e) {
                    RasUtil.logException((Throwable)((java.lang.Object)e), _tc, CLASS_NAME, "getReferencePropertyValue", "3860", this);
                    Tr.warning(_tc, "jcosInvPropIgnored");
                }
                catch (PropertyNotFound e) {
                    RasUtil.logException((Throwable)((java.lang.Object)e), _tc, CLASS_NAME, "getReferencePropertyValue", "3864", this);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getReferencePropertyValue", (java.lang.Object)e);
                    }
                    throw e;
                }
                finally {
                    if (restoreSubject && this._jndiOnly) {
                        SecurityUtil.setRunAsSubject(savedSubject);
                    }
                }
            }
            finally {
                TransactionUtil.resume(txWrapper);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getReferencePropertyValue", any);
        }
        return any;
    }

    protected Any createReferencePropertyValue(byte[] serializedObject) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createReferencePropertyValue", "serializedObject=" + serializedObject);
        }
        Any propertyValue = this._orb.create_any();
        if (this._serverType == 1) {
            String objString = Serialization.bytesToString(serializedObject);
            propertyValue.insert_string(objString);
        } else {
            propertyValue.insert_Value((Serializable)serializedObject);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createReferencePropertyValue", propertyValue);
        }
        return propertyValue;
    }

    protected byte[] extractReferencePropertyValue(Any propertyValue) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "extractReferencePropertyValue", "propertyValue=" + propertyValue);
        }
        byte[] serializedObject = null;
        if (this._serverType == 1) {
            String objString = propertyValue.extract_string();
            serializedObject = Serialization.stringToBytes(objString);
        } else {
            serializedObject = (byte[])propertyValue.extract_Value();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "extractReferencePropertyValue", serializedObject);
        }
        return serializedObject;
    }

    /*
     * Exception decompiling
     */
    protected void setReferencePropertyValue(NameComponent[] name, Any value) throws NotFound, NamingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected java.lang.Object cacheLookup(Name name, String[] parentCtxIDStrings, JavaObjectHolder javaObjHolder) throws CacheEntryNotFoundException, NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cacheLookup", new String[]{"name=" + name, "parentCtxIDStrings=" + Arrays.toString(parentCtxIDStrings)});
        }
        java.lang.Object obj = null;
        java.lang.Object objToCache = null;
        if (this._caching) {
            JavaObjectHolder cacheableReferenceHolder = new JavaObjectHolder(null);
            obj = this._cache.lookup(this, name, cacheableReferenceHolder);
            if (obj instanceof CNContextImpl) {
                CNContextImpl ctx = (CNContextImpl)obj;
                if (!ctx.isContextNamePrimary()) {
                    ctx.setContextName(this.fullyQualifiedName(name.toString()), false);
                }
            } else if (obj instanceof byte[] && cacheableReferenceHolder.value == null) {
                BooleanWrapper isCacheableReference = new BooleanWrapper(false);
                try {
                    objToCache = obj;
                    obj = Helpers.processSerializedObjectForLookup((byte[])obj, this, name.toString(), null, this._env, javaObjHolder, isCacheableReference);
                }
                catch (CannotInstantiateObjectException e) {
                    RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "cacheLookup", "4021", this);
                    CacheEntryNotFoundException ne = new CacheEntryNotFoundException("Error processing cached object.");
                    ne.initCause(e);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "cacheLookup", ne);
                    }
                    throw ne;
                }
                catch (InvalidObjectException e) {
                    RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "cacheLookup", "4031", this);
                    CacheEntryNotFoundException ne = new CacheEntryNotFoundException("Error processing cached object.");
                    ne.initCause(e);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "cacheLookup", ne);
                    }
                    throw ne;
                }
                CacheableReference cacheableReference = null;
                if (isCacheableReference.value && parentCtxIDStrings != null) {
                    objToCache = obj;
                    cacheableReference = (CacheableReference)javaObjHolder.value;
                    ContextID[] ctxIDs = this.stringsToContextIDs(parentCtxIDStrings);
                    this._cache.rebind(this, name, ctxIDs, objToCache, cacheableReference);
                }
            } else if (cacheableReferenceHolder.value != null) {
                javaObjHolder.value = cacheableReferenceHolder.value;
            }
        } else {
            CacheEntryNotFoundException cenfe = new CacheEntryNotFoundException("Not caching.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "cacheLookup", cenfe.toString());
            }
            throw cenfe;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cacheLookup", obj);
        }
        return obj;
    }

    protected NameComponent[] prepareName(NameComponent[] name, String className) {
        if (this._serverType != 2) {
            return name;
        }
        NameComponent[] newName = new NameComponent[name.length];
        for (int i = 0; i < name.length; ++i) {
            NameComponent nc;
            newName[i] = nc = new NameComponent(name[i].id, name[i].kind);
        }
        if (className == null || className.length() == 0) {
            className = CLASSNAME_FOR_JAVAOBJ;
        }
        newName[name.length - 1].kind = className;
        return newName;
    }

    protected String fullyQualifiedName(String name) {
        String fullyQualifiedName = null;
        fullyQualifiedName = name == null || name.equals("") ? this._contextName : this._contextName + NAME_DELIMITER + name;
        return fullyQualifiedName;
    }

    protected String getContextName() {
        return this._contextName;
    }

    protected void setContextName(String contextName, boolean primaryName) {
        this._contextName = contextName;
        this._contextNameIsPrimary = primaryName;
    }

    @Override
    public boolean isContextNamePrimary() {
        return this._contextNameIsPrimary;
    }

    @Override
    public ContextID getContextID() {
        ContextID contextID = null;
        contextID = this._contextID != null ? this._contextID : new StringContextID(this._orb.object_to_string((Object)this._corbaNC));
        return contextID;
    }

    @Override
    public UuidContext cloneContext() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cloneContext");
        }
        CNContextImpl clone = new CNContextImpl(this._env, this._orb, this._corbaNC, this._contextName, this._contextNameIsPrimary, this._contextID, this._cache, this._parser, this._securityAuthentication, this._principal, this._credentials, this._jndiOnly, this._securityEnabled);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cloneContext", clone);
        }
        return clone;
    }

    @Override
    public UuidContext copyContext(UuidContext ctx) throws IllegalArgumentException, NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "copyContext", "ctx=" + ctx);
        }
        Hashtable<?, ?> env = null;
        if (ctx instanceof CNContextImpl) {
            env = ((CNContextImpl)ctx)._env;
        } else if (ctx instanceof Context) {
            env = ((CNContextImpl)ctx).getEnvironment();
        } else {
            IllegalArgumentException iae = new IllegalArgumentException("Input argument is not a context.");
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "copyContext", iae);
            }
            throw iae;
        }
        WsnNameParser nameParser = WsnNameParser.getParser(env);
        CNContextImpl copy = new CNContextImpl(env, this._orb, this._corbaNC, this._contextName, this._contextNameIsPrimary, this._contextID, this._cache, nameParser, this._securityAuthentication, this._principal, this._credentials, this._jndiOnly, this._securityEnabled);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "copyContext", copy);
        }
        return copy;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append('[');
        stringBuilder.append(this.getContextName());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toDebugString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(", _env=");
        stringBuilder.append(this._env);
        stringBuilder.append(", _orb=");
        stringBuilder.append(this._orb);
        stringBuilder.append(", _corbaNC=");
        stringBuilder.append(this._corbaNC);
        stringBuilder.append(", _omgExtNC=");
        stringBuilder.append(this._omgExtNC);
        stringBuilder.append(", _ibmExtNC=");
        stringBuilder.append(this._ibmExtNC);
        stringBuilder.append(", _wsOptNC=");
        stringBuilder.append(this._wsOptNC);
        stringBuilder.append(", _batchModeContext=");
        stringBuilder.append(this._batchModeContext);
        stringBuilder.append(", _contextName=");
        stringBuilder.append(this._contextName);
        stringBuilder.append(", _contextNameIsPrimary=");
        stringBuilder.append(this._contextNameIsPrimary);
        stringBuilder.append(", _contextID=");
        stringBuilder.append(this._contextID);
        stringBuilder.append(", _cache=");
        stringBuilder.append(this._cache);
        stringBuilder.append(", _parser=");
        stringBuilder.append(this._parser);
        stringBuilder.append(", _securityAuthentication=");
        stringBuilder.append((java.lang.Object)this._securityAuthentication);
        stringBuilder.append(", _principal=");
        stringBuilder.append(this._principal);
        stringBuilder.append(", _credentials=");
        stringBuilder.append(this._credentials);
        stringBuilder.append(", _jndiOnly=");
        stringBuilder.append(this._jndiOnly);
        stringBuilder.append(", _securityEnabled=");
        stringBuilder.append(this._securityEnabled);
        stringBuilder.append(", _serverType=");
        stringBuilder.append(this._serverType);
        stringBuilder.append(", _caching=");
        stringBuilder.append(this._caching);
        stringBuilder.append(", _closed=");
        stringBuilder.append(this._closed);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private NamingException mapNotFoundException(NotFound nf, Name name) {
        String msgPrefix = "Context: " + this.getContextName() + ", name: " + name + ": ";
        if (nf.rest_of_name.length != 0) {
            String rest_of_name = null;
            try {
                rest_of_name = this._parser.ncToString(nf.rest_of_name);
            }
            catch (NamingException e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "mapNotFoundException", "4347", this);
            }
            msgPrefix = "Context: " + this.getContextName() + ", name: " + name + ": First component in name " + rest_of_name;
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "mapNotFoundException", "NotFound.rest_of_name is empty");
            }
            msgPrefix = "Context: " + this.getContextName() + ", name: " + name + ": Some component in name";
        }
        NamingException ne = null;
        ne = nf.why == NotFoundReason.missing_node ? new NameNotFoundException(msgPrefix + " not found.") : (nf.why == NotFoundReason.not_context ? new NotContextException(msgPrefix + " is not a context") : new NamingException(msgPrefix + " not found."));
        ne.initCause(nf);
        return ne;
    }

    private NamingException mapINV_OBJREF(INV_OBJREF e, Name name) {
        NamingException ne = null;
        String nameString = name.toString();
        if (this._serverType == 3) {
            NameClassPair ncp = new NameClassPair(nameString, CLASSNAME_FOR_JAVAOBJ);
            ne = new InvalidObjectException("Some object reference in the name \"" + nameString + "\" relative to " + "the context \"" + this._contextName + "\" is invalid.  Some possible causes include " + "a context binding in the name which refers to a destroyed context, or an " + "object binding which contains an invalid EJBHome reference.", ncp);
        } else {
            ne = new NamingException("Some object reference in the name \"" + nameString + "\" relative to " + "the context \"" + this._contextName + "\" is invalid.  One possible cause is that " + "some context binding in the name refers to a destroyed context. Other possible " + "causes depend on the implementation of the name server being accessed.");
        }
        ne.initCause(e);
        return ne;
    }

    private NamingException mapIMP_LIMIT(IMP_LIMIT e, String operation, Name name, boolean destroyOp) {
        NamingException ne = null;
        String nameString = name.toString();
        if (this._serverType != 3) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "mapIMP_LIMIT", "IMP_LIMIT from non-opt NC");
            }
            ne = new NamingException("Encountered a server implementation limit while attempting to " + operation + " the object \"" + nameString + "\" from the context " + "\"" + this._contextName + "\".");
            ne.initCause(e);
        } else {
            switch (e.minor) {
                case 1229066368: {
                    if (destroyOp) {
                        ne = new CannotDestroySubcontextException("The context bound with the name \"" + nameString + "\" relative to the " + "context \"" + this.getContextName() + "\" cannot be destroyed. " + "A context can be destroyed only from a context from which it was created. " + "Use the unbind method.");
                        ne.initCause(e);
                        break;
                    }
                    ne = new CannotUnbindSubcontextException("The context created with the name \"" + nameString + "\" relative to the " + "context \"" + this.getContextName() + "\" cannot be unbound. " + "The existing binding is a primary context binding. " + "Use the destroySubcontext method.");
                    ne.initCause(e);
                    break;
                }
                case 1229066369: {
                    ne = new DestroyProtectedContextException("The target context for this destroySubcontext operation on the name \"" + nameString + "\" from the context \"" + this.getContextName() + "\" is a destroy-protected context.");
                    ne.initCause(e);
                    break;
                }
                case 1229066370: {
                    ne = new WriteProtectedContextException("The target context for this operation on the name \"" + nameString + "\" from the context \"" + this.getContextName() + "\" is a read-only context.");
                    ne.initCause(e);
                }
            }
        }
        return ne;
    }

    @Override
    public boolean isLocal() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "isLocal");
        }
        boolean local = false;
        if (this._corbaNC instanceof ObjectImpl) {
            try {
                local = ((ObjectImpl)this._corbaNC)._is_local();
            }
            catch (Exception e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "isLocal", "4493", this);
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "isLocal", "_corbaNC is not instance of org.omg.CORBA.portable.ObjectImpl");
            }
            local = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "isLocal", Boolean.toString(local));
        }
        return local;
    }

    protected Subject login() throws NamingException {
        return SecurityUtil.login(this._principal, this._credentials);
    }

    protected boolean isSecurityEnabled() {
        return this._securityEnabled;
    }

    protected boolean isJndiOnly() {
        return this._jndiOnly;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/jndicos/CNContextImpl.java, WAS.naming.client, WAS70.SERV1, q0834.18, ver. 1.134");
        }
        CLASS_NAME = CNContextImpl.class.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Operation {
        BIND,
        REBIND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum EnumType {
        NAME,
        BINDING;

    }
}

