/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.jcache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.ipbase.ContextID;
import com.ibm.ws.naming.ipbase.NameSpace;
import com.ibm.ws.naming.ipbase.NameSpaceBindingData;
import com.ibm.ws.naming.ipbase.NameSpaceException;
import com.ibm.ws.naming.ipbase.UnresolvedContext;
import com.ibm.ws.naming.ipbase.UuidContext;
import com.ibm.ws.naming.jcache.CacheEntryData;
import com.ibm.ws.naming.jcache.CacheEntryNotFoundException;
import com.ibm.ws.naming.jcache.CacheInvalidPropertyValueException;
import com.ibm.ws.naming.jcache.CacheManager;
import com.ibm.ws.naming.util.CacheableReference;
import com.ibm.ws.naming.util.JavaObjectHolder;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.WsnName;
import java.util.Hashtable;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class Cache {
    protected static final String CACHE_OBJECT = "com.ibm.websphere.naming.jndicache.cacheobject";
    protected static final String CACHE_OBJECT_NONE = "none";
    protected static final String CACHE_OBJECT_POPULATED = "populated";
    protected static final String CACHE_OBJECT_CLEARED = "cleared";
    protected static final String CACHE_OBJECT_DEFAULT = "populated";
    protected static final String CACHE_NAME = "com.ibm.websphere.naming.jndicache.cachename";
    protected static final String CACHE_NAME_DEFAULT = "providerURL";
    private static final String CACHE_NAME_DEFAULT_VALUE = "iiop:///";
    protected static final String MAX_CACHE_LIFE = "com.ibm.websphere.naming.jndicache.maxcachelife";
    protected static final int MAX_CACHE_LIFE_DEFAULT = 0;
    protected static final String MAX_ENTRY_LIFE = "com.ibm.websphere.naming.jndicache.maxentrylife";
    protected static final int MAX_ENTRY_LIFE_DEFAULT = 0;
    private static final TraceComponent _tc = Tr.register(Cache.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private Hashtable _env;
    private NameSpace _cache;
    private long _lastCacheValidationTime;
    private String _cacheName;
    private ClassLoader _classLoader;
    private int _maxCacheLife;
    private int _maxEntryLife;
    private boolean _debug;

    public Cache(String cacheName, ClassLoader classLoader, Hashtable env) throws CacheInvalidPropertyValueException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "<init>", new String[]{"cacheName=" + cacheName, "classLoader=" + classLoader, "env=" + env});
        }
        this.init(cacheName, classLoader, env);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "<init>");
        }
    }

    private void init(String cacheName, ClassLoader classLoader, Hashtable env) throws CacheInvalidPropertyValueException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init", new String[]{"cacheName=" + cacheName, "classLoader=" + classLoader, "env=" + env});
        }
        this._env = env;
        this._cacheName = cacheName;
        this._classLoader = classLoader;
        try {
            this._cache = new NameSpace(2);
        }
        catch (IllegalArgumentException e) {
            this._cache = null;
        }
        this._lastCacheValidationTime = Cache.currentTime();
        this.setLifetimeProperties(env);
        this._debug = false;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init");
        }
    }

    public Hashtable getEnv() {
        return this._env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLifetimeProperties(Hashtable env) throws CacheInvalidPropertyValueException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setLifetimeProperties", "env=" + env);
        }
        int maxCacheLife = Cache.maxLifePropertyValue(env, MAX_CACHE_LIFE, 0);
        int maxEntryLife = Cache.maxLifePropertyValue(env, MAX_ENTRY_LIFE, 0);
        Cache cache = this;
        synchronized (cache) {
            this._maxCacheLife = maxCacheLife;
            this._maxEntryLife = maxEntryLife;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "setLifetimeProperties", "_maxCacheLife=" + this._maxCacheLife + ", _maxEntryLife=" + this._maxEntryLife);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setLifetimeProperties");
        }
    }

    public String getCacheName() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getCacheName", this._cacheName);
        }
        return this._cacheName;
    }

    public ClassLoader getClassLoader() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getClassLoader", this._classLoader);
        }
        return this._classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxCacheLife() {
        Cache cache = this;
        synchronized (cache) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getMaxCacheLife", Integer.toString(this._maxCacheLife));
            }
            return this._maxCacheLife;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxCacheLife(int maxCacheLife) {
        Cache cache = this;
        synchronized (cache) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "setMaxCacheLife", Integer.toString(maxCacheLife));
            }
            this._maxCacheLife = maxCacheLife;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxEntryLife() {
        Cache cache = this;
        synchronized (cache) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getMaxEntryLife", Integer.toString(this._maxEntryLife));
            }
            return this._maxEntryLife;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxEntryLife(int maxEntryLife) {
        Cache cache = this;
        synchronized (cache) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "setMaxEntryLife", Integer.toString(maxEntryLife));
            }
            this._maxEntryLife = maxEntryLife;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(UuidContext currCtx, Name name, ContextID[] ctxIDs, Object objToBind, CacheableReference cacheableRefObj) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "bind");
        }
        Cache cache = this;
        synchronized (cache) {
            this.validateCache();
            UuidContext parentCtx = currCtx;
            if (name.size() > 1 && (parentCtx = this.getParentContext(currCtx, name, ctxIDs)) == null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "bind", "getParentContext failed.");
                }
                return;
            }
            try {
                CacheEntryData data = new CacheEntryData();
                Name nameLeaf = null;
                nameLeaf = name.size() > 0 ? name.getSuffix(name.size() - 1) : name.getSuffix(name.size());
                if (cacheableRefObj != null) {
                    data.setCacheableReference(cacheableRefObj);
                }
                this._cache.bind(parentCtx, nameLeaf, objToBind, data);
            }
            catch (NamingException e) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "bind", "Exception returned from NameSpace.bind: " + e);
                }
            }
            catch (NameSpaceException e) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "bind", "Exception returned from NameSpace.bind: " + e);
                }
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "bind", "430", this);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "bind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSubcontext(UuidContext currCtx, Name name, ContextID[] ctxIDs, UuidContext newCtx) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createSubcontext");
        }
        Cache cache = this;
        synchronized (cache) {
            this.validateCache();
            UuidContext parentCtx = currCtx;
            if (name.size() > 1 && (parentCtx = this.getParentContext(currCtx, name, ctxIDs)) == null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "createSubcontext", "getParentContext failed.");
                }
                return;
            }
            try {
                CacheEntryData data = new CacheEntryData();
                Name nameLeaf = null;
                nameLeaf = name.size() > 0 ? name.getSuffix(name.size() - 1) : name.getSuffix(name.size());
                this._cache.createSubcontext(parentCtx, nameLeaf, newCtx, data);
            }
            catch (NamingException e) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "createSubcontext", "Exception returned from NameSpace.createSubcontext: " + e);
                }
            }
            catch (NameSpaceException e) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "createSubcontext", "Exception returned from NameSpace.createSubcontext: " + e);
                }
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "createSubcontext", "508", this);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createSubcontext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySubcontext(UuidContext currCtx, Name name, ContextID[] ctxIDs) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroySubcontext");
        }
        Cache cache = this;
        synchronized (cache) {
            this.validateCache();
            UuidContext parentCtx = this.getParentContext(currCtx, name, ctxIDs);
            if (parentCtx == null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "destroySubcontext", "getParentContext failed.");
                }
                return;
            }
            try {
                Name nameLeaf = name.getSuffix(name.size() - 1);
                this._cache.destroySubcontext(parentCtx, nameLeaf);
            }
            catch (NamingException e) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "destroySubcontext", "Exception returned from NameSpace.destroySubcontext: " + e);
                }
            }
            catch (NameSpaceException e) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "destroySubcontext", "Exception returned from NameSpace.destroySubcontext: " + e);
                }
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "destroySubcontext", "573", this);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroySubcontext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(UuidContext currCtx, Name name, JavaObjectHolder cacheableReferenceHolder) throws CacheEntryNotFoundException {
        if (_tc.isEntryEnabled()) {
            try {
                Tr.entry(_tc, "lookup", new String[]{"currCtx=" + (currCtx != null ? currCtx.getNameInNamespace() : "null"), "name=" + name, "cacheableReferenceHolder=" + cacheableReferenceHolder});
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        Object retObj = null;
        Cache cache = this;
        synchronized (cache) {
            this.validateCache();
            try {
                NameSpaceBindingData bindingData = this._cache.lookup(currCtx, name);
                CacheEntryData data = (CacheEntryData)bindingData.getAdditionalData();
                cacheableReferenceHolder.value = data.getCacheableReference();
                retObj = this.validateEntry(currCtx, name, bindingData.getBoundObject(), data);
            }
            catch (NamingException e) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "lookup", "NamingException: " + e);
                }
                CacheEntryNotFoundException cenfe = new CacheEntryNotFoundException("Entry \"" + name + "\" not found in cache.");
                cenfe.initCause(e);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "lookup", "Throwing CacheEntryNotFoundException: " + cenfe);
                }
                throw cenfe;
            }
            catch (NameSpaceException e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "lookup", "646", this);
                CacheEntryNotFoundException cenfe = new CacheEntryNotFoundException("Entry \"" + name + "\" not found in cache.");
                cenfe.initCause(e);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "lookup", "Throwing CacheEntryNotFoundException: " + cenfe);
                }
                throw cenfe;
            }
            if (retObj == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "lookup", "cached object failed validation.");
                }
                CacheEntryNotFoundException cenfe = new CacheEntryNotFoundException("Entry \"" + name + "\" not found in cache.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "lookup", "Throwing CacheEntryNotFoundException: " + cenfe);
                }
                throw cenfe;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "lookup", retObj);
        }
        return retObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(UuidContext currCtx, Name name, ContextID[] ctxIDs, Object objToBind, CacheableReference cacheableRefObj) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "rebind");
        }
        Cache cache = this;
        synchronized (cache) {
            this.validateCache();
            UuidContext parentCtx = this.getParentContext(currCtx, name, ctxIDs);
            if (parentCtx == null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "rebind", "getParentContext failed.");
                }
                return;
            }
            try {
                CacheEntryData data = new CacheEntryData();
                Name nameLeaf = name.getSuffix(name.size() - 1);
                if (cacheableRefObj != null) {
                    data.setCacheableReference(cacheableRefObj);
                }
                this._cache.rebind(parentCtx, nameLeaf, objToBind, data);
            }
            catch (NamingException e) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "rebind", "Exception returned from NameSpace.rebind: " + e);
                }
            }
            catch (NameSpaceException e) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "rebind", "Exception returned from NameSpace.rebind: " + e);
                }
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "rebind", "756", this);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "rebind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(UuidContext currCtx, Name name, ContextID[] ctxIDs) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "unbind");
        }
        Cache cache = this;
        synchronized (cache) {
            this.validateCache();
            UuidContext parentCtx = this.getParentContext(currCtx, name, ctxIDs);
            if (parentCtx == null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "unbind", "getParentContext failed.");
                }
                return;
            }
            try {
                Name nameLeaf = name.getSuffix(name.size() - 1);
                this._cache.unbind(parentCtx, nameLeaf);
            }
            catch (NamingException e) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "unbind", "Exception returned from NameSpace.unbind: " + e);
                }
            }
            catch (NameSpaceException e) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "unbind", "Exception returned from NameSpace.unbind: " + e);
                }
            }
            catch (Throwable t) {
                RasUtil.logException(t, _tc, CLASS_NAME, "unbind", "819", this);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "unbind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "clear");
        }
        Cache cache = this;
        synchronized (cache) {
            this._cache.clear();
            this._lastCacheValidationTime = Cache.currentTime();
        }
        CacheManager.clearJavaNameSpaceCaches(this._classLoader);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "clear");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UuidContext getParentContext(UuidContext baseCtx, Name name, ContextID[] ctxIDs) {
        UuidContext parentCtx;
        block35: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getParentContext");
            }
            parentCtx = baseCtx;
            Cache cache = this;
            synchronized (cache) {
                try {
                    if (name.size() > 1) {
                        NameSpaceBindingData bindingData = this._cache.getParentContext(baseCtx, name);
                        parentCtx = (UuidContext)bindingData.getBoundObject();
                    }
                }
                catch (NamingException e) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getParentContext", "Exception returned from NameSpace.getParentContext: " + e);
                    }
                    for (int i = 0; i < name.size() - 1; ++i) {
                        try {
                            WsnName relName;
                            try {
                                relName = new WsnName(name.get(i), this._env);
                            }
                            catch (Exception e2) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "getParentContext", new Object[]{"Exception thrown while creating a name component using WsnName. name=" + name + ", i=" + i, e2});
                                }
                                parentCtx = null;
                                break;
                            }
                            boolean found = true;
                            try {
                                NameSpaceBindingData bindingData = this._cache.intermediateCacheLookup(parentCtx, relName);
                                Object boundObject = bindingData.getBoundObject();
                                if (boundObject instanceof UuidContext) {
                                    parentCtx = (UuidContext)boundObject;
                                } else {
                                    found = false;
                                }
                            }
                            catch (NameNotFoundException e2) {
                                block34: {
                                    try {
                                        if (_tc.isDebugEnabled()) {
                                            if (parentCtx != null) {
                                                Tr.debug(_tc, "getParentContext", "Exception returned from NameSpace.lookup. relName=" + relName + ", parent ctx name=" + parentCtx.getNameInNamespace() + ", parent ctx id=" + parentCtx.getContextID() + ", e2=" + e2);
                                            } else {
                                                Tr.debug(_tc, "getParentContext", "Exception returned from NameSpace.lookup. relName=" + relName + ", parentCtx=null, e2=" + e2);
                                            }
                                        }
                                    }
                                    catch (Throwable ignore) {
                                        if (!_tc.isDebugEnabled()) break block34;
                                        Tr.debug(_tc, "getParentContext", ignore);
                                    }
                                }
                                if (ctxIDs == null || ctxIDs.length <= i) {
                                    parentCtx = null;
                                    break;
                                }
                                found = false;
                            }
                            if (found) continue;
                            Name unresolvedName = name.getPrefix(i + 1);
                            UnresolvedContext unresolvedCtx = new UnresolvedContext(((Object)ctxIDs[i]).toString(), unresolvedName.toString());
                            CacheEntryData data = new CacheEntryData();
                            this._cache.createSubcontext(parentCtx, relName, unresolvedCtx, data);
                            parentCtx = unresolvedCtx;
                            continue;
                        }
                        catch (Throwable e2) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "getParentContext", e2);
                            }
                            parentCtx = null;
                        }
                    }
                }
                catch (Throwable t) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getParentContext", t);
                    }
                    parentCtx = null;
                }
            }
            if (_tc.isDebugEnabled()) {
                try {
                    if (parentCtx != null) {
                        Tr.debug(_tc, "getParentContext", "returning context: ctx name=" + parentCtx.getNameInNamespace() + ", ctx id=" + parentCtx.getContextID());
                    } else {
                        Tr.debug(_tc, "getParentContext", "returning null context");
                    }
                }
                catch (NamingException e) {
                    if (!_tc.isDebugEnabled()) break block35;
                    Tr.debug(_tc, "getParentContext", e);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getParentContext", parentCtx);
        }
        return parentCtx;
    }

    private boolean validateCache() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "validateCache");
        }
        boolean cleared = false;
        if (this.isExpired()) {
            this._cache.clear();
            this._lastCacheValidationTime = Cache.currentTime();
            cleared = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "validateCache", Boolean.toString(cleared));
        }
        return cleared;
    }

    private Object validateEntry(UuidContext currCtx, Name name, Object boundObject, CacheEntryData data) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "validateEntry");
        }
        if (this.isExpired(data)) {
            block8: {
                try {
                    if (boundObject instanceof UuidContext) {
                        this._cache.destroySubcontext(currCtx, name);
                    } else {
                        this._cache.unbind(currCtx, name);
                    }
                    CacheManager.clearJavaNameSpaceCaches(this._classLoader);
                }
                catch (Throwable t) {
                    if (!_tc.isDebugEnabled()) break block8;
                    Tr.debug(_tc, "validateEntry", t);
                }
            }
            boundObject = null;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "validateEntry", "Entry cleared: " + (boundObject == null));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "validateEntry", boundObject);
        }
        return boundObject;
    }

    private boolean isExpired() {
        return this._maxCacheLife != 0 && this.elapsedTimeInMinutes(this._lastCacheValidationTime) >= (long)this._maxCacheLife;
    }

    private boolean isExpired(CacheEntryData entry) {
        return this._maxEntryLife != 0 && this.elapsedTimeInMinutes(entry.getCreationTime()) >= (long)this._maxEntryLife;
    }

    private long elapsedTimeInMinutes(long startTime) {
        long currTime = Cache.currentTime();
        return (currTime - startTime) / 60000L;
    }

    public static String cacheObjectPropertyValue(Hashtable env) throws CacheInvalidPropertyValueException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cacheObjectPropertyValue", "env=" + env);
        }
        String cacheObject = null;
        if (env != null) {
            Object o = env.get(CACHE_OBJECT);
            if (o == null || o instanceof String) {
                cacheObject = (String)o;
            } else {
                CacheInvalidPropertyValueException cipve = new CacheInvalidPropertyValueException("Value for the property \"com.ibm.websphere.naming.jndicache.cacheobject\" is not a String.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "cacheObjectPropertyValue", "Throwing CacheInvalidPropertyValueException: " + cipve);
                }
                throw cipve;
            }
        }
        if (cacheObject != null) {
            if (!(cacheObject.equals(CACHE_OBJECT_NONE) || cacheObject.equals(CACHE_OBJECT_CLEARED) || cacheObject.equals("populated"))) {
                CacheInvalidPropertyValueException cipve = new CacheInvalidPropertyValueException("Value of \"" + cacheObject + "\" for the property \"" + CACHE_OBJECT + "\" is not valid.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "cacheObjectPropertyValue", "Throwing CacheInvalidPropertyValueException: " + cipve);
                }
                throw cipve;
            }
        } else {
            cacheObject = "populated";
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cacheObjectPropertyValue", cacheObject);
        }
        return cacheObject;
    }

    public static String cacheNamePropertyValue(Hashtable env) throws CacheInvalidPropertyValueException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cacheNamePropertyValue", "env=" + env);
        }
        String cacheNameProp = null;
        if (env != null) {
            Object o = env.get(CACHE_NAME);
            if (o == null || o instanceof String) {
                cacheNameProp = (String)o;
            } else {
                CacheInvalidPropertyValueException cipve = new CacheInvalidPropertyValueException("Value for the property \"com.ibm.websphere.naming.jndicache.cachename\" is not a String.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "cacheObjectPropertyValue", "Throwing CacheInvalidPropertyValueException: " + cipve);
                }
                throw cipve;
            }
        }
        if (cacheNameProp == null) {
            cacheNameProp = CACHE_NAME_DEFAULT;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cacheNamePropertyValue", cacheNameProp);
        }
        return cacheNameProp;
    }

    public static String cacheNameFromPropertyValue(Hashtable env) throws CacheInvalidPropertyValueException {
        String cacheName;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cacheNameFromPropertyValue", "env=" + env);
        }
        if ((cacheName = Cache.cacheNamePropertyValue(env)) == null || cacheName.equals(CACHE_NAME_DEFAULT)) {
            String providerUrl = null;
            Object o = env.get("java.naming.provider.url");
            if (o != null && !(o instanceof String)) {
                CacheInvalidPropertyValueException cipve = new CacheInvalidPropertyValueException("Value for the property \"java.naming.provider.url\" is not a String.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "cacheNameFromPropertyValue", "Throwing CacheInvalidPropertyValueException: " + cipve);
                }
                throw cipve;
            }
            providerUrl = (String)o;
            try {
                if (providerUrl == null) {
                    providerUrl = System.getProperty("java.naming.provider.url");
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (providerUrl == null) {
                providerUrl = CACHE_NAME_DEFAULT_VALUE;
            }
            cacheName = Cache.normalizeUrl(providerUrl);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cacheNameFromPropertyValue", cacheName);
        }
        return cacheName;
    }

    private static int maxLifePropertyValue(Hashtable env, String propName, int defaultValue) throws CacheInvalidPropertyValueException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "maxLifePropertyValue", new String[]{"env=" + env, "propName=" + propName, "defaultValue=" + defaultValue});
        }
        String propValString = null;
        int propVal = defaultValue;
        if (env != null) {
            Object o = env.get(propName);
            if (o == null || o instanceof String) {
                propValString = (String)o;
            } else {
                CacheInvalidPropertyValueException cipve = new CacheInvalidPropertyValueException("Value for the property \"" + propName + "\" is not a String.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "maxLifePropertyValue", "Throwing CacheInvalidPropertyValueException: " + cipve);
                }
                throw cipve;
            }
        }
        if (propValString != null) {
            try {
                propVal = Integer.parseInt(propValString);
            }
            catch (NumberFormatException e) {
                RasUtil.logException(e, _tc, CLASS_NAME, "maxLifePropertyValue", "1329");
                CacheInvalidPropertyValueException cipve = new CacheInvalidPropertyValueException("Value for the property \"" + propName + "\" is not a valid number.");
                cipve.initCause(e);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "maxLifePropertyValue", "Throwing CacheInvalidPropertyValueException: " + cipve);
                }
                throw cipve;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "maxLifePropertyValue", Integer.toString(propVal));
        }
        return propVal;
    }

    private static String normalizeUrl(String url) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizeUrl", "url=" + url);
        }
        if (url != null) {
            int i = url.indexOf("//");
            if (i != -1) {
                i += 2;
                i = url.indexOf("/", i);
            }
            if (i != -1) {
                url = url.substring(0, i);
            }
            url = url.toLowerCase();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizeUrl", url);
        }
        return url;
    }

    private static long currentTime() {
        return System.currentTimeMillis();
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    private void printDebug(String s) {
        if (this._debug) {
            System.out.println("CACHE DEBUG: " + s);
        }
    }

    public void dump() {
        this.printDebug("BEGIN CACHE DUMP OF " + this._cacheName + " for class loader " + this._classLoader);
        this._cache.dumpNameSpace(null);
        this.printDebug("END CACHE DUMP OF " + this._cacheName + " for class loader " + this._classLoader);
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/jcache/Cache.java, WAS.naming.client, WAS70.SERV1, q0834.18, ver. 1.30");
        }
        CLASS_NAME = Cache.class.getName();
    }
}

