/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.annotations;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.ArrayList;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSignatureParser {
    private static final TraceComponent tc = Tr.register(WSSignatureParser.class, "MetaData", "com.ibm.ws.metadata.metadata");
    private String fullSignature;
    private ArrayList<String> parsedSignature;

    public WSSignatureParser(String fullSignature) {
        this.fullSignature = fullSignature;
        this.parsedSignature = new ArrayList();
    }

    public String[] parseSignature() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseSignature");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing signature: " + this.fullSignature);
        }
        this.removeParentheses();
        Stack<String> stack = this.buildStack();
        this.popStack(stack);
        if (tc.isDebugEnabled()) {
            String[] formattedList = this.formatSignatureList();
            if (formattedList != null) {
                for (String mem : formattedList) {
                    Tr.debug(tc, "Parsed method signature member: " + mem);
                }
            } else {
                Tr.debug(tc, "The parsed method signature list was null");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseSignature");
        }
        return this.formatSignatureList();
    }

    private Stack<String> buildStack() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildStack");
        }
        Stack<String> stack = new Stack<String>();
        char[] sigArray = this.fullSignature.toCharArray();
        StringBuffer pushString = new StringBuffer("");
        for (int i = sigArray.length - 1; i >= 0; --i) {
            String thisChar = String.valueOf(sigArray[i]);
            if (this.isSpecialChar(thisChar) || this.isPrimitiveType(thisChar, sigArray, i == 0 ? i : i - 1)) {
                if (pushString != null && !pushString.toString().equals("")) {
                    pushString = pushString.reverse();
                    stack.push(pushString.toString());
                    pushString = new StringBuffer("");
                }
                stack.push(thisChar);
            } else if (this.isClosedBracket(thisChar)) {
                int closedCount = 1;
                int openCount = 0;
                pushString.append(thisChar);
                while (closedCount != openCount && i > 0) {
                    String currentToken;
                    if (this.isOpenBracket(currentToken = String.valueOf(sigArray[--i]))) {
                        ++openCount;
                        pushString.append(currentToken);
                        continue;
                    }
                    pushString.append(currentToken);
                }
            } else {
                pushString = pushString.append(sigArray[i]);
            }
            if (i != 0 || pushString == null || pushString.toString().equals("")) continue;
            pushString = pushString.reverse();
            stack.push(pushString.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildStack");
        }
        return stack;
    }

    private boolean isClosedBracket(String thisChar) {
        return thisChar.equals(">");
    }

    private boolean isOpenBracket(String thisChar) {
        return thisChar.equals("<");
    }

    private boolean isSpecialChar(String token) {
        return token.equals(";") || token.equals("[");
    }

    private boolean isPrimitiveType(String token, char[] charArray, int i) {
        if (this.matchesPrimitive(token)) {
            if (i == 0) {
                return true;
            }
            String prevToken = String.valueOf(charArray[i]);
            if (this.matchesPrimitive(prevToken)) {
                return this.isPrimitiveType(prevToken, charArray, i - 1);
            }
            return prevToken.equals(";") || prevToken.equals("(") || prevToken.equals("[");
        }
        return false;
    }

    private boolean matchesPrimitive(String token) {
        return token.equals("Z") || token.equals("B") || token.equals("C") || token.equals("S") || token.equals("I") || token.equals("J") || token.equals("F") || token.equals("D");
    }

    private void popStack(Stack<String> stack) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "popStack");
        }
        int i = 0;
        while (!stack.isEmpty()) {
            String token = stack.pop();
            if (!(token.equals(";") || token.equals("<") || token.equals(")") || token.equals("[") || token.equals("("))) {
                this.parsedSignature.add(token);
            } else if (token.equals("<")) {
                this.handleGenericGrouping(stack, token);
            } else if (token.equals("[")) {
                this.handleArray(stack, token);
            }
            ++i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "popStack");
        }
    }

    private void handleGenericGrouping(Stack<String> stack, String lastToken) {
        int currentSize;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleGenericGrouping");
        }
        if ((currentSize = this.parsedSignature.size() - 1) > -1) {
            String lastString = this.parsedSignature.get(this.parsedSignature.size() - 1);
            this.parsedSignature.remove(this.parsedSignature.size() - 1);
            lastString = lastString + lastToken;
            int openedCount = 1;
            int closedCount = 0;
            while (openedCount != closedCount && !stack.isEmpty()) {
                String token = stack.pop();
                if (token.equals("<")) {
                    ++openedCount;
                } else if (token.equals(">")) {
                    ++closedCount;
                }
                lastString = lastString + token;
            }
            this.parsedSignature.add(lastString);
        } else {
            int openedCount = 1;
            int closedCount = 0;
            while (openedCount != closedCount && !stack.isEmpty()) {
                String token = stack.pop();
                if (token.equals("<")) {
                    ++openedCount;
                } else if (token.equals(">")) {
                    ++closedCount;
                }
                lastToken = lastToken + token;
            }
            this.parsedSignature.add(lastToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleGenericGrouping");
        }
    }

    private void handleArray(Stack<String> stack, String token) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleArray");
        }
        if (!stack.isEmpty()) {
            String newToken = "";
            while (!stack.isEmpty() && token.equals("[")) {
                newToken = newToken + token;
                token = stack.pop();
            }
            newToken = newToken + token;
            this.parsedSignature.add(newToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleArray");
        }
    }

    private String[] formatSignatureList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formatSignatureList");
        }
        String[] formattedList = new String[this.parsedSignature.size()];
        for (int i = 0; i < this.parsedSignature.size(); ++i) {
            String token = this.parsedSignature.get(i);
            formattedList[i] = token = this.javifyParameterPart(token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formatSignatureList");
        }
        return formattedList;
    }

    private String javifyParameterPart(String token) {
        if (token.indexOf("/") != -1) {
            token = token.replaceAll("/", ".");
        }
        if (token.startsWith("L")) {
            token = token.replaceFirst("L", "");
        }
        if (token.indexOf(40) == 0 && token.length() > 0) {
            token = this.javifyParameterPart(token.substring(1, token.length()));
        }
        if (token.indexOf(";L") != -1) {
            token = token.replaceAll(";L", ";");
        }
        if (token.indexOf("<L") != -1) {
            token = token.replaceAll("<L", "<");
        }
        if (token.indexOf("[L") != -1) {
            token = token.replaceAll("\\[L", "\\[");
        }
        if (token.indexOf(";") != -1) {
            token = token.replaceAll(";", "");
        }
        return token.trim();
    }

    private void removeParentheses() {
        int openParenIndex = this.fullSignature.indexOf(40);
        int closeParenIndex = this.fullSignature.indexOf(41);
        if (openParenIndex == 0 && closeParenIndex == 2 && this.matchesPrimitive(this.fullSignature.substring(1, 2))) {
            this.fullSignature = this.fullSignature.substring(1, 2);
        } else {
            if (openParenIndex > 0) {
                this.fullSignature = this.fullSignature.substring(openParenIndex + 1, this.fullSignature.length());
            }
            if (this.fullSignature.indexOf(")") != -1) {
                this.fullSignature = this.fullSignature.substring(0, this.fullSignature.lastIndexOf(")")).trim();
            }
        }
    }
}

