/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.annotations;

import com.ibm.ws.metadata.ClassDataObjectFields;
import com.ibm.ws.metadata.ClassRefObject;
import com.ibm.ws.metadata.EJBMethodInterfaceType;
import com.ibm.ws.metadata.MetaDataScope;
import com.ibm.ws.metadata.MetaDataSubObject;
import com.ibm.ws.metadata.ModuleDataObject;
import com.ibm.ws.metadata.annotations.ASMClassAdapter;
import com.ibm.ws.metadata.annotations.AnnotationConfigReader;
import com.ibm.ws.metadata.annotations.MethodRefObject;
import com.ibm.ws.metadata.annotations.WSMethodAdapter;
import com.ibm.ws.metadata.annotations.WSSignatureParser;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class WSClassAdapter
extends ASMClassAdapter {
    private String[] convertedMethodSignature;
    private String[] ivImplements;
    private String ivSuperName;
    private WSMethodAdapter ivMethodVisitor;
    private Integer ivClassAccess;
    private ClassRefObject classRefObject;
    private ArrayList webServiceRefs;
    private ArrayList resources;
    private List webServiceFeatures;
    private MethodRefObject ivCurrentMethodRef;

    WSClassAdapter(ClassVisitor cv, AnnotationConfigReader acr, ModuleDataObject mdo) {
        super(cv, acr, mdo);
        this.iv_AnnotationConfigReader = acr;
        this.iv_MDO = mdo;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.iv_FullClassName = name;
        this.iv_ClassName = this.getUnqualifiedClassName(name);
        this.iv_MergerInfo.iv_Extends = superName;
        this.ivImplements = interfaces;
        this.ivClassAccess = new Integer(access);
        this.ivSuperName = superName;
        if (signature != null) {
            WSSignatureParser parser2 = new WSSignatureParser(signature);
            String[] parsed = parser2.parseSignature();
            this.ivImplements = this.finalizeArray(parsed);
        }
    }

    public void putCDOEntry(ClassDataObjectFields key, Object value, MetaDataScope scope) {
        this.getCDO();
        if (key.equals((Object)ClassDataObjectFields.WEBSERVICEREF) && scope.equals((Object)MetaDataScope.CLASS)) {
            this.webServiceRefs = (ArrayList)this.iv_CDO.getEntry(ClassDataObjectFields.WEBSERVICEREF);
            if (this.webServiceRefs == null) {
                this.webServiceRefs = new ArrayList();
            }
            this.webServiceRefs.add(value);
            this.iv_CDO.putEntry(ClassDataObjectFields.WEBSERVICEREF, this.webServiceRefs);
        } else if (key.equals((Object)ClassDataObjectFields.RESOURCE) && scope.equals((Object)MetaDataScope.CLASS)) {
            this.resources = (ArrayList)this.iv_CDO.getEntry(ClassDataObjectFields.RESOURCE);
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(value);
            this.iv_CDO.putEntry(ClassDataObjectFields.RESOURCE, this.resources);
        } else if (key.equals((Object)ClassDataObjectFields.WEBSERVICEFEATURES) && scope.equals((Object)MetaDataScope.CLASS)) {
            this.webServiceFeatures = (List)this.iv_CDO.getEntry(ClassDataObjectFields.WEBSERVICEFEATURES);
            if (this.webServiceFeatures == null) {
                this.webServiceFeatures = new ArrayList();
            }
            this.webServiceFeatures.add(value);
            this.iv_CDO.putEntry(ClassDataObjectFields.WEBSERVICEFEATURES, this.webServiceFeatures);
        } else if (scope == MetaDataScope.METHOD) {
            String signature = null;
            if (this.iv_MethodName != null && this.iv_MethodName != "*") {
                signature = this.toString(this.ivCurrentMethodRef.getSignature());
            }
            MetaDataSubObject dataSubObject = new MetaDataSubObject(scope, this.iv_MethodName, EJBMethodInterfaceType.UNSPECIFIED.ordinal(), signature, value);
            if (this.iv_MethodName == "*") {
                this.iv_MethodName = null;
            }
            this.iv_CDO.putEntry(key, dataSubObject);
        } else {
            super.putCDOEntry(key, value, scope);
        }
        this.iv_CDO.putEntry(ClassDataObjectFields.CLASS_ACCESS, this.ivClassAccess);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return super.visitAnnotation(desc, visible);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions2) {
        MethodRefObject mRefObject;
        this.iv_MethodName = name;
        this.iv_MethodSignature = desc;
        Method myMethod = new Method(this.iv_MethodName, this.iv_MethodSignature);
        this.convertedMethodSignature = null;
        if (this.classRefObject == null) {
            this.classRefObject = new ClassRefObject();
            this.classRefObject.setInterfaces(this.ivImplements);
            this.classRefObject.setSuperName(this.ivSuperName);
        }
        String[] typeList = this.getWASMethodSignature(myMethod);
        String returnType = this.getReturnType(myMethod);
        this.ivCurrentMethodRef = mRefObject = new MethodRefObject(access, name, desc, typeList, returnType, exceptions2, signature);
        this.classRefObject.addMethodRef(mRefObject);
        if (this.ivMethodVisitor == null) {
            MethodVisitor methodVisitor = this.cv.visitMethod(access, name, desc, signature, exceptions2);
            this.ivMethodVisitor = new WSMethodAdapter(methodVisitor, this);
        }
        this.iv_MethodName = name;
        this.iv_MethodSignature = desc;
        this.iv_ConvertedMethodSignature = null;
        this.iv_MethodExceptions = exceptions2;
        return this.ivMethodVisitor;
    }

    public void visitEnd() {
        if (this.iv_CDO == null) {
            this.getCDO();
        }
        if (this.classRefObject == null) {
            this.classRefObject = new ClassRefObject();
            this.classRefObject.setInterfaces(this.ivImplements);
            this.classRefObject.setSuperName(this.ivSuperName);
        }
        this.iv_CDO.putEntry(ClassDataObjectFields.CLASS_INFO, this.classRefObject);
        this.classRefObject = null;
        super.visitEnd();
    }

    private String[] getWASMethodSignature(Method myMethod) {
        if (this.convertedMethodSignature == null) {
            Type[] methodArguments = myMethod.getArgumentTypes();
            this.convertedMethodSignature = new String[methodArguments.length];
            for (int i = 0; i < methodArguments.length; ++i) {
                this.convertedMethodSignature[i] = methodArguments[i].getClassName();
            }
        }
        return this.convertedMethodSignature;
    }

    private String getReturnType(Method myMethod) {
        return myMethod.getReturnType().getClassName();
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return super.visitField(access, name, desc, signature, value);
    }

    public String toString(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = i == 0 ? stringArray[i] : string + " " + stringArray[i];
        }
        return string;
    }

    public String[] finalizeArray(String[] array) {
        if (array.length > 1) {
            String[] finalized = new String[array.length - 1];
            for (int i = 1; i < array.length; ++i) {
                finalized[i - 1] = array[i];
            }
            return finalized;
        }
        return new String[0];
    }
}

