/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.annotations;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ClassDataObjectFields;
import com.ibm.ws.metadata.ComponentDataObject;
import com.ibm.ws.metadata.ComponentDataObjectFields;
import com.ibm.ws.metadata.EJBMethodInterfaceType;
import com.ibm.ws.metadata.MergerInfo;
import com.ibm.ws.metadata.MetaDataException;
import com.ibm.ws.metadata.MetaDataOrchestrator;
import com.ibm.ws.metadata.MetaDataScope;
import com.ibm.ws.metadata.MetaDataSubObject;
import com.ibm.ws.metadata.ModuleDataObject;
import com.ibm.ws.metadata.annotations.ASMFieldAdapter;
import com.ibm.ws.metadata.annotations.ASMMethodAdapter;
import com.ibm.ws.metadata.annotations.AnnotationConfigReader;
import com.ibm.ws.metadata.annotations.WSAnnotationAdapter;
import java.util.HashSet;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.commons.Method;

public class ASMClassAdapter
extends ClassAdapter {
    private static final String CLASS_NAME = ASMClassAdapter.class.getName();
    private static TraceComponent tc = Tr.register(CLASS_NAME, "MetaData", "com.ibm.ws.metadata.metadata");
    protected AnnotationConfigReader iv_AnnotationConfigReader;
    protected String iv_FullClassName;
    protected String iv_ClassName;
    protected String iv_MethodName;
    protected String iv_MethodSignature;
    protected String iv_ConvertedMethodSignature;
    protected String[] iv_MethodExceptions;
    protected String iv_FieldName;
    protected String iv_FieldSignature;
    protected String iv_ConvertedFieldSignature;
    private ASMMethodAdapter iv_ASMMethodAdapter;
    private ASMFieldAdapter iv_ASMFieldAdapter;
    protected ClassDataObject iv_CDO;
    protected ModuleDataObject iv_MDO;
    public MergerInfo iv_MergerInfo = new MergerInfo();
    protected final EmptyVisitor sv_MyEmptyVisitor = new EmptyVisitor();

    ASMClassAdapter(ClassVisitor cv, AnnotationConfigReader acr, ModuleDataObject mdo) {
        super(cv);
        this.iv_AnnotationConfigReader = acr;
        this.iv_MDO = mdo;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.iv_FullClassName = name;
        this.iv_FullClassName = this.iv_FullClassName.replace("/", ".");
        this.iv_ClassName = this.getUnqualifiedClassName(name);
        this.iv_MergerInfo.iv_Implements = interfaces;
        this.iv_MergerInfo.iv_Extends = superName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ASM processing class :" + this.iv_FullClassName);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor result = null;
        WSAnnotationAdapter annotationAdapterInstance = this.iv_AnnotationConfigReader.getAnnotationAdapterInstance(desc);
        if (annotationAdapterInstance != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ASM processing annotation :" + desc);
            }
            annotationAdapterInstance.initialize(annotationAdapterInstance, this, MetaDataScope.CLASS);
            result = annotationAdapterInstance;
        } else {
            result = this.sv_MyEmptyVisitor;
        }
        return result;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions2) {
        if (this.iv_ASMMethodAdapter == null) {
            MethodVisitor methodVisitor = this.cv.visitMethod(access, name, desc, signature, exceptions2);
            this.iv_ASMMethodAdapter = new ASMMethodAdapter(methodVisitor, this);
        }
        this.iv_MethodName = name;
        this.iv_MethodSignature = desc;
        this.iv_ConvertedMethodSignature = null;
        this.iv_MethodExceptions = exceptions2;
        return this.iv_ASMMethodAdapter;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.iv_ASMFieldAdapter == null) {
            FieldVisitor fieldVisitor = this.cv.visitField(access, name, desc, signature, value);
            this.iv_ASMFieldAdapter = new ASMFieldAdapter(fieldVisitor, this);
        }
        this.iv_FieldName = name;
        this.iv_FieldSignature = desc;
        this.iv_ConvertedFieldSignature = null;
        return this.iv_ASMFieldAdapter;
    }

    public void visitEnd() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "visitEnd");
        }
        if (this.iv_CDO == null) {
            this.iv_CDO = this.iv_MDO.getClassDataObject(this.iv_FullClassName);
        }
        if (this.iv_CDO == null && (this.iv_MergerInfo.ivEmptyLocal || this.iv_MergerInfo.ivEmptyRemote)) {
            this.iv_CDO = this.iv_MDO.createClassDataObject(this.iv_FullClassName);
        }
        if (this.iv_CDO == null) {
            this.iv_MDO.ivScannedClasses.add(this.iv_FullClassName);
        } else {
            if (this.iv_CDO.iv_MergerInfo == null) {
                this.iv_CDO.iv_MergerInfo = this.iv_MergerInfo;
            }
            String componentName = (String)this.iv_CDO.getEntry(ClassDataObjectFields.EJB_NAME);
            this.putCDOEntry(ClassDataObjectFields.CLASS_NAME, this.iv_FullClassName, MetaDataScope.CLASS);
            this.putCDOEntry(ClassDataObjectFields.SHORT_CLASS_NAME, this.iv_ClassName, MetaDataScope.CLASS);
            if (componentName == null && (this.iv_CDO.ivComponentNames == null || this.iv_CDO.ivComponentNames.isEmpty())) {
                componentName = this.iv_ClassName;
            }
            if (componentName != null && this.iv_CDO.getEntry(ClassDataObjectFields.EJB_TYPE) != null) {
                boolean newComponent;
                String applicationName = this.iv_MDO.iv_Key.getApplication();
                String moduleName = this.iv_MDO.iv_Key.getModule();
                J2EEName j2eeName = MetaDataOrchestrator.sv_J2EENameFactory.create(applicationName, moduleName, componentName);
                this.putCDOEntry(ClassDataObjectFields.J2EE_NAME, j2eeName, MetaDataScope.CLASS);
                ComponentDataObject compDO = null;
                if (this.iv_CDO.ivComponentNames == null) {
                    this.iv_CDO.ivComponentNames = new HashSet();
                }
                if (newComponent = this.iv_CDO.ivComponentNames.add(componentName)) {
                    compDO = this.createComponentDataObject(componentName);
                    compDO.ivClassDataObject = this.iv_CDO;
                }
                this.checkComponents();
            }
            this.iv_MDO.putClassDataObject(this.iv_CDO);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.iv_CDO.toString());
            }
            this.iv_CDO = null;
        }
        this.iv_MethodName = null;
        this.iv_MethodSignature = null;
        this.iv_ConvertedMethodSignature = null;
        this.iv_MethodExceptions = null;
        this.iv_FieldName = null;
        this.iv_FieldSignature = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "visitEnd", this.iv_CDO);
        }
    }

    public void putCDOEntry(ClassDataObjectFields key, Object value, MetaDataScope scope) {
        MetaDataSubObject dataSubObject = null;
        this.getCDO();
        if (scope == MetaDataScope.CLASS) {
            this.iv_CDO.putEntry(key, value);
        } else if (scope == MetaDataScope.METHOD) {
            String signature = null;
            if (this.iv_MethodName != null && this.iv_MethodName != "*") {
                signature = this.getMethodSignature();
            }
            dataSubObject = new MetaDataSubObject(scope, this.iv_MethodName, EJBMethodInterfaceType.UNSPECIFIED.ordinal(), signature, value);
            if (this.iv_MethodName == "*") {
                this.iv_MethodName = null;
            }
            this.iv_CDO.putEntry(key, dataSubObject);
        } else if (scope == MetaDataScope.FIELD) {
            dataSubObject = new MetaDataSubObject(scope, this.iv_FieldName, EJBMethodInterfaceType.UNSPECIFIED.ordinal(), this.getFieldSignature(), value);
            this.iv_CDO.putEntry(key, dataSubObject);
        } else if (scope == MetaDataScope.PARAMETER) {
            String signature = null;
            if (this.iv_MethodName != null && this.iv_MethodName != "*") {
                signature = this.getMethodSignature();
            }
            dataSubObject = new MetaDataSubObject(scope, this.iv_MethodName, EJBMethodInterfaceType.UNSPECIFIED.ordinal(), signature, value);
            if (this.iv_MethodName == "*") {
                this.iv_MethodName = null;
            }
            this.iv_CDO.putEntry(key, dataSubObject);
        }
    }

    private ComponentDataObject createComponentDataObject(String componentName) {
        String moduleName;
        String applicationName = this.iv_MDO.iv_Key.getApplication();
        J2EEName j2eeName = MetaDataOrchestrator.sv_J2EENameFactory.create(applicationName, moduleName = this.iv_MDO.iv_Key.getModule(), componentName);
        ComponentDataObject compDO = this.iv_MDO.getComponentDataObject(j2eeName);
        if (compDO == null) {
            compDO = this.iv_MDO.createComponentDataObject(j2eeName);
            compDO.putEntry(ComponentDataObjectFields.CLASS_NAME, this.iv_FullClassName);
            this.iv_MDO.putComponentDataObject(compDO);
        }
        return compDO;
    }

    private void checkComponents() {
        String[] componentNames;
        J2EEName moduleJ2EEName = this.iv_MDO.iv_Key;
        String applicationName = moduleJ2EEName.getApplication();
        String moduleName = moduleJ2EEName.getModule();
        for (String componentName : componentNames = this.iv_CDO.ivComponentNames.toArray(new String[0])) {
            J2EEName compDOKey = MetaDataOrchestrator.sv_J2EENameFactory.create(applicationName, moduleName, componentName);
            ComponentDataObject compDO = this.iv_MDO.getComponentDataObject(compDOKey);
            String className = (String)compDO.getEntry(ComponentDataObjectFields.CLASS_NAME);
            if (className == null || className == "") {
                compDO.putEntry(ComponentDataObjectFields.CLASS_NAME, this.iv_FullClassName);
                continue;
            }
            if (className.equals(this.iv_FullClassName)) continue;
            Tr.error(tc, "INCORRECT_EJB_CLASS_CWMDF0013E", new Object[]{className, compDOKey});
            MetaDataException ex = new MetaDataException("XML_CONTAINS_INCORRECT_EJB_CLASS className: " + className + " EJB: " + ((Object)compDOKey).toString());
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + "checkComponents"), (String)"561", (Object)this);
            throw ex;
        }
    }

    protected ClassDataObject getCDO() {
        if (this.iv_CDO == null) {
            this.iv_CDO = this.iv_MDO.getClassDataObject(this.iv_FullClassName);
            if (this.iv_CDO == null) {
                this.iv_CDO = this.iv_MDO.createClassDataObject(this.iv_FullClassName);
            }
        }
        if (this.iv_CDO.iv_MergerInfo == null) {
            this.iv_CDO.iv_MergerInfo = this.iv_MergerInfo;
        }
        return this.iv_CDO;
    }

    public String getUnqualifiedClassName(String fullClassName) {
        int i = 0;
        int j = fullClassName.length();
        for (i = j - 1; i > -1 && fullClassName.charAt(i) != '/'; --i) {
        }
        return fullClassName.substring(i + 1, j);
    }

    public void setMethodName(String name) {
        this.iv_MethodName = name;
    }

    public String getMethodSignature() {
        if (this.iv_ConvertedMethodSignature == null) {
            Method myMethod = new Method(this.iv_MethodName, this.iv_MethodSignature);
            Type[] methodArguments = myMethod.getArgumentTypes();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < methodArguments.length; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(methodArguments[i].getClassName());
            }
            this.iv_ConvertedMethodSignature = sb.toString();
        }
        return this.iv_ConvertedMethodSignature;
    }

    public String getFieldSignature() {
        if (this.iv_ConvertedFieldSignature == null) {
            Type fieldType = Type.getType(this.iv_FieldSignature);
            this.iv_ConvertedFieldSignature = fieldType.getClassName();
        }
        return this.iv_ConvertedFieldSignature;
    }
}

