/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.etools.commonarchive.util.EJBExtensionUtil;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ComponentDataObject;
import com.ibm.ws.metadata.ComponentDataObjectFields;
import com.ibm.ws.metadata.ConfigReader;
import com.ibm.ws.metadata.MDOFields;
import com.ibm.ws.metadata.MetaDataScope;
import com.ibm.ws.metadata.MetaDataSources;
import com.ibm.ws.metadata.MetaDataSubObject;
import com.ibm.ws.metadata.ModuleDataObject;
import com.ibm.ws.metadata.bindings.EJBModuleHelper;
import com.ibm.ws.runtime.deploy.DeployedApplication;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.service.MetaDataFactoryMgr;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.WCCMHelper;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.ejb.ActivationConfig;
import org.eclipse.jst.j2ee.ejb.ActivationConfigProperty;
import org.eclipse.jst.j2ee.ejb.ApplicationException;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;
import org.eclipse.jst.j2ee.ejb.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCCMConfigReader
implements ConfigReader {
    private static final String CLASS_NAME = WCCMConfigReader.class.getName();
    private static TraceComponent tc = Tr.register(CLASS_NAME, "MetaData", "com.ibm.ws.metadata.metadata");
    private static TraceComponent common_tc = null;
    private static boolean isZOS = false;
    private static TransactionAttributeType[] JEE15TxFromMofMap;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void populateModuleData(ModuleDataObject mdo, MetaDataSources mds) throws EJBConfigurationException {
        ModuleFile moduleFile;
        DeployedModule dmod = (DeployedModule)mds.iv_Sources[MetaDataSources.sv_DeployedModuleIndex];
        MetaDataFactoryMgr metaDataManager = (MetaDataFactoryMgr)mds.iv_Sources[MetaDataSources.sv_MetaDataManagerIndex];
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "populateModuleData", dmod);
        }
        if ((moduleFile = dmod.getModuleFile()).isEJBJarFile()) {
            AssemblyDescriptor assemblyDescriptor;
            ConfigObject ejbModConfig;
            int numBeans = 0;
            EList beans = null;
            EJBJarFile ejbJarFile = (EJBJarFile)moduleFile;
            mdo.putEntry(MDOFields.EJB_MODULE_FILE, ejbJarFile);
            String moduleName = dmod.getName();
            String appName = dmod.getDeployedApplication().getName();
            ApplicationMetaData amd = (ApplicationMetaData)dmod.getDeployedApplication().getMetaData();
            EJBJar ejbJarDD = WCCMHelper.getDeploymentDescriptor(ejbJarFile, false);
            if (ejbJarDD != null) {
                beans = ejbJarDD.getEnterpriseBeans();
                numBeans = beans.size();
            }
            if ((ejbModConfig = dmod.getClusterModuleConfig()) == null) {
                ejbModConfig = dmod.getServerModuleConfig();
            }
            mdo.putEntry(MDOFields.APPLICATION_NAME, appName);
            mdo.putEntry(MDOFields.MODULE_NAME, moduleName);
            int modVersion = ejbJarDD == null ? 30 : ejbJarDD.getVersionID();
            mdo.putEntry(MDOFields.MODULE_VERSION, new Integer(modVersion));
            if (modVersion < 30) {
                mdo.putEntry(MDOFields.METADATA_COMPLETE, Boolean.TRUE);
            } else if (ejbJarDD != null) {
                if (ejbJarDD.isSetMetadataComplete()) {
                    mdo.putEntry(MDOFields.METADATA_COMPLETE, new Boolean(ejbJarDD.isMetadataComplete()));
                } else {
                    mdo.putEntry(MDOFields.METADATA_COMPLETE, Boolean.FALSE);
                }
            } else {
                mdo.putEntry(MDOFields.METADATA_COMPLETE, Boolean.FALSE);
            }
            J2EEName j2eeName = metaDataManager.getJ2EENameFactory().create(appName, moduleName, null);
            mdo.putEntry(MDOFields.J2EE_NAME, j2eeName);
            mdo.putEntry(MDOFields.CLASSLOADER, dmod.getClassLoader());
            mdo.putEntry(MDOFields.CONTAINS_TIMED_EJB, new Boolean(EJBExtensionUtil.containsTimedObject(ejbJarFile)));
            mdo.putEntry(MDOFields.APPLICATION_META_DATA, amd);
            mdo.putEntry(MDOFields.DEPLOYED_MODULE_SOFT_REF, new SoftReference<DeployedModule>(dmod));
            mdo.putEntry(MDOFields.META_DATA_FACTORY_MGR, metaDataManager);
            mdo.putEntry(MDOFields.ENTERPRISE_BEANS, beans);
            DeployedApplication dApp = dmod.getDeployedApplication();
            ConfigObject appConfig = dApp.getClusterApplicationConfig();
            if (appConfig == null) {
                appConfig = dApp.getServerApplicationConfig();
            }
            mdo.putEntry(MDOFields.APPLICATION_CONFIG, appConfig);
            mdo.putEntry(MDOFields.EJB_MODULE_CONFIG, ejbModConfig);
            mdo.putEntry(MDOFields.EJB_MODULE_DD, ejbJarDD);
            mdo.putEntry(MDOFields.EJB_MODULE_EXTENSIONS, dmod.getExtension());
            EJBModuleHelper moduleHelper = new EJBModuleHelper();
            EJBModuleRef ejbModRef = (EJBModuleRef)dmod.getModuleRef();
            moduleHelper.processBindingsFile(ejbModRef);
            mdo.putEntry(MDOFields.MODULE_BINDINGS_HELPER, moduleHelper);
            HashMap<String, Boolean> exceptionMap = new HashMap<String, Boolean>();
            if (ejbJarDD != null && (assemblyDescriptor = ejbJarDD.getAssemblyDescriptor()) != null) {
                EList applicationExceptions = assemblyDescriptor.getApplicationExceptionList();
                for (int i = 0; i < applicationExceptions.size(); ++i) {
                    ApplicationException exceptionClass = (ApplicationException)applicationExceptions.get(i);
                    boolean isRollback = exceptionClass.isRollback();
                    Boolean rollback = Boolean.FALSE;
                    if (isRollback) {
                        rollback = Boolean.TRUE;
                    }
                    exceptionMap.put(exceptionClass.getExceptionClass().getQualifiedName(), rollback);
                }
            }
            mdo.putEntry(MDOFields.APPLICATION_EXCEPTIONS, exceptionMap);
            if (beans != null) {
                for (int i = 0; i < numBeans; ++i) {
                    JavaClass clazz;
                    EnterpriseBean eb = (EnterpriseBean)beans.get(i);
                    String beanName = eb.getName();
                    j2eeName = metaDataManager.getJ2EENameFactory().create(appName, moduleName, beanName);
                    ComponentDataObject cdo = mdo.createComponentDataObject(j2eeName);
                    cdo.putEntry(ComponentDataObjectFields.J2EE_NAME, j2eeName);
                    String ejbClass = eb.getEjbClassName();
                    ClassDataObject classDO = mdo.getClassDataObject(ejbClass);
                    if (classDO == null) {
                        classDO = mdo.createClassDataObject(ejbClass, beanName);
                        mdo.putClassDataObject(classDO);
                    }
                    cdo.ivClassDataObject = classDO;
                    cdo.putEntry(ComponentDataObjectFields.WCCM_ENTERPRISE_BEAN, eb);
                    cdo.putEntry(ComponentDataObjectFields.EJB_NAME, beanName);
                    int beanType = 1;
                    if (eb.isSession() && ((Session)eb).isSetSessionType()) {
                        beanType = ((Session)eb).getSessionType().getValue() == 0 ? 3 : 2;
                    } else if (eb.isEntity()) {
                        beanType = eb instanceof ContainerManagedEntity ? 5 : 4;
                    } else if (eb.isMessageDriven()) {
                        beanType = 6;
                    }
                    if (beanType != 1) {
                        cdo.putEntry(ComponentDataObjectFields.EJB_TYPE, new Integer(beanType));
                    }
                    int txManagementType = 1;
                    boolean txManagementTypeSet = false;
                    if (eb.isSession()) {
                        if (((Session)eb).isSetTransactionType()) {
                            txManagementType = ((Session)eb).getTransactionType().getValue();
                            txManagementTypeSet = true;
                        }
                    } else if (eb.isMessageDriven() && ((MessageDriven)eb).isSetTransactionType()) {
                        txManagementType = ((MessageDriven)eb).getTransactionType().getValue();
                        txManagementTypeSet = true;
                    }
                    if (txManagementTypeSet) {
                        if (txManagementType == 0) {
                            cdo.putEntry(ComponentDataObjectFields.EJB_TX_MANAGEMENT, (Object)TransactionManagementType.BEAN);
                        } else {
                            cdo.putEntry(ComponentDataObjectFields.EJB_TX_MANAGEMENT, (Object)TransactionManagementType.CONTAINER);
                        }
                    }
                    cdo.putEntry(ComponentDataObjectFields.REMOTE_HOME_INTERFACE, eb.getHomeInterfaceName());
                    cdo.putEntry(ComponentDataObjectFields.REMOTE_INTERFACE, eb.getRemoteInterfaceName());
                    cdo.putEntry(ComponentDataObjectFields.LOCAL_HOME_INTERFACE, eb.getLocalHomeInterfaceName());
                    cdo.putEntry(ComponentDataObjectFields.LOCAL_INTERFACE, eb.getLocalInterfaceName());
                    if (eb.isSession()) {
                        EList localInterfaceClasses = ((Session)eb).getLocalBusinessInterfaces();
                        EList remoteInterfaceClasses = ((Session)eb).getRemoteBusinessInterfaces();
                        if (!localInterfaceClasses.isEmpty()) {
                            cdo.putEntry(ComponentDataObjectFields.LOCAL_BUSINESS_INTERFACES, WCCMHelper.getJavaClassNames(localInterfaceClasses));
                        }
                        if (!remoteInterfaceClasses.isEmpty()) {
                            cdo.putEntry(ComponentDataObjectFields.REMOTE_BUSINESS_INTERFACES, WCCMHelper.getJavaClassNames(remoteInterfaceClasses));
                        }
                    }
                    if ((beanType == 2 || beanType == 3) && (clazz = ((Session)eb).getServiceEndpoint()) != null) {
                        cdo.putEntry(ComponentDataObjectFields.WEBSERVICE_ENDPOINT_INTERFACE, clazz.getQualifiedName());
                    }
                    cdo.putEntry(ComponentDataObjectFields.CLASS_NAME, eb.getEjbClassName());
                    if (eb.isEntity()) {
                        cdo.putEntry(ComponentDataObjectFields.PRIMARY_KEY_CLASS_NAME, ((Entity)eb).getPrimaryKeyName());
                    }
                    if (beanType == 6) {
                        ActivationConfig ac;
                        MessageDriven mdb = (MessageDriven)eb;
                        JavaClass jClass = mdb.getMessagingType();
                        if (jClass != null) {
                            cdo.putEntry(ComponentDataObjectFields.MESSAGE_LISTENER_INTERFACE, jClass.getQualifiedName());
                        }
                        if ((ac = mdb.getActivationConfig()) != null) {
                            EList propList;
                            Properties acprops = new Properties();
                            EList acpList = propList = ac.getConfigProperties();
                            for (ActivationConfigProperty p : acpList) {
                                String name = p.getName();
                                String value = p.getValue();
                                acprops.put(name, value);
                            }
                            if (!acprops.isEmpty()) {
                                cdo.putEntry(ComponentDataObjectFields.ACTIVATION_CONFIG_PROPERTIES, acprops);
                            }
                        }
                    }
                    int cmpVersion = 0;
                    String cmpVersionString = null;
                    if (beanType == 5) {
                        if (modVersion >= 30) {
                            Tr.error(tc, "INVALID_CMP_ENTITY_BEAN_CONFIG_CWMDF0019E", new Object[]{beanName, moduleName});
                            throw new EJBConfigurationException("The product does not support container-managed persistence (CMP) Entity beans in Enterprise JavaBeans (EJB) 3.0-level modules. The " + beanName + " bean in the " + moduleName + " module must be moved to an EJB 2.1 or earlier-level module.");
                        }
                        cmpVersionString = ((ContainerManagedEntity)eb).getVersion();
                        if (cmpVersionString.equals("1.x")) {
                            cmpVersion = 1;
                        } else if (cmpVersionString.equals("2.x")) {
                            cmpVersion = 2;
                        }
                    }
                    cdo.putEntry(ComponentDataObjectFields.CMP_VERSION, new Integer(cmpVersion));
                    if (beanType == 4 && modVersion >= 30) {
                        Tr.error(tc, "INVALID_BMP_ENTITY_BEAN_CONFIG_CWMDF0021E", new Object[]{beanName, moduleName});
                        throw new EJBConfigurationException("The product does not support bean-managed persistence (BMP) Entity beans in Enterprise JavaBeans (EJB) 3.0-level modules. The " + beanName + " bean in the " + moduleName + " module must be moved to an EJB 2.1 or earlier-level module.");
                    }
                    String homeInterfaceName = eb.getHomeInterfaceName();
                    cdo.putEntry(ComponentDataObjectFields.REMOTE_HOME_INTERFACE, homeInterfaceName);
                    mdo.putComponentDataObject(cdo);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ModuleDataObject:  ", mdo);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "populateModuleData");
            }
        }
    }

    public static final ArrayList<MetaDataSubObject> getTxAttributes(List tranAttrList, EnterpriseBean enterpriseBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTxAttributes");
        }
        ArrayList<MetaDataSubObject> txAttributes = null;
        if (tranAttrList != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "tranAttrList is not null");
            }
            txAttributes = new ArrayList<MetaDataSubObject>();
            for (int i = 0; i < tranAttrList.size(); ++i) {
                MethodTransaction methodTransaction = (MethodTransaction)tranAttrList.get(i);
                int tranType = methodTransaction.getTransactionAttribute().getValue();
                EList methodElements = methodTransaction.getMethodElements();
                for (int j = 0; j < methodElements.size(); ++j) {
                    MethodElement me = (MethodElement)methodElements.get(j);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "MethodElement EnterpriseBean name:", me.getEnterpriseBean());
                        Tr.debug(tc, "MethodElement method name:", me.getName());
                        Tr.debug(tc, "MethodElement method parms:", me.getParms());
                        if (me.isUnspecified()) {
                            Tr.debug(tc, "Interface type unspecified");
                        } else {
                            Tr.debug(tc, "Interface type:", new Integer(me.getType().getValue()));
                        }
                    }
                    if (me.getEnterpriseBean() != enterpriseBean) continue;
                    String methodName = me.getName().trim();
                    int methodType = me.getType().getValue();
                    String methodSignature = me.getParms();
                    TransactionAttributeType txAttribute = JEE15TxFromMofMap[tranType];
                    MetaDataSubObject mdso = new MetaDataSubObject(MetaDataScope.METHOD, methodName, methodType, methodSignature, (Object)txAttribute);
                    txAttributes.add(mdso);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTxAttributes");
        }
        return txAttributes;
    }

    private static final void populateJEE15TxFromMofMap() {
        JEE15TxFromMofMap = new TransactionAttributeType[6];
        WCCMConfigReader.JEE15TxFromMofMap[0] = TransactionAttributeType.NOT_SUPPORTED;
        WCCMConfigReader.JEE15TxFromMofMap[1] = TransactionAttributeType.SUPPORTS;
        WCCMConfigReader.JEE15TxFromMofMap[2] = TransactionAttributeType.REQUIRED;
        WCCMConfigReader.JEE15TxFromMofMap[3] = TransactionAttributeType.REQUIRES_NEW;
        WCCMConfigReader.JEE15TxFromMofMap[4] = TransactionAttributeType.MANDATORY;
        WCCMConfigReader.JEE15TxFromMofMap[5] = TransactionAttributeType.NEVER;
    }

    static {
        isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
        if (isZOS) {
            common_tc = Tr.register("BeanMetaData390Msgs", "MetaDataConfigConstants.traceString", "com.ibm.ejs.resources.ws390Messages");
        }
        WCCMConfigReader.populateJEE15TxFromMofMap();
    }
}

