/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.csi.J2EENameImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ComponentDataObject;
import com.ibm.ws.metadata.ComponentDataObjectFields;
import com.ibm.ws.metadata.ConfigReader;
import com.ibm.ws.metadata.MDOFields;
import com.ibm.ws.metadata.MetaDataSources;
import com.ibm.ws.metadata.ModuleDataObject;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.WCCMHelper;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.JarFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;

public class StubGenWCCMConfigReader
implements ConfigReader {
    private static final String BUNDLE_NAME = "com.ibm.ws.metadata.metadata";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.metadata.metadata", Locale.getDefault());
    private static final String CLASS_NAME = StubGenWCCMConfigReader.class.getName();
    private static TraceComponent tc = Tr.register(CLASS_NAME, "MetaData", "com.ibm.ws.metadata.metadata");
    private static TraceComponent common_tc = null;
    private static boolean isZOS = false;

    public void populateModuleData(ModuleDataObject mdo, MetaDataSources mds) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "populateModuleData");
        }
        try {
            JarFile jar = (JarFile)mds.iv_Sources[MetaDataSources.sv_JarFileIndex];
            if (jar != null) {
                String moduleName = jar.getName();
                CommonarchiveFactory archiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
                EJBJarFile ejbJarFile = archiveFactory.openEJBJarFile(moduleName);
                EJBJar ejbJarDD = WCCMHelper.getDeploymentDescriptor(ejbJarFile, false);
                mdo.putEntry(MDOFields.MODULE_NAME, moduleName);
                int modVersion = ejbJarDD == null ? 30 : ejbJarDD.getVersionID();
                mdo.putEntry(MDOFields.MODULE_VERSION, new Integer(modVersion));
                if (modVersion < 30) {
                    mdo.putEntry(MDOFields.METADATA_COMPLETE, Boolean.TRUE);
                } else if (ejbJarDD != null) {
                    if (ejbJarDD.isSetMetadataComplete()) {
                        mdo.putEntry(MDOFields.METADATA_COMPLETE, new Boolean(ejbJarDD.isMetadataComplete()));
                    } else {
                        mdo.putEntry(MDOFields.METADATA_COMPLETE, Boolean.FALSE);
                    }
                } else {
                    mdo.putEntry(MDOFields.METADATA_COMPLETE, Boolean.FALSE);
                }
                if (ejbJarDD != null) {
                    EList beans = ejbJarDD.getEnterpriseBeans();
                    int numBeans = beans.size();
                    for (int i = 0; i < numBeans; ++i) {
                        EnterpriseBean eb = (EnterpriseBean)beans.get(i);
                        String beanName = eb.getName();
                        J2EENameImpl j2eeName = new J2EENameImpl("", "", beanName);
                        ComponentDataObject cdo = mdo.createComponentDataObject(j2eeName);
                        String ejbClass = eb.getEjbClassName();
                        ClassDataObject classDO = mdo.getClassDataObject(ejbClass);
                        if (classDO == null) {
                            classDO = mdo.createClassDataObject(ejbClass, beanName);
                            mdo.putClassDataObject(classDO);
                        }
                        cdo.ivClassDataObject = classDO;
                        int beanType = 1;
                        if (eb.isSession() && ((Session)eb).isSetSessionType()) {
                            beanType = ((Session)eb).getSessionType().getValue() == 0 ? 3 : 2;
                        } else if (eb.isEntity()) {
                            beanType = eb instanceof ContainerManagedEntity ? 5 : 4;
                        } else if (eb.isMessageDriven()) {
                            beanType = 6;
                        }
                        if (beanType != 1) {
                            cdo.putEntry(ComponentDataObjectFields.EJB_TYPE, new Integer(beanType));
                        }
                        cdo.putEntry(ComponentDataObjectFields.EJB_NAME, beanName);
                        cdo.putEntry(ComponentDataObjectFields.REMOTE_HOME_INTERFACE, eb.getHomeInterfaceName());
                        cdo.putEntry(ComponentDataObjectFields.REMOTE_INTERFACE, eb.getRemoteInterfaceName());
                        if (eb.isSession()) {
                            EList localInterfaceClasses = ((Session)eb).getLocalBusinessInterfaces();
                            EList remoteInterfaceClasses = ((Session)eb).getRemoteBusinessInterfaces();
                            if (!localInterfaceClasses.isEmpty()) {
                                cdo.putEntry(ComponentDataObjectFields.LOCAL_BUSINESS_INTERFACES, WCCMHelper.getJavaClassNames(localInterfaceClasses));
                            }
                            if (!remoteInterfaceClasses.isEmpty()) {
                                cdo.putEntry(ComponentDataObjectFields.REMOTE_BUSINESS_INTERFACES, WCCMHelper.getJavaClassNames(remoteInterfaceClasses));
                            }
                        }
                        mdo.putComponentDataObject(cdo);
                    }
                }
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ModuleDataObject:  ", mdo);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "populateModuleData");
                    }
                }
                ejbJarFile.close();
            }
        }
        catch (Throwable t) {
            StubGenWCCMConfigReader.issueMessage("UNEXPECTED_EXCEPTION_CWMDF9000E", new Object[]{t.getLocalizedMessage()}, null);
            t.printStackTrace();
        }
    }

    private static void issueMessage(String key, Object[] args, String defaultMsg) {
        String msg = StubGenWCCMConfigReader.getFormattedMetadataMessage(key, args, defaultMsg);
        System.out.println(msg);
    }

    private static String getFormattedMetadataMessage(String key, Object[] args, String defaultString) {
        try {
            String result = RESOURCE_BUNDLE.getString(key);
            if (result == null) {
                return defaultString;
            }
            return MessageFormat.format(result, args);
        }
        catch (MissingResourceException e) {
            if (defaultString == null) {
                return defaultString;
            }
            return MessageFormat.format(defaultString, args);
        }
        catch (NullPointerException npe) {
            return defaultString;
        }
    }

    static {
        isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
        if (isZOS) {
            common_tc = Tr.register("BeanMetaData390Msgs", "MetaDataConfigConstants.traceString", "com.ibm.ejs.resources.ws390Messages");
        }
    }
}

