/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ClassDataObjectFields;
import com.ibm.ws.metadata.ComponentDataObjectFields;
import com.ibm.ws.metadata.MDOFields;
import com.ibm.ws.metadata.MergerInfo;
import com.ibm.ws.metadata.MetaDataSubObject;
import com.ibm.ws.metadata.ModuleDataObject;
import com.ibm.ws.security.util.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.Local;
import javax.ejb.LocalHome;
import javax.ejb.MessageDriven;
import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;

public class ComponentDataObject {
    private static final String CLASS_NAME = ComponentDataObject.class.getName();
    private static TraceComponent tc = Tr.register(CLASS_NAME, "MetaData", "com.ibm.ws.metadata.metadata");
    protected J2EEName iv_Key;
    public ClassDataObject ivClassDataObject;
    protected EnumMap<ComponentDataObjectFields, Object> iv_CDOMap = new EnumMap(ComponentDataObjectFields.class);
    public MergerInfo iv_MergerInfo;
    public ModuleDataObject iv_MDO;
    public ArrayList<String> ivLocalsOnImplements;
    public ArrayList<String> ivRemotesOnImplements;
    public ArrayList<String> ivPojosOnImplements;
    public int ivInterfacesOnImplements;

    ComponentDataObject(J2EEName j2eeName, ModuleDataObject mdo) {
        this(mdo);
        this.iv_Key = j2eeName;
    }

    ComponentDataObject(ModuleDataObject mdo) {
        this.iv_MDO = mdo;
    }

    public final Object getCDOEntry(String key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getCDOEntry entry/exit");
        }
        ComponentDataObjectFields keyName = Enum.valueOf(ComponentDataObjectFields.class, key);
        return this.iv_CDOMap.get((Object)keyName);
    }

    public final Object getEntry(ComponentDataObjectFields keyName) {
        return this.iv_CDOMap.get((Object)keyName);
    }

    public final void putEntry(ComponentDataObjectFields key, MetaDataSubObject value) {
        ArrayList<MetaDataSubObject> arrayList = (ArrayList<MetaDataSubObject>)this.iv_CDOMap.get((Object)key);
        if (arrayList == null) {
            arrayList = new ArrayList<MetaDataSubObject>();
            this.iv_CDOMap.put(key, arrayList);
        }
        arrayList.add(value);
    }

    public final void putEntry(ComponentDataObjectFields key, Object value) {
        this.iv_CDOMap.put(key, value);
    }

    public final void setKey(J2EEName key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setKey: ", key);
        }
        this.iv_Key = key;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "putEntry");
        }
    }

    public final void finishCDO() throws EJBConfigurationException {
        Integer ejbType;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishCDO", this);
        }
        if (this.ivClassDataObject.iv_MergerInfo == null) {
            this.getAnnotationsFromClass();
        }
        this.iv_MergerInfo = this.ivClassDataObject.iv_MergerInfo;
        String ejbName = (String)this.getEntry(ComponentDataObjectFields.EJB_NAME);
        if (ejbName == null) {
            ejbName = (String)this.ivClassDataObject.getEntry(ClassDataObjectFields.EJB_NAME);
            if (ejbName == null) {
                ejbName = (String)this.ivClassDataObject.getEntry(ClassDataObjectFields.SHORT_CLASS_NAME);
            }
            if (ejbName != null) {
                this.putEntry(ComponentDataObjectFields.EJB_NAME, ejbName);
            }
        }
        if ((ejbType = (Integer)this.getEntry(ComponentDataObjectFields.EJB_TYPE)) == null) {
            ejbType = (Integer)this.ivClassDataObject.getEntry(ClassDataObjectFields.EJB_TYPE);
            if (ejbType != null) {
                this.putEntry(ComponentDataObjectFields.EJB_TYPE, ejbType);
            }
        } else {
            Integer annotationEJBType = (Integer)this.ivClassDataObject.getEntry(ClassDataObjectFields.EJB_TYPE);
            if (annotationEJBType != null && !ejbType.equals(annotationEJBType)) {
                String ejbTypeString = this.getEJBTypeString(ejbType);
                String annotationTypeString = this.getEJBTypeString(annotationEJBType);
                Tr.error(tc, "EJB_DEFINED_AS_TWO_TYPES_CWMDF0006E", new Object[]{ejbName, ejbTypeString, annotationTypeString});
                EJBConfigurationException ex = new EJBConfigurationException("EJB '" + ejbName + "' defined as both '" + ejbTypeString + "' and '" + annotationTypeString + "'");
                FFDCFilter.processException((Throwable)ex, CLASS_NAME + "finishCDO", "348", this);
                throw ex;
            }
        }
        if (ejbType != null && (ejbType == 6 || ejbType == 3 || ejbType == 2)) {
            String remoteHomeInterface;
            String localHomeInterface;
            J2EEName j2eeName;
            TransactionManagementType txManagement = (TransactionManagementType)((Object)this.getEntry(ComponentDataObjectFields.EJB_TX_MANAGEMENT));
            if (txManagement == null) {
                txManagement = (TransactionManagementType)((Object)this.ivClassDataObject.getEntry(ClassDataObjectFields.EJB_TX_MANAGEMENT));
                if (txManagement != null) {
                    this.putEntry(ComponentDataObjectFields.EJB_TX_MANAGEMENT, (Object)txManagement);
                }
            } else {
                TransactionManagementType annotationTxManagement = (TransactionManagementType)((Object)this.ivClassDataObject.getEntry(ClassDataObjectFields.EJB_TX_MANAGEMENT));
                if (annotationTxManagement != null && !txManagement.equals((Object)annotationTxManagement)) {
                    Tr.error(tc, "EJB_DEFINED_AS_TWO_TX_MANAGEMENT_TYPES_CWMDF0014E", new Object[]{ejbName, txManagement, annotationTxManagement});
                    EJBConfigurationException ex = new EJBConfigurationException("Bean '" + ejbName + "' has been defined as transaction management type '" + (Object)((Object)txManagement) + "' in XML and '" + (Object)((Object)annotationTxManagement) + "' in annotations.");
                    FFDCFilter.processException((Throwable)ex, CLASS_NAME + "finishCDO", "376", this);
                    throw ex;
                }
            }
            if ((j2eeName = (J2EEName)this.getEntry(ComponentDataObjectFields.J2EE_NAME)) == null && (j2eeName = (J2EEName)this.ivClassDataObject.getEntry(ClassDataObjectFields.J2EE_NAME)) != null) {
                this.putEntry(ComponentDataObjectFields.J2EE_NAME, j2eeName);
            }
            this.setInterfacesFromImplements(ejbType);
            if (ejbType != 6) {
                String[] pojoInterfaces;
                String[] remoteAnnotationInterfaces;
                String[] localAnnotationInterfaces;
                String[] remoteXMLInterfaces;
                HashSet<String> localSet = new HashSet<String>();
                HashSet<String> remoteSet = new HashSet<String>();
                String[] localXMLInterfaces = (String[])this.getEntry(ComponentDataObjectFields.LOCAL_BUSINESS_INTERFACES);
                if (localXMLInterfaces != null) {
                    localSet.addAll(Arrays.asList(localXMLInterfaces));
                }
                if ((remoteXMLInterfaces = (String[])this.getEntry(ComponentDataObjectFields.REMOTE_BUSINESS_INTERFACES)) != null) {
                    remoteSet.addAll(Arrays.asList(remoteXMLInterfaces));
                }
                if ((localAnnotationInterfaces = (String[])this.ivClassDataObject.getEntry(ClassDataObjectFields.LOCAL_BUSINESS_INTERFACES)) != null) {
                    localSet.addAll(Arrays.asList(localAnnotationInterfaces));
                }
                if ((remoteAnnotationInterfaces = (String[])this.ivClassDataObject.getEntry(ClassDataObjectFields.REMOTE_BUSINESS_INTERFACES)) != null) {
                    remoteSet.addAll(Arrays.asList(remoteAnnotationInterfaces));
                }
                localSet.addAll(this.ivLocalsOnImplements);
                remoteSet.addAll(this.ivRemotesOnImplements);
                if (this.iv_MergerInfo.ivEmptyLocal && this.iv_MergerInfo.ivEmptyRemote) {
                    Tr.error(tc, "EMPTY_REMOTE_AND_LOCAL_ANNOTATIONS_ON_SAME_BEAN_CLASS_CWMDF0004E", this.getEntry(ComponentDataObjectFields.CLASS_NAME));
                    EJBConfigurationException ex = new EJBConfigurationException("EMPTY_REMOTE_AND_LOCAL_ANNOTATIONS_ON_SAME_BEAN_CLASS '" + this.getEntry(ComponentDataObjectFields.CLASS_NAME) + "'");
                    FFDCFilter.processException((Throwable)ex, CLASS_NAME + "finishCDO", "489", this);
                    throw ex;
                }
                if ((this.iv_MergerInfo.ivEmptyLocal || this.iv_MergerInfo.ivEmptyRemote) && this.ivInterfacesOnImplements != 1) {
                    Tr.error(tc, "INCORRECT_CONFIGURATION_OF_MULTIPLE_BUSINESS_INTERFACES_CWMDF0005E", this.getEntry(ComponentDataObjectFields.CLASS_NAME));
                    EJBConfigurationException ex = new EJBConfigurationException("BUSINESS_INTERFACES_CONFIGURATION_ERROR - One and only one business interface can be defined via implements clause of bean class." + this.getEntry(ComponentDataObjectFields.EJB_NAME));
                    FFDCFilter.processException((Throwable)ex, CLASS_NAME + "finishCDO", "503", this);
                    throw ex;
                }
                if (!this.ivPojosOnImplements.isEmpty() && (pojoInterfaces = this.ivPojosOnImplements.toArray(new String[0])).length == 1) {
                    if (this.iv_MergerInfo.ivEmptyRemote) {
                        remoteSet.add(pojoInterfaces[0]);
                    } else if (this.iv_MergerInfo.ivEmptyLocal) {
                        localSet.add(pojoInterfaces[0]);
                    } else if (localSet.isEmpty() && remoteSet.isEmpty()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Single interface on implements " + pojoInterfaces[0] + " set as local business interface");
                        }
                        localSet.add(pojoInterfaces[0]);
                    }
                }
                String[] mergedRemoteInterfaces = null;
                String[] mergedLocalInterfaces = null;
                if (!remoteSet.isEmpty()) {
                    mergedRemoteInterfaces = remoteSet.toArray(new String[0]);
                }
                if (!localSet.isEmpty()) {
                    mergedLocalInterfaces = localSet.toArray(new String[0]);
                }
                if (mergedRemoteInterfaces != null && !remoteSet.isEmpty() && !localSet.isEmpty()) {
                    for (int i = 0; i < mergedRemoteInterfaces.length; ++i) {
                        if (!localSet.contains(mergedRemoteInterfaces[i])) continue;
                        Tr.error(tc, "BUSINESS_INTERFACE_DESIGNATED_AS_BOTH_REMOTE_AND_LOCAL_CWMDF0003E", mergedRemoteInterfaces[i]);
                        EJBConfigurationException ex = new EJBConfigurationException("BUSINESS_INTERFACE_DESIGNATED_AS_BOTH_REMOTE_AND_LOCAL: '" + mergedRemoteInterfaces[i] + "'");
                        FFDCFilter.processException((Throwable)ex, CLASS_NAME + "finishCDO", "558", this);
                        throw ex;
                    }
                }
                if (!remoteSet.isEmpty()) {
                    this.putEntry(ComponentDataObjectFields.REMOTE_BUSINESS_INTERFACES, mergedRemoteInterfaces);
                }
                if (!localSet.isEmpty()) {
                    this.putEntry(ComponentDataObjectFields.LOCAL_BUSINESS_INTERFACES, mergedLocalInterfaces);
                }
            }
            if ((localHomeInterface = (String)this.getEntry(ComponentDataObjectFields.LOCAL_HOME_INTERFACE)) == null && (localHomeInterface = (String)this.ivClassDataObject.getEntry(ClassDataObjectFields.LOCAL_HOME_INTERFACE)) != null) {
                this.putEntry(ComponentDataObjectFields.LOCAL_HOME_INTERFACE, localHomeInterface);
            }
            if (ejbType == 6) {
                String messageListenerInterface = (String)this.getEntry(ComponentDataObjectFields.MESSAGE_LISTENER_INTERFACE);
                if (messageListenerInterface == null) {
                    messageListenerInterface = (String)this.ivClassDataObject.getEntry(ClassDataObjectFields.MESSAGE_LISTENER_INTERFACE);
                    if (messageListenerInterface != null) {
                        this.putEntry(ComponentDataObjectFields.MESSAGE_LISTENER_INTERFACE, messageListenerInterface);
                    } else if (!this.ivPojosOnImplements.isEmpty() && this.ivPojosOnImplements.size() == 1) {
                        this.putEntry(ComponentDataObjectFields.MESSAGE_LISTENER_INTERFACE, this.ivPojosOnImplements.get(0));
                    }
                }
                Properties annotationProperties = (Properties)this.ivClassDataObject.getEntry(ClassDataObjectFields.ACTIVATION_CONFIG_PROPERTIES);
                Properties xmlProperties = (Properties)this.getEntry(ComponentDataObjectFields.ACTIVATION_CONFIG_PROPERTIES);
                if (annotationProperties != null && xmlProperties != null) {
                    annotationProperties.putAll((Map<?, ?>)xmlProperties);
                }
                if (annotationProperties != null) {
                    this.putEntry(ComponentDataObjectFields.ACTIVATION_CONFIG_PROPERTIES, annotationProperties);
                }
            }
            if ((remoteHomeInterface = (String)this.getEntry(ComponentDataObjectFields.REMOTE_HOME_INTERFACE)) == null && (remoteHomeInterface = (String)this.ivClassDataObject.getEntry(ClassDataObjectFields.REMOTE_HOME_INTERFACE)) != null) {
                this.putEntry(ComponentDataObjectFields.REMOTE_HOME_INTERFACE, remoteHomeInterface);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishCDO", this);
        }
    }

    private void setInterfacesFromImplements(int ejbType) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setInterfaceFromImplements", Arrays.toString(this.ivClassDataObject.iv_MergerInfo.iv_Implements));
        }
        this.ivInterfacesOnImplements = 0;
        String[] interfaces = this.ivClassDataObject.iv_MergerInfo.iv_Implements;
        if (interfaces != null) {
            ArrayList<String> locals = new ArrayList<String>(interfaces.length);
            ArrayList<String> remotes = new ArrayList<String>(interfaces.length);
            ArrayList<String> pojos = new ArrayList<String>(interfaces.length);
            for (int i = 0; i < interfaces.length; ++i) {
                String s = interfaces[i];
                s = s.replace("/", ".");
                boolean startsWithJavax = false;
                if (s.length() >= 11) {
                    startsWithJavax = s.substring(0, 10).equals("javax.ejb.");
                }
                if (s.equals("java.io.Serializable") || s.equals("java.io.Externalizable") || startsWithJavax) continue;
                ClassDataObject classDO = this.iv_MDO.getClassDataObject(s);
                boolean localInterface = false;
                boolean remoteInterface = false;
                if (classDO != null) {
                    if (classDO.iv_MergerInfo.ivEmptyLocal) {
                        localInterface = true;
                        locals.add(s);
                    }
                    if (classDO.iv_MergerInfo.ivEmptyRemote) {
                        remoteInterface = true;
                        remotes.add(s);
                    }
                } else if (ejbType != 6 && this.iv_MDO.ivScannedClasses != null && !this.iv_MDO.ivScannedClasses.contains(s)) {
                    Class<?> classToCheck = null;
                    try {
                        ClassLoader appClassloader = (ClassLoader)this.iv_MDO.getEntry(MDOFields.CLASSLOADER);
                        classToCheck = Class.forName(s, false, appClassloader);
                    }
                    catch (ClassNotFoundException ex) {
                        String excMsg = TraceNLS.getFormattedMessage("com.ibm.ws.metadata.metadata", "INTERFACE_CANNOT_BE_LOADED_CWMDF0015E", new Object[]{s, this.ivClassDataObject.iv_Key}, "CWMDF0015E: The class loader cannot load the " + s + " interface on the " + this.ivClassDataObject.iv_Key + " Enterprise JavaBeans (EJB) file.");
                        Tr.error(tc, excMsg);
                        EJBConfigurationException ex1 = new EJBConfigurationException(excMsg);
                        FFDCFilter.processException((Throwable)ex, CLASS_NAME + " setInterfacesFromImplements", "799", this);
                        throw ex1;
                    }
                    if (classToCheck != null) {
                        Local localAnnotation;
                        Remote remoteAnnotation = classToCheck.getAnnotation(Remote.class);
                        if (remoteAnnotation != null) {
                            remoteInterface = true;
                            remotes.add(s);
                        }
                        if ((localAnnotation = classToCheck.getAnnotation(Local.class)) != null) {
                            localInterface = true;
                            locals.add(s);
                        }
                    }
                }
                if (!localInterface && !remoteInterface) {
                    pojos.add(s);
                }
                if (!localInterface || !remoteInterface) continue;
                Tr.error(tc, "BUSINESS_INTERFACE_DESIGNATED_AS_BOTH_REMOTE_AND_LOCAL_CWMDF0003E", s);
                EJBConfigurationException ex = new EJBConfigurationException("BUSINESS_INTERFACE_DESIGNATED_AS_BOTH_REMOTE_AND_LOCAL: '" + s + "'");
                FFDCFilter.processException((Throwable)ex, CLASS_NAME + " setInterfacesFromImplements", "738", this);
                throw ex;
            }
            this.ivLocalsOnImplements = locals;
            this.ivRemotesOnImplements = remotes;
            this.ivPojosOnImplements = pojos;
            this.ivInterfacesOnImplements = this.ivLocalsOnImplements.size() + this.ivRemotesOnImplements.size() + this.ivPojosOnImplements.size();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Local Business Interfaces on implements clause: " + Arrays.toString(this.ivLocalsOnImplements.toArray()));
            Tr.debug(tc, "Remote Business Interfaces on implements clause: " + Arrays.toString(this.ivRemotesOnImplements.toArray()));
            Tr.debug(tc, "Pojo Interfaces on implements clause: " + Arrays.toString(this.ivPojosOnImplements.toArray()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setInterfaceFromImplements");
        }
    }

    private String getEJBTypeString(Integer type) {
        String result = "UNKNOWN";
        int intType = type;
        if (intType == 2) {
            result = "STATELESS_SESSION";
        } else if (intType == 3) {
            result = "STATEFUL_SESSION";
        } else if (intType == 4) {
            result = "BEAN_MANAGED_ENTITY";
        } else if (intType == 5) {
            result = "CONTAINER_MANAGED_ENTITY";
        } else if (intType == 6) {
            result = "MESSAGE_DRIVEN";
        }
        return result;
    }

    public String toString() {
        if (this.iv_Key != null) {
            String newLine = (String)AccessController.doPrivileged(new SystemGetPropertyPrivileged("line.separator", "\n"));
            StringBuffer sb = new StringBuffer();
            String indent = "     ";
            Set<ComponentDataObjectFields> cdoSet = this.iv_CDOMap.keySet();
            Object[] cdoKeys = null;
            cdoKeys = cdoSet.toArray();
            sb.append(newLine + newLine + indent + "*** START ComponentDataObject fields ***");
            sb.append(newLine + indent + "Key = " + this.iv_Key);
            if (this.iv_MergerInfo != null) {
                sb.append(newLine + indent + "Merger_Info = " + this.iv_MergerInfo);
            }
            for (int j = 0; j < cdoKeys.length; ++j) {
                Object entry = this.iv_CDOMap.get(cdoKeys[j]);
                if (entry instanceof Object[]) {
                    sb.append(this.objectArrayToString(cdoKeys[j].toString(), (Object[])entry, newLine + indent));
                    continue;
                }
                if (entry instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)entry;
                    sb.append(this.objectArrayToString(cdoKeys[j].toString(), arrayList.toArray(), newLine + indent));
                    continue;
                }
                sb.append(newLine + indent + cdoKeys[j] + " = " + entry);
            }
            sb.append(newLine + indent + "*** END ComponentDataObject fields  ***");
            return sb.toString();
        }
        return "ComponentDataObject is empty";
    }

    private StringBuffer objectArrayToString(String key, Object[] objectArray, String separator) {
        StringBuffer sb = new StringBuffer();
        if (objectArray != null) {
            int k = 0;
            for (k = 0; k < objectArray.length; ++k) {
                if (objectArray[k] == null) continue;
                if (objectArray[k] instanceof Object[]) {
                    sb.append(separator + key + "[" + k + "]" + " = " + Arrays.toString((Object[])objectArray[k]));
                    continue;
                }
                sb.append(separator + key + "[" + k + "]" + " = " + objectArray[k]);
            }
            if (k == 0) {
                sb.append(separator + key + " = null");
            }
        }
        return sb;
    }

    private void getAnnotationsFromClass() throws EJBConfigurationException {
        Remote remoteAnnotation;
        LocalHome localHomeAnnotation;
        RemoteHome remoteHomeAnnotation;
        TransactionManagement transactionManagementAnnotation;
        MessageDriven messageDrivenAnnotation;
        Stateful statefulAnnotation;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAnnotationsFromClass");
        }
        Class<?> classToCheck = null;
        String ejbClassName = this.ivClassDataObject.iv_Key;
        String ejbJ2EEName = ((Object)this.iv_Key).toString();
        ClassLoader appClassloader = (ClassLoader)this.iv_MDO.getEntry(MDOFields.CLASSLOADER);
        try {
            classToCheck = Class.forName(ejbClassName, false, appClassloader);
        }
        catch (ClassNotFoundException ex) {
            EJBConfigurationException ex2 = new EJBConfigurationException("The bean class '" + ejbClassName + "' for EJB '" + ejbJ2EEName + "' is not found.");
            Tr.error(tc, "EJB_CLASS_NOT_FOUND_CWMDF0012E", new Object[]{ejbClassName, ejbJ2EEName});
            FFDCFilter.processException((Throwable)ex, CLASS_NAME + "getAnnotationsFromClass", "1014", this);
            throw ex2;
        }
        if (classToCheck == null) {
            EJBConfigurationException ex = new EJBConfigurationException("The bean class '" + ejbClassName + "' for EJB '" + ((Object)this.iv_Key).toString() + "' is not found.");
            Tr.error(tc, "EJB_CLASS_NOT_FOUND_CWMDF0012E", new Object[]{ejbClassName, ejbJ2EEName});
            FFDCFilter.processException((Throwable)ex, CLASS_NAME + "getAnnotationsFromClass", "1026", this);
            throw ex;
        }
        this.ivClassDataObject.putEntry(ClassDataObjectFields.CLASS_NAME, classToCheck.getName());
        this.ivClassDataObject.putEntry(ClassDataObjectFields.SHORT_CLASS_NAME, classToCheck.getSimpleName());
        this.ivClassDataObject.iv_MergerInfo = new MergerInfo();
        this.reflectMergerInfo(classToCheck);
        String ejbType = null;
        Stateless statelessAnnotation = classToCheck.getAnnotation(Stateless.class);
        if (statelessAnnotation != null) {
            ejbType = "Stateless";
            this.reflectStateless(statelessAnnotation);
        }
        if ((statefulAnnotation = classToCheck.getAnnotation(Stateful.class)) != null) {
            if (ejbType != null) {
                Tr.error(tc, "EJB_DEFINED_AS_TWO_TYPES_CWMDF0020E", new Object[]{((Object)this.iv_Key).toString(), ejbType, "Stateful"});
                EJBConfigurationException ex = new EJBConfigurationException("EJB '" + ejbJ2EEName + "' is annotated with both '@" + ejbType + "' and '@Stateful' annotations.");
                FFDCFilter.processException((Throwable)ex, CLASS_NAME + "getAnnotationsFromClass", "1056", this);
                throw ex;
            }
            ejbType = "Stateful";
            this.reflectStateful(statefulAnnotation);
        }
        if ((messageDrivenAnnotation = classToCheck.getAnnotation(MessageDriven.class)) != null) {
            if (ejbType != null) {
                Tr.error(tc, "EJB_DEFINED_AS_TWO_TYPES_CWMDF0020E", new Object[]{((Object)this.iv_Key).toString(), ejbType, "MessageDriven"});
                EJBConfigurationException ex = new EJBConfigurationException("EJB '" + ejbJ2EEName + "' is annotated with both '@" + ejbType + "' and '@MessageDriven' annotations.");
                FFDCFilter.processException((Throwable)ex, CLASS_NAME + "getAnnotationsFromClass", "1074", this);
                throw ex;
            }
            ejbType = "MessageDriven";
            this.reflectMessageDriven(messageDrivenAnnotation);
        }
        if ((transactionManagementAnnotation = classToCheck.getAnnotation(TransactionManagement.class)) != null) {
            this.reflectTransactionManagement(transactionManagementAnnotation);
        }
        if ((remoteHomeAnnotation = classToCheck.getAnnotation(RemoteHome.class)) != null) {
            this.reflectRemoteHome(remoteHomeAnnotation);
        }
        if ((localHomeAnnotation = classToCheck.getAnnotation(LocalHome.class)) != null) {
            this.reflectLocalHome(localHomeAnnotation);
        }
        if ((remoteAnnotation = classToCheck.getAnnotation(Remote.class)) != null) {
            this.reflectRemote(remoteAnnotation);
        }
        Local localAnnotation = classToCheck.getAnnotation(Local.class);
        if (remoteAnnotation != null) {
            this.reflectLocal(localAnnotation);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ClassDataObject from Reflection" + this.ivClassDataObject.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAnnotationsFromClass");
        }
    }

    private void reflectMergerInfo(Class classToCheck) {
        Class<?>[] interfaces;
        Class superClass;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reflectMergerInfo");
        }
        if ((superClass = classToCheck.getSuperclass()) != null) {
            this.ivClassDataObject.iv_MergerInfo.iv_Extends = superClass.getName();
        }
        if ((interfaces = classToCheck.getInterfaces()) != null) {
            this.ivClassDataObject.iv_MergerInfo.iv_Implements = new String[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                this.ivClassDataObject.iv_MergerInfo.iv_Implements[i] = interfaces[i].getName();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reflectMergerInfo");
        }
    }

    private void reflectStateless(Stateless statelessAnnotation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reflectStateless");
        }
        Integer i = new Integer(2);
        this.ivClassDataObject.putEntry(ClassDataObjectFields.EJB_TYPE, i);
        this.ivClassDataObject.putEntry(ClassDataObjectFields.EJB_NAME, statelessAnnotation.name());
        this.ivClassDataObject.putEntry(ClassDataObjectFields.MAPPED_NAME, statelessAnnotation.mappedName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reflectStateless");
        }
    }

    private void reflectStateful(Stateful statefulAnnotation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reflectStateful");
        }
        Integer i = new Integer(3);
        this.ivClassDataObject.putEntry(ClassDataObjectFields.EJB_TYPE, i);
        this.ivClassDataObject.putEntry(ClassDataObjectFields.EJB_NAME, statefulAnnotation.name());
        this.ivClassDataObject.putEntry(ClassDataObjectFields.MAPPED_NAME, statefulAnnotation.mappedName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reflectStateful");
        }
    }

    private void reflectMessageDriven(MessageDriven messageDrivenAnnotation) {
        ActivationConfigProperty[] activationConfigPropertyAnnotations;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reflectMessageDriven");
        }
        Integer i = new Integer(6);
        this.ivClassDataObject.putEntry(ClassDataObjectFields.EJB_TYPE, i);
        this.ivClassDataObject.putEntry(ClassDataObjectFields.EJB_NAME, messageDrivenAnnotation.name());
        this.ivClassDataObject.putEntry(ClassDataObjectFields.MAPPED_NAME, messageDrivenAnnotation.mappedName());
        Class messageListenerInterfaceClass = messageDrivenAnnotation.messageListenerInterface();
        if (messageListenerInterfaceClass != null) {
            this.ivClassDataObject.putEntry(ClassDataObjectFields.MESSAGE_LISTENER_INTERFACE, messageListenerInterfaceClass.getName());
        }
        if ((activationConfigPropertyAnnotations = messageDrivenAnnotation.activationConfig()) != null) {
            Properties activationConfigProperties = new Properties();
            for (ActivationConfigProperty propertyAnnotation : activationConfigPropertyAnnotations) {
                activationConfigProperties.setProperty(propertyAnnotation.propertyName(), propertyAnnotation.propertyValue());
            }
            this.ivClassDataObject.putEntry(ClassDataObjectFields.ACTIVATION_CONFIG_PROPERTIES, activationConfigProperties);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reflectMessageDriven");
        }
    }

    private void reflectTransactionManagement(TransactionManagement transactionManagementAnnotation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reflectTransactionManagement");
        }
        this.ivClassDataObject.putEntry(ClassDataObjectFields.EJB_TX_MANAGEMENT, (Object)transactionManagementAnnotation.value());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reflectTransactionManagement");
        }
    }

    private void reflectRemoteHome(RemoteHome remoteHomeAnnotation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reflectRemoteHome", remoteHomeAnnotation.value().getName());
        }
        if (remoteHomeAnnotation.value() != null) {
            this.ivClassDataObject.putEntry(ClassDataObjectFields.REMOTE_HOME_INTERFACE, remoteHomeAnnotation.value().getName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reflectRemoteHome");
        }
    }

    private void reflectLocalHome(LocalHome localHomeAnnotation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reflectLocalHome", localHomeAnnotation.value().getName());
        }
        this.ivClassDataObject.putEntry(ClassDataObjectFields.LOCAL_HOME_INTERFACE, localHomeAnnotation.value().getName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reflectLocalHome");
        }
    }

    private void reflectRemote(Remote remoteAnnotation) {
        Class[] remoteBusinessInterfaces;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reflectRemote");
        }
        if ((remoteBusinessInterfaces = remoteAnnotation.value()) == null || remoteBusinessInterfaces.length == 0) {
            this.ivClassDataObject.iv_MergerInfo.ivEmptyRemote = true;
        } else {
            String[] businessInterfaces = new String[remoteBusinessInterfaces.length];
            for (int i = 0; i < remoteBusinessInterfaces.length; ++i) {
                businessInterfaces[i] = remoteBusinessInterfaces[i].getName();
            }
            this.ivClassDataObject.putEntry(ClassDataObjectFields.REMOTE_BUSINESS_INTERFACES, businessInterfaces);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reflectRemote");
        }
    }

    private void reflectLocal(Local localAnnotation) {
        Class[] localBusinessInterfaces;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reflectLocal");
        }
        if ((localBusinessInterfaces = localAnnotation.value()) == null || localBusinessInterfaces.length == 0) {
            this.ivClassDataObject.iv_MergerInfo.ivEmptyLocal = true;
        } else {
            String[] businessInterfaces = new String[localBusinessInterfaces.length];
            for (int i = 0; i < localBusinessInterfaces.length; ++i) {
                businessInterfaces[i] = localBusinessInterfaces[i].getName();
            }
            this.ivClassDataObject.putEntry(ClassDataObjectFields.LOCAL_BUSINESS_INTERFACES, businessInterfaces);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reflectLocal");
        }
    }
}

