/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.csi.J2EENameImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ComponentDataObject;
import com.ibm.ws.metadata.ComponentDataObjectFields;
import com.ibm.ws.metadata.ConfigReader;
import com.ibm.ws.metadata.MetaDataSources;
import com.ibm.ws.metadata.ModuleDataObject;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.WCCMHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;

public class CTSWCCMConfigReader
implements ConfigReader {
    private static final String CLASS_NAME = CTSWCCMConfigReader.class.getName();
    private static TraceComponent tc = Tr.register(CLASS_NAME, "MetaData", "com.ibm.ws.metadata.metadata");
    private static TraceComponent common_tc = null;
    private static boolean isZOS = false;

    public void populateModuleData(ModuleDataObject mdo, MetaDataSources mds) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "populateModuleData");
        }
        try {
            EJBJarFile ejbJarFile = (EJBJarFile)mds.iv_Sources[MetaDataSources.sv_JarFileIndex];
            if (ejbJarFile != null) {
                EJBJar ejbJarDD = WCCMHelper.getDeploymentDescriptor(ejbJarFile, false);
                if (ejbJarDD != null) {
                    EList beans = ejbJarDD.getEnterpriseBeans();
                    int numBeans = beans.size();
                    for (int i = 0; i < numBeans; ++i) {
                        EnterpriseBean eb = (EnterpriseBean)beans.get(i);
                        String beanName = eb.getName();
                        J2EENameImpl j2eeName = new J2EENameImpl("", "", beanName);
                        ComponentDataObject cdo = mdo.createComponentDataObject(j2eeName);
                        String ejbClass = eb.getEjbClassName();
                        ClassDataObject classDO = mdo.getClassDataObject(ejbClass);
                        if (classDO == null) {
                            classDO = mdo.createClassDataObject(ejbClass, beanName);
                            mdo.putClassDataObject(classDO);
                        }
                        cdo.ivClassDataObject = classDO;
                        cdo.putEntry(ComponentDataObjectFields.EJB_NAME, beanName);
                        int beanType = 1;
                        if (eb.isSession() && ((Session)eb).isSetSessionType()) {
                            beanType = ((Session)eb).getSessionType().getValue() == 0 ? 3 : 2;
                        } else if (eb.isEntity()) {
                            beanType = eb instanceof ContainerManagedEntity ? 5 : 4;
                        } else if (eb.isMessageDriven()) {
                            beanType = 6;
                        }
                        if (beanType != 1) {
                            cdo.putEntry(ComponentDataObjectFields.EJB_TYPE, new Integer(beanType));
                        }
                        mdo.putComponentDataObject(cdo);
                    }
                }
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ModuleDataObject:  ", mdo);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "populateModuleData");
                    }
                }
            }
        }
        catch (Throwable t) {
            System.out.println("UNEXPECTED_EXCEPTION" + t.getLocalizedMessage());
            t.printStackTrace();
        }
    }

    static {
        isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
        if (isZOS) {
            common_tc = Tr.register("BeanMetaData390Msgs", "MetaDataConfigConstants.traceString", "com.ibm.ejs.resources.ws390Messages");
        }
    }
}

