/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.WSSecurityContextFactory;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.internal.Config;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.authorizer.service.AdminAuthzServiceEvent;
import com.ibm.websphere.management.authorizer.service.AdminAuthzServiceListener;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminDataHolder;
import com.ibm.ws.management.util.AdminCertificateHelper;
import com.ibm.ws.management.util.AdminKerberosHelper;
import com.ibm.ws.management.util.SecurityServiceMonitor;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.kerberos.KerberosPolicy;
import com.ibm.ws.security.auth.kerberos.KerberosThreadManager;
import com.ibm.ws.security.auth.rsatoken.RSAPropagationManager;
import com.ibm.ws.security.auth.rsatoken.RSATokenThreadManager;
import com.ibm.ws.security.config.SecurityConfigResource;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorNullImpl;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import org.apache.soap.encoding.soapenc.Base64;

public final class SecurityHelper
implements SecurityServiceListener,
AdminAuthzServiceListener,
SecurityServiceMonitor {
    private static final TraceComponent tc = Tr.register(SecurityHelper.class);
    public static final String isInternal = "isInternal";
    public static final String loginMethod = "LoginMethod";
    public static final String tokenBasedAuth = "TokenBased";
    public static final String basicAuth = "BasicAuth";
    public static final String tokeElement = "token";
    public static final String trustStoreProp = "javax.net.ssl.trustStore";
    public static final String keyStoreProp = "javax.net.ssl.keyStore";
    public static final String trustStorePasswordProp = "javax.net.ssl.trustStorePassword";
    public static final String keyStorePasswordProp = "javax.net.ssl.keyStorePassword";
    public static final String trustStoreTypeProp = "javax.net.ssl.trustStoreType";
    public static final String keyStoreTypeProp = "javax.net.ssl.keyStoreType";
    public static final String sslHandlerProp = "java.protocol.handler.pkgs";
    public static final String defaultSslHandler = "com.ibm.net.ssl.internal.www.protocol";
    public static final String FIPSProvider = "ssl.SocketFactory.provider";
    public static final String contextProvider = "com.ibm.ssl.contextProvider";
    private boolean securityEnabled = false;
    private boolean securityServiceEnabled = false;
    private boolean securityServiceStopped = false;
    private RoleBasedConfigurator nullconfigurator = new RoleBasedConfiguratorNullImpl();
    private SecurityService securityService = null;
    private static final WebSphereRuntimePermission perm = new WebSphereRuntimePermission("SecOwnCredentials");
    private WSSecurityContext securityContext = null;
    private String clientSSLAlias = null;
    private static SecurityHelper myself = new SecurityHelper();
    private AdminAuthorizer authorizer = null;
    private static String URL_HANDLER_PROP = "java.protocol.handler.pkgs";
    private static final String PKGNAME_DELIMITER = "|";

    private SecurityHelper() {
    }

    public static SecurityHelper getHelper() {
        return myself;
    }

    public String getClientSSLAlias() {
        return this.clientSSLAlias;
    }

    public void setClientSSLAlias(String alias) {
        this.clientSSLAlias = alias;
    }

    public void stateChanged(AdminAuthzServiceEvent aase) {
        block5: {
            int aas;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stateChanged", aase);
            }
            if ((aas = aase.getState()) == 1) {
                try {
                    this.authorizer = AdminAuthorizerFactory.getAdminAuthorizer();
                }
                catch (Exception ex) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "AdminAuthorizer not initialized");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged");
        }
    }

    public void stateChanged(SecurityServiceEvent sse) {
        int sss;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateChanged");
        }
        if ((sss = sse.getState()) == 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Marking the Security Service as having been started.");
            }
            this.securityServiceEnabled = true;
            this.securityServiceStopped = false;
        } else if (sss == 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Marking the Security Service as having been stopped.");
            }
            this.securityServiceStopped = true;
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security service state change to: " + sss);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged");
        }
    }

    public WSSecurityContext getWSSecurityContext() {
        if (this.securityContext == null) {
            this.securityContext = WSSecurityContextFactory.getInstance().createContext(RSAPropagationManager.getInstance().getAdminPreferredAuthMechOID());
        }
        return this.securityContext;
    }

    public void setSecurityService(SecurityService secService) {
        this.securityService = secService;
        this.securityEnabled = this.securityService.isSecurityEnabled();
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public AdminAuthorizer getAdminAuthorizer() {
        String uuid = AdminContext.peek();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminAuthorizer: " + uuid);
        }
        AdminAuthorizer ret = this.authorizer;
        if (uuid != null) {
            ret = AdminAuthorizerFactory.getAdminAuthorizer();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminAuthorizer: " + uuid + " " + ret);
        }
        return ret;
    }

    public boolean isSecurityServiceStarted() {
        return this.securityServiceEnabled;
    }

    public boolean isSecurityServiceStopped() {
        return this.securityServiceStopped;
    }

    public RoleBasedConfigurator getConfigurator() {
        RoleBasedConfigurator configurator;
        block4: {
            configurator = this.nullconfigurator;
            if (this.securityServiceEnabled && this.securityService != null) {
                try {
                    configurator = this.securityService.getConfigurator();
                }
                catch (RoleBasedAppException ex) {
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "RoleBasedConfigurator not initialized");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigurator " + configurator);
        }
        return configurator;
    }

    public String getRealm() {
        String realm = this.securityService.getRealm();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm " + realm);
        }
        return realm;
    }

    public static Subject authenticate(String name, String password) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate");
        }
        Subject subject = null;
        boolean secPushed = false;
        SecurityConfigResource res = null;
        try {
            res = AdminContext.peek() != null ? new SecurityConfigResource("", "application") : new SecurityConfigResource("", "admin");
            secPushed = SecurityObjectLocator.getThreadLocal().pushResource(res);
            subject = RasHelper.isServer() ? SecurityHelper.getContextManager().login(SecurityHelper.getContextManager().getDefaultRealm(), name, password) : SecurityHelper.createBasicAuthSubject(name, password);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fail to authenticate", ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "authenticate - failed");
            }
            if (ex instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)ex;
            }
            throw new WSLoginFailedException(ex.getMessage(), ex);
        }
        finally {
            if (secPushed) {
                SecurityObjectLocator.getThreadLocal().popResource();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authenticate");
        }
        return subject;
    }

    public static Subject validate(byte[] token) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        Subject subject = null;
        try {
            subject = SecurityHelper.getContextManager().login(SecurityHelper.getContextManager().getDefaultRealm(), token);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fail to validate", ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate - failed");
            }
            if (ex instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)ex;
            }
            throw new WSLoginFailedException(ex.getMessage(), ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return subject;
    }

    public static Subject createBasicAuthSubject(String name, String password) {
        Subject subject;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createBasicAuthSubject");
            }
            subject = null;
            try {
                subject = SubjectHelper.createBasicAuthSubject(SecurityHelper.getContextManager().getDefaultRealm(), name, password);
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fail to create basic auth subject", ex);
                }
                if (!tc.isEntryEnabled()) break block5;
                Tr.exit(tc, "authenticate - failed");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createBasicAuthSubject");
        }
        return subject;
    }

    public static void removeSubjectFromThreadTable(Subject subject) {
        block2: {
            try {
                SecurityHelper.getContextManager().initializeCallerContext((Subject)null);
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Failed to initialize caller context.", ex);
            }
        }
    }

    public static Subject pushInvocationSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pushInvocationSubject");
        }
        Subject pushedSubject = null;
        try {
            pushedSubject = SecurityHelper.getContextManager().pushInvocationSubject(subject);
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.management.connector.util.SecurityHelper.pushInvocationSubject", "226");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pushInvocationSubject");
        }
        return pushedSubject;
    }

    public static void popInvocationSubject(Subject pushedSubject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "popInvocationSubject");
        }
        try {
            SecurityHelper.getContextManager().popInvocationSubject(pushedSubject);
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.management.connector.util.SecurityHelper.popInvocationSubject", "239");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "popInvocationSubject");
        }
    }

    public static Subject getOwnedSubject() {
        return SecurityHelper.getServerSubject();
    }

    public static Subject retrieveSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveSubject");
        }
        Subject subject = SecurityHelper.getInvocationSubject();
        WSCredential wsCred = null;
        if (subject != null) {
            wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
        }
        if ((subject == null || wsCred != null && wsCred.isUnauthenticated()) && (subject = SecurityHelper.getReceivedSubject()) != null && (wsCred = SubjectHelper.getWSCredentialFromSubject(subject)) != null && wsCred.isUnauthenticated()) {
            subject = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveSubject");
        }
        return subject;
    }

    public static Subject getInvocationSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvocationSubject");
        }
        Subject subject = null;
        WSCredential creds = null;
        boolean valid = true;
        try {
            subject = SecurityHelper.getContextManager().getInvocationSubject();
            creds = SubjectHelper.getWSCredentialFromSubject(subject);
            if (creds != null) {
                if (RasHelper.isServer()) {
                    valid = SecurityHelper.getContextManager().getWSCredTokenMapper().checkValidityOfAllTokensAndRefresh(subject);
                }
                if (!valid && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Non-server invocation subject could not be refreshed.");
                }
            }
            if (!valid && subject != null && SecurityHelper.getContextManager().isServerSubject(subject)) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server subject is expired, logging in to get a new one.");
                    }
                    subject = SecurityHelper.getContextManager().getServerSubject();
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.management.connector.util.SecurityHelper.getInvocationSubject", "450");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unable to obtain invocation subject or subject expired", e);
                    }
                    subject = null;
                }
            } else if (!valid && subject != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Non-server invocation subject is invalid or expired.");
                }
            } else if (subject == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invocation subject is null.");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.management.connector.util.SecurityHelper.getInvocationSubject", "394");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to obtain invocation subject from ContextManager.", e);
            }
            valid = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvocationSubject");
        }
        return subject;
    }

    public static void resetContext() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "resetContext");
            }
            try {
                SecurityHelper.getContextManager().initializeCallerContext((Subject)null);
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "fail to initialize caller context.", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetContext");
        }
    }

    public static void setInvocationSubject(Subject subject) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setInvocationSubject");
            }
            try {
                SecurityHelper.getContextManager().setInvocationSubject(subject);
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "fail to set invocation subject.", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInvocationSubject");
        }
    }

    public static void setReceivedSubject(Subject subject) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setReceivedSubject");
            }
            try {
                SecurityHelper.getContextManager().setCallerSubject(subject);
            }
            catch (Exception ex) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Failed to set caller subject.", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setReceivedSubject");
        }
    }

    public static Subject getReceivedSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReceivedSubject");
        }
        Subject subject = null;
        WSCredential wsCred = null;
        boolean valid = false;
        try {
            subject = SecurityHelper.getContextManager().getCallerSubject();
            if (subject != null) {
                wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
            }
            if (wsCred != null) {
                valid = wsCred.isCurrent();
            }
            if (!valid && subject != null && SecurityHelper.getContextManager().isServerSubject(subject)) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server subject is expired, logging in to get a new one.");
                    }
                    subject = SecurityHelper.getContextManager().getServerSubject();
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.management.connector.util.SecurityHelper.getReceivedSubject", "557");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unable to obtain received subject or subject is expired", e);
                    }
                    subject = null;
                }
            } else if (!valid && subject != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Non-server received subject is invalid or expired.");
                }
                subject = null;
            } else if (subject == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Received subject is null.");
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to obtain received subject from ContextManager.", e);
            }
            FFDCFilter.processException(e, "com.ibm.ws.management.connector.util.SecurityHelper.getReceivedSubject", "504");
            valid = false;
        }
        if (valid && subject != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getReceivedSubject");
            }
            return subject;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReceivedSubject");
        }
        return null;
    }

    public static Subject getActualSubject(Subject in_subject) {
        WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(in_subject);
        if (wsCred.isBasicAuth() && !wsCred.isUnauthenticated()) {
            Subject subject = null;
            try {
                subject = SecurityHelper.getContextManager().login(wsCred);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "LoginFailed exception getting server cred.", new Object[]{e});
                }
                FFDCFilter.processException(e, "com.ibm.ws.management.connector.util.SecurityHelper.getActualSubject", "566");
                subject = null;
            }
            return subject;
        }
        return in_subject;
    }

    public static Subject getServerSubject() {
        Subject subject = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...Expecting : " + perm.toString());
            }
            sm.checkPermission(perm);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting server subject.");
            }
            subject = SecurityHelper.getContextManager().getServerSubject();
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to obtain own subject or subject is expired", e);
            }
            FFDCFilter.processException(e, "com.ibm.ws.management.connector.util.SecurityHelper.getServerCredential", "1001");
            subject = null;
        }
        return subject;
    }

    public static String getUserName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserName");
        }
        String userName = null;
        try {
            Subject subject = SecurityHelper.retrieveSubject();
            WSCredential creds = SubjectHelper.getWSCredentialFromSubject(subject);
            if (creds != null) {
                userName = creds.getRealmSecurityName();
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception attempting to getUserName from credential.", new Object[]{e});
            }
            FFDCFilter.processException(e, "com.ibm.ws.management.connector.util.SecurityHelper.getUserName", "637");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserName");
        }
        return userName;
    }

    public static ContextManager getContextManager() {
        return ContextManagerFactory.getInstance();
    }

    public static synchronized void registerPackage(String pkgNamePrefix) {
        ArrayList<String> transportPackages = new ArrayList<String>();
        String currentPackageList = System.getProperty(URL_HANDLER_PROP);
        if (currentPackageList != null) {
            StringTokenizer tok = new StringTokenizer(currentPackageList, PKGNAME_DELIMITER);
            while (tok.hasMoreTokens()) {
                transportPackages.add(tok.nextToken());
            }
        }
        if (transportPackages.contains(pkgNamePrefix)) {
            return;
        }
        transportPackages.add(pkgNamePrefix);
        StringBuffer currentPackages = new StringBuffer();
        Iterator i = transportPackages.iterator();
        while (i.hasNext()) {
            String thisPackage = (String)i.next();
            currentPackages.append(thisPackage);
            if (!i.hasNext()) continue;
            currentPackages.append('|');
        }
        System.setProperty(URL_HANDLER_PROP, currentPackages.toString());
    }

    public static String getAuditUserName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuditUserName");
        }
        String auditUserName = null;
        try {
            Subject subject = SecurityHelper.getContextManager().getSubjectBeforeRunAs();
            WSCredential creds = SubjectHelper.getWSCredentialFromSubject(subject);
            if (creds != null) {
                auditUserName = creds.getRealmSecurityName();
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception attempting to getAuditUserName from credential.", new Object[]{e});
            }
            FFDCFilter.processException(e, "com.ibm.ws.management.connector.util.SecurityHelper.getUserName", "637");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuditUserName");
        }
        return auditUserName;
    }

    public static WSSecurityContext createContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createContext");
        }
        try {
            Class<?> wrapperclass = Class.forName("com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl");
            Object wrapperObj = wrapperclass.newInstance();
            WSSecurityContext custom = null;
            custom = (WSSecurityContext)wrapperObj;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Instantiating WSSecurityContext instance: com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl");
            }
            return custom;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception attempting to createContext.", new Object[]{e});
            }
            FFDCFilter.processException(e, "com.ibm.ws.management.connector.util.SecurityHelper.createContext", "769");
            return null;
        }
    }

    public static String getTargetKrbRealm(String host, String krb5Config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetKrbRealm" + host + " " + krb5Config);
        }
        String targetKrbRealm = "default";
        if (krb5Config != null && krb5Config.length() > 0) {
            System.setProperty("java.security.krb5.conf", krb5Config);
        }
        String canonicalHost = SecurityHelper.getCanonicalHost(host);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "canonicalHost: " + canonicalHost);
        }
        try {
            targetKrbRealm = Config.getInstance().mapHostToRealm(canonicalHost);
        }
        catch (KrbException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception attempting to mapHostToRealm.", new Object[]{e});
            }
            FFDCFilter.processException(e, "com.ibm.ws.management.connector.util.SecurityHelper.getTargetKrbRealm", "793");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetKrbRealm" + targetKrbRealm);
        }
        return targetKrbRealm;
    }

    public static String getTargetKrbSPN(String host, String krb5Service) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetKrbSPN" + host + " " + krb5Service);
        }
        String spn = null;
        String canonicalHost = SecurityHelper.getCanonicalHost(host);
        spn = krb5Service + "@" + canonicalHost;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetKrbSPN" + spn);
        }
        return spn;
    }

    public static String getCanonicalHost(String host) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCanonicalHost");
        }
        String canonicalHost = null;
        if (host.equals("localhost")) {
            try {
                canonicalHost = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception attempting to getCanonicalHostName.", new Object[]{e});
                }
                FFDCFilter.processException(e, "com.ibm.ws.management.connector.util.SecurityHelper.getCanonicalHost", "825");
            }
        } else {
            canonicalHost = host;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCanonicalHost" + canonicalHost);
        }
        return canonicalHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate retrieveRSACertificate(Properties proxyProps) {
        X509Certificate targetCertificate;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "retrieveRSACertificate");
            }
            targetCertificate = null;
            try {
                if (AdminCertificateHelper.getInstance().isRSAPropagationEnabled()) {
                    if (!RSATokenThreadManager.getInstance().isCertificateRetrievalInProcess().booleanValue()) {
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Retrieving the admin target certificate.");
                            }
                            RSATokenThreadManager.getInstance().setCertificateRetrievalInProcess();
                            targetCertificate = AdminCertificateHelper.getInstance().retrieveTargetCertificate(proxyProps);
                            break block14;
                        }
                        finally {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Finished retrieving the admin target certificate.");
                            }
                            RSATokenThreadManager.getInstance().unsetCertificateRetrievalInProcess();
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Certificate retrieval in process.");
                    }
                    targetCertificate = AdminCertificateHelper.getInstance().checkCacheForCertificate(proxyProps);
                    break block14;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RSA token authentication is not enabled.");
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception setting up RSA token information.", new Object[]{e});
                }
                FFDCFilter.processException(e, "com.ibm.ws.management.util.SecurityHelper.retrieveRSACertificate", "873");
                RSATokenThreadManager.getInstance().setTargetCertificate(null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveRSACertificate", new Object[]{targetCertificate});
        }
        return targetCertificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KerberosPolicy retrieveKerberosPolicy(Properties proxyProps, boolean isInternal) {
        KerberosPolicy kerberosPolicy;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "retrieveKerberosPolicy");
            }
            kerberosPolicy = null;
            try {
                boolean get_policy;
                boolean bl = get_policy = !isInternal || SubjectHelper.containsKerberosCredential(SecurityHelper.retrieveSubject());
                if (get_policy) {
                    if (!KerberosThreadManager.getInstance().isKerberosPolicyRetrievalInProcess().booleanValue()) {
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Retrieving the admin KerberosPolicy.");
                            }
                            KerberosThreadManager.getInstance().setKerberosPolicyRetrievalInProcess();
                            kerberosPolicy = AdminKerberosHelper.getInstance().retrieveKerberosPolicy(proxyProps);
                            break block14;
                        }
                        finally {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Finished retrieving the admin KerberosPolicy.");
                            }
                            KerberosThreadManager.getInstance().unsetKerberosPolicyRetrievalInProcess();
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "KerberosPolicy retrieval in process.");
                    }
                    kerberosPolicy = AdminKerberosHelper.getInstance().checkCacheForKerberosPolicy(proxyProps);
                    break block14;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Kerberos is not enabled.");
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception setting up KerberosPolicy information.", new Object[]{e});
                }
                FFDCFilter.processException(e, "com.ibm.ws.management.util.SecurityHelper.retrieveKerberosPolicy", "873");
                KerberosThreadManager.getInstance().setKerberosPolicy(null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveKerberosPolicy", new Object[]{kerberosPolicy});
        }
        return kerberosPolicy;
    }

    public static boolean isKerberosEnabled(Properties proxyProps, boolean isInternal) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKerberosEnabled (internal = " + isInternal + ")");
        }
        if (!isInternal) {
            String authTarget = proxyProps.getProperty("authTarget");
            if (authTarget != null && authTarget.length() > 0 && (authTarget.equalsIgnoreCase("KRB5") || authTarget.equalsIgnoreCase("Kerberos"))) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isKerberosEnabled(true)");
                }
                return true;
            }
        } else {
            boolean enabled;
            boolean bl = enabled = SecurityObjectLocator.getSecurityConfig("security").getAdminPreferredAuthMechanism().getType().equals("KRB5") || SecurityObjectLocator.getSecurityConfig("security").getActiveAuthMechanism().getType().equals("KRB5");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isKerberosEnabled(" + enabled + ")");
            }
            return enabled;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKerberosEnabled(false)");
        }
        return false;
    }

    public static byte[] getKerberosToken(String host, String user, String password, String authTarget, String loginSource, String krb5Ccache, String krb5Config, String krb5Service, String krb5RefreshingTicket, String spn, String realm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKerberosToken");
        }
        String krbTokenStr = null;
        byte[] token = null;
        Object o = AdminDataHolder.getData("wsSubject");
        Subject krbSubject = null;
        if (o instanceof Subject) {
            krbSubject = (Subject)o;
        }
        if ((krbTokenStr = (String)AdminDataHolder.getData("krb5TokenStr")) != null && krbTokenStr.length() > 0) {
            token = Base64.decode(krbTokenStr);
        } else {
            krbTokenStr = null;
        }
        if (krbSubject == null || krbTokenStr == null || new Boolean(krb5RefreshingTicket).booleanValue()) {
            if (!(loginSource != null && loginSource.equalsIgnoreCase("krb5Ccache") || krb5Config == null || krb5Config.length() == 0)) {
                System.setProperty("java.security.krb5.conf", krb5Config);
            }
            if (krbSubject == null || krbTokenStr == null) {
                try {
                    krbSubject = AdminClientFactory.jaas_login(authTarget, loginSource, user, password, null, krb5Ccache, krb5Config);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Kerberos subject: " + krbSubject);
                    }
                }
                catch (WSLoginFailedException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSLoginFailedException occurred: ", new Object[]{e});
                    }
                    FFDCFilter.processException(e, "com.ibm.ws.management.util.SecurityHelper", "1014");
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception occurred during JAAS login: ", new Object[]{e});
                    }
                    FFDCFilter.processException(e, "com.ibm.ws.management.util.SecurityHelper", "1017");
                }
            }
            if (krbSubject != null) {
                AdminDataHolder.setData("wsSubject", krbSubject);
                token = SecurityHelper.getKerberosServiceTicket(krbSubject, host, krb5Config, krb5Service, spn, realm);
                krbTokenStr = Base64.encode(token);
                if (krbTokenStr != null) {
                    AdminDataHolder.setData("krb5TokenStr", krbTokenStr);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKerberosToken");
        }
        return token;
    }

    public static byte[] getKerberosServiceTicket(Subject krbSubject, String spn, String realm) {
        if (spn == null || realm == null || spn.length() < 1 || realm.length() < 1) {
            throw new IllegalArgumentException("spn and realm must both be non-empty. spn = '" + spn + "', realm = '" + realm + "'");
        }
        return SecurityHelper.getKerberosServiceTicket(krbSubject, null, null, null, spn, realm);
    }

    public static byte[] getKerberosServiceTicket(Subject krbSubject, String host, String krb5Config, String krb5Service, String spn, String realm) {
        String METHOD = "getKerberosServiceTicket";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKerberosServiceTicket");
        }
        byte[] token = null;
        WSSecurityContext ctx = null;
        try {
            SecurityHelper.getHelper();
            ctx = SecurityHelper.createContext();
        }
        catch (Exception e) {
            Tr.debug(tc, "fail to initialize the security context for Kerberos authentication", e);
            FFDCFilter.processException(e, "com.ibm.ws.management.util.SecurityHelper", "1067");
        }
        if (ctx == null) {
            Tr.debug(tc, "WSSecurityContext is null - not good");
        } else {
            try {
                String targetKrbSPN;
                String string;
                String targetKrbRealm;
                String string2;
                if (realm != null && realm.length() > 0) {
                    string2 = realm;
                } else {
                    SecurityHelper.getHelper();
                    string2 = targetKrbRealm = SecurityHelper.getTargetKrbRealm(host, krb5Config);
                }
                if (spn != null && spn.length() > 0) {
                    string = spn;
                } else {
                    SecurityHelper.getHelper();
                    string = targetKrbSPN = SecurityHelper.getTargetKrbSPN(host, krb5Service);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling initSecContext()");
                    Tr.debug(tc, "targetKrbRealm: " + targetKrbRealm);
                    Tr.debug(tc, "targetKrbSPN: " + targetKrbSPN);
                }
                token = ctx.initSecContext(krbSubject, targetKrbSPN, targetKrbRealm);
            }
            catch (WSSecurityContextException ex) {
                Tr.debug(tc, "fail to initialize the security context", ex);
                FFDCFilter.processException(ex, "com.ibm.ws.management.util.SecurityHelper", "1088");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKerberosServiceTicket");
        }
        return token;
    }

    public static boolean isKrb5Auth(WSCredential cred) throws CredentialDestroyedException, CredentialExpiredException {
        return OID.compareOIDs(cred.getOID(), "oid:1.2.840.113554.1.2.2");
    }
}

