/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.AdminHelper;

public class EncodingUtils {
    private static TraceComponent tc = Tr.register(EncodingUtils.class, "Admin", null);
    private static final String S_CP1250 = "Cp1250";
    private static final String S_CP1251 = "Cp1251";
    private static final String S_CP1252 = "Cp1252";
    private static final String S_CP1253 = "Cp1253";
    private static final String S_CP1254 = "Cp1254";
    private static final String S_CP1255 = "Cp1255";
    private static final String S_CP1256 = "Cp1256";
    private static final String S_CP1257 = "Cp1257";
    private static final String S_CP852 = "Cp852";
    private static final String S_CP855 = "Cp855";
    private static final String S_CP866 = "Cp866";
    private static final String S_CP850 = "Cp850";
    private static final String S_CP737 = "Cp737";
    private static final String S_CP857 = "Cp857";
    private static final String S_CP862 = "Cp862";
    private static final String S_CP720 = "Cp720";
    private static final String S_CP775 = "Cp775";
    private static final String S_CP1047 = "Cp1047";
    private static final String S_JAVA_FILE_ENCODING_PROPERTY = "file.encoding";
    private static final String S_JAVA_USER_LANGUAGE_PROPERTY = "user.language";
    private static final String S_SERBIAN_CYRILLIC_USER_LANGUAGE_KEY = "sr";

    public static String getProperEncoding() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getProperEncoding");
        }
        String sEncoding = System.getProperty(S_JAVA_FILE_ENCODING_PROPERTY);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "System.getProperty(\"file.encoding\") is: " + sEncoding);
        }
        if (EncodingUtils.isPlatformWindows()) {
            String currentEncoding = System.getProperty(S_JAVA_FILE_ENCODING_PROPERTY);
            return EncodingUtils.lookupEncoding(currentEncoding);
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            return S_CP1047;
        }
        return sEncoding;
    }

    private static String lookupEncoding(String currentEncoding) {
        if (currentEncoding.equalsIgnoreCase(S_CP1252)) {
            return S_CP850;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1251)) {
            if (EncodingUtils.isSerbianCyrillic()) {
                return S_CP855;
            }
            return S_CP866;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1250)) {
            return S_CP852;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1253)) {
            return S_CP737;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1254)) {
            return S_CP857;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1255)) {
            return S_CP862;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1256)) {
            return S_CP720;
        }
        if (currentEncoding.equalsIgnoreCase(S_CP1257)) {
            return S_CP775;
        }
        return currentEncoding;
    }

    private static boolean isSerbianCyrillic() {
        String userLanguage = System.getProperty(S_JAVA_USER_LANGUAGE_PROPERTY);
        return userLanguage.equalsIgnoreCase(S_SERBIAN_CYRILLIC_USER_LANGUAGE_KEY);
    }

    private static boolean isPlatformWindows() {
        String osName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPlatformWindows()");
        }
        return (osName = System.getProperty("os.name")).toLowerCase().indexOf("windows") >= 0;
    }
}

