/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.DebugUtils;
import com.ibm.ws.security.auth.kerberos.KerberosPolicy;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class AdminKerberosHelper {
    private static final TraceComponent tc = Tr.register(AdminKerberosHelper.class);
    private static AdminKerberosHelper cm = null;
    private static HashMap kpCache = new HashMap();

    public static synchronized AdminKerberosHelper getInstance() {
        if (cm == null) {
            cm = new AdminKerberosHelper();
        }
        return cm;
    }

    public void clearKerberosPolicyFromCache(String host, String port) {
        KerberosPolicy kp;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearKerberosPolicyFromCache");
        }
        String cacheKey = host + ":" + port;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Looking up KerberosPolicy from cacheKey: " + cacheKey);
        }
        if ((kp = (KerberosPolicy)kpCache.get(cacheKey)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found kerberos policy in cache, removing it.");
            }
            kpCache.remove(cacheKey);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearKerberosPolicyFromCache");
        }
    }

    public KerberosPolicy checkCacheForKerberosPolicy(Properties connectorProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCacheForKerberosPolicy", new Object[]{DebugUtils.createPropertiesMaskPlainTextPassword(connectorProps)});
        }
        KerberosPolicy kp = null;
        try {
            if (connectorProps == null) {
                throw new IllegalArgumentException("Connector properties specified are null.");
            }
            String host = connectorProps.getProperty("host");
            String port = connectorProps.getProperty("port");
            if (host == null || port == null) {
                throw new IllegalArgumentException("Connector properties specified do not have a valid \"host\" and \"port\" property.");
            }
            String cacheKey = host + ":" + port;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking up kerberos policy from cacheKey: " + cacheKey);
            }
            if ((kp = (KerberosPolicy)kpCache.get(cacheKey)) != null && tc.isEntryEnabled()) {
                Tr.exit(tc, "retrieveKerberosPolicy (found in cache)");
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception received: ", new Object[]{e});
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.util.AdminKerberosHelper.checkCacheForKerberosPolicy", "133", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCacheForKerberosPolicy");
        }
        return kp;
    }

    public KerberosPolicy retrieveKerberosPolicy(Properties connectorProps) {
        KerberosPolicy kp;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "retrieveKerberosPolicy", new Object[]{DebugUtils.createPropertiesMaskPlainTextPassword(connectorProps)});
            }
            kp = null;
            try {
                if (connectorProps == null) {
                    throw new IllegalArgumentException("Connector properties specified are null.");
                }
                String host = connectorProps.getProperty("host");
                String port = connectorProps.getProperty("port");
                if (host == null || port == null) {
                    throw new IllegalArgumentException("Connector properties specified do not have a valid \"host\" and \"port\" property.");
                }
                String cacheKey = host + ":" + port;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking up kerberos policy from cacheKey: " + cacheKey);
                }
                if ((kp = (KerberosPolicy)kpCache.get(cacheKey)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "retrieveKerberosPolicy (cache)");
                    }
                    break block15;
                }
                try {
                    Subject unauthSubject = ContextManagerFactory.getInstance().createUnauthenticatedSubject();
                    AdminClientGetMBeanAction getMBeanAction = new AdminClientGetMBeanAction(connectorProps);
                    ObjectName securityAdmin = (ObjectName)ContextManagerFactory.getInstance().runAsSpecified(unauthSubject, (PrivilegedExceptionAction)getMBeanAction);
                    AdminKerberosPolicyAction getKerberosPolicyAction = new AdminKerberosPolicyAction(connectorProps, securityAdmin);
                    kp = (KerberosPolicy)ContextManagerFactory.getInstance().runAsSpecified(unauthSubject, (PrivilegedExceptionAction)getKerberosPolicyAction);
                }
                catch (Exception ex) {
                    Tr.debug(tc, "Exception calling adminClientCertificateAction: " + ex.getMessage());
                    throw ex;
                }
                if (kp != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found a kerberos policy and adding it using cacheKey: " + cacheKey);
                    }
                    kpCache.put(cacheKey, kp);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "An attempt to get the target's kerberos policy failed.");
                }
            }
            catch (Exception e) {
                Tr.debug(tc, "Exception received: ", new Object[]{e});
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.util.AdminKerberosHelper.retrieveKerberosPolicy", "223", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveKerberosPolicy (lookup)", new Object[]{kp});
        }
        return kp;
    }

    AdminKerberosHelper() {
    }

    class AdminClientGetMBeanAction
    implements PrivilegedExceptionAction {
        Properties props = null;

        public AdminClientGetMBeanAction(Properties connectorProps) {
            this.props = connectorProps;
        }

        public Object run() throws Exception {
            try {
                AdminClient adminClient = AdminClientFactory.createAdminClient(this.props);
                String processName = this.getProcessName(adminClient);
                ObjectName queryString = new ObjectName("WebSphere:type=SecurityAdmin,process=" + processName + ",*");
                Set s = adminClient.queryNames(queryString, null);
                ObjectName securityAdmin = null;
                if (s.isEmpty()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "retrieveKerberosPolicy (can't get SecurityAdmin)");
                    }
                    throw new Exception("retrieveKerberosPolicy can't get SecurityAdmin MBean");
                }
                securityAdmin = (ObjectName)s.iterator().next();
                return securityAdmin;
            }
            catch (Exception e) {
                Tr.debug(tc, "Exception received: ", new Object[]{e});
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.util.AdminKerberosHelper.AdminClientGetMBeanAction.run", "383", this);
                throw e;
            }
        }

        private String getProcessName(AdminClient client) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getProcessName");
            }
            ObjectName mbean = null;
            String name = null;
            try {
                mbean = client.getServerMBean();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.management.util.AdminKerberosHelper.AdminKerberosPolicyAction.getProcessName", "404", this);
            }
            if (mbean != null) {
                name = ObjectNameHelper.getProcessName(mbean);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getProcessName -> " + name);
            }
            return name;
        }
    }

    class AdminKerberosPolicyAction
    implements PrivilegedExceptionAction {
        Properties props = null;
        ObjectName securityAdminMBean = null;

        public AdminKerberosPolicyAction(Properties connectorProps, ObjectName securityAdmin) {
            this.props = connectorProps;
            this.securityAdminMBean = securityAdmin;
        }

        public Object run() throws Exception {
            try {
                AdminClient adminClient = AdminClientFactory.createAdminClient(this.props);
                byte[] kerberos_policy_bytes = (byte[])adminClient.invoke(this.securityAdminMBean, "getKerberosPolicy", new Object[0], new String[0]);
                if (kerberos_policy_bytes != null) {
                    return new KerberosPolicy(kerberos_policy_bytes);
                }
            }
            catch (Exception e) {
                Tr.debug(tc, "Exception received: ", new Object[]{e});
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.util.AdminKerberosHelper.AdminClientCertificateAction.run", "339", this);
                throw e;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning null KerberosPolicy.");
            }
            return null;
        }
    }
}

