/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository.client;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.filetransfer.client.FileUploadInputStream;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClient;
import com.ibm.ws.management.filetransfer.FileTransferConfigImpl;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.util.ImplFactory;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class JMXRemoteConfigRepositoryClient
implements ConfigRepositoryClient {
    AdminClient client = null;
    ObjectName repositoryObjectName = null;
    FileTransferClient ftclient;
    FileTransferOptions options;

    public void connect(Properties connectInfo) throws ConnectorException {
        try {
            this.client = AdminClientFactory.createAdminClient(connectInfo);
            this.repositoryObjectName = this.getRepositoryName();
            this.initializeFileTransfer(connectInfo);
        }
        catch (MalformedObjectNameException e) {
            throw new ConnectorException(e);
        }
        catch (AdminException e) {
            throw new ConnectorException(e);
        }
    }

    protected Object invoke(String opName, String[] signature, Object[] params) throws RepositoryException {
        return this.invokeMBean(this.repositoryObjectName, opName, signature, params);
    }

    protected Object invokeMBean(ObjectName objectName, String opName, String[] signature, Object[] params) throws RepositoryException {
        try {
            return this.client.invoke(objectName, opName, params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new RepositoryException(e);
        }
        catch (MBeanException e) {
            Exception t = e.getTargetException();
            if (t instanceof RepositoryException) {
                throw (RepositoryException)t;
            }
            throw new RepositoryException(e);
        }
        catch (ReflectionException e) {
            throw new RepositoryException(e);
        }
        catch (ConnectorException e) {
            throw new RepositoryException(e);
        }
    }

    protected InputStream getUploadStream(String srcPath) {
        FileUploadInputStream source = new FileUploadInputStream();
        source.setDelete(true);
        source.setSrcPath(srcPath);
        return source;
    }

    public void initialize(Properties p) throws AdminException {
        this.initializeFileTransfer(p);
    }

    private void initializeFileTransfer(Properties p) throws AdminException {
        this.ftclient = (FileTransferClient)ImplFactory.loadImplFromKey(FileTransferClient.class);
        FileTransferConfig ftcfg = (FileTransferConfig)p.get("fileTransferConfig");
        if (this.client != null && ftcfg == null) {
            this.ftclient.initialize(this.client);
        } else if (ftcfg != null) {
            this.ftclient.setFileTransferConfig(ftcfg);
        } else {
            ftcfg = this.getFileTransferConfig();
            if (ftcfg != null) {
                this.ftclient.setFileTransferConfig(ftcfg);
            } else {
                ftcfg = new FileTransferConfigImpl();
                Properties fp = ftcfg.getProperties();
                fp.setProperty("host", "localhost");
                fp.setProperty("port", FileTransferConfigImpl.DEFAULT_PORT_STRING_VALUE);
                this.ftclient.setFileTransferConfig(ftcfg);
            }
        }
        this.options = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
        this.options.setCompress(true);
        this.options.setOverwrite(true);
    }

    private void upload(DocumentContentSource contents) throws RepositoryException {
        try {
            String srcPath = "upload/" + contents.getDocument().getTempName();
            this.ftclient.uploadFile(contents.getSource(), srcPath, this.options);
            contents.setSource(this.getUploadStream(srcPath));
        }
        catch (Throwable t) {
            throw new RepositoryException(t);
        }
    }

    public DocumentDigest create(DocumentContentSource contents) throws RepositoryException {
        this.upload(contents);
        String opName = "create";
        String[] signature = new String[]{"com.ibm.websphere.management.repository.DocumentContentSource"};
        Object[] params = new Object[]{contents};
        return (DocumentDigest)this.invoke(opName, signature, params);
    }

    public DocumentDigest[] create(DocumentContentSource[] contents) throws RepositoryException {
        for (int i = 0; i < contents.length; ++i) {
            this.upload(contents[i]);
        }
        String opName = "create";
        String[] signature = new String[]{"[Lcom.ibm.websphere.management.repository.DocumentContentSource;"};
        Object[] params = new Object[]{contents};
        return (DocumentDigest[])this.invoke(opName, signature, params);
    }

    public void delete(String docURI) throws RepositoryException {
        String opName = "delete";
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{docURI};
        this.invoke(opName, signature, params);
    }

    public void delete(Document doc) throws RepositoryException {
        String opName = "delete";
        String[] signature = new String[]{"com.ibm.websphere.management.repository.Document"};
        Object[] params = new Object[]{doc};
        this.invoke(opName, signature, params);
    }

    public void delete(String[] docURIs) throws RepositoryException {
        String opName = "delete";
        String[] signature = new String[]{"[Ljava.lang.String;"};
        Object[] params = new Object[]{docURIs};
        this.invoke(opName, signature, params);
    }

    public void delete(Document[] docs) throws RepositoryException {
        String opName = "delete";
        String[] signature = new String[]{"[Lcom.ibm.websphere.management.repository.Document;"};
        Object[] params = new Object[]{docs};
        this.invoke(opName, signature, params);
    }

    public void rename(String docURI, String newDocURI) throws RepositoryException {
        String opName = "rename";
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{docURI, newDocURI};
        this.invoke(opName, signature, params);
    }

    public void rename(Document doc, Document newDoc) throws RepositoryException {
        String opName = "rename";
        String[] signature = new String[]{"com.ibm.websphere.management.repository.DocumentContentSource", "com.ibm.websphere.management.repository.DocumentContentSource"};
        Object[] params = new Object[]{doc, newDoc};
        this.invoke(opName, signature, params);
    }

    public DocumentContentSource extract(String docURI) throws RepositoryException {
        String opName = "extract";
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{docURI};
        DocumentContentSource src = (DocumentContentSource)this.invoke(opName, signature, params);
        return src;
    }

    public DocumentContentSource extract(Document doc) throws RepositoryException {
        String opName = "extract";
        String[] signature = new String[]{"com.ibm.websphere.management.repository.Document"};
        Object[] params = new Object[]{doc};
        return (DocumentContentSource)this.invoke(opName, signature, params);
    }

    public DocumentContentSource[] extract(String[] docURIs) throws RepositoryException {
        String opName = "extract";
        String[] signature = new String[]{"[Ljava.lang.String;"};
        Object[] params = new Object[]{docURIs};
        return (DocumentContentSource[])this.invoke(opName, signature, params);
    }

    public DocumentContentSource[] extract(Document[] docs) throws RepositoryException {
        String opName = "extract";
        String[] signature = new String[]{"[Lcom.ibm.websphere.management.repository.Document;"};
        Object[] params = new Object[]{docs};
        return (DocumentContentSource[])this.invoke(opName, signature, params);
    }

    public DocumentDigest modify(DocumentContentSource contents) throws RepositoryException {
        this.upload(contents);
        String opName = "modify";
        String[] signature = new String[]{"com.ibm.websphere.management.repository.DocumentContentSource"};
        Object[] params = new Object[]{contents};
        return (DocumentDigest)this.invoke(opName, signature, params);
    }

    public DocumentDigest[] modify(DocumentContentSource[] contents) throws RepositoryException {
        for (int i = 0; i < contents.length; ++i) {
            this.upload(contents[i]);
        }
        String opName = "modify";
        String[] signature = new String[]{"[Lcom.ibm.websphere.management.repository.DocumentContentSource;"};
        Object[] params = new Object[]{contents};
        return (DocumentDigest[])this.invoke(opName, signature, params);
    }

    public HashMap update(DocumentContentSource[] create, DocumentContentSource[] modify, Document[] delete) throws RepositoryException {
        int i;
        for (i = 0; i < create.length; ++i) {
            this.upload(create[i]);
        }
        for (i = 0; i < modify.length; ++i) {
            this.upload(modify[i]);
        }
        String opName = "update";
        String[] signature = new String[]{"[Lcom.ibm.websphere.management.repository.DocumentContentSource;", "[Lcom.ibm.websphere.management.repository.DocumentContentSource;", "[Lcom.ibm.websphere.management.repository.Document;"};
        Object[] params = new Object[]{create, modify, delete};
        return (HashMap)this.invoke(opName, signature, params);
    }

    public DocumentDigest getDigest(String docPath) throws RepositoryException {
        String opName = "getDigest";
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{docPath};
        return (DocumentDigest)this.invoke(opName, signature, params);
    }

    public DocumentDigest[] getDigest(String[] docURIs) throws RepositoryException {
        String opName = "getDigest";
        String[] signature = new String[]{"[Ljava.lang.String;"};
        Object[] params = new Object[]{docURIs};
        return (DocumentDigest[])this.invoke(opName, signature, params);
    }

    public Boolean lockRepository(String reason) throws RepositoryException {
        String opName = "lockRepository";
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{reason};
        return (Boolean)this.invoke(opName, signature, params);
    }

    public Boolean unlockRepository(String reason) throws RepositoryException {
        String opName = "unlockRepository";
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{reason};
        return (Boolean)this.invoke(opName, signature, params);
    }

    public Properties getConfig() {
        String opName = "getConfig";
        String[] signature = new String[]{};
        Object[] params = new Object[]{};
        try {
            return (Properties)this.invoke(opName, signature, params);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public String[] listResourceNames(String parent, int type, int depth) {
        String opName = "listResourceNames";
        String[] signature = new String[]{"java.lang.String", "int", "int"};
        Object[] params = new Object[]{parent, new Integer(type), new Integer(depth)};
        try {
            return (String[])this.invoke(opName, signature, params);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] listResourceNames(String parent, int type, int depth, ResourceNameFilter filter) {
        String opName = "listResourceNames";
        String[] signature = new String[]{"java.lang.String", "int", "int", "com.ibm.websphere.management.repository.ResourceNameFilter"};
        Object[] params = new Object[]{parent, new Integer(type), new Integer(depth)};
        try {
            return (String[])this.invoke(opName, signature, params);
        }
        catch (Exception e) {
            return null;
        }
    }

    private ObjectName getRepositoryName() throws MalformedObjectNameException, ConnectorException, AdminException {
        String netmgrName = Utils.getNetmgrName(this.client);
        String query = "WebSphere:process=" + netmgrName + ",type=" + "ConfigRepository" + ",*";
        ObjectName queryName = new ObjectName(query);
        Set s = this.client.queryNames(queryName, null);
        if (s.size() != 1) {
            throw new AdminException("There are " + s.size() + " repositories!");
        }
        Object[] o = s.toArray();
        return (ObjectName)o[0];
    }

    private ObjectName getFileTransferName() throws MalformedObjectNameException, ConnectorException, AdminException {
        String query = "WebSphere:process=" + Utils.getNetmgrName(this.client) + ",type=" + "FileTransferServer" + ",*";
        ObjectName queryName = new ObjectName(query);
        Set s = this.client.queryNames(queryName, null);
        if (s.size() != 1) {
            throw new AdminException("There are " + s.size() + " file transfer servers.");
        }
        Object[] o = s.toArray();
        return (ObjectName)o[0];
    }

    private FileTransferConfig getFileTransferConfig() throws AdminException {
        FileTransferConfig ftcfg = null;
        ObjectName fileTransferServer = null;
        try {
            fileTransferServer = this.getFileTransferName();
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
        if (fileTransferServer != null) {
            ftcfg = (FileTransferConfig)this.invokeMBean(fileTransferServer, "getServerConfig", null, null);
        }
        return ftcfg;
    }

    public void addListener(ConfigRepositoryListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeListener(ConfigRepositoryListener listener) {
        throw new UnsupportedOperationException();
    }

    public ConfigEpoch getRepositoryEpoch() {
        String opName = "getRepositoryEpoch";
        String[] signature = new String[]{"com.ibm.websphere.management.repository.ConfigEpoch"};
        Object[] params = new Object[]{};
        try {
            return (ConfigEpoch)this.invoke(opName, signature, params);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ConfigEpoch refreshRepositoryEpoch() {
        String opName = "refreshRepositoryEpoch";
        String[] signature = new String[]{"com.ibm.websphere.management.repository.ConfigEpoch"};
        Object[] params = new Object[]{};
        try {
            return (ConfigEpoch)this.invoke(opName, signature, params);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void createDigestFile(String docURI, boolean delete) throws RepositoryException {
        String opName = "createDigestFile";
        String[] signature = new String[]{"java.lang.String", "boolean"};
        Object[] params = new Object[]{docURI, delete ? Boolean.TRUE : Boolean.FALSE};
        this.invoke(opName, signature, params);
    }
}

