/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.profileregistry;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;

public class ProfileRegistryUtils {
    private static TraceComponent tc = Tr.register(ProfileRegistryUtils.class, "ProfileRegistryUtils", "com.ibm.ws.management.resources.adminagent");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getManagedNodeProperties(String profileKey) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getManagedNodeProperties", profileKey);
        }
        Properties mnProperties = new Properties();
        Session session = new Session();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService is ", cs);
            }
            ObjectName mnON = ConfigServiceHelper.createObjectName(null, "ManagedNode");
            ObjectName[] managedNodeArray = cs.queryConfigObjects(session, null, mnON, null);
            for (int i = 0; i < managedNodeArray.length; ++i) {
                String pKey;
                ObjectName mn = managedNodeArray[i];
                String managedNodeName = (String)cs.getAttribute(session, mn, "name");
                ObjectName propON = ConfigServiceHelper.createObjectName(null, "Property");
                ObjectName[] propertyArray = cs.queryConfigObjects(session, mn, propON, null);
                mnProperties = new Properties();
                for (int j = 0; j < propertyArray.length; ++j) {
                    ObjectName prop = propertyArray[j];
                    String name = (String)cs.getAttribute(session, prop, "name");
                    String value = (String)cs.getAttribute(session, prop, "value");
                    mnProperties.put(name, value);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "managed node name ", managedNodeName);
                    Tr.debug(tc, "properties ", mnProperties.toString());
                }
                if (!(pKey = mnProperties.getProperty("profile.registry.profile.key")).equals(profileKey)) continue;
                mnProperties.put("profile.registry.managed.node.name", managedNodeName);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cs.discard(session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getManagedNodeProperties", mnProperties.toString());
        }
        return mnProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getManagedNodeProperties(String profileKey, AdminClient adminClient) throws ConfigServiceException, ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getManagedNodeProperties", profileKey);
        }
        Properties mnProperties = new Properties();
        Session session = new Session();
        ConfigServiceProxy cs = new ConfigServiceProxy(adminClient);
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConfigService is ", cs);
            }
            ObjectName mnON = ConfigServiceHelper.createObjectName(null, "ManagedNode");
            ObjectName[] managedNodeArray = cs.queryConfigObjects(session, null, mnON, null);
            for (int i = 0; i < managedNodeArray.length; ++i) {
                String pKey;
                ObjectName mn = managedNodeArray[i];
                String managedNodeName = (String)cs.getAttribute(session, mn, "name");
                ObjectName propON = ConfigServiceHelper.createObjectName(null, "Property");
                ObjectName[] propertyArray = cs.queryConfigObjects(session, mn, propON, null);
                mnProperties = new Properties();
                for (int j = 0; j < propertyArray.length; ++j) {
                    ObjectName prop = propertyArray[j];
                    String name = (String)cs.getAttribute(session, prop, "name");
                    String value = (String)cs.getAttribute(session, prop, "value");
                    mnProperties.put(name, value);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "managed node name ", managedNodeName);
                    Tr.debug(tc, "properties ", mnProperties.toString());
                }
                if (!(pKey = mnProperties.getProperty("profile.registry.profile.key")).equals(profileKey)) continue;
                mnProperties.put("profile.registry.managed.node.name", managedNodeName);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cs.discard(session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getManagedNodeProperties", mnProperties.toString());
        }
        return mnProperties;
    }
}

