/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.profileregistry;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.profileregistry.ProfileRegistry;
import com.ibm.ws.management.profileregistry.ProfileRegistryFactory;
import com.ibm.ws.management.profileregistry.ProfileRegistryGenerator;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.io.File;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public class FileBasedProfileRegistry
implements ProfileRegistry {
    private static TraceComponent tc = Tr.register(FileBasedProfileRegistry.class, "FileBasedProfileRegistry", "com.ibm.ws.management.resources.adminagent");
    private static final String LOCAL_REGISTRY = "profile.local";
    private Map registryCache = new HashMap();
    private List remoteProfileKeys = new ArrayList();
    private String managedNode = null;

    protected FileBasedProfileRegistry() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "FileBasedProfileRegistry");
        }
        this.initializeRegistry();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "FileBasedProfileRegistry");
        }
    }

    private void initializeRegistry() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeRegistry");
        }
        try {
            HashMap propsMap = this.getAllManagedNodeProperties();
            Set propSet = propsMap.keySet();
            for (String mnName : propSet) {
                Properties props = (Properties)propsMap.get(mnName);
                String profileKey = props.getProperty("profile.registry.profile.key");
                String adminAgentName = props.getProperty("profile.registry.adminagent.name");
                this.registryCache.put(profileKey, props);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "profile key is " + profileKey);
                    Tr.debug(tc, "properties " + props.toString());
                }
                if (this.remoteProfileKeys.contains(profileKey)) continue;
                this.remoteProfileKeys.add(profileKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeRegistry");
        }
    }

    public String register(Map parms) throws Exception {
        String profileKey;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registry", parms);
        }
        if ((profileKey = (String)parms.get("profile.registry.profile.key")) == null) {
            profileKey = ProfileRegistryGenerator.generateProfileKey(parms);
        }
        parms.put("profile.registry.profile.key", profileKey);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)parms);
        this.registryCache.put(profileKey, props);
        String profilePath = (String)parms.get("profile.registry.profile.root");
        this.initializeRegistry();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registry", profileKey);
        }
        return profileKey;
    }

    public Map lookupProfile(String profileKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookup for profile " + profileKey);
        }
        this.initializeRegistry();
        Map result = (Map)this.registryCache.get(profileKey);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookup for profile " + result);
        }
        return result;
    }

    public String lookupProfile(Map profileMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookup for profile " + profileMap);
        }
        String pKey = null;
        String profilePath = (String)profileMap.get("profile.registry.profile.root");
        this.initializeRegistry();
        try {
            HashMap mnMap = this.getAllManagedNodeProperties();
            Set propSet = mnMap.keySet();
            for (Properties props : propSet) {
                File profilePathFile;
                String pRoot = props.getProperty("profile.registry.profile.root");
                File pRootFile = new File(pRoot);
                if (pRootFile.compareTo(profilePathFile = new File(profilePath)) != 0) continue;
                pKey = props.getProperty("profile.registry.profile.key");
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookup for profile " + pKey);
        }
        return pKey;
    }

    public Map lookupLocalProfile() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupLocalProfile");
        }
        this.initializeRegistry();
        return this.lookupProfile(LOCAL_REGISTRY);
    }

    public List getRemoteProfileKeys() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRemoteProfileKeys");
        }
        this.initializeRegistry();
        return this.remoteProfileKeys;
    }

    public void removeUnregisterProfileKey(String pKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUnregisterProfile", pKey);
        }
        this.remoteProfileKeys.remove(pKey);
        this.registryCache.remove(pKey);
        ProfileRegistryFactory.resetRegistry();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Updated remoteProfileKeys " + this.remoteProfileKeys);
            Tr.debug(tc, "Updated registryCache " + this.registryCache);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUnregisterProfile", pKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getAllManagedNodeProperties() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllManagedNodeProperties entry");
        }
        boolean pushed = false;
        HashMap ret = null;
        try {
            if (AdminContext.peek() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAllManagedNodeProperties: pushing null AdminContext");
                }
                pushed = AdminContext.push(null);
            }
            ret = (HashMap)ContextManagerFactory.getInstance().runAsSystem(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return FileBasedProfileRegistry.this.getAllManagedNodePropertiesPrivate();
                }
            });
        }
        finally {
            if (pushed) {
                AdminContext.pop();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllManagedNodeProperties exit: " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getAllManagedNodePropertiesPrivate() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllManagedNodePropertiesPrivate");
        }
        HashMap<String, Properties> propMap = new HashMap<String, Properties>();
        Session session = new Session();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ConfigService is ", cs);
        }
        if (cs != null) {
            try {
                ObjectName mnON = ConfigServiceHelper.createObjectName(null, "ManagedNode");
                ObjectName[] managedNodeArray = cs.queryConfigObjects(session, null, mnON, null);
                for (int i = 0; i < managedNodeArray.length; ++i) {
                    Properties mnProperties = new Properties();
                    ObjectName mn = managedNodeArray[i];
                    String managedNodeName = (String)cs.getAttribute(session, mn, "name");
                    ObjectName propON = ConfigServiceHelper.createObjectName(null, "Property");
                    ObjectName[] propertyArray = cs.queryConfigObjects(session, mn, propON, null);
                    mnProperties = new Properties();
                    for (int j = 0; j < propertyArray.length; ++j) {
                        ObjectName prop = propertyArray[j];
                        String name = (String)cs.getAttribute(session, prop, "name");
                        String value = (String)cs.getAttribute(session, prop, "value");
                        mnProperties.put(name, value);
                    }
                    mnProperties.put("profile.registry.managed.node.name", managedNodeName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "managed node name ", managedNodeName);
                        Tr.debug(tc, "properties ", mnProperties.toString());
                    }
                    propMap.put(managedNodeName, mnProperties);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                cs.discard(session);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllManagedNodePropertiesPrivate");
        }
        return propMap;
    }

    public Map lookupManagedNode(String managedNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupManagedNode " + managedNode);
        }
        Properties result = null;
        this.initializeRegistry();
        Set registeredNodeSet = this.registryCache.keySet();
        for (String profileKey : registeredNodeSet) {
            Properties props = (Properties)this.registryCache.get(profileKey);
            String managedNodeNm = props.getProperty("profile.registry.managed.node.name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "managedNode from registry " + managedNodeNm);
            }
            if (!managedNode.equals(managedNodeNm)) continue;
            result = props;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupManagedNode " + result);
        }
        return result;
    }
}

