/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.fileservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.server.FileTransferServer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminServiceFactoryInitializer;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.util.ImplFactory;
import java.lang.reflect.Constructor;
import java.util.Properties;
import javax.management.ObjectName;

public class FileTransferFactory {
    private static TraceComponent tc = Tr.register(FileTransferFactory.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    private static ObjectName fileTransferObjectName = null;
    private static FileTransferConfig ftsConfig = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(FileTransferConfig fts) {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", fts);
            }
            ftsConfig = fts;
            String pType = AdminServiceFactory.getAdminService().getProcessType();
            if (pType.equals("NodeAgent")) {
                FileTransferFactory.createFileTransferClientMBean();
            } else if (pType.equals("DeploymentManager") || pType.equals("UnManagedProcess") || pType.equals("AdminAgent") || pType.equals("JobManager")) {
                FileTransferFactory.createFileTransferServerMBean();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.management.fileservice.FileTransferFactory.initialize", "104");
            Tr.error(tc, "ADFS0102", e);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
        }
    }

    public static FileTransferClient getFileTransferClient(FileTransferConfig fts) throws AdminException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initializeFileTransferClient");
            }
            ftsConfig = fts;
            FileTransferClient ftClient = (FileTransferClient)ImplFactory.loadImplFromKey(FileTransferClient.class);
            ftClient.initialize(ftsConfig);
            FileTransferClient fileTransferClient = ftClient;
            return fileTransferClient;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.management.fileservice.FileTransferFactory.getFileTransferClient", "172");
            Tr.service(tc, "ADFS0102", e);
            throw new AdminException(e, "Error Creating FileTransferClient");
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
        }
    }

    public static FileTransferClient getFileTransferClient(AdminClient client) throws AdminException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getFileTransferClient");
            }
            FileTransferClient ftClient = (FileTransferClient)ImplFactory.loadImplFromKey(FileTransferClient.class);
            ftClient.initialize(client);
            FileTransferClient fileTransferClient = ftClient;
            return fileTransferClient;
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.management.fileservice.FileTransferFactory.getFileTransferClient", "158");
            Tr.service(tc, "ADFS0102", e);
            throw new AdminException(e, "Error Creating FileTransferClient");
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
        }
    }

    private static void createFileTransferServerMBean() throws AdminException {
        try {
            AdminService adminService;
            String pType;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createFileTransferServerMBean");
            }
            if ("UnManagedProcess".equals(pType = (adminService = AdminServiceFactory.getAdminService()).getProcessType()) && AdminServiceFactoryInitializer.isCellRegistered()) {
                String className = "com.ibm.wsspi.management.collaborator.AgentProxyCollaborator";
                Class<?> implClass = Class.forName(className);
                Constructor<?> constructor = implClass.getConstructor(Class.class);
                RuntimeCollaborator proxyCollab = (RuntimeCollaborator)constructor.newInstance(FileTransferServer.class);
                fileTransferObjectName = adminService.getMBeanFactory().activateMBean("FileTransferServer", proxyCollab, "FileTransferServer", null);
                return;
            }
            FileTransferServer ftServer = (FileTransferServer)ImplFactory.loadImplFromKey(FileTransferServer.class);
            ftServer.startServer(ftsConfig);
            DefaultRuntimeCollaborator ftCollaborator = new DefaultRuntimeCollaborator(ftServer);
            fileTransferObjectName = adminService.getMBeanFactory().activateMBean("FileTransferServer", ftCollaborator, "FileTransferServer", null);
        }
        catch (AdminException e) {
            FFDCFilter.processException(e, "com.ibm.ws.management.fileservice.FileTransferFactory.createFileTransferServerMBean", "218");
            Object[] params = new Object[]{"FileTransferServer"};
            Tr.service(tc, "ADFS0100", params);
            throw e;
        }
        catch (Exception e2) {
            FFDCFilter.processException(e2, "com.ibm.ws.management.fileservice.FileTransferFactory.createFileTransferServerMBean", "225");
            Tr.service(tc, "ADFS0105", e2);
            throw new AdminException(e2, "The file transfer server can not be created");
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createFileTransferServerMBean");
            }
        }
    }

    private static void createFileTransferClientMBean() throws AdminException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createFileTransferClientMBean");
            }
            FileTransferClient ftClient = FileTransferFactory.getFileTransferClient(ftsConfig);
            DefaultRuntimeCollaborator ftCollaborator = new DefaultRuntimeCollaborator(ftClient);
            AdminService adminService = AdminServiceFactory.getAdminService();
            fileTransferObjectName = adminService.getMBeanFactory().activateMBean("FileTransferClient", ftCollaborator, "FileTransferClient", null);
        }
        catch (AdminException e) {
            FFDCFilter.processException(e, "com.ibm.ws.management.fileservice.FileTransferFactory.createFileTransferClientMBean", "254");
            Object[] params = new Object[]{"FileTransferClient"};
            Tr.service(tc, "ADFS0100", params);
            throw e;
        }
        catch (Exception e2) {
            FFDCFilter.processException(e2, "com.ibm.ws.management.fileservice.FileTransferFactory.createFileTransferClientMBean", "261");
            Tr.service(tc, "ADFS0105", e2);
            throw new AdminException(e2, "The file transfer client can not be created");
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createFileTransferClientMBean");
            }
        }
    }

    public static void uninitialize() {
        FileTransferFactory.deactivateFileTransferMBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deactivateFileTransferMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deactivateFileTransferMBean");
        }
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            adminService.getMBeanFactory().deactivateMBean("FileTransferClient");
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.management.fileservice.FileTransferFactory.deactivateFileTransferMBean", "293");
            Object[] params = new Object[]{"FileTransferClient", e};
            Tr.service(tc, "ADFS0101", params);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deactivateFileTransferMBean");
            }
        }
    }

    public static ObjectName getFileTransferObjectName() {
        return fileTransferObjectName;
    }

    public static FileTransferConfig getFileTransferServiceConfig() {
        return ftsConfig;
    }

    public static Properties getFileTransferProperties() {
        return ftsConfig.getProperties();
    }
}

