/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.deployment.j2ee;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.deployment.core.DeployableObject;
import com.ibm.websphere.management.deployment.exception.DeploymentException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;

public class ArchiveDeployableObject
extends DeployableObject {
    private static TraceComponent tc = Tr.register(ArchiveDeployableObject.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.DeploymentMessages", Locale.getDefault());
    private Archive _handle;
    private String _pathToContent;

    public ArchiveDeployableObject(Archive archive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ArchiveDeployableObject", new Object[]{archive});
        }
        this._handle = archive;
        this._pathToContent = this._handle.getURI();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ArchiveDeployableObject");
        }
    }

    public void setContentPath(String contentPath) throws DeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setContentPath");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new path: " + contentPath);
        }
        this._pathToContent = contentPath;
        if (this._handle != null) {
            try {
                AppUtils.dbg(tc, "********** closing: " + this._handle.getURI());
                this._handle.close();
                this._handle = null;
            }
            catch (Throwable th) {
                throw new DeploymentException(th.getMessage(), th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setContentPath");
        }
    }

    public String getContentPath() throws DeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHandle");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHandle" + this._pathToContent);
        }
        return this._pathToContent;
    }

    public Object getHandle() throws DeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHandle");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHandle - " + this._handle);
        }
        return this._handle;
    }

    public Object getHandle(Object options) throws DeploymentException {
        boolean useJavaReflection;
        boolean readOnly;
        if (options == null) {
            readOnly = false;
            useJavaReflection = true;
        } else {
            Hashtable archiveOptions = (Hashtable)options;
            readOnly = (Boolean)archiveOptions.get("use_java_reflection");
            useJavaReflection = (Boolean)archiveOptions.get("read_only");
        }
        Archive archive = null;
        boolean isEar = false;
        if (this._handle.isEARFile()) {
            isEar = true;
        }
        try {
            archive = AppInstallHelper.getArchive(this._handle.getURI(), useJavaReflection, readOnly, null, isEar);
        }
        catch (AppDeploymentException ade) {
            throw new DeploymentException(ade.getMessage(), ade);
        }
        return archive;
    }
}

